/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.ctrl;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.ep.client.ctrl.TreeComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class TreePopup
extends JPopupMenu
implements ComboPopup {
    protected TreeComboBox comboBox;
    protected JScrollPane scrollPane;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    private int popupHeight = 100;
    private MouseListener treeSelectListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath treePath = tree.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                TreePopup.this.comboBox.setSelectedItem(node);
                TreePopup.this.togglePopup();
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    };
    protected JList list = new JList();

    public TreePopup(JComboBox comboBox, int popupHeight) {
        this.popupHeight = popupHeight;
        this.comboBox = (TreeComboBox)comboBox;
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());
        KDTree tree = this.comboBox.getTree();
        if (tree != null) {
            this.scrollPane = new JScrollPane((Component)tree);
            this.scrollPane.setBorder(null);
            this.add((Component)this.scrollPane, "Center");
            tree.addMouseListener(this.treeSelectListener);
        }
    }

    @Override
    public void show() {
        this.updatePopup();
        try {
            this.show(this.comboBox, 0, this.comboBox.getHeight());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        this.comboBox.getTree().requestFocus();
    }

    @Override
    public void hide() {
        this.setVisible(false);
        this.comboBox.firePropertyChange("popupVisible", true, false);
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionAdapter(){};
        }
        return this.mouseMotionListener;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    @Override
    public void uninstallingUI() {
    }

    @Override
    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new InvocationMouseHandler();
        }
        return this.mouseListener;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected void updatePopup() {
        this.setPreferredSize(new Dimension(this.comboBox.getSize().width, this.popupHeight));
        Object selectedObj = this.comboBox.getSelectedItem();
        if (selectedObj != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selectedObj;
            this.comboBox.getTree().setSelectionNode(node);
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !TreePopup.this.comboBox.isEnabled()) {
                return;
            }
            if (TreePopup.this.comboBox.isEditable()) {
                Component comp = TreePopup.this.comboBox.getEditor().getEditorComponent();
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    comp.requestFocus();
                }
            } else if (TreePopup.this.comboBox.isRequestFocusEnabled()) {
                TreePopup.this.comboBox.requestFocus();
            }
            TreePopup.this.togglePopup();
        }
    }
}

