/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.ctrl;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class UictCheckBoxList
extends KDList {
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public UictCheckBoxList() {
        this.setCellRenderer(new CheckBoxCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JCheckBox checkbox;
                int index = UictCheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1 && (checkbox = (JCheckBox)UictCheckBoxList.this.getModel().getElementAt(index)).isEnabled()) {
                    checkbox.setSelected(!checkbox.isSelected());
                    UictCheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JCheckBox checkbox;
                int index;
                if (e.getKeyCode() == 32 && (index = UictCheckBoxList.this.getSelectedIndex()) != -1 && (checkbox = (JCheckBox)UictCheckBoxList.this.getModel().getElementAt(index)).isEnabled()) {
                    checkbox.setSelected(!checkbox.isSelected());
                    UictCheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    public void setListDataByDefaultListModel(Object[] listData) {
        if (listData != null) {
            DefaultListModel<Object> model = new DefaultListModel<Object>();
            this.setModel(model);
            for (int i = 0; i < listData.length; ++i) {
                model.addElement(listData[i]);
            }
        }
    }

    public List getSelectedElement() {
        ArrayList list = new ArrayList();
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (model != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object obj = model.getElementAt(i);
                if (!(obj instanceof KDCheckBox) || !((KDCheckBox)obj).isSelected()) continue;
                list.add(obj);
            }
        }
        return list;
    }

    public void setAllElementSelected() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (model != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object obj = model.getElementAt(i);
                if (!(obj instanceof KDCheckBox)) continue;
                ((KDCheckBox)obj).setSelected(true);
            }
        }
        this.repaint();
    }

    public void setAllElementUnSelected() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (model != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object obj = model.getElementAt(i);
                if (!(obj instanceof KDCheckBox)) continue;
                ((KDCheckBox)obj).setSelected(false);
            }
        }
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        UictCheckBoxList cbList = new UictCheckBoxList();
        cbList.setSelectionMode(2);
        Object[] cbArray = new Object[]{new KDCheckBox("one"), new KDCheckBox("two"), new KDCheckBox("three")};
        cbList.setListData(cbArray);
        JScrollPane scroller = new JScrollPane((Component)((Object)cbList), 20, 30);
        frame.getContentPane().add(scroller);
        frame.pack();
        frame.setVisible(true);
    }

    protected class CheckBoxCellRenderer
    implements ListCellRenderer {
        protected CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            KDCheckBox checkbox = (KDCheckBox)value;
            if (!UictCheckBoxList.this.isEnabled()) {
                checkbox.setEnabled(false);
            }
            checkbox.setFont(UictCheckBoxList.this.getFont());
            checkbox.setFocusPainted(false);
            checkbox.setBorderPainted(true);
            checkbox.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return checkbox;
        }
    }
}

