/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.depend;

import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.depend.LRULinkedHashMap;
import com.kingdee.eas.ep.client.runtime.DynSelectorBuilder;
import java.util.Map;

public class CachedDynSelectorBuilder {
    private static String oldDSessionId = null;
    private static Map cache = new LRULinkedHashMap();

    public static synchronized SelectorItemCollection getDynSelectors(UIObjectInfo ui) {
        SelectorItemCollection selectors = null;
        String pk = ui.getFullName();
        if (CachedDynSelectorBuilder.sessionChanged()) {
            CachedDynSelectorBuilder.clear();
        } else {
            selectors = CachedDynSelectorBuilder.getFromCache(pk);
        }
        if (selectors == null) {
            selectors = CachedDynSelectorBuilder.innerBuildSelectors(ui);
            CachedDynSelectorBuilder.storeToCache(pk, selectors);
        }
        return selectors;
    }

    private static boolean sessionChanged() {
        String sessionId = SysContext.getSysContext().getSessionID();
        if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            return true;
        }
        return false;
    }

    private static SelectorItemCollection getFromCache(String pk) {
        Object obj = cache.get(pk);
        if (obj instanceof SelectorItemCollection) {
            return (SelectorItemCollection)obj;
        }
        return null;
    }

    private static SelectorItemCollection innerBuildSelectors(UIObjectInfo uiModel) {
        DynSelectorBuilder build = new DynSelectorBuilder();
        return build.buildSelectors(uiModel, uiModel.getMainPanelComponent());
    }

    private static void storeToCache(String pk, SelectorItemCollection selectors) {
        cache.put(pk, selectors);
    }

    public static synchronized void clear() {
        cache.clear();
    }
}

