/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.depend;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.ExtendPointInfo;
import com.kingdee.eas.ep.ExtendPointParamCollection;
import com.kingdee.eas.ep.ExtendPointParamInfo;
import com.kingdee.eas.ep.IPlugIn;
import com.kingdee.eas.ep.PlugInCollection;
import com.kingdee.eas.ep.PlugInFactory;
import com.kingdee.eas.ep.PlugInInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScriptCache {
    public static final String DEPPLUGINCACHE = "depplugincache";
    private static final Logger logger = CoreUIObject.getLogger(ScriptCache.class);
    private static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int seq1 = ((ExtendPointParamInfo)o1).getSeq();
            int seq2 = ((ExtendPointParamInfo)o2).getSeq();
            return seq1 - seq2;
        }
    };

    public static PlugInCollection getPlugin(String meta, ExtendPointInfo point) throws EASBizException, BOSException {
        Map plugins = ScriptCache.getFromCache(meta);
        if (plugins == null) {
            plugins = ScriptCache.getFromServer(meta);
            ScriptCache.StoreToCache(meta, plugins);
        }
        return (PlugInCollection)((Object)plugins.get(point));
    }

    private static Map getFromCache(String meta) {
        Object obj;
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null && (obj = ehcacheService.getCache(DEPPLUGINCACHE, meta, false)) instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    private static Map getFromServer(String meta) {
        PlugInCollection piCol = null;
        try {
            IPlugIn ip = PlugInFactory.getRemoteInstance();
            piCol = ip.getPlugIn(meta);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return ScriptCache.toMap(piCol);
    }

    private static Map toMap(PlugInCollection col) {
        HashMap<ExtendPointInfo, PlugInCollection> map = new HashMap<ExtendPointInfo, PlugInCollection>();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                PlugInInfo plugInInfo = col.get(i);
                ExtendPointInfo point = plugInInfo.getPoint();
                PlugInCollection subCol = (PlugInCollection)((Object)map.get(point = ScriptCache.clone(point)));
                if (subCol == null) {
                    subCol = new PlugInCollection();
                    map.put(point, subCol);
                }
                subCol.add(plugInInfo);
            }
        }
        return map;
    }

    private static ExtendPointInfo clone(ExtendPointInfo point) {
        ExtendPointInfo newpoint = new ExtendPointInfo();
        newpoint.setName(point.getName());
        ExtendPointParamCollection params = point.getParam();
        if (params != null && !params.isEmpty()) {
            int i;
            ArrayList<ExtendPointParamInfo> list = new ArrayList<ExtendPointParamInfo>();
            ExtendPointParamInfo newParam = null;
            for (i = 0; i < params.size(); ++i) {
                newParam = ScriptCache.clone(params.get(i));
                list.add(newParam);
            }
            Collections.sort(list, comparator);
            for (i = 0; i < list.size(); ++i) {
                newpoint.getParam().add((ExtendPointParamInfo)list.get(i));
            }
        }
        if (point.isInner()) {
            newpoint.setParamNum(point.getParamNum());
            newpoint.setParamLen(point.getParamLen());
        } else {
            newpoint.setResult(null);
            newpoint.setInner(false);
        }
        return newpoint;
    }

    private static ExtendPointParamInfo clone(ExtendPointParamInfo epp) {
        ExtendPointParamInfo param = new ExtendPointParamInfo();
        param.setType(epp.getType());
        param.setSeq(epp.getSeq());
        return param;
    }

    private static void StoreToCache(String key, Map value) {
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null && value != null) {
            ehcacheService.putCache(DEPPLUGINCACHE, key, (Object)value, 0L);
        } else {
            logger.error((Object)"can't store to cache because Ehcache not available");
        }
    }

    public static void clear() {
        EhcacheService ehcacheService = EhcacheService.getInstance();
        if (ehcacheService != null) {
            ehcacheService.removeCacheRegion(DEPPLUGINCACHE);
        } else {
            logger.error((Object)"can't store to cache because Ehcache not available");
        }
    }
}

