/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bind;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UICommonUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.editor.bind.AbstractDataBindUI;
import com.kingdee.eas.ep.client.editor.bind.BindPropertyUI;
import com.kingdee.eas.ep.client.editor.bind.DataBindChangeListener;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.bind.PropertyBindingInfoProxy;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.util.UIStatus;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.wizard.bind.BindPropertyWizardUI;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataBindUI
extends AbstractDataBindUI {
    private static final Logger logger = CoreUIObject.getLogger(DataBindUI.class);
    private IContext context;
    private AbstractUIObjectInfo uiModel;
    private Project depend;
    public static final Color dynColor = new Color(233, 226, 184);
    private DataBindChangeListener dataBindChangeListener;

    public void onLoad() throws Exception {
        super.onLoad();
        this.objTable.checkParsed(true);
        this.ctrlTable.checkParsed(true);
        this.objTable.setEditable(false);
        this.ctrlTable.setEditable(false);
        this.ctrlTable.getSelectManager().setSelectMode(10);
        this.btnAddEntity.setEnabled(false);
        this.btnAddQuery.setEnabled(false);
        this.btnDefault.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.add2.setVisible(false);
    }

    public void setViewerContext(IContext context) {
        this.context = context;
        this.uiModel = context.getUiModel();
    }

    public static Color getDynColor() {
        return dynColor;
    }

    public Project getDepend() {
        return this.depend;
    }

    public void setDepend(Project depend) {
        this.depend = depend;
    }

    public void loadData() {
        this.loadObj();
        this.loadCtrl();
    }

    protected DataBindChangeListener getDataBindChangListener() {
        if (this.dataBindChangeListener == null) {
            this.dataBindChangeListener = new DataBindChangeListener(this.context, this.depend);
        }
        return this.dataBindChangeListener;
    }

    protected void ctrlTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.btnCtrlRemove.setEnabled(true);
        for (int index : KDTableUtil.getSelectedRows((KDTable)this.ctrlTable)) {
            PropertyBindingInfo propertyBindingInfo;
            IRow row = this.ctrlTable.getRow(index);
            List dataItem = (List)row.getUserObject();
            ComponentInfo componentInfo = (ComponentInfo)dataItem.get(0);
            if (this.isconfigured(componentInfo, propertyBindingInfo = (PropertyBindingInfo)dataItem.get(1))) continue;
            this.btnCtrlRemove.setEnabled(false);
            return;
        }
    }

    protected void saveObj() {
        DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
        dataObjectCollection.clear();
        int length = this.objTable.getRowCount();
        for (int i = 0; i < length; ++i) {
            IRow row = this.objTable.getRow(i);
            if (!(row.getUserObject() instanceof DataObjectInfo)) continue;
            dataObjectCollection.add((DataObjectInfo)row.getUserObject());
        }
        this.context.setDirty(true);
    }

    private void loadObj() {
        this.objTable.removeRows();
        DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
        if (dataObjectCollection == null) {
            return;
        }
        for (int i = 0; i < dataObjectCollection.size(); ++i) {
            String packageName;
            String objectName;
            DataObjectInfo doInfo = dataObjectCollection.get(i);
            IRow row = this.objTable.addRow();
            row.setUserObject((Object)doInfo);
            row.getCell(0).setValue((Object)doInfo.getName());
            if (doInfo.getType().indexOf(".") == -1) {
                objectName = doInfo.getType();
                packageName = "";
            } else {
                objectName = doInfo.getType().substring(doInfo.getType().lastIndexOf(".") + 1, doInfo.getType().length());
                packageName = doInfo.getType().substring(0, doInfo.getType().lastIndexOf("."));
            }
            row.getCell(1).setValue((Object)objectName);
            row.getCell(2).setValue((Object)packageName);
            if (doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) {
                row.getCell(3).setValue((Object)"\u5b9e\u4f53\u5bf9\u8c61");
            } else if (doInfo.getObjectType().equals(MetaDataTypeList.JOINQUERY.toString())) {
                row.getCell(3).setValue((Object)"\u67e5\u8be2\u5bf9\u8c61");
            }
            if (i != 0) continue;
            row.getCell(4).setValue((Object)"*");
        }
    }

    private void removeObjectFromUIObject(DataObjectInfo dataObjectInfo) {
        ComponentCollection componentCollection;
        ComponentCollection newComponentCollection;
        DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
        for (int i = 0; i < dataObjectCollection.size(); ++i) {
            if (!dataObjectCollection.get(i).getName().equals(dataObjectInfo.getName())) continue;
            dataObjectCollection.removeObject(i);
            this.uiModel.getNameManager().remove(dataObjectInfo.getName());
            break;
        }
        if ((newComponentCollection = this.removePropertyBindingByDataObject(dataObjectInfo, componentCollection = this.uiModel.getComponents())) == null) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5220\u9664\u5c5e\u6027\u7ed1\u5b9a\u5931\u8d25\uff01");
            return;
        }
        this.uiModel.setComponents(newComponentCollection);
        this.context.setDirty(true);
    }

    private ComponentCollection removePropertyBindingByDataObject(DataObjectInfo dataObjectInfo, ComponentCollection componentCollection) {
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
            for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                PropertyBindingInfo propertyBindingInfo = propertyBindingCollection.get(j);
                if (!propertyBindingInfo.getBindingObject().equals(dataObjectInfo.getName())) continue;
                propertyBindingCollection.remove(propertyBindingInfo);
                componentInfo.setPropertyBindings(propertyBindingCollection);
                componentCollection.set(i, componentInfo);
            }
            if (!componentInfo.isContainer()) continue;
            ComponentCollection ttComponentCollection = this.removePropertyBindingByDataObject(dataObjectInfo, componentInfo.getComponents());
            componentInfo.setComponents(ttComponentCollection);
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    @Override
    protected void btnCtrlAdd_actionPerformed(ActionEvent e) throws Exception {
        List newDataItem;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BindPropertyWizardUI.class.getName(), (Map)uiContext);
        BindPropertyWizardUI wizard = (BindPropertyWizardUI)uiWindow.getUIObject();
        wizard.setModel(this.uiModel);
        wizard.setDepend(this.depend);
        wizard.setStatus(UIStatus.STATUS_ADDNEW);
        wizard.addPages();
        uiWindow.show();
        if ("confirm".equals(wizard.getExitStatus()) && (newDataItem = wizard.getValue()) != null && !newDataItem.isEmpty()) {
            ComponentInfo componentInfo = (ComponentInfo)newDataItem.get(0);
            PropertyBindingInfo propertyBindingInfo = (PropertyBindingInfo)newDataItem.get(1);
            if (this.needValidate(this.uiModel) && !this.validate(componentInfo, propertyBindingInfo)) {
                return;
            }
            propertyBindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            ((PropertyBindingInfo)newDataItem.get(1)).setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            IRow row = this.ctrlTable.addRow(0);
            row.getCell(0).setValue((Object)UictUtils.getAlias(componentInfo));
            row.getCell(1).setValue((Object)propertyBindingInfo.getPropertyName());
            row.getCell(2).setValue((Object)propertyBindingInfo.getBindingObject());
            row.getCell(3).setValue((Object)propertyBindingInfo.getBingdingField());
            row.setUserObject((Object)newDataItem);
            row.getStyleAttributes().setFontColor(Color.BLUE);
            this.saveForAdd(0);
            this.resetComponent(componentInfo, propertyBindingInfo, 1);
            this.getDataBindChangListener().fireDataBindChanged(componentInfo, propertyBindingInfo);
        }
    }

    @Override
    protected void actionBtnAdd2_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("uiModel", this.uiModel);
        uiContext.put("depend", this.depend);
        this.openBindPropertyUI((Map)uiContext);
    }

    protected void btnCtrlEdit_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.ctrlTable);
        List selectObj = (List)this.ctrlTable.getRow(rowIndex[0]).getUserObject();
        ComponentInfo omponentInfo = (ComponentInfo)selectObj.get(0);
        PropertyBindingInfo propertyBinding = (PropertyBindingInfo)selectObj.get(1);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("uiModel", this.uiModel);
        uiContext.put("depend", this.depend);
        uiContext.put("selectComp", omponentInfo);
        uiContext.put("selectProp", propertyBinding);
        this.openBindPropertyUI((Map)uiContext);
    }

    private void openBindPropertyUI(Map uiContext) throws UIException {
        List newDataItem;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BindPropertyUI.class.getName(), uiContext);
        BindPropertyUI bindUI = (BindPropertyUI)uiWindow.getUIObject();
        uiWindow.show();
        if ("confirm".equals(bindUI.EXIT_STATUS) && (newDataItem = bindUI.getValue()) != null && !newDataItem.isEmpty()) {
            ComponentInfo componentInfo = (ComponentInfo)newDataItem.get(0);
            PropertyBindingInfoProxy proxy = (PropertyBindingInfoProxy)newDataItem.get(1);
            if (this.needValidate(this.uiModel) && !this.validate(componentInfo, proxy.getTarget())) {
                return;
            }
            proxy.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            proxy = this.getPropertyBindingInfoProxy(proxy, componentInfo, this.uiModel.getDataObjects());
            IRow row = this.ctrlTable.addRow(0);
            row.getCell(0).setValue((Object)componentInfo.getName());
            row.getCell(1).setValue((Object)proxy.getPropertyAlias());
            row.getCell(2).setValue((Object)proxy.getBindingObject());
            row.getCell(3).setValue((Object)proxy.getBindingFieldAlias());
            newDataItem.set(1, proxy.getTarget());
            row.setUserObject((Object)newDataItem);
            row.getStyleAttributes().setFontColor(Color.BLUE);
            this.saveForAdd(0);
            this.resetComponent(componentInfo, proxy.getTarget(), 1);
            this.getDataBindChangListener().fireDataBindChanged(componentInfo, proxy.getTarget());
        }
    }

    private void resetComponent(ComponentInfo cInfo, PropertyBindingInfo bindInfo, int type) {
        if (bindInfo == null || cInfo == null) {
            return;
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
            this.extractPropertyToTable(cInfo, bindInfo, type);
        } else {
            String bindingObject = bindInfo.getBindingObject();
            String bindField = bindInfo.getBingdingField();
            String propertyName = bindInfo.getPropertyName();
            if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
                return;
            }
            EntityObjectInfo bindEntity = this.getBindEntity(this.uiModel, bindingObject);
            DataBindUtils.extractPropertyToComponentInfo(bindEntity, cInfo, bindInfo, type);
        }
    }

    private boolean validate(ComponentInfo cInfo, PropertyBindingInfo bindInfo) {
        if (cInfo == null || bindInfo == null) {
            MsgBox.showInfo((String)"\u83b7\u53d6\u63a7\u4ef6\u4fe1\u606f\u6216\u8005\u6570\u636e\u7ed1\u5b9a\u4fe1\u606f\u51fa\u9519");
            return false;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            MsgBox.showInfo((String)"\u7ed1\u5b9a\u5bf9\u8c61\uff0c\u7ed1\u5b9a\u5b57\u6bb5\uff0c\u7ed1\u5b9a\u63a7\u4ef6\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(cInfo.getClassType())) {
            EntityObjectInfo bindEntity = this.getBindEntity(this.uiModel, bindingObject);
            PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
            if (prop == null) {
                MsgBox.showInfo((String)("\u52a0\u8f7d\u5c5e\u6027 : " + bindField + "\u51fa\u9519"));
                return false;
            }
            if (prop instanceof LinkPropertyInfo) {
                RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                if (relationShip == null || relationShip.getSupplierObject() == null) {
                    MsgBox.showInfo((String)"\u83b7\u53d6relationShip\u51fa\u9519");
                    return false;
                }
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                if (supplyEntityInfo == null) {
                    MsgBox.showInfo((String)("supplyEntity is null : " + relationShip.getAlias()));
                    return false;
                }
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (StringUtils.isEmpty((String)sQueryPK)) {
                    MsgBox.showInfo((String)("\u5173\u8054\u5b9e\u4f53 " + supplyEntityInfo.getFullName() + "\u7f3a\u5c11\u5c55\u5c5e\u6027defaultF7Query , \u4e0d\u5141\u8bb8\u7ed1\u5b9a  \uff0c\u8bf7\u901a\u77e5\u8be5\u5355\u636e\u5f00\u53d1\u4eba\u5458\u5c06\u6269\u5c55\u5c5e\u6027\u8865\u5145\u5b8c\u6574"));
                    return false;
                }
            } else {
                MsgBox.showInfo((String)"F7\u7c7b\u578b\u63a7\u4ef6\u5e94\u5f53\u7ed1\u5b9a\u8fde\u63a5\u5c5e\u6027");
                return false;
            }
        }
        return true;
    }

    private boolean needValidate(AbstractUIObjectInfo uiobj) {
        if (uiobj == null || !(uiobj instanceof UIObjectInfo)) {
            return false;
        }
        DataObjectCollection col = uiobj.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!MetaDataTypeList.JOINQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.UNIONQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.BASEQUERY.toString().equals(doInfo.getObjectType())) continue;
                return false;
            }
        }
        return true;
    }

    private void extractPropertyToTable(ComponentInfo cInfo, PropertyBindingInfo bindInfo, int type) {
        if (bindInfo != null && !StringUtils.isEmpty((String)bindInfo.getBindingObject())) {
            EntityObjectInfo bindEntity = this.getBindEntity(this.uiModel, bindInfo.getBindingObject());
            DataBindUtils.extractPropertyToTable(cInfo, null, bindEntity, bindInfo, type);
        }
    }

    private static ColumnInfo getMappingField(PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop.getMappingField() != null) {
            return prop.getMappingField();
        }
        if (prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return null;
    }

    @Override
    protected void btnCtrlRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.ctrlTable);
        if (rowIndex.length <= 0) {
            return;
        }
        for (int i = 0; i < rowIndex.length; ++i) {
            List dataItem = (List)this.ctrlTable.getRow(rowIndex[i]).getUserObject();
            if (dataItem.get(1) instanceof PropertyBindingInfoProxy) {
                dataItem.set(1, ((PropertyBindingInfoProxy)dataItem.get(1)).getTarget());
            }
            this.removePropertyFromUIObject(dataItem);
            ComponentInfo componentInfo = (ComponentInfo)dataItem.get(0);
            PropertyBindingInfo propertyBindingInfo = (PropertyBindingInfo)dataItem.get(1);
            propertyBindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.resetComponent(componentInfo, propertyBindingInfo, -1);
            this.getDataBindChangListener().fireDataBindChanged(componentInfo, null);
        }
        this.loadCtrl();
    }

    public EntityObjectInfo getBindEntity(AbstractUIObjectInfo uiModel, String entityName) {
        DataObjectCollection col = uiModel.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!doInfo.getName().equals(entityName) || !doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) continue;
                MetaDataPK entitypk = MetaDataPK.create((String)doInfo.getType());
                EntityObjectInfo bindEntity = UictUtils.loadEntity((IMetaDataPK)entitypk, this.depend);
                return bindEntity;
            }
        }
        return null;
    }

    @Override
    protected void ctrlTable_tableClicked(KDTMouseEvent e) throws Exception {
        int[] rowIndex;
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && (rowIndex = KDTableUtil.getSelectedRows((KDTable)this.ctrlTable)).length > 0) {
            ArrayList<String> oldDataItem = new ArrayList<String>();
            List selectObj = (List)this.ctrlTable.getRow(rowIndex[0]).getUserObject();
            ComponentInfo oldComponentInfo = (ComponentInfo)selectObj.get(0);
            PropertyBindingInfo oldPropertyBinding = (PropertyBindingInfo)selectObj.get(1);
            oldDataItem.add(((ComponentInfo)selectObj.get(0)).getName());
            oldDataItem.add(((PropertyBindingInfo)selectObj.get(1)).getPropertyName());
            oldDataItem.add(((PropertyBindingInfo)selectObj.get(1)).getBindingObject());
            oldDataItem.add(((PropertyBindingInfo)selectObj.get(1)).getBingdingField());
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BindPropertyWizardUI.class.getName(), (Map)uiContext);
            BindPropertyWizardUI wizard = (BindPropertyWizardUI)uiWindow.getUIObject();
            wizard.setModel(this.uiModel);
            wizard.setDepend(this.depend);
            wizard.setValue(selectObj);
            wizard.setStatus(UIStatus.STATUS_EDIT);
            wizard.setComponentInfo(oldComponentInfo);
            wizard.setBindProName(((PropertyBindingInfo)selectObj.get(1)).getPropertyName());
            wizard.addPages();
            uiWindow.show();
            if ("confirm".equals(wizard.getExitStatus())) {
                List newDataItem = wizard.getValue();
                if (newDataItem == null || newDataItem.isEmpty()) {
                    return;
                }
                if (!this.compareDataItem(oldDataItem, newDataItem)) {
                    ComponentInfo componentInfo = (ComponentInfo)newDataItem.get(0);
                    PropertyBindingInfo propertyBindingInfo = (PropertyBindingInfo)newDataItem.get(1);
                    if (this.needValidate(this.uiModel) && !this.validate(componentInfo, propertyBindingInfo)) {
                        return;
                    }
                    this.removePropertyFromUIObject(oldDataItem);
                    propertyBindingInfo.setUserDefined(oldPropertyBinding.isUserDefined());
                    String componentName = componentInfo.getName();
                    String propertyName = propertyBindingInfo.getPropertyName();
                    String objectName = propertyBindingInfo.getBindingObject();
                    String fieldName = propertyBindingInfo.getBingdingField();
                    IRow tableItem = this.ctrlTable.getRow(rowIndex[0]);
                    tableItem.getCell(0).setValue((Object)componentName);
                    tableItem.getCell(1).setValue((Object)propertyName);
                    tableItem.getCell(2).setValue((Object)objectName);
                    tableItem.getCell(3).setValue((Object)fieldName);
                    tableItem.setUserObject((Object)newDataItem);
                    this.saveCtrl();
                    this.resetComponent(componentInfo, oldPropertyBinding, -1);
                    this.resetComponent(componentInfo, propertyBindingInfo, 1);
                    this.getDataBindChangListener().fireDataBindChanged(componentInfo, propertyBindingInfo);
                }
            }
        }
    }

    protected void saveCtrl() {
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.ctrlTable);
        if (rowIndex.length <= 0) {
            return;
        }
        List dataItem = (List)this.ctrlTable.getRow(rowIndex[0]).getUserObject();
        ComponentInfo componentInfo = (ComponentInfo)dataItem.get(0);
        String componentName = ((ComponentInfo)dataItem.get(0)).getName();
        PropertyBindingInfo propertyBindingInfo = (PropertyBindingInfo)dataItem.get(1);
        String propertyName = ((PropertyBindingInfo)dataItem.get(1)).getPropertyName();
        String objectName = ((PropertyBindingInfo)dataItem.get(1)).getBindingObject();
        String filedName = ((PropertyBindingInfo)dataItem.get(1)).getBingdingField();
        if (componentName == null || componentName.equals("") || propertyName == null || propertyName.equals("") || objectName == null || objectName.equals("")) {
            return;
        }
        if ((filedName == null || filedName.equals("")) && propertyName.indexOf("items") == -1) {
            return;
        }
        ComponentCollection componentCollection = this.uiModel.getComponents();
        this.findTheComponent(componentName, propertyName, componentCollection, rowIndex[0]);
        DataBindUtils.addProBindDesc(componentInfo, propertyBindingInfo);
        this.context.setDirty(true);
    }

    protected void saveForAdd(int itemNO) {
        List dataItem = (List)this.ctrlTable.getRow(itemNO).getUserObject();
        if (dataItem == null) {
            return;
        }
        ComponentInfo componentInfo = (ComponentInfo)dataItem.get(0);
        String componentName = ((ComponentInfo)dataItem.get(0)).getName();
        PropertyBindingInfo propertyBindingInfo = (PropertyBindingInfo)dataItem.get(1);
        String propertyName = ((PropertyBindingInfo)dataItem.get(1)).getPropertyName();
        String objectName = ((PropertyBindingInfo)dataItem.get(1)).getBindingObject();
        String filedName = ((PropertyBindingInfo)dataItem.get(1)).getBingdingField();
        if (componentName == null || componentName.equals("") || propertyName == null || propertyName.equals("") || objectName == null || objectName.equals("")) {
            return;
        }
        if ((filedName == null || filedName.equals("")) && propertyName.indexOf("items") == -1) {
            return;
        }
        ComponentCollection componentCollection = this.uiModel.getComponents();
        this.findTheComponent(componentName, propertyName, componentCollection, itemNO);
        DataBindUtils.addProBindDesc(componentInfo, propertyBindingInfo);
        this.context.setDirty(true);
    }

    private void loadCtrl() {
        this.ctrlTable.removeRows();
        ComponentCollection componentCollection = this.uiModel.getComponents();
        List result = this.getAllPropertyBindingInfos(this.uiModel, componentCollection);
        for (List data : result) {
            if (data == null || data.size() != 2) continue;
            ComponentInfo cp = (ComponentInfo)data.get(0);
            PropertyBindingInfoProxy propertyBindingInfo = (PropertyBindingInfoProxy)data.get(1);
            if (cp == null || propertyBindingInfo == null) continue;
            IRow row = this.ctrlTable.addRow();
            row.getCell(0).setValue((Object)UictUtils.getAlias(cp));
            row.getCell(1).setValue((Object)propertyBindingInfo.getPropertyAlias());
            row.getCell(2).setValue((Object)propertyBindingInfo.getBindingObjAlias());
            row.getCell(3).setValue((Object)propertyBindingInfo.getBindingFieldAlias());
            data.add(1, propertyBindingInfo.getTarget());
            row.setUserObject((Object)data);
            if (!this.isconfigured(cp, propertyBindingInfo.getTarget())) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
            if (this.ctrlTable.getRowCount() <= 1) continue;
            int rowCount = this.ctrlTable.getRowCount() - 1;
            this.ctrlTable.moveRow(rowCount, 0);
        }
        if (this.ctrlTable.getRowCount() > 0) {
            this.ctrlTable.getSelectManager().removeAll();
            this.ctrlTable.getSelectManager().add(0, 0);
        }
    }

    private boolean isconfigured(ComponentInfo componentInfo, PropertyBindingInfo PBProxy) {
        if (componentInfo == null || PBProxy == null) {
            return false;
        }
        String pro = componentInfo.getExtendedProperty("dynpropertybinds");
        if (StringUtils.isEmpty((String)pro)) {
            return false;
        }
        String[] split = StringUtils.split((String)pro, (String)"|");
        for (int i = 0; i < split.length; ++i) {
            if (!PBProxy.getPropertyName().equals(split[i])) continue;
            return true;
        }
        return false;
    }

    private List getAllPropertyBindingInfos(AbstractUIObjectInfo uiobject, ComponentCollection componentCollection) {
        if (componentCollection == null || componentCollection.size() == 0) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
            if (propertyBindingCollection == null || propertyBindingCollection.size() == 0) continue;
            for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                ArrayList<Object> dataItem = new ArrayList<Object>();
                dataItem.add(0, componentInfo);
                PropertyBindingInfoProxy proxy = new PropertyBindingInfoProxy(propertyBindingCollection.get(j));
                proxy = this.getPropertyBindingInfoProxy(proxy, componentInfo, uiobject.getDataObjects());
                dataItem.add(1, proxy);
                result.add(dataItem);
            }
        }
        return result;
    }

    private PropertyBindingInfoProxy getPropertyBindingInfoProxy(PropertyBindingInfoProxy proxy, ComponentInfo componentInfo, DataObjectCollection dataObjects) {
        PropertyBindingInfo target = proxy.getTarget();
        String fieldName = proxy.getBingdingField();
        String bindingObjectName = proxy.getBindingObject();
        DataObjectInfo doInfo = (DataObjectInfo)dataObjects.getObject((Object)bindingObjectName);
        IObjectValue ov = MetadataUtils.loadMD(new BOSObjectType(doInfo.getObjectType()), (IMetaDataPK)MetaDataPK.create((String)doInfo.getType()), this.depend);
        if (ov instanceof EntityObjectInfo) {
            String alias = this.getPropertyAliasFromEntity((EntityObjectInfo)ov, fieldName);
            proxy.setBindingFieldAlias(alias);
        } else if (ov instanceof JoinQueryInfo) {
            JoinQueryInfo query = (JoinQueryInfo)ov;
            ArrayList fields = query.getSelector().getFields();
            for (int i = 0; i < fields.size(); ++i) {
                QueryFieldInfo field = (QueryFieldInfo)fields.get(i);
                if (!fieldName.equalsIgnoreCase(field.getName())) continue;
                proxy.setBindingFieldAlias(field.getDisplayName());
                break;
            }
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) {
            String columeAlias = DataBindUtils.getColumnAliasFromName(componentInfo, target.getPropertyName());
            proxy.setPropertyAlias(columeAlias);
        } else {
            String lias = UictUtils.getAlias(componentInfo);
            proxy.setPropertyAlias(lias);
        }
        return proxy;
    }

    private String getPropertyAliasFromEntity(EntityObjectInfo entity, String field) {
        int index = field.indexOf(".");
        if (index > 0) {
            String fieldName = field.substring(0, index);
            PropertyInfo property = null;
            property = entity.getPropertyByName(fieldName);
            if (property != null && property instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
                entity = relation.isClient(fieldName) ? relation.getSupplierObject() : relation.getClientObject();
                return this.getPropertyAliasFromEntity(entity, field.substring(index + 1));
            }
            return null;
        }
        PropertyInfo property = entity.getPropertyByName(field);
        return property.getAlias();
    }

    private String getPropertySimpleName(String name) {
        String simpleName = name;
        int lastIndex = simpleName.lastIndexOf(".");
        if (lastIndex > 0) {
            simpleName = simpleName.substring(0, lastIndex);
        }
        return simpleName;
    }

    private ComponentCollection findTheComponent(String componentName, String propertyName, ComponentCollection componentCollection, int itemNO) {
        boolean find = false;
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (componentInfo.getName().trim().equals(componentName)) {
                PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
                for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                    PropertyBindingInfo tempPropertyBindingInfo = propertyBindingCollection.get(j);
                    if (!tempPropertyBindingInfo.getPropertyName().equals(propertyName)) continue;
                    find = true;
                    tempPropertyBindingInfo = this.setPropertyBindingInfoValue(tempPropertyBindingInfo, itemNO);
                    propertyBindingCollection.set(j, tempPropertyBindingInfo);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
                if (!find) {
                    PropertyBindingInfo tempPBI = new PropertyBindingInfo();
                    tempPBI.setPropertyName(propertyName);
                    tempPBI = this.setPropertyBindingInfoValue(tempPBI, itemNO);
                    propertyBindingCollection.add(tempPBI);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
            }
            if (componentInfo.isContainer()) {
                ComponentCollection subComponentCollection = componentInfo.getComponents();
                ComponentCollection newSubComponentCollection = this.findTheComponent(componentName, propertyName, subComponentCollection, itemNO);
                componentInfo.setComponents(newSubComponentCollection);
            }
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    private PropertyBindingInfo setPropertyBindingInfoValue(PropertyBindingInfo tempPropertyBindingInfo, int itemNO) {
        List dataItem = (List)this.ctrlTable.getRow(itemNO).getUserObject();
        PropertyBindingInfo pbi = (PropertyBindingInfo)dataItem.get(1);
        tempPropertyBindingInfo.setBindingObject(pbi.getBindingObject());
        if (pbi.getBingdingField() != null) {
            tempPropertyBindingInfo.setBingdingField(pbi.getBingdingField());
        } else {
            tempPropertyBindingInfo.setBingdingField("");
        }
        tempPropertyBindingInfo.setAccessType(2);
        tempPropertyBindingInfo.setAutoMode(false);
        tempPropertyBindingInfo.setPropertyType(pbi.getPropertyType());
        tempPropertyBindingInfo.setFieldType(pbi.getFieldType());
        tempPropertyBindingInfo.setUserDefined(pbi.isUserDefined());
        return tempPropertyBindingInfo;
    }

    private void removePropertyFromUIObject(List dataItem) {
        if (dataItem == null) {
            return;
        }
        String componentName = null;
        String propertyName = null;
        if (dataItem.get(0) instanceof ComponentInfo) {
            componentName = ((ComponentInfo)dataItem.get(0)).getName();
            propertyName = ((PropertyBindingInfo)dataItem.get(1)).getPropertyName();
        } else {
            componentName = (String)dataItem.get(0);
            propertyName = (String)dataItem.get(1);
        }
        ComponentCollection componentCollection = this.uiModel.getComponents();
        ComponentCollection newComponentCollection = this.removeThePropertyBindingInfo(componentName, propertyName, componentCollection);
        if (newComponentCollection == null) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5220\u9664\u5931\u8d25\uff01");
            return;
        }
        this.uiModel.setComponents(newComponentCollection);
        this.context.setDirty(true);
    }

    private ComponentCollection removeThePropertyBindingInfo(String componentName, String propertyName, ComponentCollection componentCollection) {
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (componentInfo.getName().trim().equals(componentName)) {
                PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
                for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                    PropertyBindingInfo tempPropertyBindingInfo = propertyBindingCollection.get(j);
                    if (!tempPropertyBindingInfo.getPropertyName().equals(propertyName)) continue;
                    propertyBindingCollection.remove(tempPropertyBindingInfo);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    DataBindUtils.delProBindDesc(componentInfo, tempPropertyBindingInfo);
                    return componentCollection;
                }
            }
            if (componentInfo.isContainer()) {
                ComponentCollection subComponentCollection = componentInfo.getComponents();
                ComponentCollection newSubComponentCollection = this.removeThePropertyBindingInfo(componentName, propertyName, subComponentCollection);
                componentInfo.setComponents(newSubComponentCollection);
            }
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    private boolean compareDataItem(List oldDataItem, List newDataItem) {
        String oldComponentInfoName = (String)oldDataItem.get(0);
        ComponentInfo newComponentInfo = (ComponentInfo)newDataItem.get(0);
        if (oldDataItem.get(3) == null || oldDataItem.get(1) == null || oldDataItem.get(2) == null || oldComponentInfoName == null || newComponentInfo == null) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u6570\u636e\u9519\u8bef");
            return true;
        }
        if (!oldComponentInfoName.equals(newComponentInfo.getName())) {
            return false;
        }
        PropertyBindingInfo newPropertyBindingInfo = (PropertyBindingInfo)newDataItem.get(1);
        if (newPropertyBindingInfo.getPropertyName() == null || newPropertyBindingInfo.getBindingObject() == null || newPropertyBindingInfo.getBingdingField() == null) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u6570\u636e\u9519\u8bef");
            return true;
        }
        if (!oldDataItem.get(1).toString().trim().equals(newPropertyBindingInfo.getPropertyName().trim())) {
            return false;
        }
        if (!oldDataItem.get(2).toString().trim().equals(newPropertyBindingInfo.getBindingObject().trim())) {
            return false;
        }
        return oldDataItem.get(3).toString().trim().equals(newPropertyBindingInfo.getBingdingField().trim());
    }

    public IContext getContext() {
        return this.context;
    }

    public void handUIException(Throwable throwable) {
        logger.error((Object)"error", throwable);
        UICommonUtils.handleException((Throwable)throwable, (Component)((Object)this));
    }
}

