/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bind;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.eas.ep.client.model.dtc.DTControlHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class DataBindUtils {
    public static final String DYNPROPERTYBINDS = "dynpropertybinds";

    public static void extractPropertyToTable(ComponentInfo cInfo, TableInfo tableInfo, EntityObjectInfo bindEntity, PropertyBindingInfo bindInfo, int type) {
        String columnName;
        if (cInfo == null || bindInfo == null) {
            return;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        if (tableInfo == null) {
            PropertyInfo property = cInfo.getProperties().get("formatXml");
            if (property == null) {
                return;
            }
            tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue());
        }
        if (StringUtils.isEmpty((String)(columnName = StringUtils.replace((String)propertyName, (String)".text", (String)"")))) {
            return;
        }
        List columns = tableInfo.getColumns();
        com.kingdee.bos.ui.dtp.kdtable.ColumnInfo column = null;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (!columnName.equalsIgnoreCase(((com.kingdee.bos.ui.dtp.kdtable.ColumnInfo)columns.get(i)).getName())) continue;
            column = (com.kingdee.bos.ui.dtp.kdtable.ColumnInfo)columns.get(i);
            break;
        }
        if (column == null) {
            return;
        }
        String formatXmlExt = cInfo.getExtendedProperty("extend_formatxml");
        TableInfoHelper.parseFormatXmlExt((TableInfo)tableInfo, (String)formatXmlExt);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
        if (prop == null || type == -1) {
            column.removeExtendedProperty("defaultF7Query");
            column.removeExtendedProperty("f7UsedListUIClassName");
            column.removeExtendedProperty("bindpropertytype");
            column.removeExtendedProperty("maxLength");
            column.removeExtendedProperty("precision");
            column.removeExtendedProperty("enumclassname");
            column.removeExtendedProperty("dataField");
        }
        if (type == 1) {
            if (prop instanceof OwnPropertyInfo) {
                if (((OwnPropertyInfo)prop).getDataType() == DataType.ENUM) {
                    column.setExtendedProperty("enumclassname", ((OwnPropertyInfo)prop).getMetaDataRef());
                    column.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
                } else if (DataType.BOOLEAN.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                    column.setExtendedProperty("bindpropertytype", DataType.BOOLEAN.getName());
                } else {
                    ColumnInfo mappingField = DataBindUtils.getMappingField(prop);
                    if (mappingField != null) {
                        SQLType typeName = mappingField.getTypeName();
                        column.setExtendedProperty("bindpropertytype", typeName.getName());
                        if (SQLType.NVARCHAR.equals((Object)typeName)) {
                            int length = mappingField.getLength();
                            column.setExtendedProperty("maxLength", String.valueOf(length));
                        } else if (SQLType.NUMERIC.equals((Object)typeName)) {
                            int maxValueLength = -1;
                            int pr = -1;
                            String bdt = prop.getExtendedProperty("bizDataType");
                            if (BizDataType.AMOUNT.getName().equals(bdt)) {
                                pr = 2;
                            } else if (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt)) {
                                pr = 4;
                            } else {
                                pr = ((OwnPropertyInfo)prop).getDecimalDigits();
                                maxValueLength = ((OwnPropertyInfo)prop).getLength() - pr;
                            }
                            if (pr >= 0) {
                                column.setExtendedProperty("precision", String.valueOf(pr));
                            }
                            if (maxValueLength > 0) {
                                int i;
                                String str = "";
                                for (i = 0; i < maxValueLength; ++i) {
                                    str = str + 9;
                                }
                                str = str + ".";
                                for (i = 0; i < pr; ++i) {
                                    str = str + 9;
                                }
                                column.setExtendedProperty("maximumValue", String.valueOf(str));
                                column.setExtendedProperty("minimumValue", String.valueOf("-" + str));
                            }
                        }
                    }
                }
            } else if (prop instanceof LinkPropertyInfo) {
                String f7ListUIName;
                RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                if (relationShip == null || relationShip.getSupplierObject() == null) {
                    return;
                }
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (!StringUtils.isEmpty((String)sQueryPK)) {
                    column.setExtendedProperty("defaultF7Query", sQueryPK);
                }
                if (!StringUtils.isEmpty((String)(f7ListUIName = supplyEntityInfo.getExtendedProperty("f7UsedListUIClassName")))) {
                    column.setExtendedProperty("f7UsedListUIClassName", f7ListUIName);
                }
            }
        }
        formatXmlExt = TableInfoHelper.toFormatXmlExt((TableInfo)tableInfo);
        cInfo.setExtendedProperty("extend_formatxml", formatXmlExt);
    }

    public static void extractPropertyToComponent(ComponentInfo cInfo, com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProperty = (OwnPropertyInfo)prop;
            if (ownProperty.getDataType() == DataType.ENUM) {
                cInfo.setExtendedProperty("enumclassname", ownProperty.getMetaDataRef());
                cInfo.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
            } else if (DataType.DECIMAL.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                int maxValueLength = -1;
                int pr = -1;
                String bdt = prop.getExtendedProperty("bizDataType");
                if (BizDataType.AMOUNT.getName().equals(bdt)) {
                    pr = 2;
                } else if (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt)) {
                    pr = 4;
                } else {
                    pr = ((OwnPropertyInfo)prop).getDecimalDigits();
                    maxValueLength = ((OwnPropertyInfo)prop).getLength() - pr;
                }
                PropertyCollection pcol = cInfo.getProperties();
                if (maxValueLength > 0) {
                    int i;
                    String str = "";
                    for (i = 0; i < maxValueLength; ++i) {
                        str = str + 9;
                    }
                    str = str + ".";
                    for (i = 0; i < pr; ++i) {
                        str = str + 9;
                    }
                    PropertyInfo length = new PropertyInfo();
                    length.setName("maximumValue");
                    length.setType("int");
                    length.setValue(str);
                    length.setOverride(true);
                    pcol.add(length);
                    length = new PropertyInfo();
                    length.setName("minimumValue");
                    length.setType("int");
                    length.setValue("-" + str);
                    length.setOverride(true);
                    pcol.add(length);
                }
                if (pr >= 0) {
                    PropertyInfo precision = new PropertyInfo();
                    precision.setName("precision");
                    precision.setType("int");
                    precision.setValue(String.valueOf(pr));
                    precision.setOverride(true);
                    pcol.add(precision);
                }
            } else if (DataType.STRING.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                PropertyCollection pcol = cInfo.getProperties();
                int length = -1;
                length = ((OwnPropertyInfo)prop).getLength();
                PropertyInfo maxLength = new PropertyInfo();
                maxLength.setName("maxLength");
                maxLength.setType("int");
                maxLength.setValue(String.valueOf(length));
                maxLength.setOverride(true);
                pcol.add(maxLength);
            } else {
                ColumnInfo mappingField = DataBindUtils.getMappingField(prop);
                if (mappingField != null) {
                    cInfo.setExtendedProperty("bindpropertytype", mappingField.getTypeName().getName());
                }
            }
        }
    }

    public static void extractPropertyToComponentInfo(EntityObjectInfo bindEntity, ComponentInfo cInfo, PropertyBindingInfo bindInfo, int type) {
        if (cInfo == null || bindInfo == null) {
            return;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
        if (prop == null || type == -1) {
            cInfo.removeExtendedProperty("enumclassname");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("f7UsedListUIClassName");
            cInfo.removeExtendedProperty("defaultF7Query");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("displayFormat");
            PropertyCollection collection = cInfo.getProperties();
            if (collection != null && collection.get("precision") != null) {
                cInfo.getProperties().remove("precision");
            }
        }
        if (type == 1) {
            if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(cInfo.getClassType())) {
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProperty = (OwnPropertyInfo)prop;
                    if (ownProperty.getDataType() == DataType.ENUM) {
                        cInfo.setExtendedProperty("enumclassname", ownProperty.getMetaDataRef());
                        cInfo.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
                    } else {
                        ColumnInfo mappingField = DataBindUtils.getMappingField(prop);
                        if (mappingField != null) {
                            cInfo.setExtendedProperty("bindpropertytype", mappingField.getTypeName().getName());
                        }
                    }
                }
            } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(cInfo.getClassType())) {
                if (prop instanceof LinkPropertyInfo) {
                    String f7ListUIName;
                    RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                    if (relationShip == null || relationShip.getSupplierObject() == null) {
                        return;
                    }
                    EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                    String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                    if (!StringUtils.isEmpty((String)sQueryPK)) {
                        cInfo.setExtendedProperty("defaultF7Query", sQueryPK);
                    }
                    if (!StringUtils.isEmpty((String)(f7ListUIName = supplyEntityInfo.getExtendedProperty("f7UsedListUIClassName")))) {
                        cInfo.setExtendedProperty("f7UsedListUIClassName", f7ListUIName);
                    }
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDBusiCurrencyField".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(cInfo.getClassType())) {
                if (prop instanceof OwnPropertyInfo && DataType.DECIMAL.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                    int maxValueLength = -1;
                    int pr = -1;
                    String bdt = prop.getExtendedProperty("bizDataType");
                    if (BizDataType.AMOUNT.getName().equals(bdt)) {
                        pr = 2;
                    } else if (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt)) {
                        pr = 4;
                    } else {
                        pr = ((OwnPropertyInfo)prop).getDecimalDigits();
                        maxValueLength = ((OwnPropertyInfo)prop).getLength() - pr;
                    }
                    PropertyCollection pcol = cInfo.getProperties();
                    if (maxValueLength > 0) {
                        int i;
                        String str = "";
                        for (i = 0; i < maxValueLength; ++i) {
                            str = str + 9;
                        }
                        str = str + ".";
                        for (i = 0; i < pr; ++i) {
                            str = str + 9;
                        }
                        PropertyInfo length = new PropertyInfo();
                        length.setName("maximumValue");
                        length.setType("int");
                        length.setValue(str);
                        length.setOverride(true);
                        pcol.add(length);
                        length = new PropertyInfo();
                        length.setName("minimumValue");
                        length.setType("int");
                        length.setValue("-" + str);
                        length.setOverride(true);
                        pcol.add(length);
                    }
                    if (pr >= 0) {
                        PropertyInfo precision = new PropertyInfo();
                        precision.setName("precision");
                        precision.setType("int");
                        precision.setValue(String.valueOf(pr));
                        precision.setOverride(true);
                        pcol.add(precision);
                    }
                }
            } else if (("com.kingdee.bos.ctrl.swing.KDTextField".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equals(cInfo.getClassType())) && prop instanceof OwnPropertyInfo && DataType.STRING.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                PropertyCollection pcol = cInfo.getProperties();
                int length = -1;
                length = ((OwnPropertyInfo)prop).getLength();
                PropertyInfo maxLength = new PropertyInfo();
                maxLength.setName("maxLength");
                maxLength.setType("int");
                maxLength.setValue(String.valueOf(length));
                maxLength.setOverride(true);
                pcol.add(maxLength);
            }
        }
    }

    private static ColumnInfo getMappingField(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop.getMappingField() != null) {
            return prop.getMappingField();
        }
        if (prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return null;
    }

    public static PropertyBindingInfo getPropertyBindInfo(ComponentInfo comp) {
        String[] propertyNames = DataBindUtils.getAllPropertyNames(comp);
        for (int n = 0; n < propertyNames.length; ++n) {
            String propertyName = propertyNames[n];
            PropertyBindingCollection bindings = comp.getPropertyBindings();
            for (int i = 0; i < bindings.size(); ++i) {
                PropertyBindingInfo info = bindings.get(i);
                if (!propertyName.equals(info.getPropertyName())) continue;
                return info;
            }
        }
        return null;
    }

    public static String[] getAllPropertyNames(ComponentInfo info) {
        if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(info.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(info.getClassType())) {
            return new String[]{"selected"};
        }
        String[] result = DTControlHelper.getControlStaticInfo(info.getClassType()).getAllCanBindingPropName();
        if (info.getClassType().indexOf("KDTable") != -1) {
            for (int i = 0; i < result.length; ++i) {
                int j;
                if (!result[i].equals("formatXml")) continue;
                PropertyInfo tempProp = info.getPropertyByName(result[i]);
                if (tempProp == null || StringUtils.isEmpty((String)tempProp.getValue())) {
                    MsgBox.showError((String)"\u5e94\u5148\u8bbe\u8ba1KDTable\u7684\u57fa\u672c\u5c5e\u6027");
                    return new String[]{"\u5e94\u5148\u8bbe\u8ba1KDTable\u7684\u57fa\u672c\u5c5e\u6027"};
                }
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)tempProp.getValue());
                String[] columnNameList = tableInfo.getColumnNameList();
                PropertyBindingCollection pbc = info.getPropertyBindings();
                ArrayList<String> propertyName = new ArrayList<String>();
                for (int m = 0; m < pbc.size(); ++m) {
                    propertyName.add(pbc.get(m).getPropertyName());
                }
                ArrayList<String> tmpList = new ArrayList<String>();
                for (j = 0; j < columnNameList.length; ++j) {
                    if (!((com.kingdee.bos.ui.dtp.kdtable.ColumnInfo)tableInfo.getColumns().get(j)).isConfigured() || pbc.get(columnNameList[j] + ".text") != null || propertyName.contains(columnNameList[j] + ".text")) continue;
                    tmpList.add(DataBindUtils.getColumnAliasFromName(info, columnNameList[j]) + "(" + columnNameList[j]);
                }
                if (tmpList.size() <= 0) continue;
                String[] realResult = new String[tmpList.size()];
                for (j = 0; j < tmpList.size(); ++j) {
                    realResult[j] = tmpList.get(j) + ".text)";
                }
                return realResult;
            }
        }
        return DataBindUtils.fillterProperties(result);
    }

    public static String getPropertyName(Class classType) {
        if ("com.kingdee.bos.ctrl.swing.KDCheckBox".equals(classType.getName()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(classType.getName())) {
            return "selected";
        }
        if (classType.isAssignableFrom(IColumn.class)) {
            return "text";
        }
        String[] result = DTControlHelper.getControlStaticInfo(classType.getName()).getAllCanBindingPropName();
        if ((result = DataBindUtils.fillterProperties(result)) != null && result.length > 0) {
            return result[0];
        }
        return "";
    }

    public static String getPropertyName(String className) {
        String propertyName = "";
        try {
            Class<?> forName = Class.forName(className);
            propertyName = DataBindUtils.getPropertyName(forName);
        }
        catch (Exception e) {
            propertyName = "text";
        }
        return propertyName;
    }

    private static String[] fillterProperties(String[] properties) {
        if (properties == null) {
            return null;
        }
        ArrayList<String> vvre = new ArrayList<String>();
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (property.equals("toolTipText") || property.equals("enabled") || property.equals("visible") || property.equals("userObject") || property.equals("formatXml")) continue;
            vvre.add(properties[i]);
        }
        String[] newProperties = new String[vvre.size()];
        for (int i = 0; i < vvre.size(); ++i) {
            newProperties[i] = vvre.get(i).toString();
        }
        return newProperties;
    }

    public static String getColumnAliasFromName(ComponentInfo componentInfo, String name) {
        TableInfo tableInfo;
        PropertyInfo property;
        String retVal = null;
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType()) && (property = componentInfo.getProperties().get("formatXml")) != null && (tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)property.getValue())).getHeaders().size() > 0) {
            HeaderInfo headerInfo = (HeaderInfo)tableInfo.getHeaders().get(0);
            List columns = tableInfo.getColumns();
            int cellCount = headerInfo.getCellCount();
            int columnCount = columns.size();
            ArrayList<CellInfo> cells = new ArrayList<CellInfo>();
            for (int index = 0; index < cellCount; ++index) {
                CellInfo cell = (CellInfo)headerInfo.getCells().get(index);
                if (cell.getColSpan() == 0) {
                    cells.add(cell);
                }
                int span = cell.getColSpan();
                for (int j = 0; j < span; ++j) {
                    cells.add(cell);
                }
            }
            cellCount = cells.size();
            String propName = DataBindUtils.getPropertySimpleName(name);
            for (int i = 0; i < columnCount; ++i) {
                com.kingdee.bos.ui.dtp.kdtable.ColumnInfo column = (com.kingdee.bos.ui.dtp.kdtable.ColumnInfo)columns.get(i);
                CellInfo cell = null;
                if (i < cellCount) {
                    cell = (CellInfo)cells.get(i);
                }
                if (!propName.equalsIgnoreCase(column.getName())) continue;
                retVal = cell == null ? column.getName() : cell.getName();
                break;
            }
        }
        return retVal;
    }

    private static String getPropertySimpleName(String name) {
        String simpleName = name;
        int lastIndex = simpleName.lastIndexOf(".");
        if (lastIndex > 0) {
            simpleName = simpleName.substring(0, lastIndex);
        }
        return simpleName;
    }

    public static void addProBindDesc(ComponentInfo componentInfo, PropertyBindingInfo propertyBindingInfo) {
        if (componentInfo == null || propertyBindingInfo == null || StringUtils.isEmpty((String)propertyBindingInfo.getPropertyName())) {
            return;
        }
        String proName = propertyBindingInfo.getPropertyName();
        DataBindUtils.addProBindDesc(componentInfo, proName);
    }

    public static void delProBindDesc(ComponentInfo componentInfo, PropertyBindingInfo propertyBindingInfo) {
        String dynProBinds = componentInfo.getExtendedProperty(DYNPROPERTYBINDS);
        String proName = propertyBindingInfo.getPropertyName();
        if (!StringUtils.isEmpty((String)dynProBinds)) {
            int i;
            boolean exists = false;
            String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
            if (pros != null && pros.length > 0) {
                for (i = 0; i < pros.length; ++i) {
                    if (!proName.equals(pros[i])) continue;
                    pros[i] = null;
                    exists = true;
                }
            }
            if (exists) {
                dynProBinds = null;
                for (i = 0; i < pros.length; ++i) {
                    if (StringUtils.isEmpty((String)pros[i])) continue;
                    dynProBinds = dynProBinds == null ? pros[i] : dynProBinds + "|" + pros[i];
                }
                if (!StringUtils.isEmpty((String)dynProBinds)) {
                    componentInfo.setExtendedProperty(DYNPROPERTYBINDS, dynProBinds);
                } else {
                    componentInfo.removeExtendedProperty(DYNPROPERTYBINDS);
                }
            }
        }
    }

    public static void addProBindDesc(ComponentInfo componentInfo, String proName) {
        if (componentInfo == null || proName == null) {
            return;
        }
        String dynProBinds = componentInfo.getExtendedProperty(DYNPROPERTYBINDS);
        if (StringUtils.isEmpty((String)dynProBinds)) {
            componentInfo.setExtendedProperty(DYNPROPERTYBINDS, proName);
        } else {
            String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
            boolean exists = false;
            if (pros != null && pros.length > 0) {
                for (int i = 0; i < pros.length; ++i) {
                    if (!proName.equals(pros[i])) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                dynProBinds = dynProBinds + "|" + proName;
                componentInfo.setExtendedProperty(DYNPROPERTYBINDS, dynProBinds);
            }
        }
    }
}

