/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bind;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.bind.AbstractNewDataBindUI;
import com.kingdee.eas.ep.client.editor.bind.DataBindChangeListener;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.bind.PropertyBindingInfoProxy;
import com.kingdee.eas.ep.client.editor.bind.javaext.BindSplitPaneUI;
import com.kingdee.eas.ep.client.editor.bind.javaext.EntityFilteredTreeModel;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.AllComponentInfoArr;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.model.dtc.DTControlHelper;
import com.kingdee.eas.ep.client.util.ListVisibleTool;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.wizard.bind.DataBindTreeBuilder;
import com.kingdee.eas.ep.util.ConfigServiceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NewDataBindUI
extends AbstractNewDataBindUI {
    private static final Logger logger = CoreUIObject.getLogger(NewDataBindUI.class);
    private static final String CONFIG_KEY_SHOWSTATICFIELD = "isShowStaticField";
    private static final long serialVersionUID = -3692000490648001044L;
    private Context context;
    private AbstractUIObjectInfo uiModel = null;
    private EntityObjectInfo entityInfo = null;
    private JoinQueryInfo queryInfo = null;
    private Project depend = null;
    private EditUIEditor editor = null;
    private EditPartViewer viewer = null;
    private DataBindChangeListener dataBindChangeListener;
    private KingdeeTreeModel valueTreeModel = null;
    private KingdeeTreeModel componentTreeModel = null;
    private static final double KDTAB_LOCATION = 0.3;
    private static final String DYNPROPERTYBINDS = "dynpropertybinds";
    private Timer moveTimer = null;

    public void onLoad() {
        this.initParameterFromContext();
        this.reJbInit();
        this.showTempTree();
        this.loadData();
    }

    private void showTempTree() {
        DefaultKingdeeTreeNode rootNode1 = new DefaultKingdeeTreeNode((Object)"\u6570\u636e\u88c5\u8f7d\u4e2d,\u8bf7\u7a0d\u5019......");
        DefaultKingdeeTreeNode rootNode2 = new DefaultKingdeeTreeNode((Object)"\u6570\u636e\u88c5\u8f7d\u4e2d,\u8bf7\u7a0d\u5019......");
        rootNode1.setAllowsChildren(true);
        rootNode2.setAllowsChildren(true);
        KDTree tempTree1 = new KDTree((ITreeNode)rootNode1);
        ((KingdeeTreeModel)tempTree1.getModel()).setAsksAllowsChildren(true);
        tempTree1.setShowCheckBox(false);
        KDTree tempTree2 = new KDTree((ITreeNode)rootNode1);
        ((KingdeeTreeModel)tempTree2.getModel()).setAsksAllowsChildren(true);
        tempTree2.setShowCheckBox(false);
        this.objectTree.setVisible(false);
        this.componentTree.setVisible(false);
        this.componentTreeView.setTree(tempTree1);
        this.objectTreeView.setTree(tempTree2);
    }

    private void loadData() {
        Thread t1 = new Thread(new ComponetTreeLazyLoader());
        t1.setDaemon(true);
        t1.start();
        Thread t2 = new Thread(new DataValueTreeLazyLoader());
        t2.setDaemon(true);
        t2.start();
        this.loadBindTable();
    }

    private void initParameterFromContext() {
        try {
            Map uiContext = this.getUIContext();
            this.viewer = (EditPartViewer)uiContext.get("editPartViewer");
            this.editor = (EditUIEditor)uiContext.get("editorUI");
            this.depend = (Project)uiContext.get("depend");
            this.context = (Context)this.viewer.getContext();
            this.uiModel = this.context.getUiModel();
            this.entityInfo = this.context.getEditorUI().getModel().getEntity();
            this.queryInfo = this.context.getEditorUI().getModel().getQuery();
        }
        catch (Exception e) {
            logger.error((Object)"Context\u8bfb\u53d6\u5931\u8d25\u3002\u3002\u3002\u3002\u3002");
            logger.error((Object)e);
            SysUtil.abort();
        }
    }

    public void actionBtnAdd_actionPerformed(ActionEvent e) {
        if (this.beforeBtnAddActionPerformed()) {
            PropertyBindingInfoProxy bindingInfoProxy = this.getBindingInfoProxy();
            if (bindingInfoProxy != null && this.needValidate(this.uiModel) && !this.validate(bindingInfoProxy)) {
                return;
            }
            ComponentInfo componentInfo = bindingInfoProxy.getComponentInfo();
            bindingInfoProxy.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            IRow row = this.bindDataTable.addRow(0);
            row.getCell(0).setValue((Object)componentInfo.getName());
            row.getCell(1).setValue((Object)bindingInfoProxy.getPropertyName());
            row.getCell(2).setValue((Object)bindingInfoProxy.getBindingObject());
            row.getCell(3).setValue((Object)bindingInfoProxy.getBindingFieldAlias());
            row.setUserObject((Object)bindingInfoProxy);
            row.getStyleAttributes().setFontColor(Color.BLUE);
            this.saveForAdd(0);
            BizConfigureTreeNode parent = (BizConfigureTreeNode)this.context.getEditorUI().getRootNode();
            this.dealListVisible(parent, componentInfo, true);
            this.resetComponent(bindingInfoProxy, 1);
            this.getDataBindChangListener().fireDataBindChanged(componentInfo, bindingInfoProxy.getTarget());
            this.loadComponetTree();
            this.loadBindTable();
        }
    }

    private boolean beforeBtnAddActionPerformed() {
        boolean retVal = true;
        DefaultKingdeeTreeNode componentNode = (DefaultKingdeeTreeNode)this.componentTree.getLastSelectedPathComponent();
        if (componentNode == null || !componentNode.isLeaf() || componentNode.isRoot() || componentNode.getUserObject() == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u63a7\u4ef6\u5c5e\u6027\uff01");
            retVal = false;
            return retVal;
        }
        DefaultKingdeeTreeNode objNode = (DefaultKingdeeTreeNode)this.objectTree.getLastSelectedPathComponent();
        DataObjectInfo objInfo = this.getSelectedDataObjInfo();
        if (objNode == null || objNode.isRoot() || objNode.getUserObject() == null || objInfo == null) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5bf9\u8c61\u5c5e\u6027\uff01");
            retVal = false;
            return retVal;
        }
        if (componentNode.getUserObject() instanceof ComponentInfo) {
            String classType = ((ComponentInfo)componentNode.getUserObject()).getClassType();
            com.kingdee.bos.metadata.entity.PropertyInfo propertyInfo = (com.kingdee.bos.metadata.entity.PropertyInfo)objNode.getUserObject();
            if (propertyInfo instanceof OwnPropertyInfo && ((OwnPropertyInfo)propertyInfo).isMultilingual() && !classType.equals("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox") && !classType.equals("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea")) {
                MsgBox.showInfo((String)"\u63a7\u4ef6\u4e0e\u5bf9\u8c61\u5c5e\u6027\u7684\u591a\u8bed\u8a00\u5c5e\u6027\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4\uff01");
                retVal = false;
                return retVal;
            }
            if (!(!classType.equals("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox") && !classType.equals("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea") || propertyInfo instanceof OwnPropertyInfo && ((OwnPropertyInfo)propertyInfo).isMultilingual())) {
                MsgBox.showInfo((String)"\u63a7\u4ef6\u4e0e\u5bf9\u8c61\u5c5e\u6027\u7684\u591a\u8bed\u8a00\u5c5e\u6027\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4\uff01");
                retVal = false;
                return retVal;
            }
            boolean bl = retVal = !this.checkDataObject(objNode);
            if (!retVal) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u975e\u5206\u5f55\u5217\u4e0d\u80fd\u7ed1\u5b9a\u5206\u5f55\u5bf9\u8c61\u7684\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
            return retVal;
        }
        if (componentNode.getUserObject() instanceof String && objNode.getUserObject() instanceof com.kingdee.bos.metadata.entity.PropertyInfo) {
            retVal = this.checkDataObject(objNode);
            if (!retVal) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5206\u5f55\u5217\u4e0d\u80fd\u7ed1\u5b9a\u975e\u5206\u5f55\u5bf9\u8c61\u7684\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
            return retVal;
        }
        if (componentNode.getUserObject() instanceof ComponentInfo) {
            ComponentInfo info = (ComponentInfo)componentNode.getUserObject();
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(info.getClassType())) {
                if (objNode.isLeaf()) {
                    MsgBox.showInfo((String)"\u679a\u4e3e\u548cF7\u7c7b\u578b\u9700\u8981\u7ed1\u5b9a\u5b9e\u4f53\uff01");
                    retVal = false;
                    return retVal;
                }
            } else if (!objNode.isLeaf()) {
                MsgBox.showInfo((String)"\u679a\u4e3e\u548cF7\u4ee5\u5916\u7c7b\u578b\u9700\u8981\u7ed1\u5b9a\u5b9e\u4f53\u5c5e\u6027\uff01");
                retVal = false;
                return retVal;
            }
        }
        return retVal;
    }

    public boolean checkDataObject(DefaultKingdeeTreeNode objNode) {
        if (objNode.getUserObject() instanceof com.kingdee.bos.metadata.entity.PropertyInfo) {
            com.kingdee.bos.metadata.entity.PropertyInfo propertyInfo = (com.kingdee.bos.metadata.entity.PropertyInfo)objNode.getUserObject();
            if (propertyInfo instanceof LinkPropertyInfo) {
                if (((LinkPropertyInfo)propertyInfo).getRelationship().getType().equals((Object)RelationshipType.COMPOSITION) && !((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE)) {
                    return true;
                }
                return this.checkDataObject((DefaultKingdeeTreeNode)objNode.getParent());
            }
            if (propertyInfo instanceof OwnPropertyInfo) {
                return this.checkDataObject((DefaultKingdeeTreeNode)objNode.getParent());
            }
        }
        return false;
    }

    private boolean validate(PropertyBindingInfoProxy bindInfo) {
        if (bindInfo == null || bindInfo.getComponentInfo() == null) {
            MsgBox.showInfo((String)"\u83b7\u53d6\u63a7\u4ef6\u4fe1\u606f\u6216\u8005\u6570\u636e\u7ed1\u5b9a\u4fe1\u606f\u51fa\u9519");
            return false;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            MsgBox.showInfo((String)"\u7ed1\u5b9a\u5bf9\u8c61\uff0c\u7ed1\u5b9a\u5b57\u6bb5\uff0c\u7ed1\u5b9a\u63a7\u4ef6\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(bindInfo.getComponentInfo().getClassType())) {
            EntityObjectInfo bindEntity = this.editor.getBindEntity();
            com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
            if (prop == null) {
                MsgBox.showInfo((String)("\u52a0\u8f7d\u5c5e\u6027 : " + bindField + "\u51fa\u9519"));
                return false;
            }
            if (prop instanceof LinkPropertyInfo) {
                RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                if (relationShip == null || relationShip.getSupplierObject() == null) {
                    MsgBox.showInfo((String)"\u83b7\u53d6relationShip\u51fa\u9519");
                    return false;
                }
                EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                if (supplyEntityInfo == null) {
                    MsgBox.showInfo((String)("supplyEntity is null : " + relationShip.getAlias()));
                    return false;
                }
                String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                if (StringUtils.isEmpty((String)sQueryPK)) {
                    MsgBox.showInfo((String)("\u5173\u8054\u5b9e\u4f53 " + supplyEntityInfo.getFullName() + "\u7f3a\u5c11\u5c55\u5c5e\u6027defaultF7Query\uff0c\u4e0d\u5141\u8bb8\u7ed1\u5b9a\uff0c\u8bf7\u901a\u77e5\u8be5\u5355\u636e\u5f00\u53d1\u4eba\u5458\u5c06\u6269\u5c55\u5c5e\u6027\u8865\u5145\u5b8c\u6574\u3002"));
                    return false;
                }
            } else {
                MsgBox.showInfo((String)"F7\u7c7b\u578b\u63a7\u4ef6\u5e94\u5f53\u7ed1\u5b9a\u8fde\u63a5\u5c5e\u6027");
                return false;
            }
        }
        return true;
    }

    private boolean needValidate(AbstractUIObjectInfo uiobj) {
        if (uiobj == null || !(uiobj instanceof UIObjectInfo)) {
            return false;
        }
        DataObjectCollection col = uiobj.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!MetaDataTypeList.JOINQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.UNIONQUERY.toString().equals(doInfo.getObjectType()) && !MetaDataTypeList.BASEQUERY.toString().equals(doInfo.getObjectType())) continue;
                return false;
            }
        }
        return true;
    }

    public PropertyBindingInfoProxy getBindingInfoProxy() {
        ComponentInfo info = this.getSelectedComponentInfo();
        PropertyBindingInfoProxy pbi = this.getBindingInfo(info);
        return pbi;
    }

    private PropertyBindingInfoProxy getBindingInfo(ComponentInfo componentInfo) {
        PropertyBindingInfo bindingInfo = new PropertyBindingInfo();
        PropertyBindingInfoProxy proxy = new PropertyBindingInfoProxy(bindingInfo);
        DefaultKingdeeTreeNode valueInfo = this.getSelectedValueInfo();
        DataObjectInfo objInfo = this.getSelectedDataObjInfo();
        bindingInfo.setPropertyName(this.getSelectedComponentProperty(componentInfo));
        proxy.setPropertyAlias(componentInfo.getAlias());
        String tempType = DTControlHelper.getControlStaticInfo(componentInfo.getClassType()).getPropStaticInfo(componentInfo.getName()).getType();
        if (StringUtils.isEmpty((String)tempType)) {
            bindingInfo.setPropertyType(Object.class.getName());
        } else {
            bindingInfo.setPropertyType(tempType);
        }
        String bindingObject = objInfo.getName();
        bindingInfo.setBindingObject(bindingObject);
        String[] result = this.getResult(valueInfo);
        bindingInfo.setBingdingField(result[0]);
        bindingInfo.setFieldType(result[1]);
        bindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        proxy.setComponentInfo(componentInfo);
        return proxy;
    }

    private DataObjectInfo getSelectedDataObjInfo() {
        DefaultKingdeeTreeNode node = this.getSelectedValueInfo();
        DataObjectInfo retVal = null;
        while (node != null && node.getParent() != null) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            if (parent.getUserObject() instanceof DataObjectInfo) {
                retVal = (DataObjectInfo)parent.getUserObject();
                break;
            }
            node = parent;
        }
        return retVal;
    }

    private DefaultKingdeeTreeNode getSelectedValueInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.objectTree.getLastSelectedPathComponent();
        return node;
    }

    private ComponentInfo getSelectedComponentInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.componentTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object userObj = node.getUserObject();
        if (userObj instanceof ComponentInfo) {
            return (ComponentInfo)node.getUserObject();
        }
        return (ComponentInfo)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
    }

    private String getSelectedComponentProperty(ComponentInfo componentInfo) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.componentTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) {
            String property = (String)node.getUserObject();
            int begin = property.indexOf("(");
            int end = property.indexOf(")");
            if (begin > 0 && end > begin) {
                property = property.substring(begin + 1, end);
            }
            return property;
        }
        String property = node.getText();
        int begin = property.indexOf("(");
        int end = property.indexOf(")");
        if (begin > 0 && end > begin) {
            property = property.substring(begin + 1, end);
        }
        int index = property.lastIndexOf(".");
        property = property.substring(index + 1);
        return property;
    }

    private String[] getResult(DefaultKingdeeTreeNode node) {
        String filedType;
        String[] resArr = new String[2];
        resArr[0] = NewDataBindUI.getBindField(node);
        Object propData = node.getUserObject();
        while (node.getParent() != null && !((DefaultKingdeeTreeNode)node.getParent()).isRoot() && !(((DefaultKingdeeTreeNode)node.getParent()).getUserObject() instanceof DataObjectInfo)) {
            if (node.getParent() == null) continue;
            node = (DefaultKingdeeTreeNode)node.getParent();
        }
        DataObjectInfo tempInfo = null;
        DefaultKingdeeTreeNode parent2 = (DefaultKingdeeTreeNode)node.getParent();
        if (parent2.getUserObject() instanceof DataObjectInfo) {
            tempInfo = (DataObjectInfo)parent2.getUserObject();
        }
        resArr[1] = filedType = NewDataBindUI.getFiledType(propData, tempInfo);
        return resArr;
    }

    public static String getBindField(DefaultKingdeeTreeNode node) {
        ArrayList<String> vec;
        StringBuffer result;
        block4: {
            result = new StringBuffer();
            if (node == null) {
                return null;
            }
            vec = new ArrayList<String>();
            String name = null;
            Object userObject = null;
            while (true) {
                name = (userObject = node.getUserObject()) != null && userObject instanceof AbstractMDValue ? ((AbstractMDValue)userObject).getString("name") : node.getText();
                vec.add(0, name);
                if (node.getParent() == null || ((DefaultKingdeeTreeNode)node.getParent()).isRoot() || ((DefaultKingdeeTreeNode)node.getParent()).getUserObject() instanceof DataObjectInfo) break block4;
                if (node.getParent() == null) break;
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            return null;
        }
        for (int i = 0; i < vec.size(); ++i) {
            if (i == 0) {
                result.append((String)vec.get(i));
                continue;
            }
            result.append("." + (String)vec.get(i));
        }
        return result.toString();
    }

    public static String getFiledType(Object field, DataObjectInfo parent) {
        String type = "java.lang.String";
        if (field instanceof OwnPropertyInfo) {
            OwnPropertyInfo propInfo = (OwnPropertyInfo)field;
            type = DataType.ENUM.equals((Object)propInfo.getDataType()) ? propInfo.getMetaDataRef() : propInfo.getJavaType();
        } else if (field instanceof LinkPropertyInfo) {
            boolean isClient;
            LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)field;
            type = linkPropInfo.getRelationship().getSupplierObject().getObjectValueClass();
            RelationshipInfo ship = linkPropInfo.getRelationship();
            boolean bl = isClient = ship.getClientObject().getFullName().equals(parent.getType()) || !ship.getSupplierObject().getFullName().equals(parent.getType());
            type = isClient ? (CardinalityType.isOneORZero((CardinalityType)ship.getSupplierCardinality()) ? ship.getSupplierObject().getObjectValueClass() : ship.getSupplierObject().getObjectCollectionClass()) : (CardinalityType.isOneORZero((CardinalityType)ship.getClientCardinality()) ? ship.getClientObject().getObjectValueClass() : ship.getClientObject().getObjectCollectionClass());
        }
        return type;
    }

    public void actionBtnDel_actionPerformed(ActionEvent e) {
        PropertyBindingInfoProxy infoProxy;
        int i;
        int[] rowIndex = KDTableUtil.getSelectedRows((KDTable)this.bindDataTable);
        if (rowIndex.length <= 0) {
            MsgBox.showInfo((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5df2\u7ed1\u5b9a\u6570\u636e\uff01");
            return;
        }
        for (i = 0; i < rowIndex.length; ++i) {
            infoProxy = (PropertyBindingInfoProxy)this.bindDataTable.getRow(rowIndex[i]).getUserObject();
            if (!this.isConfigured(infoProxy)) {
                MsgBox.showInfo((String)("\u9759\u6001\u7ed1\u5b9a\u5173\u7cfb\u3010" + infoProxy.getPropertyAlias() + "\u3011\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
                return;
            }
            if (!this.isEntries(infoProxy)) continue;
            MsgBox.showInfo((String)("\u5bf9\u8c61\u7ed1\u5b9a\u5173\u7cfb\u3010" + infoProxy.getPropertyAlias() + "\u3011\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
            return;
        }
        for (i = 0; i < rowIndex.length; ++i) {
            infoProxy = (PropertyBindingInfoProxy)this.bindDataTable.getRow(rowIndex[i]).getUserObject();
            ComponentInfo componentInfo = infoProxy.getComponentInfo();
            BizConfigureTreeNode parent = (BizConfigureTreeNode)this.context.getEditorUI().getRootNode();
            this.dealListVisible(parent, componentInfo, false);
            this.removePropertyFromUIObject(infoProxy);
            PropertyBindingInfo propertyBindingInfo = infoProxy.getTarget();
            propertyBindingInfo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            this.resetComponent(infoProxy, -1);
            this.getDataBindChangListener().fireDataBindChanged(componentInfo, null);
        }
        this.loadBindTable();
        this.loadComponetTree();
        this.loadObjectTree();
    }

    public void dealListVisible(BizConfigureTreeNode parent, ComponentInfo comp, boolean isVisible) {
        BizUnitInfo bizunit = this.context.getEditorUI().getModel();
        if (parent != null) {
            int i;
            int n = parent.getConfigureItems().size();
            for (i = 0; i < n; ++i) {
                BizConfigureItemInfo item = (BizConfigureItemInfo)parent.getConfigureItems().get(i);
                if (!UIType.EDITUI.equals((Object)this.context.getUitype()) || item.getComponent() == null && item.getEntry() == null) continue;
                ComponentInfo info = null;
                info = item.getComponent() != null ? item.getComponent() : item.getEntry();
                if (!info.equals((Object)comp) || !item.isListVisible()) continue;
                PropertyBindingCollection bindings = info.getPropertyBindings();
                if (bindings != null && !bindings.isEmpty()) {
                    if (isVisible) {
                        String bindingField = bindings.get(0).getBingdingField();
                        com.kingdee.bos.metadata.entity.PropertyInfo proInfo = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)this.entityInfo, (String)bindingField);
                        item.setProperty(proInfo);
                    }
                    ListVisibleTool tool = new ListVisibleTool(this.context, bizunit, item);
                    tool.setListVisible(isVisible);
                }
                return;
            }
            n = parent.getChildCount();
            for (i = 0; i < n; ++i) {
                this.dealListVisible((BizConfigureTreeNode)((Object)parent.getChildAt(i)), comp, isVisible);
            }
        }
    }

    private void removePropertyFromUIObject(PropertyBindingInfoProxy bindInfoProxy) {
        ComponentCollection componentCollection;
        String propertyName;
        if (bindInfoProxy == null) {
            return;
        }
        String componentName = bindInfoProxy.getComponentInfo().getName();
        ComponentCollection newComponentCollection = this.removeThePropertyBindingInfo(componentName, propertyName = bindInfoProxy.getPropertyName(), componentCollection = this.uiModel.getComponents());
        if (newComponentCollection == null) {
            ExceptionHandler.handleError((Component)((Object)this), null, "\u5220\u9664\u5931\u8d25\uff01");
            return;
        }
        this.uiModel.setComponents(newComponentCollection);
        this.context.setDirty(true);
    }

    private ComponentCollection removeThePropertyBindingInfo(String componentName, String propertyName, ComponentCollection componentCollection) {
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (componentInfo.getName().trim().equals(componentName)) {
                PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
                for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                    PropertyBindingInfo tempPropertyBindingInfo = propertyBindingCollection.get(j);
                    if (!tempPropertyBindingInfo.getPropertyName().equals(propertyName)) continue;
                    propertyBindingCollection.remove(tempPropertyBindingInfo);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    this.delProBindDesc(componentInfo, tempPropertyBindingInfo);
                    return componentCollection;
                }
            }
            if (componentInfo.isContainer()) {
                ComponentCollection subComponentCollection = componentInfo.getComponents();
                ComponentCollection newSubComponentCollection = this.removeThePropertyBindingInfo(componentName, propertyName, subComponentCollection);
                componentInfo.setComponents(newSubComponentCollection);
            }
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    private void delProBindDesc(ComponentInfo componentInfo, PropertyBindingInfo propertyBindingInfo) {
        String dynProBinds = componentInfo.getExtendedProperty(DYNPROPERTYBINDS);
        String proName = propertyBindingInfo.getPropertyName();
        if (!StringUtils.isEmpty((String)dynProBinds)) {
            int i;
            boolean exists = false;
            String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
            if (pros != null && pros.length > 0) {
                for (i = 0; i < pros.length; ++i) {
                    if (!proName.equals(pros[i])) continue;
                    pros[i] = null;
                    exists = true;
                }
            }
            if (exists) {
                dynProBinds = null;
                for (i = 0; i < pros.length; ++i) {
                    if (StringUtils.isEmpty((String)pros[i])) continue;
                    dynProBinds = dynProBinds == null ? pros[i] : dynProBinds + "|" + pros[i];
                }
                if (!StringUtils.isEmpty((String)dynProBinds)) {
                    componentInfo.setExtendedProperty(DYNPROPERTYBINDS, dynProBinds);
                } else {
                    componentInfo.removeExtendedProperty(DYNPROPERTYBINDS);
                }
            }
        }
    }

    @Override
    protected void actionBindDataTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (((double)this.mainPanel.getDividerLocation() + 0.0) / (double)this.mainPanel.getHeight() > 0.3) {
            this.moveMainPanelDividerLocation(0.3);
        }
    }

    @Override
    protected void actionComponentTree_mouseClicked(MouseEvent e) throws Exception {
        if (((double)this.mainPanel.getDividerLocation() + 0.0) / (double)this.mainPanel.getHeight() < 0.7) {
            this.moveMainPanelDividerLocation(0.7);
        }
    }

    @Override
    protected void actionObjectTree_mouseClicked(MouseEvent e) throws Exception {
        if (((double)this.mainPanel.getDividerLocation() + 0.0) / (double)this.mainPanel.getHeight() < 0.7) {
            this.moveMainPanelDividerLocation(0.7);
        }
    }

    @Override
    protected void actionIsShowStaticMD_actionPerformed(ActionEvent e) throws Exception {
        KDCheckBox checkBox = (KDCheckBox)e.getSource();
        EntityFilteredTreeModel model = (EntityFilteredTreeModel)((Object)this.objectTree.getModel());
        model.setIsShowStaticEntity(checkBox.isSelected());
        this.objectTree.expandOnLevel(3);
        ConfigServiceUtils.saveUserConfigData(CONFIG_KEY_SHOWSTATICFIELD, this.getMetaDataPK(), String.valueOf(checkBox.isSelected()));
    }

    private void loadBindTable() {
        this.bindDataTable.removeRows();
        List bindingInfos = this.getAllPropertyBindingInfos(this.uiModel);
        for (PropertyBindingInfoProxy propertyBindingInfo : bindingInfos) {
            ComponentInfo compInfo;
            if (propertyBindingInfo == null || (compInfo = propertyBindingInfo.getComponentInfo()) == null) continue;
            IRow row = this.bindDataTable.addRow();
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(compInfo.getClassType())) {
                String showSimpleName = this.getSimplePropertyName(propertyBindingInfo.getPropertyName());
                row.getCell(0).setValue((Object)(compInfo.getName() + "." + showSimpleName));
            } else {
                row.getCell(0).setValue((Object)compInfo.getName());
            }
            row.getCell(1).setValue((Object)propertyBindingInfo.getPropertyAlias());
            row.getCell(2).setValue((Object)(propertyBindingInfo.getBindingObjAlias() + "." + propertyBindingInfo.getBingdingField()));
            row.getCell(3).setValue((Object)propertyBindingInfo.getBindingFieldAlias());
            row.setUserObject((Object)propertyBindingInfo);
            if (!this.isConfigured(propertyBindingInfo)) continue;
            row.getStyleAttributes().setFontColor(Color.BLUE);
            if (this.bindDataTable.getRowCount() <= 1) continue;
            int rowCount = this.bindDataTable.getRowCount() - 1;
            this.bindDataTable.moveRow(rowCount, 0);
        }
        if (this.bindDataTable.getRowCount() > 0) {
            this.bindDataTable.getSelectManager().removeAll();
            this.bindDataTable.getSelectManager().add(0, 0);
        }
    }

    private String getSimplePropertyName(String name) {
        int lastIndex = name.lastIndexOf(".");
        if (lastIndex > 0) {
            name = name.substring(0, lastIndex);
        }
        return name;
    }

    private boolean isConfigured(PropertyBindingInfoProxy PBProxy) {
        boolean retVal = false;
        if (PBProxy == null || PBProxy.getComponentInfo() == null) {
            return retVal;
        }
        String pro = PBProxy.getComponentInfo().getExtendedProperty(DYNPROPERTYBINDS);
        if (StringUtils.isEmpty((String)pro)) {
            return retVal;
        }
        String[] split = StringUtils.split((String)pro, (String)"|");
        for (int i = 0; i < split.length; ++i) {
            if (!PBProxy.getPropertyName().equals(split[i])) continue;
            retVal = true;
        }
        return retVal;
    }

    private boolean isEntries(PropertyBindingInfoProxy PBProxy) {
        boolean retVal = false;
        if (PBProxy == null || PBProxy.getComponentInfo() == null) {
            return retVal;
        }
        String classType = PBProxy.getComponentInfo().getClassType();
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(classType) && "userObject".equals(PBProxy.getPropertyName())) {
            retVal = true;
        }
        return retVal;
    }

    private List getAllPropertyBindingInfos(AbstractUIObjectInfo uiobject) {
        ComponentCollection componentCollection = uiobject.getComponents();
        if (componentCollection == null || componentCollection.size() == 0) {
            return null;
        }
        ArrayList<PropertyBindingInfoProxy> bindingInfos = new ArrayList<PropertyBindingInfoProxy>();
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
            if (propertyBindingCollection == null || propertyBindingCollection.size() == 0) continue;
            for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                PropertyBindingInfoProxy proxy = new PropertyBindingInfoProxy(propertyBindingCollection.get(j));
                proxy = this.getPropertyBindingInfoProxy(proxy, componentInfo, uiobject.getDataObjects());
                proxy.setComponentInfo(componentInfo);
                bindingInfos.add(proxy);
            }
        }
        return bindingInfos;
    }

    private PropertyBindingInfoProxy getPropertyBindingInfoProxy(PropertyBindingInfoProxy proxy, ComponentInfo componentInfo, DataObjectCollection dataObjects) {
        PropertyBindingInfo target = proxy.getTarget();
        String fieldName = proxy.getBingdingField();
        String bindingObjectName = proxy.getBindingObject();
        if (this.entityInfo != null) {
            String alias = this.getPropertyAliasFromEntity(this.entityInfo, fieldName);
            proxy.setBindingFieldAlias(alias);
            proxy.setBindingObjAlias(this.entityInfo.get("name").toString());
        } else if (this.queryInfo != null) {
            JoinQueryInfo query = this.queryInfo;
            ArrayList fields = query.getSelector().getFields();
            for (int i = 0; i < fields.size(); ++i) {
                QueryFieldInfo field = (QueryFieldInfo)fields.get(i);
                if (fieldName == null || !fieldName.equalsIgnoreCase(field.getName())) continue;
                proxy.setBindingFieldAlias(field.getDisplayName());
                break;
            }
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(componentInfo.getClassType())) {
            String columeAlias = DataBindUtils.getColumnAliasFromName(componentInfo, target.getPropertyName());
            proxy.setPropertyAlias(columeAlias);
        } else {
            String lias = UictUtils.getAlias(componentInfo);
            proxy.setPropertyAlias(lias);
        }
        return proxy;
    }

    private String getPropertyAliasFromEntity(EntityObjectInfo entity, String field) {
        int index = field.indexOf(".");
        if (index > 0) {
            String fieldName = field.substring(0, index);
            com.kingdee.bos.metadata.entity.PropertyInfo property = null;
            property = entity.getPropertyByName(fieldName);
            if (property != null && property instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
                entity = relation.isClient(fieldName) ? relation.getSupplierObject() : relation.getClientObject();
                return this.getPropertyAliasFromEntity(entity, field.substring(index + 1));
            }
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo property = entity.getPropertyByName(field);
        String alias = "";
        if (property != null) {
            alias = property.getAlias();
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponetTree() {
        DefaultKingdeeTreeNode componentTreeRoot = new DefaultKingdeeTreeNode((Object)"\u63a7\u4ef6");
        try {
            this.componentTreeModel = new KingdeeTreeModel((TreeNode)componentTreeRoot);
            this.componentTree.setModel((TreeModel)this.componentTreeModel);
            if (!(this.uiModel instanceof AbstractUIObjectInfo)) {
                return;
            }
            AllComponentInfoArr allComponentInfoArr = new AllComponentInfoArr(this.uiModel);
            if (allComponentInfoArr.getComponentInfoArr().toArray().length <= 0) {
                return;
            }
            DataBindTreeBuilder.initComponentTree(this.componentTree, allComponentInfoArr);
            TreePath path = this.componentTree.getSelectionPath();
            this.componentTreeModel.reload();
            this.componentTree.setSelectionPath(path);
            this.componentTree.expandOnLevel(3);
        }
        catch (Exception e) {
            componentTreeRoot.setText("\u521d\u59cb\u5316\u63a7\u4ef6\u6811\u51fa\u9519,\u8bf7\u67e5\u770b\u65e5\u5fd7");
            logger.error((Object)"\u521d\u59cb\u5316\u63a7\u4ef6\u6811\u51fa\u9519", (Throwable)e);
        }
        finally {
            this.componentTreeView.setTree(this.componentTree);
            this.componentTree.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjectTree() {
        DefaultKingdeeTreeNode valueTreeRoot = new DefaultKingdeeTreeNode((Object)"\u5b9e\u4f53");
        if (!"editUI".equals(((Context)this.viewer.getContext()).getUitype().getName())) {
            valueTreeRoot = new DefaultKingdeeTreeNode((Object)"\u4e1a\u52a1\u6570\u636e\u6e90");
        }
        try {
            this.valueTreeModel = new EntityFilteredTreeModel(valueTreeRoot);
            this.objectTree.setModel((TreeModel)this.valueTreeModel);
            if (!(this.uiModel instanceof AbstractUIObjectInfo)) {
                return;
            }
            DataObjectCollection dataObjectCollection = this.uiModel.getDataObjects();
            if (dataObjectCollection == null || dataObjectCollection.size() == 0) {
                return;
            }
            IUIEditor editorUI = ((Context)this.viewer.getContext()).getEditorUI();
            DataBindTreeBuilder.initValueObjTree(this.objectTree, editorUI, dataObjectCollection, this.depend);
            this.valueTreeModel.reload();
            boolean showStaticField = Boolean.valueOf(ConfigServiceUtils.getUserConfigData(CONFIG_KEY_SHOWSTATICFIELD, this.getMetaDataPK()));
            if (this.isShowStaticMD.isSelected() != showStaticField) {
                this.isShowStaticMD.setSelected(showStaticField);
            }
            ((EntityFilteredTreeModel)this.valueTreeModel).setIsShowStaticEntity(showStaticField);
            this.objectTree.expandOnLevel(3);
        }
        catch (Exception e) {
            valueTreeRoot.setText("\u521d\u59cb\u5316\u5bf9\u8c61\u6811\u51fa\u9519,\u8bf7\u67e5\u770b\u65e5\u5fd7");
            logger.error((Object)"\u521d\u59cb\u5316\u5bf9\u8c61\u6811\u51fa\u9519", (Throwable)e);
        }
        finally {
            this.objectTreeView.setTree(this.objectTree);
            this.objectTree.setVisible(true);
        }
    }

    private void reJbInit() {
        int defaultMinW1 = (int)this.componentTreeView.getMinimumSize().getWidth();
        this.componentTreeView.setMinimumSize(new Dimension(defaultMinW1, 23));
        int defaultMinW2 = (int)this.componentTreeView.getMinimumSize().getWidth();
        this.objectTreeView.setMinimumSize(new Dimension(defaultMinW2, 23));
        this.mainPanel.setUI((SplitPaneUI)((Object)new BindSplitPaneUI(this.mainPanel)));
        this.mainPanel.setDividerLocation(0.5);
        this.treePanel.setDividerLocation(this.mainPanel.getWidth() / 2 - 5);
        this.bindDataTable.setEditable(false);
        this.bindDataTable.checkParsed(true);
        this.bindDataTable.getSelectManager().setSelectMode(10);
    }

    protected void saveForAdd(int rowNum) {
        PropertyBindingInfoProxy bindingInfoProxy = (PropertyBindingInfoProxy)this.bindDataTable.getRow(rowNum).getUserObject();
        if (bindingInfoProxy == null) {
            return;
        }
        ComponentInfo componentInfo = bindingInfoProxy.getComponentInfo();
        String componentName = componentInfo.getName();
        String propertyName = bindingInfoProxy.getPropertyName();
        String objectName = bindingInfoProxy.getBindingObject();
        String filedName = bindingInfoProxy.getBingdingField();
        if (componentName == null || componentName.equals("") || propertyName == null || propertyName.equals("") || objectName == null || objectName.equals("")) {
            return;
        }
        if ((filedName == null || filedName.equals("")) && propertyName.indexOf("items") == -1) {
            return;
        }
        ComponentCollection componentCollection = this.uiModel.getComponents();
        this.findTheComponent(componentName, propertyName, componentCollection, rowNum);
        this.addProBindDesc(componentInfo, bindingInfoProxy.getTarget());
        this.viewer.getContext().setDirty(true);
    }

    private void addProBindDesc(ComponentInfo componentInfo, PropertyBindingInfo propertyBindingInfo) {
        if (componentInfo == null || propertyBindingInfo == null || StringUtils.isEmpty((String)propertyBindingInfo.getPropertyName())) {
            return;
        }
        String proName = propertyBindingInfo.getPropertyName();
        if (componentInfo == null || proName == null) {
            return;
        }
        String dynProBinds = componentInfo.getExtendedProperty(DYNPROPERTYBINDS);
        if (StringUtils.isEmpty((String)dynProBinds)) {
            componentInfo.setExtendedProperty(DYNPROPERTYBINDS, proName);
        } else {
            String[] pros = StringUtils.split((String)dynProBinds, (String)"|");
            boolean exists = false;
            if (pros != null && pros.length > 0) {
                for (int i = 0; i < pros.length; ++i) {
                    if (!proName.equals(pros[i])) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                dynProBinds = dynProBinds + "|" + proName;
                componentInfo.setExtendedProperty(DYNPROPERTYBINDS, dynProBinds);
            }
        }
    }

    private ComponentCollection findTheComponent(String componentName, String propertyName, ComponentCollection componentCollection, int itemNO) {
        boolean find = false;
        for (int i = 0; i < componentCollection.size(); ++i) {
            ComponentInfo componentInfo = componentCollection.get(i);
            if (componentInfo.getName().trim().equals(componentName)) {
                PropertyBindingCollection propertyBindingCollection = componentInfo.getPropertyBindings();
                for (int j = 0; j < propertyBindingCollection.size(); ++j) {
                    PropertyBindingInfo tempPropertyBindingInfo = propertyBindingCollection.get(j);
                    if (!tempPropertyBindingInfo.getPropertyName().equals(propertyName)) continue;
                    find = true;
                    tempPropertyBindingInfo = this.setPropertyBindingInfoValue(tempPropertyBindingInfo, itemNO);
                    propertyBindingCollection.set(j, tempPropertyBindingInfo);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
                if (!find) {
                    PropertyBindingInfo tempPBI = new PropertyBindingInfo();
                    tempPBI.setPropertyName(propertyName);
                    tempPBI = this.setPropertyBindingInfoValue(tempPBI, itemNO);
                    propertyBindingCollection.add(tempPBI);
                    componentInfo.setPropertyBindings(propertyBindingCollection);
                    componentCollection.set(i, componentInfo);
                    return componentCollection;
                }
            }
            if (componentInfo.isContainer()) {
                ComponentCollection subComponentCollection = componentInfo.getComponents();
                ComponentCollection newSubComponentCollection = this.findTheComponent(componentName, propertyName, subComponentCollection, itemNO);
                componentInfo.setComponents(newSubComponentCollection);
            }
            componentCollection.set(i, componentInfo);
        }
        return componentCollection;
    }

    private PropertyBindingInfo setPropertyBindingInfoValue(PropertyBindingInfo tempPropertyBindingInfo, int itemNO) {
        PropertyBindingInfoProxy bindingInfoProxy = (PropertyBindingInfoProxy)this.bindDataTable.getRow(itemNO).getUserObject();
        tempPropertyBindingInfo.setBindingObject(bindingInfoProxy.getBindingObject());
        if (bindingInfoProxy.getBingdingField() != null) {
            tempPropertyBindingInfo.setBingdingField(bindingInfoProxy.getBingdingField());
        } else {
            tempPropertyBindingInfo.setBingdingField("");
        }
        tempPropertyBindingInfo.setAccessType(2);
        tempPropertyBindingInfo.setAutoMode(false);
        tempPropertyBindingInfo.setPropertyType(bindingInfoProxy.getTarget().getPropertyType());
        tempPropertyBindingInfo.setFieldType(bindingInfoProxy.getTarget().getFieldType());
        tempPropertyBindingInfo.setUserDefined(bindingInfoProxy.isUserDefined());
        return tempPropertyBindingInfo;
    }

    protected DataBindChangeListener getDataBindChangListener() {
        if (this.dataBindChangeListener == null) {
            this.dataBindChangeListener = new DataBindChangeListener(this.context, this.depend);
        }
        return this.dataBindChangeListener;
    }

    private void resetComponent(PropertyBindingInfoProxy bindInfo, int type) {
        if (bindInfo == null || bindInfo.getComponentInfo() == null) {
            return;
        }
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(bindInfo.getComponentInfo().getClassType())) {
            this.extractPropertyToTable(bindInfo, type);
        } else {
            this.extractPropertyToComponentInfo(bindInfo, type);
        }
    }

    private void extractPropertyToComponentInfo(PropertyBindingInfoProxy bindInfo, int type) {
        if (bindInfo == null) {
            return;
        }
        ComponentInfo cInfo = bindInfo.getComponentInfo();
        if (cInfo == null) {
            return;
        }
        String bindingObject = bindInfo.getBindingObject();
        String bindField = bindInfo.getBingdingField();
        String propertyName = bindInfo.getPropertyName();
        if (StringUtils.isEmpty((String)bindingObject) || StringUtils.isEmpty((String)bindField) || StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        EntityObjectInfo bindEntity = this.getBindEntity(this.uiModel, bindingObject);
        com.kingdee.bos.metadata.entity.PropertyInfo prop = EditUIProxyHelper.getPropertyByName((EntityObjectInfo)bindEntity, (String)bindField);
        if (prop == null || type == -1) {
            cInfo.removeExtendedProperty("enumclassname");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("f7UsedListUIClassName");
            cInfo.removeExtendedProperty("defaultF7Query");
            cInfo.removeExtendedProperty("bindpropertytype");
            cInfo.removeExtendedProperty("displayFormat");
            PropertyCollection collection = cInfo.getProperties();
            if (collection != null && collection.get("precision") != null) {
                cInfo.getProperties().remove("precision");
            }
        }
        if (type == 1) {
            if ("com.kingdee.bos.ctrl.swing.KDComboBox".equals(cInfo.getClassType())) {
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProperty = (OwnPropertyInfo)prop;
                    if (ownProperty.getDataType() == DataType.ENUM) {
                        cInfo.setExtendedProperty("enumclassname", ownProperty.getMetaDataRef());
                        cInfo.setExtendedProperty("bindpropertytype", DataType.ENUM.getName());
                    } else {
                        ColumnInfo mappingField = NewDataBindUI.getMappingField(prop);
                        if (mappingField != null) {
                            cInfo.setExtendedProperty("bindpropertytype", mappingField.getTypeName().getName());
                        }
                    }
                }
            } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(cInfo.getClassType())) {
                if (prop instanceof LinkPropertyInfo) {
                    String f7ListUIName;
                    RelationshipInfo relationShip = ((LinkPropertyInfo)prop).getRelationship();
                    if (relationShip == null || relationShip.getSupplierObject() == null) {
                        return;
                    }
                    EntityObjectInfo supplyEntityInfo = relationShip.getSupplierObject();
                    String sQueryPK = supplyEntityInfo.getExtendedProperty("defaultF7Query");
                    if (!StringUtils.isEmpty((String)sQueryPK)) {
                        cInfo.setExtendedProperty("defaultF7Query", sQueryPK);
                    }
                    if (!StringUtils.isEmpty((String)(f7ListUIName = supplyEntityInfo.getExtendedProperty("f7UsedListUIClassName")))) {
                        cInfo.setExtendedProperty("f7UsedListUIClassName", f7ListUIName);
                    }
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDBusiCurrencyField".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(cInfo.getClassType())) {
                if (prop instanceof OwnPropertyInfo && DataType.DECIMAL.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                    int maxValueLength = -1;
                    int pr = -1;
                    String bdt = prop.getExtendedProperty("bizDataType");
                    if (BizDataType.AMOUNT.getName().equals(bdt)) {
                        pr = 2;
                    } else if (BizDataType.PRICE.getName().equals(bdt) || BizDataType.QUANTITY.getName().equals(bdt)) {
                        pr = 4;
                    } else {
                        pr = ((OwnPropertyInfo)prop).getDecimalDigits();
                        maxValueLength = ((OwnPropertyInfo)prop).getLength() - pr;
                    }
                    PropertyCollection pcol = cInfo.getProperties();
                    if (maxValueLength > 0) {
                        int i;
                        String str = "";
                        for (i = 0; i < maxValueLength; ++i) {
                            str = str + 9;
                        }
                        str = str + ".";
                        for (i = 0; i < pr; ++i) {
                            str = str + 9;
                        }
                        PropertyInfo length = new PropertyInfo();
                        length.setName("maximumValue");
                        length.setType("int");
                        length.setValue(str);
                        length.setOverride(true);
                        pcol.add(length);
                        length = new PropertyInfo();
                        length.setName("minimumValue");
                        length.setType("int");
                        length.setValue("-" + str);
                        length.setOverride(true);
                        pcol.add(length);
                    }
                    if (pr >= 0) {
                        PropertyInfo precision = new PropertyInfo();
                        precision.setName("precision");
                        precision.setType("int");
                        precision.setValue(String.valueOf(pr));
                        precision.setOverride(true);
                        pcol.add(precision);
                    }
                }
            } else if (("com.kingdee.bos.ctrl.swing.KDTextField".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equals(cInfo.getClassType())) && prop instanceof OwnPropertyInfo && DataType.STRING.equals((Object)((OwnPropertyInfo)prop).getDataType())) {
                PropertyCollection pcol = cInfo.getProperties();
                int length = -1;
                length = ((OwnPropertyInfo)prop).getLength();
                PropertyInfo maxLength = new PropertyInfo();
                maxLength.setName("maxLength");
                maxLength.setType("int");
                maxLength.setValue(String.valueOf(length));
                maxLength.setOverride(true);
                pcol.add(maxLength);
            }
        }
    }

    private static ColumnInfo getMappingField(com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (prop == null) {
            return null;
        }
        if (prop.getMappingField() != null) {
            return prop.getMappingField();
        }
        if (prop.getExtendedField() != null) {
            return prop.getExtendedField().getExtendedColumn();
        }
        return null;
    }

    private void extractPropertyToTable(PropertyBindingInfoProxy bindInfo, int type) {
        if (bindInfo != null && !StringUtils.isEmpty((String)bindInfo.getBindingObject())) {
            EntityObjectInfo bindEntity = this.getBindEntity(this.uiModel, bindInfo.getBindingObject());
            DataBindUtils.extractPropertyToTable(bindInfo.getComponentInfo(), null, bindEntity, bindInfo.getTarget(), type);
        }
    }

    public EntityObjectInfo getBindEntity(AbstractUIObjectInfo uiModel, String entityName) {
        DataObjectCollection col = uiModel.getDataObjects();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                DataObjectInfo doInfo = col.get(i);
                if (!doInfo.getName().equals(entityName) || !doInfo.getObjectType().equals(MetaDataTypeList.ENTITY.toString())) continue;
                MetaDataPK entitypk = MetaDataPK.create((String)doInfo.getType());
                EntityObjectInfo bindEntity = UictUtils.loadEntity((IMetaDataPK)entitypk, this.depend);
                return bindEntity;
            }
        }
        return null;
    }

    private void moveMainPanelDividerLocation(double location) {
    }

    class MoveActionListener
    implements ActionListener {
        private Timer parentTimer = null;
        private int beginLocation = 0;
        private int endLocation = 0;
        private int currentLocation = 0;
        private static final int moveSpeed = 5;

        public MoveActionListener(int beginLocation, int endLocation) {
            this.beginLocation = beginLocation;
            this.currentLocation = beginLocation;
            this.endLocation = endLocation;
        }

        public Timer getParentTimer() {
            return this.parentTimer;
        }

        public void setParentTimer(Timer parentTimer) {
            this.parentTimer = parentTimer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.beginLocation > this.endLocation) {
                this.currentLocation -= 5;
                if (this.currentLocation <= this.endLocation + 5) {
                    this.getParentTimer().stop();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewDataBindUI.this.mainPanel.setDividerLocation(MoveActionListener.this.currentLocation);
                    }
                });
            } else {
                this.currentLocation += 5;
                if (this.currentLocation >= this.endLocation - 5) {
                    this.getParentTimer().stop();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewDataBindUI.this.mainPanel.setDividerLocation(MoveActionListener.this.currentLocation);
                    }
                });
            }
        }
    }

    class DataValueTreeLazyLoader
    implements Runnable {
        DataValueTreeLazyLoader() {
        }

        @Override
        public void run() {
            NewDataBindUI.this.loadObjectTree();
        }
    }

    class ComponetTreeLazyLoader
    implements Runnable {
        ComponetTreeLazyLoader() {
        }

        @Override
        public void run() {
            NewDataBindUI.this.loadComponetTree();
        }
    }
}

