/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.RuleInfo;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.client.editor.bizrule.AbstractBizRuleEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.ConditionEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.RuleActionManager;
import com.kingdee.eas.ep.client.editor.bizrule.RuleSelector;
import com.kingdee.eas.ep.client.editor.bizrule.param.AbstractParamPanel;
import com.kingdee.eas.ep.client.editor.bizrule.param.ParamPanelFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizRuleEditUI
extends AbstractBizRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BizRuleEditUI.class);
    private int exitStatus;
    private Context context;
    private AbstractParamPanel paramPanel;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.bizpromtRuleName.setSelector((KDPromptSelector)new RuleSelector());
        this.bizpromtRuleName.setDisplayFormat("$name$");
        this.bizpromtRuleName.setEditFormat("$name$");
        this.bizpromtRuleName.setRequired(true);
        this.bizpromtCondition.setSelector((KDPromptSelector)new ConditionSelector());
        this.bizpromtCondition.setRequired(true);
        this.bizpromtCondition.setDisplayFormat("$alias$");
        this.bizpromtCondition.setEditFormat("$alias$");
    }

    @Override
    protected void bizpromtRuleName_dataChanged(DataChangeEvent e) throws Exception {
        ActionInfo ruleDescription = (ActionInfo)this.bizpromtRuleName.getData();
        if (ruleDescription != null) {
            this.txtdescription.setText(ruleDescription.getAlias());
            RuleInfo dataObject = this.getDataObject();
            ActionInfo action = dataObject.getAction();
            String name = action.getName();
            String newName = ruleDescription.getName();
            if (!newName.equals(name)) {
                this.initParamPanel(ruleDescription);
            }
        }
    }

    private void initParamPanel(ActionInfo rule) {
        this.paramPanel = ParamPanelFactory.createParamPanel(this, rule);
        this.centerPanel.removeAll();
        this.centerPanel.add((Component)((Object)this.paramPanel), (Object)"Center");
        this.centerPanel.revalidate();
        this.repaint();
    }

    public KDPanel getParamPanel() {
        return this.centerPanel;
    }

    public KDTextArea getScriptArea() {
        return this.scriptArea;
    }

    public KDTextArea getScriptDescriptionArea() {
        return this.scriptDescriptionArea;
    }

    public RuleInfo getDataObject() {
        return (RuleInfo)super.getDataObject();
    }

    @Override
    public void loadFields() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return;
        }
        RuleInfo rule = this.getDataObject();
        this.initParamPanel(rule.getAction());
        ActionInfo ruleDescription = RuleActionManager.getInstance().getActionDescription(rule);
        this.bizpromtRuleName.setData((Object)ruleDescription);
        this.bizpromtCondition.setData((Object)rule.getCondition());
    }

    private void beforeStoreFields() {
        if (this.bizpromtRuleName.getData() == null) {
            MsgBox.showInfo((String)"\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.bizpromtRuleName.requestFocus();
            SysUtil.abort();
        } else if (!this.paramPanel.verify()) {
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        ActionInfo desc = (ActionInfo)this.bizpromtRuleName.getData();
        if (desc != null) {
            RuleInfo rule = this.getDataObject();
            ActionInfo action = rule.getAction();
            if (action == null) {
                action = new ActionInfo();
                rule.setAction(action);
            }
            action.setName(desc.getName());
            action.setInstanceClass(desc.getInstanceClass());
            action.getParameters().clear();
            action.getParameters().addCollection(this.paramPanel.getParams());
            this.getDataObject().setCondition((ActionInfo)this.bizpromtCondition.getData());
            this.setSchemeID(rule, this.context.getDepend().getId());
        }
    }

    private void setSchemeID(RuleInfo rule, String schemeID) {
        rule.setSchemeID(schemeID);
        if (rule.getCondition() != null) {
            rule.getCondition().setSchemeID(schemeID);
            RuleParameterCollection parameters = rule.getCondition().getParameters();
            this.setSchemeID(parameters, schemeID);
        }
        if (rule.getAction() != null) {
            rule.getAction().setSchemeID(schemeID);
            this.setSchemeID(rule.getAction().getParameters(), schemeID);
        }
        rule.getTriggerTime().setSchemeID(schemeID);
    }

    private void setSchemeID(RuleParameterCollection parameters, String schemeID) {
        for (int i = 0; i < parameters.size(); ++i) {
            RuleParameterInfo param = parameters.get(i);
            param.setSchemeID(schemeID);
        }
    }

    @Override
    protected void btnconfirm_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields();
        this.storeFields();
        this.exitStatus = 1;
        this.destroyWindow();
    }

    @Override
    protected void btncancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void handUIException(Throwable throwable) {
        ExceptionHandler.handle((Component)((Object)this), (Throwable)throwable);
    }

    private class ConditionSelector
    implements KDPromptSelector {
        private ConditionEditUI ui;

        private ConditionSelector() {
        }

        public void show() {
            IUIFactory uiFactory = null;
            try {
                UIContext context = new UIContext();
                context.put((Object)"Owner", (Object)BizRuleEditUI.this);
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create(ConditionEditUI.class.getName(), (Map)context);
                this.ui = (ConditionEditUI)window.getUIObject();
                this.ui.setDataObject((IObjectValue)((ActionInfo)BizRuleEditUI.this.bizpromtCondition.getData()));
                this.ui.loadFields();
                window.show();
            }
            catch (BOSException ex) {
                ExceptionHandler.handle((Throwable)ex);
                SysUtil.abort();
            }
        }

        public Object getData() {
            return this.ui.getDataObject();
        }

        public boolean isCanceled() {
            return this.ui.isCanceled();
        }
    }
}

