/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.RuleCollection;
import com.kingdee.eas.ep.RuleInfo;
import com.kingdee.eas.ep.RuleSetInfo;
import com.kingdee.eas.ep.TriggerTimeInfo;
import com.kingdee.eas.ep.client.editor.bizrule.AbstractBizRuleListUI;
import com.kingdee.eas.ep.client.editor.bizrule.BizRuleEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.RuleActionManager;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.UserBehaviorCollector;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Map;

public class BizRuleListUI
extends AbstractBizRuleListUI {
    private Context context;
    private BizConfigureItemInfo item;

    public void onLoad() throws Exception {
        Map map = this.getUIContext();
        this.context = (Context)map.get("context");
        this.item = (BizConfigureItemInfo)map.get("item");
        super.onLoad();
        this.loadFields();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnCancel.setVisible(false);
        this.btnConfirm.setVisible(false);
        this.tblMain.setBounds(new Rectangle(10, 10, 545, 410));
        this.tblMain.checkParsed(false);
        this.tblMain.setAutoResize(true);
        this.tblMain.setColumnsAutoResizeMode(4);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void loadFields() {
        RuleCollection rules = this.getRuleCollection();
        for (int i = 0; i < rules.size(); ++i) {
            RuleInfo rule = rules.get(i);
            this.fillTable(rule);
        }
    }

    private RuleCollection getRuleCollection() {
        RuleSetInfo ruleSet = this.getDataObject();
        if (ruleSet != null) {
            String owner = this.getOwner(this.item);
            return ruleSet.getRules(owner);
        }
        return new RuleCollection();
    }

    private RuleInfo getSelectedRule() {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        return (RuleInfo)row.getUserObject();
    }

    private String getOwner(BizConfigureItemInfo item) {
        if (item != null) {
            ComponentInfo comp = item.getComponent();
            if (comp != null) {
                return comp.getName();
            }
            if (item.getEntry() != null && item.getColumn() != null) {
                ComponentInfo entry = item.getEntry();
                ColumnInfo column = item.getColumn();
                return entry.getName() + "." + column.getName();
            }
        }
        return "";
    }

    private void fillTable(RuleInfo rule) {
        RuleActionManager manager = RuleActionManager.getInstance();
        ActionInfo action = rule.getAction();
        String processName = action.getName();
        ActionInfo description = manager.getRuleDescription(processName);
        IRow row = this.tblMain.addRow();
        String[] split = StringUtils.split((String)processName, (String)".");
        row.getCell(0).setValue((Object)split[split.length - 1]);
        if (description != null) {
            row.getCell(1).setValue((Object)description.getAlias());
        }
        row.setUserObject((Object)rule);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizRuleEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            BizRuleEditUI ui = (BizRuleEditUI)uiWindow.getUIObject();
            ui.setContext(this.context);
            RuleInfo rule = new RuleInfo();
            rule.setRuleSet(this.getDataObject());
            TriggerTimeInfo time = new TriggerTimeInfo();
            time.setComponentName(this.getOwner(this.item));
            rule.setTriggerTime(time);
            rule.setAction(new ActionInfo());
            ui.setDataObject((IObjectValue)rule);
            ui.loadFields();
            uiWindow.show();
            if (ui.getExitStatus() == 1 && ui.getDataObject() != null) {
                rule = ui.getDataObject();
                RuleSetInfo ruleSet = this.getDataObject();
                ruleSet.getRules().add(rule);
                this.tblMain.removeRows();
                this.loadFields();
                if (this.tblMain.getRowCount() > 0) {
                    this.tblMain.getSelectManager().select(this.tblMain.getRowCount() - 1, 0);
                }
                UserBehaviorCollector.fireCreateBizRule(rule.getAction().getName());
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handleError((Component)((Object)this), ex, "\u6253\u5f00\u4e8b\u4ef6\u8bbe\u7f6e\u754c\u9762 \u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put("Owner", this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizRuleEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            BizRuleEditUI ui = (BizRuleEditUI)uiWindow.getUIObject();
            ui.setContext(this.context);
            ui.setDataObject((IObjectValue)this.getSelectedRule());
            ui.loadFields();
            uiWindow.show();
            this.tblMain.removeRows();
            this.loadFields();
            if (this.tblMain.getRowCount() > 0) {
                this.tblMain.getSelectManager().select(this.tblMain.getRowCount() - 1, 0);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handleError((Component)((Object)this), ex, "\u6253\u5f00\u4e8b\u4ef6\u8bbe\u7f6e\u754c\u9762 \u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        RuleSetInfo ruleSet = this.getDataObject();
        RuleInfo rule = this.getSelectedRule();
        ruleSet.getRules().remove(rule);
        this.tblMain.removeRows();
        this.loadFields();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionDelete.setEnabled(false);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.actionEdit.setEnabled(true);
        this.actionDelete.setEnabled(true);
    }

    public BizConfigureItemInfo getItem() {
        return this.item;
    }

    public void setItem(BizConfigureItemInfo item) {
        this.item = item;
    }

    public RuleSetInfo getDataObject() {
        return (RuleSetInfo)super.getDataObject();
    }
}

