/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.ep.client.ContextUI;
import com.kingdee.eas.ep.client.editor.bizrule.param.ComponentTreeBuilder;
import com.kingdee.eas.ep.client.editor.bizrule.param.PropertyTreeBuilder;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ConditionContextUI
extends KDPanel {
    private BizUnitInfo bizUnit;
    private KDSplitPane mainPanel = null;
    protected KDTree tree = null;
    private KDTextArea txtDesc = null;
    private List<ContextApply> contextApply = new ArrayList<ContextApply>();
    private NodeType[] types = NodeType.values();

    public ConditionContextUI(BizUnitInfo bizUnit) {
        this.bizUnit = bizUnit;
        this.initUIContent();
    }

    public void initUIContent() {
        this.tree = new KDTree();
        this.setBounds(new Rectangle(0, 0, 200, 600));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 200, 600));
        this.txtDesc = new KDTextArea();
        this.txtDesc.setEditable(false);
        this.mainPanel = new KDSplitPane(0);
        this.mainPanel.setBounds(new Rectangle(0, 0, 200, 600));
        this.mainPanel.setPreferredSize(new Dimension(200, 600));
        this.mainPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 200, 600));
        this.add((Component)this.mainPanel, new KDLayout.Constraints(0, 0, 200, 600, 15));
        this.mainPanel.setResizeWeight(0.8);
        this.mainPanel.setOneTouchExpandable(true);
        KDTreeView treeView = new KDTreeView(this.tree);
        treeView.setPreferredSize(new Dimension(200, 480));
        treeView.setMinimumSize(new Dimension(0, 0));
        this.mainPanel.add((Component)treeView, (Object)"top");
        KDScrollPane scroll = new KDScrollPane((Component)this.txtDesc);
        scroll.setMinimumSize(new Dimension(0, 0));
        scroll.setPreferredSize(new Dimension(200, 111));
        this.mainPanel.add((Component)scroll, (Object)"bottom");
    }

    public void buildTree() {
        DefaultKingdeeTreeNode node;
        UIObjectInfo ui = this.bizUnit.getEditUI();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText("\u754c\u9762\u6269\u5c55\u4e0a\u4e0b\u6587");
        if (CtrlUtil.Array.containElement((Object[])this.types, (Object)((Object)NodeType.component))) {
            ComponentInfo mainPanel = ui.getMainPanelComponent();
            node = ComponentTreeBuilder.createNode(mainPanel);
            node.setText("\u754c\u9762\u63a7\u4ef6");
            root.add((MutableTreeNode)node);
        }
        if (CtrlUtil.Array.containElement((Object[])this.types, (Object)((Object)NodeType.toolbar))) {
            ComponentInfo toolBar = ui.getToolbarsPanel();
            node = ComponentTreeBuilder.createNode(toolBar);
            node.setText("\u5de5\u5177\u680f");
            root.add((MutableTreeNode)node);
        }
        if (CtrlUtil.Array.containElement((Object[])this.types, (Object)((Object)NodeType.menu))) {
            ComponentInfo menu = ui.getMenubarComponent();
            node = ComponentTreeBuilder.createNode(menu);
            node.setText("\u83dc\u5355");
            root.add((MutableTreeNode)node);
        }
        if (CtrlUtil.Array.containElement((Object[])this.types, (Object)((Object)NodeType.property))) {
            EntityObjectInfo entity = this.bizUnit.getEntity();
            PropertyTreeBuilder build = new PropertyTreeBuilder(entity, 0);
            DefaultKingdeeTreeNode node2 = build.createNode();
            node2.setText("\u5b57\u6bb5");
            root.add((MutableTreeNode)node2);
        }
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultKingdeeTreeNode node = ConditionContextUI.this.getSelectedTreeNode();
                if (node != null) {
                    Object object = node.getUserObject();
                    if (object instanceof ComponentInfo) {
                        ComponentInfo comp = (ComponentInfo)object;
                        String script = ContextUI.ContextUtil.getScript(comp);
                        ConditionContextUI.this.txtDesc.setText(script);
                    } else if (object instanceof PropertyInfo) {
                        PropertyInfo property = (PropertyInfo)object;
                        String script = ConditionContextUI.this.getScript(property);
                        ConditionContextUI.this.txtDesc.setText(script);
                    } else {
                        ConditionContextUI.this.txtDesc.setText("");
                    }
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultKingdeeTreeNode node;
                if (e.getClickCount() == 2 && (node = ConditionContextUI.this.getSelectedTreeNode()) != null) {
                    String script = "";
                    Object object = node.getUserObject();
                    if (object instanceof ComponentInfo) {
                        ComponentInfo comp = (ComponentInfo)object;
                        script = ContextUI.ContextUtil.getScript(comp);
                    } else if (object instanceof PropertyInfo) {
                        PropertyInfo property = (PropertyInfo)object;
                        script = ConditionContextUI.this.getScript(property);
                    }
                    if (!StringUtils.isEmpty((String)script)) {
                        int size = ConditionContextUI.this.contextApply.size();
                        for (int i = 0; i < size; ++i) {
                            ((ContextApply)ConditionContextUI.this.contextApply.get(i)).apply(script);
                        }
                    }
                }
            }
        });
    }

    private String getScript(PropertyInfo property) {
        StringBuffer script = new StringBuffer();
        if (!StringUtils.isEmpty((String)property.getName())) {
            script.append("pluginCtx.get");
            script.append("Property");
            script.append("(\"");
            script.append(property.getName());
            script.append("\")");
            script.append("");
        }
        return script.toString();
    }

    DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public void addContextApply(ContextApply apply) {
        this.contextApply.add(apply);
    }

    public void setNodeFilter(NodeType[] types) {
        this.types = types;
    }

    public static enum NodeType {
        component,
        menu,
        toolbar,
        property;

    }

    public static interface ContextApply {
        public void apply(String var1);
    }
}

