/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.RuleInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RuleActionManager {
    private static final Logger logger = CoreUIObject.getLogger(RuleActionManager.class);
    private static RuleActionManager instance;
    private static List<ActionInfo> rules;

    private RuleActionManager() {
        this.initRules();
    }

    public static synchronized RuleActionManager getInstance() {
        if (instance == null) {
            instance = new RuleActionManager();
        }
        return instance;
    }

    private void initRules() {
        rules = new ArrayList<ActionInfo>();
        Element root = this.getRoot();
        if (root != null) {
            List elements = root.elements();
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                rules.add(this.craeteRule(element));
            }
        }
    }

    private Element getRoot() {
        URL resource = RuleActionManager.class.getResource("RuleActionManager.properties");
        SAXReader reader = new SAXReader();
        Element root = null;
        try {
            Document doc = reader.read(resource);
            root = doc.getRootElement();
        }
        catch (DocumentException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return root;
    }

    private ActionInfo craeteRule(Element parent) {
        ActionInfo rule = new ActionInfo();
        List elements = parent.elements();
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            if ("name".equals(element.getName())) {
                String name = element.getTextTrim();
                rule.setName(name);
                continue;
            }
            if ("description".equals(element.getName())) {
                rule.setAlias(element.getTextTrim());
                continue;
            }
            if (!"process".equals(element.getName())) continue;
            rule.setInstanceClass(element.getTextTrim());
        }
        return rule;
    }

    public List<ActionInfo> getRuleDescriptions() {
        return rules;
    }

    public ActionInfo getActionDescription(RuleInfo rule) {
        if (rule != null) {
            String name = rule.getAction().getName();
            for (int i = 0; i < rules.size(); ++i) {
                ActionInfo desc = rules.get(i);
                if (!desc.getName().equals(name)) continue;
                return desc;
            }
        }
        return null;
    }

    public ActionInfo getRuleDescription(String name) {
        for (int i = 0; i < rules.size(); ++i) {
            ActionInfo rule = rules.get(i);
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }
}

