/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.ProjectProviderManager;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.IRuleSet;
import com.kingdee.eas.ep.RuleCollection;
import com.kingdee.eas.ep.RuleInfo;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.RuleSetFactory;
import com.kingdee.eas.ep.RuleSetInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizUnitProxy;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.Comparator;

public class RuleManager {
    private static RuleManager instance = new RuleManager();
    private static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int seq1 = ((RuleParameterInfo)o1).getIndex();
            int seq2 = ((RuleParameterInfo)o2).getIndex();
            return seq1 - seq2;
        }
    };

    public static RuleManager getInstance() {
        return instance;
    }

    public RuleSetInfo getRuleSet(String uipk) {
        String ais = ConfigMDUtil.getAIS();
        Project[] projects = ProjectProviderManager.getProvider().getProjects(ais);
        try {
            IRuleSet instance = RuleSetFactory.getRemoteInstance();
            String where = this.buildWhere(projects, uipk);
            where = where + " order by rules.seq asc";
            CoreBaseCollection col = instance.getCollection(where);
            if (col != null && !col.isEmpty()) {
                RuleSetInfo set = (RuleSetInfo)col.get(0);
                this.reOrderRuleParams(set);
                return set;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleError(null, e, "\u83b7\u53d6\u4e1a\u52a1\u89c4\u5219\u51fa\u9519");
        }
        RuleSetInfo ruleSet = new RuleSetInfo();
        ruleSet.setOwner(uipk);
        return ruleSet;
    }

    public static RuleSetInfo getRuleSet(IContext context) {
        IUIEditor editor = context.getEditorUI();
        BizUnitInfo unitInfo = editor.getModel();
        if (unitInfo instanceof BizUnitProxy) {
            return ((BizUnitProxy)unitInfo).getDynRuleSet();
        }
        return null;
    }

    public static RuleCollection getRuleCollection(IContext context, BizConfigureItemInfo item) {
        RuleSetInfo ruleSet = RuleManager.getRuleSet(context);
        if (ruleSet != null) {
            String owner = RuleManager.getOwner(item);
            return ruleSet.getRules(owner);
        }
        return new RuleCollection();
    }

    public static RuleCollection getRuleCollection(RuleSetInfo ruleSet, BizConfigureItemInfo item) {
        if (ruleSet != null) {
            String owner = RuleManager.getOwner(item);
            return ruleSet.getRules(owner);
        }
        return new RuleCollection();
    }

    private static String getOwner(BizConfigureItemInfo item) {
        if (item != null) {
            ComponentInfo comp = item.getComponent();
            if (comp != null) {
                return comp.getName();
            }
            if (item.getEntry() != null && item.getColumn() != null) {
                ComponentInfo entry = item.getEntry();
                ColumnInfo column = item.getColumn();
                return entry.getName() + "." + column.getName();
            }
        }
        return "";
    }

    private String buildWhere(Project[] projects, String uipk) {
        StringBuffer sql = new StringBuffer();
        if (projects != null && projects.length > 0) {
            sql.append("where schemeID in (");
            for (int i = 0; i < projects.length; ++i) {
                sql.append("'");
                sql.append(projects[i].getId());
                sql.append("'");
                if (i == projects.length - 1) continue;
                sql.append(",");
            }
            sql.append(")");
            sql.append(" and owner = '");
            sql.append(uipk);
            sql.append("'");
        }
        return sql.toString();
    }

    public RuleSetInfo getRuleSet(String schemeID, String uipk) {
        try {
            IRuleSet instance = RuleSetFactory.getRemoteInstance();
            StringBuffer sql = new StringBuffer();
            sql.append("where schemeID = '");
            sql.append(schemeID);
            sql.append("' and owner = '");
            sql.append(uipk);
            sql.append("'");
            sql.append(" order by rules.seq asc");
            CoreBaseCollection col = instance.getCollection(sql.toString());
            if (col != null && !col.isEmpty()) {
                RuleSetInfo set = (RuleSetInfo)col.get(0);
                this.reOrderRuleParams(set);
                return set;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleError(null, e, "\u83b7\u53d6\u4e1a\u52a1\u89c4\u5219\u51fa\u9519");
        }
        RuleSetInfo ruleSet = new RuleSetInfo();
        ruleSet.setSchemeID(schemeID);
        ruleSet.setOwner(uipk);
        return ruleSet;
    }

    private void reOrderRuleParams(RuleSetInfo ruleSet) {
        if (ruleSet != null && ruleSet.getRules() != null) {
            RuleCollection rules = ruleSet.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                RuleInfo ruleInfo = rules.get(i);
                this.reOrderRuleParams(ruleInfo);
            }
        }
    }

    private void reOrderRuleParams(RuleInfo rule) {
        ActionInfo action = rule.getAction();
        if (action != null) {
            RuleParameterCollection params = action.getParameters();
            Object[] array = params.toArray();
            Arrays.sort((Object[])array, (Comparator)comparator);
            params.clear();
            for (int i = 0; i < array.length; ++i) {
                params.add((RuleParameterInfo)array[i]);
            }
        }
    }
}

