/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.ActionInfo;
import com.kingdee.eas.ep.client.editor.bizrule.AbstractBizRuleListUI;
import com.kingdee.eas.ep.client.editor.bizrule.RuleActionManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class RuleSelector
extends KDCommonPromptDialog {
    private ProcessListUI processList;

    public void show() {
        IUIFactory uiFactory = null;
        try {
            UIContext context = new UIContext();
            context.put((Object)"Owner", (Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(ProcessListUI.class.getName(), (Map)context);
            window.show();
            this.processList = (ProcessListUI)window.getUIObject();
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
            SysUtil.abort();
        }
    }

    public Object getData() {
        ActionInfo action = this.processList.getData();
        return this.createCopy(action);
    }

    private ActionInfo createCopy(ActionInfo action) {
        ActionInfo copy = new ActionInfo();
        copy.setName(action.getName());
        copy.setInstanceClass(action.getInstanceClass());
        copy.setAlias(action.getAlias());
        return copy;
    }

    public boolean isCanceled() {
        return this.processList.getExitStatus() == 0;
    }

    public static class ProcessListUI
    extends AbstractBizRuleListUI {
        private int exitStatus;
        private ActionInfo data;

        public String getUITitle() {
            return "\u9009\u62e9\u4e1a\u52a1\u89c4\u5219";
        }

        @Override
        public void initUIContentLayout() {
            super.initUIContentLayout();
            this.tblMain.checkParsed(false);
            this.tblMain.setAutoResize(true);
            this.tblMain.getSelectManager().setSelectMode(2);
            this.tblMain.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                        this.confirm();
                    }
                }
            });
        }

        @Override
        public void initUIToolBarLayout() {
            this.toolBar = null;
        }

        public void onLoad() throws Exception {
            super.onLoad();
            this.loadFields();
        }

        @Override
        public void loadFields() {
            List<ActionInfo> rules = RuleActionManager.getInstance().getRuleDescriptions();
            for (int i = 0; i < rules.size(); ++i) {
                ActionInfo rule = rules.get(i);
                IRow row = this.tblMain.addRow();
                row.getCell(0).setValue((Object)rule.getName());
                row.getCell(1).setValue((Object)rule.getAlias());
                row.setUserObject((Object)rule);
            }
        }

        public ActionInfo getData() {
            return this.data;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }

        @Override
        protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
            this.confirm();
        }

        private void confirm() {
            this.exitStatus = 1;
            IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            Object object = row.getUserObject();
            if (object instanceof ActionInfo) {
                this.data = (ActionInfo)object;
            }
            this.destroyWindow();
        }

        @Override
        protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
            this.destroyWindow();
        }
    }
}

