/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.client.editor.bizrule.param.ParamPanelFactory;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public abstract class AbstractParamPanel
extends KDPanel {
    private static final Logger logger = CoreUIObject.getLogger(AbstractParamPanel.class);
    private String ruleName;
    private JLabel descLabel;

    public AbstractParamPanel() {
    }

    public AbstractParamPanel(String ruleName) {
        this.ruleName = ruleName;
        this.setLayout(new BorderLayout());
        if (ruleName != null) {
            this.descLabel = new JLabel(this.getIntroduction());
            this.descLabel.setPreferredSize(new Dimension(100, 25));
            this.add(this.descLabel, "North");
        }
    }

    public abstract RuleParameterCollection getParams();

    public abstract void setParams(RuleParameterCollection var1);

    public boolean verify() {
        RuleParameterCollection params = this.getParams();
        if (params == null || params.size() == 0) {
            MsgBox.showInfo((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIntroduction() {
        Properties properties = new Properties();
        InputStream stream = ParamPanelFactory.class.getResourceAsStream("AbstractParamPanel.properties");
        try {
            properties.load(stream);
            String string = properties.getProperty(this.ruleName);
            return string;
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }
}

