/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.ParamType;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.client.editor.bizrule.BizRuleEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.param.AbstractParamPanel;
import com.kingdee.eas.ep.client.editor.bizrule.param.ComponentTreeBuilder;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.tree.TreeNode;

public class ComponentTreeParamPanel
extends AbstractParamPanel {
    protected KDTree tree;
    protected BizRuleEditUI ruleEditui;
    protected ComponentInfo component;

    public ComponentTreeParamPanel(String ruleName, BizRuleEditUI ruleEditui) {
        super(ruleName);
        this.ruleEditui = ruleEditui;
    }

    public void setComponent(ComponentInfo component) {
        this.component = component;
    }

    public void initLayout() {
        this.tree = this.createTree();
        this.add((Component)new KDScrollPane((Component)this.tree), "Center");
    }

    private KDTree createTree() {
        DefaultKingdeeTreeNode root = ComponentTreeBuilder.createNode(this.component);
        this.tree = new KDTree((ITreeNode)root);
        this.tree.setShowsRootHandles(true);
        this.tree.setShowCheckBox(true);
        this.tree.expandAllNodes(true, (TreeNode)root);
        this.tree.setRootVisible(false);
        this.tree.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                ComponentTreeParamPanel.this.resetScriptArea();
            }
        });
        return this.tree;
    }

    @Override
    public RuleParameterCollection getParams() {
        RuleParameterCollection col = new RuleParameterCollection();
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        ComponentCollection components = this.getSelectedComponents(parent);
        for (int i = 0; i < components.size(); ++i) {
            ComponentInfo comp = components.get(i);
            RuleParameterInfo param = new RuleParameterInfo();
            param.setValue(comp.getName());
            param.setType(ParamType.component);
            col.add(param);
        }
        return col;
    }

    private ComponentCollection getSelectedComponents(DefaultKingdeeTreeNode parent) {
        ComponentCollection col = new ComponentCollection();
        if (parent.isChecked() && parent.getUserObject() instanceof ComponentInfo) {
            ComponentInfo comp = (ComponentInfo)parent.getUserObject();
            col.add(comp);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parent.getChildAt(i);
            ComponentCollection components = this.getSelectedComponents(child);
            if (components.isEmpty()) continue;
            col.addObjectCollection((IObjectCollection)components);
        }
        return col;
    }

    @Override
    public void setParams(RuleParameterCollection params) {
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        for (int i = 0; i < params.size(); ++i) {
            RuleParameterInfo param = params.get(i);
            this.doSelect(param.getValue(), parent);
        }
        this.resetScriptArea();
    }

    private void doSelect(String compName, DefaultKingdeeTreeNode parent) {
        ComponentInfo comp;
        if (parent.getUserObject() instanceof ComponentInfo && compName.equals((comp = (ComponentInfo)parent.getUserObject()).getName())) {
            parent.setChecked(true);
            return;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)parent.getChildAt(i);
            this.doSelect(compName, child);
        }
    }

    public void resetScriptArea() {
        StringBuffer script = new StringBuffer();
        StringBuffer desc = new StringBuffer();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        ComponentCollection comps = this.getSelectedComponents(node);
        for (int i = 0; i < comps.size(); ++i) {
            ComponentInfo comp = comps.get(i);
            if (i != 0) {
                script.append(" , ");
                desc.append(" , ");
            }
            script.append(comp.getName());
            String label = EditUIEditorHelper.getLabel(comp);
            if (StringUtils.isEmpty((String)label)) {
                label = comp.getName();
            }
            desc.append(label);
        }
        this.ruleEditui.getScriptArea().setText(script.toString());
        this.ruleEditui.getScriptDescriptionArea().setText(desc.toString());
    }
}

