/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.eas.ep.ParamType;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.util.StringUtils;

public class ParamParser {
    private BizConfigureTreeNode root;

    public ParamParser(BizConfigureTreeNode node) {
        this.root = node;
    }

    public RuleParameterCollection getParams(BizConfigureItemCollection items) {
        RuleParameterCollection col = new RuleParameterCollection();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            RuleParameterInfo param;
            BizConfigureItemInfo item = (BizConfigureItemInfo)items.get(i);
            if (item.getComponent() != null) {
                ComponentInfo comp = item.getComponent();
                param = new RuleParameterInfo();
                param.setValue(comp.getName());
                param.setType(ParamType.component);
                col.add(param);
                continue;
            }
            if (item.getEntry() == null || item.getColumn() == null) continue;
            ComponentInfo entry = item.getEntry();
            ColumnInfo column = item.getColumn();
            param = new RuleParameterInfo();
            param.setValue(entry.getName() + "." + column.getName());
            param.setType(ParamType.component);
            col.add(param);
        }
        return col;
    }

    public BizConfigureItemCollection getItems(RuleParameterCollection params) {
        BizConfigureItemCollection col = new BizConfigureItemCollection();
        if (params != null && !params.isEmpty()) {
            BizConfigureItemInfo item = this.root.getItem();
            if (this.contains(params, item)) {
                col.add(item);
            }
            col.addCollection(this.getItems(this.root, params));
        }
        return col;
    }

    private BizConfigureItemCollection getItems(BizConfigureTreeNode node, RuleParameterCollection params) {
        int i;
        BizConfigureItemCollection col = new BizConfigureItemCollection();
        AbstractBizConfigureItemCollection items = node.getConfigureItems();
        for (i = 0; i < items.size(); ++i) {
            BizConfigureItemInfo item = (BizConfigureItemInfo)items.get(i);
            if (!this.contains(params, item)) continue;
            col.add(item);
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)node.getChildAt(i));
            col.addCollection(this.getItems(child, params));
        }
        return col;
    }

    private boolean contains(RuleParameterCollection params, BizConfigureItemInfo item) {
        if (item != null) {
            String name;
            ComponentInfo component = item.getComponent();
            if (component != null) {
                if (this.contains(params, component.getName())) {
                    return true;
                }
                ComponentInfo round = EditUIEditorHelper.getRoundedComponent(component);
                if (this.contains(params, round.getName())) {
                    return true;
                }
            } else if (item.getEntry() != null && item.getColumn() != null && this.contains(params, name = item.getEntry().getName() + "." + item.getColumn().getName())) {
                return true;
            }
        }
        return false;
    }

    private boolean contains(RuleParameterCollection params, String name) {
        if (!StringUtils.isEmpty((String)name)) {
            for (int i = 0; i < params.size(); ++i) {
                RuleParameterInfo param = params.get(i);
                String paramName = param.getValue();
                if (!name.equals(paramName) && !name.equals(paramName)) continue;
                return true;
            }
        }
        return false;
    }
}

