/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.ep.ParamType;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.client.editor.bizrule.param.AbstractParamPanel;
import com.kingdee.eas.ep.client.editor.bizrule.param.PropertyTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.tree.TreeNode;

public class PropertyParamPanel
extends AbstractParamPanel {
    private EntityObjectInfo entity;
    private KDTree tree;
    private int deepLevel;

    public PropertyParamPanel(String ruleName, EntityObjectInfo entity, int deepLevel) {
        super(ruleName);
        this.entity = entity;
        this.deepLevel = deepLevel;
        this.initUIContent();
    }

    private void initUIContent() {
        this.createOutlineTree();
        this.setLayout(new BorderLayout());
        this.add((Component)new KDScrollPane((Component)this.tree), "Center");
    }

    private void createOutlineTree() {
        PropertyTreeBuilder build = new PropertyTreeBuilder(this.entity, this.deepLevel);
        DefaultKingdeeTreeNode root = build.createNode();
        this.tree = new KDTree((ITreeNode)root);
        this.tree.expandAllNodes(true, (TreeNode)this.tree.getModel().getRoot());
        this.tree.setRootVisible(false);
        this.tree.setShowCheckBox(true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public RuleParameterCollection getParams() {
        RuleParameterCollection params = new RuleParameterCollection();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            RuleParameterCollection collection = this.getParams(child);
            params.addCollection(collection);
        }
        return params;
    }

    private RuleParameterCollection getParams(DefaultKingdeeTreeNode node) {
        RuleParameterCollection params = new RuleParameterCollection();
        if (node.isChecked()) {
            RuleParameterInfo param = this.createParam(node);
            params.add(param);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            RuleParameterCollection collection = this.getParams(child);
            params.addCollection(collection);
        }
        return params;
    }

    private RuleParameterInfo createParam(DefaultKingdeeTreeNode node) {
        String paramName = this.getParamName(node);
        RuleParameterInfo param = new RuleParameterInfo();
        param.setValue(paramName);
        param.setType(ParamType.property);
        return param;
    }

    private String getParamName(DefaultKingdeeTreeNode node) {
        PropertyInfo property = (PropertyInfo)node.getUserObject();
        StringBuffer propertyName = new StringBuffer(property.getName());
        DefaultKingdeeTreeNode tempNode = node;
        while (tempNode.getParent() instanceof DefaultKingdeeTreeNode) {
            tempNode = (DefaultKingdeeTreeNode)tempNode.getParent();
            PropertyInfo parentProperty = (PropertyInfo)tempNode.getUserObject();
            propertyName.insert(0, ".");
            propertyName.insert(0, parentProperty.getName());
        }
        return propertyName.toString();
    }

    @Override
    public void setParams(RuleParameterCollection params) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.setParams(params, child);
        }
    }

    private void setParams(RuleParameterCollection params, DefaultKingdeeTreeNode node) {
        if (this.contains(params, node)) {
            node.setChecked(true);
        } else {
            node.setChecked(false);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setParams(params, (DefaultKingdeeTreeNode)node.getChildAt(i));
        }
    }

    private boolean contains(RuleParameterCollection params, DefaultKingdeeTreeNode node) {
        String name = this.getParamName(node);
        for (int i = 0; i < params.size(); ++i) {
            RuleParameterInfo param = params.get(i);
            if (!name.equals(param.getValue())) continue;
            return true;
        }
        return false;
    }
}

