/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.util.StringUtils;
import javax.swing.tree.MutableTreeNode;

public class PropertyTreeBuilder {
    private EntityObjectInfo entity;
    private int deepLevel;

    public PropertyTreeBuilder(EntityObjectInfo entity, int deepLevel) {
        this.entity = entity;
        this.deepLevel = deepLevel;
    }

    public DefaultKingdeeTreeNode createNode() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"\u5b57\u6bb5");
        this.initTreeNode(root, this.entity, 0);
        return root;
    }

    private void initTreeNode(DefaultKingdeeTreeNode parent, EntityObjectInfo entity, int curLevel) {
        if (curLevel <= this.deepLevel) {
            PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
            for (int i = 0; i < properties.size(); ++i) {
                DefaultKingdeeTreeNode node;
                PropertyInfo property = properties.get(i);
                if (property instanceof LinkPropertyInfo) {
                    EntityObjectInfo supplyEntity = this.getSupplyEntity((LinkPropertyInfo)property);
                    if (supplyEntity == null) continue;
                    node = new DefaultKingdeeTreeNode((Object)property);
                    node.setText(this.getText(property));
                    parent.add((MutableTreeNode)node);
                    int level = this.isEntry(supplyEntity, (LinkPropertyInfo)property) ? curLevel : curLevel + 1;
                    this.initTreeNode(node, supplyEntity, level);
                    continue;
                }
                node = new DefaultKingdeeTreeNode((Object)property);
                node.setText(this.getText(property));
                parent.add((MutableTreeNode)node);
            }
        }
    }

    private boolean isEntry(EntityObjectInfo entity, LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) && relationship.getClientObject().equals((Object)entity);
    }

    private EntityObjectInfo getSupplyEntity(LinkPropertyInfo property) {
        RelationshipInfo relation = property.getRelationship();
        if (relation != null) {
            return relation.getSupplierObject();
        }
        return null;
    }

    private String getText(PropertyInfo property) {
        return StringUtils.isEmpty((String)property.getAlias()) ? property.getName() : property.getAlias();
    }
}

