/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellEditorListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.ParamType;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.RuleParameterInfo;
import com.kingdee.eas.ep.TriggerTimeInfo;
import com.kingdee.eas.ep.client.editor.bizrule.BizRuleEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.param.AbstractParamPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;

public class TakeBaseDataParamPanel
extends AbstractParamPanel {
    private KDTable table;
    private BizRuleEditUI parent;
    private List<Field> sourceFields;
    private List<Field> targetFields;

    public TakeBaseDataParamPanel(String ruleName, BizRuleEditUI parent) {
        this.parent = parent;
        this.initUIContent();
    }

    private void initUIContent() {
        this.setLayout(new BorderLayout());
        this.initTable();
        this.initButtons();
        this.parent.getParamPanel().revalidate();
        this.parent.getParamPanel().repaint();
    }

    private void initTable() {
        this.table = new KDTable();
        this.table.setAutoResize(true);
        this.table.getSelectManager().setSelectMode(2);
        this.sourceFields = this.getSourceFields();
        this.createSourceColumn(this.sourceFields);
        this.targetFields = this.getTargetFields();
        this.createTargetColumn(this.targetFields);
        IRow row = this.table.addHeadRow();
        row.getCell(0).setValue((Object)"\u6e90\u5b57\u6bb5");
        row.getCell(1).setValue((Object)"\u76ee\u6807\u5b57\u6bb5");
        this.add((Component)this.table, "Center");
    }

    private List<Field> getSourceFields() {
        BizConfigureItemInfo item = this.getSourceProperty();
        if (item != null) {
            EntityObjectInfo entity = item.getDataSource();
            PropertyInfo sourceProperty = item.getProperty();
            return this.getFields(entity, sourceProperty);
        }
        return null;
    }

    private BizConfigureItemInfo getSourceProperty() {
        Context context = this.parent.getContext();
        IUIEditor editor = context.getEditorUI();
        if (editor instanceof EditUIEditor) {
            BizConfigureTreeNode root = ((EditUIEditor)editor).getRootNode();
            TriggerTimeInfo time = this.parent.getDataObject().getTriggerTime();
            String name = time.getComponentName();
            return EditUIEditorHelper.getItemByComponentName(root, name);
        }
        return null;
    }

    private List<Field> getFields(EntityObjectInfo entity, PropertyInfo sourceProperty) {
        LinkedList<Field> list = new LinkedList<Field>();
        if (entity != null && sourceProperty != null) {
            PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo property = properties.get(i);
                if (!(property instanceof OwnPropertyInfo)) continue;
                String name = property.getName();
                String alias = sourceProperty.getAlias() + "." + property.getAlias();
                list.add(new Field(name, alias, property));
            }
        }
        return list;
    }

    private void createSourceColumn(List<Field> fields) {
        IColumn column = this.table.addColumn();
        column.setKey("source");
        column.setWidth(485);
        if (fields != null && !fields.isEmpty()) {
            KDComboBox box = new KDComboBox();
            box.addItems(fields.toArray());
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)box);
            column.setEditor((ICellEditor)editor);
            editor.addCellEditorListener((KDTCellEditorListener)new CellEditListener());
        }
    }

    private boolean isEntry() {
        BizConfigureItemInfo item = this.getSourceProperty();
        return item.getEntry() != null && item.getColumn() != null;
    }

    private List<Field> getTargetFields() {
        Context context = this.parent.getContext();
        IUIEditor editor = context.getEditorUI();
        BizConfigureTreeNode rootNode = (BizConfigureTreeNode)editor.getRootNode();
        return this.getTargetFields(rootNode, this.isEntry());
    }

    private List<Field> getTargetFields(BizConfigureTreeNode node, boolean onlyEntry) {
        int i;
        LinkedList<Field> fields = new LinkedList<Field>();
        BizConfigureItemCollection items = (BizConfigureItemCollection)node.getConfigureItems();
        BizConfigureItemInfo sourceItem = this.getSourceProperty();
        for (i = 0; i < items.size(); ++i) {
            BizConfigureItemInfo item = (BizConfigureItemInfo)items.get(i);
            if (item == sourceItem) continue;
            ComponentInfo comp = item.getComponent();
            PropertyInfo property = item.getProperty();
            if (comp == null || !EditUIEditorHelper.canBind(comp) || onlyEntry || property == null) continue;
            Field field = new Field(comp.getName(), this.getAlias(item), property);
            fields.add(field);
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            List<Field> childList = this.getTargetFields((BizConfigureTreeNode)((Object)node.getChildAt(i)), onlyEntry);
            fields.addAll(childList);
        }
        return fields;
    }

    private String getAlias(BizConfigureItemInfo item) {
        return StringUtils.isEmpty((String)item.getLabel()) ? item.getName() : item.getLabel();
    }

    private void createTargetColumn(List<Field> fields) {
        IColumn column = this.table.addColumn();
        column.setKey("target");
        column.setWidth(485);
        if (fields != null && !fields.isEmpty()) {
            KDComboBox box = new KDComboBox();
            box.addItems(fields.toArray());
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)box);
            column.setEditor((ICellEditor)editor);
            editor.addCellEditorListener((KDTCellEditorListener)new CellEditListener());
        }
    }

    private void initButtons() {
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new KDLayout());
        panel.setPreferredSize(new Dimension(880, 20));
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 883, 21));
        KDLabel label = new KDLabel("\u628a\u6e90\u5b57\u6bb5\u7684\u503c\u643a\u5e26\u5230\u76ee\u6807\u5b57\u6bb5\u4e0a");
        label.setBounds(0, 0, 500, 19);
        panel.add((Component)label, (Object)new KDLayout.Constraints(0, 0, 500, 19, 260));
        KDWorkButton btnAdd = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAdd.setToolTipText("\u65b0\u589e");
        btnAdd.setBounds(837, 0, 22, 19);
        panel.add((Component)btnAdd, (Object)new KDLayout.Constraints(837, 0, 22, 19, 136));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TakeBaseDataParamPanel.this.table.addRow();
            }
        });
        KDWorkButton btnDelete = new KDWorkButton(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelete.setToolTipText("\u5220\u9664");
        btnDelete.setBounds(861, 0, 22, 19);
        panel.add((Component)btnDelete, (Object)new KDLayout.Constraints(861, 0, 22, 19, 136));
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)TakeBaseDataParamPanel.this.table);
                if (row != null) {
                    TakeBaseDataParamPanel.this.table.removeRow(row.getRowIndex());
                    TakeBaseDataParamPanel.this.resetScriptArea();
                } else {
                    int index = TakeBaseDataParamPanel.this.table.getRowCount() - 1;
                    if (index >= 0) {
                        TakeBaseDataParamPanel.this.table.removeRow(index);
                        TakeBaseDataParamPanel.this.resetScriptArea();
                    }
                }
            }
        });
        panel.add((Component)btnAdd);
        panel.add((Component)btnDelete);
        this.add((Component)panel, "North");
    }

    @Override
    public RuleParameterCollection getParams() {
        StringBuffer sourceValue = new StringBuffer();
        StringBuffer targetValue = new StringBuffer();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            Field source = (Field)row.getCell(0).getValue();
            Field target = (Field)row.getCell(1).getValue();
            if (source == null || target == null) {
                return null;
            }
            sourceValue.append(source.getName());
            targetValue.append(target.getName());
            if (i >= this.table.getRowCount() - 1) continue;
            sourceValue.append(",");
            targetValue.append(",");
        }
        RuleParameterInfo compParam = new RuleParameterInfo();
        BizConfigureItemInfo item = this.getSourceProperty();
        compParam.setValue(item.getComponent().getName());
        compParam.setType(ParamType.component);
        compParam.setIndex(0);
        RuleParameterInfo sourceParam = new RuleParameterInfo();
        sourceParam.setValue(sourceValue.toString());
        sourceParam.setType(ParamType.constants);
        sourceParam.setIndex(1);
        RuleParameterInfo targetParam = new RuleParameterInfo();
        targetParam.setValue(targetValue.toString());
        targetParam.setType(ParamType.components);
        targetParam.setIndex(2);
        RuleParameterCollection params = new RuleParameterCollection();
        params.add(compParam);
        params.add(sourceParam);
        params.add(targetParam);
        return params;
    }

    @Override
    public void setParams(RuleParameterCollection params) {
        if (params.size() == 3) {
            String compName = params.get(0).getValue();
            String propertyName = params.get(1).getValue();
            String targetValue = params.get(2).getValue();
            if (!(StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)targetValue) || StringUtils.isEmpty((String)compName))) {
                String[] sources = StringUtils.split((String)propertyName, (String)",");
                String[] targets = StringUtils.split((String)targetValue, (String)",");
                if (sources.length > 0 && sources.length == targets.length) {
                    for (int i = 0; i < sources.length; ++i) {
                        Field sourceField = this.getField(this.sourceFields, sources[i]);
                        Field targetField = this.getField(this.targetFields, targets[i]);
                        IRow row = this.table.addRow();
                        row.getCell(0).setValue((Object)sourceField);
                        row.getCell(1).setValue((Object)targetField);
                    }
                }
            }
        } else if (params == null || params.isEmpty()) {
            this.table.addRow();
        }
    }

    public void resetScriptArea() {
        RuleParameterCollection params = this.getParams();
        if (params != null && params.size() == 3) {
            String compName = params.get(0).getValue();
            String propertyName = params.get(1).getValue();
            String targetValue = params.get(2).getValue();
            if (!(StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)targetValue) || StringUtils.isEmpty((String)compName))) {
                StringBuffer script = new StringBuffer();
                StringBuffer desc = new StringBuffer();
                String[] sources = StringUtils.split((String)propertyName, (String)",");
                String[] targets = StringUtils.split((String)targetValue, (String)",");
                if (sources.length > 0 && sources.length == targets.length) {
                    for (int i = 0; i < sources.length; ++i) {
                        Field sourceField = this.getField(this.sourceFields, sources[i]);
                        Field targetField = this.getField(this.targetFields, targets[i]);
                        if (sourceField == null || targetField == null) continue;
                        script.append(compName + "." + sourceField.getName());
                        script.append("=");
                        script.append(sourceField.getName());
                        script.append(" ; ");
                        desc.append(sourceField.getAlias());
                        desc.append("=");
                        desc.append(targetField.getAlias());
                        desc.append(" ; ");
                    }
                }
                this.parent.getScriptArea().setText(script.toString());
                this.parent.getScriptDescriptionArea().setText(desc.toString());
            }
        }
    }

    private Field getField(List<Field> fields, String fieldName) {
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public boolean verify() {
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.table.getRow(i);
            Field source = (Field)row.getCell(0).getValue();
            if (source == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u6e90\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b8c\u6574");
                return false;
            }
            Field target = (Field)row.getCell(1).getValue();
            if (target == null) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u76ee\u6807\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b8c\u6574");
                return false;
            }
            PropertyInfo sProperty = source.getProperty();
            PropertyInfo tProperty = target.getProperty();
            if (sProperty.getBOSType() == tProperty.getBOSType()) continue;
            MsgBox.showInfo((Component)this.table, (String)("\u7b2c" + i + "\u884c\u6e90\u5b57\u6bb5\u548c\u76ee\u6807\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d"));
            return false;
        }
        return super.verify();
    }

    private class CellEditListener
    implements KDTCellEditorListener {
        private CellEditListener() {
        }

        public void editingStopped() {
            TakeBaseDataParamPanel.this.resetScriptArea();
        }

        public void editingCanceled() {
        }

        public void editingChanged() {
        }
    }

    private class Field {
        private String name;
        private String alias;
        private PropertyInfo property;

        private Field(String name, String alias, PropertyInfo property) {
            this.name = name;
            this.alias = alias;
            this.property = property;
        }

        public String toString() {
            return this.alias;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Field) {
                return ((Field)obj).name.equals(this.name);
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public PropertyInfo getProperty() {
            return this.property;
        }
    }
}

