/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.eas.ep.RuleParameterCollection;
import com.kingdee.eas.ep.client.editor.bizrule.BizRuleEditUI;
import com.kingdee.eas.ep.client.editor.bizrule.param.AbstractParamPanel;
import com.kingdee.eas.ep.client.editor.bizrule.param.ConfiugreItemOutlineParamSelector;
import com.kingdee.eas.ep.client.editor.bizrule.param.ParamParser;
import com.kingdee.eas.ep.client.editor.bizrule.param.UIParamSelector;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIOutlineParamPanel
extends AbstractParamPanel {
    private BizConfigureItemCollection selectedItems = new BizConfigureItemCollection();
    private BizRuleEditUI parent;
    private UIParamSelector uiSelector;
    private ConfiugreItemOutlineParamSelector outlineSelector;
    private ParamParser parse;

    public UIOutlineParamPanel(String ruleName, BizRuleEditUI parent) {
        super(ruleName);
        this.parent = parent;
        this.initSelectors();
        this.initParamParse();
    }

    private void initSelectors() {
        this.initUIParamSelector();
        this.initOutlineParamSelector();
        KDTabbedPane tabPane = new KDTabbedPane();
        JScrollPane scroll = new JScrollPane(this.uiSelector.getRootViewer());
        scroll.getVerticalScrollBar().setUnitIncrement(19);
        tabPane.add((Component)scroll, (Object)"\u4ece\u754c\u9762\u9009\u62e9");
        tabPane.add((Component)this.outlineSelector.getMainPanel(), (Object)"\u4ece\u5927\u7eb2\u9009\u62e9");
        tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    UIOutlineParamPanel.this.tabSelectChanged(e);
                }
                catch (Exception exc) {
                    ExceptionHandler.handleError(null, exc, "\u5207\u6362\u9875\u7b7e\u51fa\u9519");
                }
            }
        });
        this.add((Component)tabPane, "Center");
    }

    private void initParamParse() {
        IUIEditor editor = this.parent.getContext().getEditorUI();
        BizConfigureTreeNode rootNode = (BizConfigureTreeNode)editor.getRootNode();
        this.parse = new ParamParser(rootNode);
    }

    private void initUIParamSelector() {
        IUIEditor editor = this.parent.getContext().getEditorUI();
        BizUnitInfo model = editor.getModel();
        BizConfigureTreeNode rootNode = (BizConfigureTreeNode)editor.getRootNode();
        this.uiSelector = new UIParamSelector(model, rootNode);
        this.uiSelector.setParent(this);
    }

    private void initOutlineParamSelector() {
        IUIEditor editor = this.parent.getContext().getEditorUI();
        BizConfigureTreeNode rootNode = (BizConfigureTreeNode)editor.getRootNode();
        this.outlineSelector = new ConfiugreItemOutlineParamSelector(rootNode);
        this.outlineSelector.setParent(this);
    }

    public void fireItemSelectedChanged(BizConfigureItemCollection items) {
        if (items != null) {
            this.selectedItems = items;
        } else {
            this.selectedItems.clear();
        }
        this.resetScriptArea(this.selectedItems);
    }

    public void resetScriptArea(BizConfigureItemCollection selectedItems) {
        StringBuffer scriptBuffer = new StringBuffer();
        StringBuffer scriptDescBuffer = new StringBuffer();
        for (int i = 0; i < selectedItems.size(); ++i) {
            AbstractBizConfigureItemInfo itemInfo = selectedItems.get(i);
            scriptBuffer.append(itemInfo.getName());
            String dexc = StringUtils.isEmpty((String)itemInfo.getLabel()) ? itemInfo.getAlias() : itemInfo.getLabel();
            scriptDescBuffer.append(dexc);
            if (i == selectedItems.size() - 1) continue;
            scriptBuffer.append(" , ");
            scriptDescBuffer.append(" , ");
        }
        this.parent.getScriptArea().setText(scriptBuffer.toString());
        this.parent.getScriptDescriptionArea().setText(scriptDescBuffer.toString());
    }

    public void loadFields() {
        this.uiSelector.setSelectedItems(this.selectedItems);
        this.outlineSelector.setSelectedItems(this.selectedItems);
    }

    public void tabSelectChanged(ChangeEvent e) {
        KDTabbedPane pane = (KDTabbedPane)e.getSource();
        int index = pane.getSelectedIndex();
        if (index == 0) {
            this.uiSelector.setSelectedItems(this.selectedItems);
        } else {
            this.outlineSelector.setSelectedItems(this.selectedItems);
        }
    }

    protected BizConfigureItemCollection getSelectedItems() {
        return this.selectedItems;
    }

    @Override
    public RuleParameterCollection getParams() {
        return this.parse.getParams(this.selectedItems);
    }

    @Override
    public void setParams(RuleParameterCollection params) {
        this.selectedItems = this.parse.getItems(params);
        this.loadFields();
    }
}

