/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.bizrule.param;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.eas.ep.client.editor.bizrule.param.UIOutlineParamPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditorType;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.RootEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MultiSelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.UnSelectedRequest;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.UserConfigureUtils;
import java.util.List;

public class UIParamSelector
implements IUIEditor {
    private Context context;
    private BizConfigureTreeNode node;
    private RootEditPartViewer rootViewer;
    private BizUnitInfo model;
    private UIOutlineParamPanel paramManager;

    public UIParamSelector(BizUnitInfo model, BizConfigureTreeNode node) {
        this.model = model;
        this.node = node;
        this.initContext();
        this.initEditPartViewer();
    }

    private void initContext() {
        this.context = new Context();
        this.context.setCommandStack(new CommandStack());
        this.context.setShowContainer(false);
        this.context.setEditorType(EditorType.userLayout);
        this.context.setUiModel(this.getModel().getEditUI());
        this.context.setUitype(UIType.EDITUI);
        this.context.setDepend(UserConfigureUtils.userConfigureProject);
        this.context.setEditorUI(this);
        this.context.setStatus(3);
    }

    private void initEditPartViewer() {
        this.rootViewer = new RootEditPartViewer(this.node, this.context);
        this.context.setRootViewer(this.rootViewer);
    }

    public void setParent(UIOutlineParamPanel paramManager) {
        this.paramManager = paramManager;
    }

    @Override
    public BizUnitInfo getModel() {
        return this.model;
    }

    @Override
    public BizConfigureTreeNode getRootNode() {
        return this.node;
    }

    public RootEditPartViewer getRootViewer() {
        return this.rootViewer;
    }

    @Override
    public void editPartSelectionChanged(SelectionChangedEvent event) {
        if (event.getSource() instanceof EditPartManager) {
            EditPartManager manager = (EditPartManager)event.getSource();
            BizConfigureItemCollection items = new BizConfigureItemCollection();
            items.addCollection(this.paramManager.getSelectedItems());
            List selectedParts = manager.getMultiSelected();
            List allParts = manager.getPartList();
            for (int i = 0; i < allParts.size(); ++i) {
                Object object = allParts.get(i);
                if (!(object instanceof CommonEditPart)) continue;
                CommonEditPart part = (CommonEditPart)object;
                BizConfigureItemInfoAdapter model = (BizConfigureItemInfoAdapter)part.getModel();
                AbstractBizConfigureItemInfo item = model.getItem();
                if (selectedParts.contains(part)) {
                    if (items.contains(item)) continue;
                    items.add(item);
                    continue;
                }
                if (!items.contains(item)) continue;
                items.remove(item);
            }
            this.paramManager.fireItemSelectedChanged(items);
        }
    }

    public void setSelectedItems(BizConfigureItemCollection items) {
        this.doSelect(this.rootViewer, items);
        this.rootViewer.revalidate();
    }

    private AbstractBizConfigureItemInfo getBizconfigureItem(EditPart part) {
        Object object = part.getModel();
        if (object instanceof BizConfigureItemInfoAdapter) {
            return ((BizConfigureItemInfoAdapter)object).getItem();
        }
        return null;
    }

    private void doSelect(EditPartViewer view, BizConfigureItemCollection items) {
        EditPartManager partManager = view.getPartManager();
        partManager.clearMultiSelected();
        List parts = view.getPartManager().getPartList();
        for (int i = 0; i < parts.size(); ++i) {
            EditPart part = (EditPart)parts.get(i);
            if (items.contains(this.getBizconfigureItem(part))) {
                partManager.addMultiSelected(part);
                part.performRequest(new MultiSelectedRequest());
                continue;
            }
            part.performRequest(new UnSelectedRequest());
        }
        List childs = view.getChildViewer();
        for (int i = 0; i < childs.size(); ++i) {
            EditPartViewer child = (EditPartViewer)childs.get(i);
            this.doSelect(child, items);
        }
    }

    @Override
    public Project getDepends() {
        return null;
    }

    @Override
    public UIType getUiType() {
        return UIType.EDITUI;
    }

    @Override
    public void reset() {
    }
}

