/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.eas.ep.client.cursor.CursorHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.KeyEventHandler;
import com.kingdee.eas.ep.client.editor.editui.designer.MaskPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.Operate;
import com.kingdee.eas.ep.client.editor.editui.designer.OperateType;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.RootEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.action.AbstractMoveAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.ISelectionChangedListener;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.AfterMouseDraggRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ChangeContainerRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MouseDraggRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MoveInRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MoveOutRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.MultiSelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.SelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.UnSelectedRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.UictDetailPanel;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentResizeManager;
import com.kingdee.eas.ep.client.editor.editui.designer.util.UictEditorHelper;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public abstract class AbstractEditPartViewer
extends JPanel
implements EditPartViewer,
MouseListener,
MouseMotionListener,
KeyListener,
PropertyChangeListener {
    protected static Logger logger = Logger.getLogger(AbstractEditPartViewer.class);
    protected KeyEventHandler keyEventHandler;
    public int x;
    public int y;
    public int tx;
    public int ty;
    protected Map imageList = new HashMap();
    protected Map itemAdapterMap = new HashMap();
    protected boolean drawBorder = false;
    protected boolean isResizing = false;
    protected boolean isExited = false;
    public int border = 0;
    public KDPopupMenu popMenu = new KDPopupMenu();
    protected JCheckBoxMenuItem showContainerPop = null;
    protected EditPartFactory factory;
    protected EditPartManager partManager;
    protected CommandStack commandStack;
    protected ActionRegistry actionRegistry;
    protected KDPanel maskPanel;
    protected Dimension initCavansSize = new Dimension();
    protected MoveInRequest moveInRequest = new MoveInRequest();
    protected MoveOutRequest moveOutRequest = new MoveOutRequest();
    protected SelectedRequest selectedRequest = new SelectedRequest();
    protected MultiSelectedRequest multiSelectedRequest = new MultiSelectedRequest();
    protected UnSelectedRequest unSelectedRequest = new UnSelectedRequest();
    protected JMenuItem editTabPanePop = null;
    protected JMenuItem dataBindPop = null;
    protected JMenuItem newDataBindPop = null;
    protected JMenuItem entriesManagerPop = null;
    protected JMenuItem tablePop = null;
    protected JMenuItem editKDTablePop = null;
    protected IContext context;
    protected ComponentTreeNode node;
    protected List childViewer = new ArrayList();
    protected EditPartViewer parentViewer;
    protected BasicStroke _4fbs = new BasicStroke(4.0f);
    protected AbstractMoveAction moveAction;
    protected boolean launchMouseEvent = false;
    public final Timer moveTimer = new Timer(0, new MoveActionListener());
    public int moveStep = 0;
    public int direction = 0;
    public final Timer mouseStopTimer = new Timer(1000, new MouseStopActionListener());
    protected boolean isStopNSeconds;
    protected List mouseInInfo = new ArrayList();

    public AbstractEditPartViewer(IContext context) {
        this.context = context;
        this.setOpaque(false);
        this.maskPanel = new MaskPanel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                AbstractEditPartViewer.this.paintMaskPanel(g);
            }

            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                AbstractEditPartViewer.this.paintMaskPanelTopLevel(g);
            }

            public boolean isFocusTraversable() {
                return true;
            }
        };
        this.maskPanel.setOpaque(false);
        this.maskPanel.setFocusable(true);
        this.maskPanel.addMouseListener((MouseListener)this);
        if (1 != this.getContext().getStatus() && 3 != this.getContext().getStatus()) {
            this.maskPanel.addMouseMotionListener((MouseMotionListener)this);
            this.maskPanel.addKeyListener((KeyListener)this);
        }
        this.maskPanel.setBounds(new Rectangle(0, 0, 9999, 9999));
        this.keyEventHandler = new KeyEventHandler(this);
    }

    public AbstractEditPartViewer() {
    }

    @Override
    public EditPartFactory getEditPartFactory() {
        return this.factory;
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.partManager.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.partManager.removeSelectionChangedListener(l);
    }

    @Override
    public void select(EditPart editpart) {
        this.partManager.select(editpart);
    }

    @Override
    public EditPart getSelection() {
        return this.partManager.getSelection();
    }

    @Override
    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    public boolean isResizing() {
        return this.isResizing;
    }

    public void setResizing(boolean isResizing) {
        this.isResizing = isResizing;
    }

    @Override
    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    @Override
    public EditPartViewer getParentViewer() {
        return this.parentViewer;
    }

    @Override
    public void setParentViewer(EditPartViewer parentViewer) {
        this.parentViewer = parentViewer;
    }

    public void updateAction() {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = registry.getActions();
        while (iter.hasNext()) {
            BaseAction action = (BaseAction)iter.next();
            action.updateAction();
        }
    }

    protected abstract void perform_editComponent(EditPart var1);

    protected void updateEntryProperty() {
    }

    public void sendRequest(EditPart part, Request req) {
        if (part == null) {
            Iterator iter = this.partManager.iterator();
            while (iter.hasNext() && ((part = (EditPart)iter.next()) == null || !(part instanceof CommonEditPart))) {
            }
        }
        if (part != null) {
            part.sendRequest(req);
        }
    }

    @Override
    public JPanel getMaskPanel() {
        return this.maskPanel;
    }

    public void setAllViewerEscape() {
        ArrayList viewers = new ArrayList();
        UictEditorHelper.getAllViewer(viewers, this.getContext().getRootViewer());
        int size = viewers.size();
        for (int i = size - 1; i >= 0; --i) {
            AbstractEditPartViewer viewer = (AbstractEditPartViewer)viewers.get(i);
            viewer.setAllEditPartUnSelected();
            viewer.setAllEditPartMoveOut();
            viewer.imageList.clear();
            viewer.getContext().setMouseInViewer(null);
            viewer.getContext().setDragViewer(null);
            viewer.launchMouseEvent = false;
        }
    }

    public void setAllViewerEditPartUnSelected() {
        AbstractEditPartViewer rootViewer = this.context.getRootViewer();
        this.setEditPartUnSelected(rootViewer);
    }

    private void setEditPartUnSelected(EditPartViewer viewer) {
        viewer.setAllEditPartUnSelected();
        List children = viewer.getChildViewer();
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            this.setEditPartUnSelected((EditPartViewer)children.get(i));
        }
    }

    public void releasSelectedParam() {
        this.getContext().setDragViewer(null);
        this.imageList.clear();
        this.resetCursor();
    }

    @Override
    public void setAllEditPartUnSelected() {
        if (this.partManager != null) {
            List selected = this.partManager.getMultiSelected();
            for (int i = 0; i < selected.size(); ++i) {
                ((EditPart)selected.get(i)).performRequest(this.unSelectedRequest);
            }
            this.partManager.clearMultiSelected();
            this.partManager.select(null);
            this.partManager.source(null);
            this.releasSelectedParam();
        }
    }

    public void setAllEditPartMoveOut() {
        if (this.partManager != null) {
            Iterator iter = this.partManager.iterator();
            while (iter.hasNext()) {
                EditPart part = (EditPart)iter.next();
                part.performRequest(this.moveOutRequest);
            }
        }
    }

    public void setAllViewerEditPartMoveOut() {
        ArrayList viewers = new ArrayList();
        UictEditorHelper.getAllViewer(viewers, this.getContext().getRootViewer());
        int size = viewers.size();
        for (int i = size - 1; i >= 0; --i) {
            AbstractEditPartViewer viewer = (AbstractEditPartViewer)viewers.get(i);
            viewer.setAllEditPartMoveOut();
        }
    }

    public ComponentTreeNode getNode() {
        return null;
    }

    @Override
    public EditPartManager getPartManager() {
        return this.partManager;
    }

    @Override
    public List getChildViewer() {
        return this.childViewer;
    }

    @Override
    public void addChildViewer(EditPartViewer viewer) {
        this.childViewer.add(viewer);
    }

    public LayoutInfo getLayoutInfo() {
        if (this.getNode().getUserObject() instanceof ComponentInfo) {
            ComponentInfo cInfo = (ComponentInfo)this.getNode().getUserObject();
            return cInfo.getLayoutInfo();
        }
        return null;
    }

    public abstract void createEditPart();

    public void paintMaskPanel(Graphics g) {
        this.paintSelectedComponent(g);
        this.paintResizeComponent(g);
        if (this.context.getRootViewer() == this) {
            this.resetPreferredSize();
        }
        if (1 != this.getContext().getStatus() && !this.imageList.isEmpty()) {
            this.partManager.drawImageComponents(g, this.x - this.tx, this.y - this.ty, this.imageList);
        }
        if (this.drawBorder && this.getContext().isShowContainer()) {
            g.setColor(Color.blue);
            ((Graphics2D)g).setStroke(this._4fbs);
            g.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private Rectangle getDragStart() {
        Component comp;
        Rectangle tmp = new Rectangle();
        EditPart selection = this.partManager.getSelection();
        if (selection != null && (comp = selection.getComponent()) != null) {
            tmp = new Rectangle(comp.getBounds());
        }
        return tmp;
    }

    protected void paintSelectedComponent(Graphics g) {
        Iterator iter = this.partManager.iterator();
        while (iter.hasNext()) {
            EditPart part = (EditPart)iter.next();
            BufferedImage figure = part.getFigure();
            Component comp = part.getComponent();
            if (figure == null || comp == null) continue;
            g.drawImage(figure, comp.getX() - 2, comp.getY() - 2, figure.getWidth(), figure.getHeight(), this);
        }
    }

    private void paintResizeComponent(Graphics g) {
        if (this.isResizing && OperateType.drag.equals((Object)this.getContext().getOperate().getOperateType())) {
            Rectangle tmp = this.getDragStart();
            Rectangle rt = new Rectangle(tmp);
            switch (this.border) {
                case 8: {
                    tmp.y = this.y;
                    tmp.height = rt.y - this.y + rt.height;
                    break;
                }
                case 9: {
                    tmp.height = this.y - rt.y;
                    break;
                }
                case 10: {
                    tmp.x = this.x;
                    tmp.width = rt.x - this.x + rt.width;
                    break;
                }
                case 11: {
                    tmp.width = this.x - rt.x;
                    break;
                }
                case 6: {
                    tmp.y = this.y;
                    tmp.height = rt.y - this.y + rt.height;
                    tmp.x = this.x;
                    tmp.width = rt.x - this.x + rt.width;
                    break;
                }
                case 7: {
                    tmp.y = this.y;
                    tmp.height = rt.y - this.y + rt.height;
                    tmp.width = this.x - rt.x;
                    break;
                }
                case 4: {
                    tmp.x = this.x;
                    tmp.width = rt.x - this.x + rt.width;
                    tmp.height = this.y - rt.y;
                    break;
                }
                case 5: {
                    tmp.width = this.x - rt.x;
                    tmp.height = this.y - rt.y;
                }
            }
            if (tmp.height < 0) {
                tmp.height = 1;
                logger.info((Object)"\u9ad8\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a19px");
            }
            if (tmp.width < 0) {
                tmp.width = 1;
                logger.info((Object)"\u5bbd\u5ea6\u5c0f\u4e8e0,\u81ea\u52a8\u8c03\u6574\u4e3a1px");
            }
            BufferedImage fillBack = FigureHelper.drawAlphaImage(tmp.getSize(), 0.3f, Color.gray, true);
            g.drawImage(fillBack, tmp.x, tmp.y, tmp.width, tmp.height, this);
        }
    }

    protected void resetPreferredSize() {
    }

    protected void paintMaskPanelTopLevel(Graphics g) {
        if (!this.isExited && this.isStopNSeconds && this.mouseInInfo != null && this.mouseInInfo.size() > 0) {
            int h = this.mouseInInfo.size() * 15 + 2;
            g.setColor(new Color(255, 255, 180));
            g.fillRect(this.x, this.y, 300, h);
            g.setColor(Color.gray);
            int size = this.mouseInInfo.size();
            for (int i = 0; i < size; ++i) {
                g.drawString((String)this.mouseInInfo.get(i), this.x + 5, this.y + i * 15 + 13);
            }
            g.drawRect(this.x, this.y, 300, h);
        }
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    @Override
    public void keyTyped(KeyEvent e) {
        this.keyEventHandler.keyTyped(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyEventHandler.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyEventHandler.keyReleased(e);
    }

    public KeyEventHandler getKeyEventHandler() {
        return this.keyEventHandler;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (OperateType.select != this.getContext().getOperate().getOperateType()) {
            return;
        }
        this.launchMouseEvent = true;
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.x = e.getX();
            this.y = e.getY();
            this.getContext().setMouseInViewer(this);
            if (!this.isResizing && !this.isMutiSelectModel(e)) {
                EditPart currentPart = this.partManager.getPart(e.getX(), e.getY());
                if (currentPart != null && (currentPart.getComponent() instanceof KDTable || currentPart.getComponent() instanceof UictDetailPanel)) {
                    BizConfigureItemInfoAdapter adapter;
                    int columnIndex;
                    Component comp = currentPart.getComponent();
                    KDTable table = comp instanceof KDTable ? (KDTable)comp : ((UictDetailPanel)comp).getEntryTable();
                    if (EditUIEditorHelper.dispatchEvent2KDTScrollBar((Component)this.maskPanel, e, table)) {
                        this.setAllViewerEditPartUnSelected();
                        return;
                    }
                    if (!this.context.isBase() && (columnIndex = EditUIEditorHelper.dispatchEvent2KDTHeadView((Component)this.maskPanel, e, table, (int)comp.getBounds().getX())) != -1 && (adapter = (BizConfigureItemInfoAdapter)currentPart.getModel()) != null && adapter.getItem() != null) {
                        adapter.getItem().setFromColumnIndex(columnIndex);
                    }
                }
                if (!this.partManager.isSelectedPart(currentPart)) {
                    this.setAllViewerEditPartUnSelected();
                }
                if (currentPart != null && currentPart.getComponent() != null) {
                    Component comp = currentPart.getComponent();
                    this.tx = e.getX() - comp.getX();
                    this.ty = e.getY() - comp.getY();
                    this.partManager.target(null);
                    this.partManager.source(currentPart);
                    this.partManager.select(currentPart);
                    this.getContext().setDragViewer(this);
                    currentPart.performRequest(this.selectedRequest);
                } else {
                    if (this.getParentViewer() instanceof AbstractEditPartViewer) {
                        ((AbstractEditPartViewer)this.getParentViewer()).setResizing(this.isResizing);
                    }
                    EditUIEditorHelper.dispatchEvent2ParentViewer(this, e);
                    this.imageList.clear();
                }
            } else {
                this.imageList.clear();
            }
        }
    }

    public void resetCursor() {
        OperateType type = this.getContext().getOperate().getOperateType();
        AbstractEditPartViewer viewer = this.getContext().getMouseInViewer();
        if (viewer == null) {
            viewer = this;
        }
        if (OperateType.drag == type && this.getContext().getDragViewer() != this) {
            viewer.setCursor(CursorHelper.getDragCursor());
        } else if (OperateType.create == type) {
            viewer.setCursor(CursorHelper.getCreatecursor());
        } else if (OperateType.format == type) {
            viewer.setCursor(CursorHelper.getFormatCurssor());
        } else {
            viewer.setCursor(CursorHelper.getDefaultCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        OperateType type = this.getContext().getOperate().getOperateType();
        if (SwingUtilities.isLeftMouseButton(e) && (OperateType.select == type || OperateType.drag == type)) {
            if (OperateType.select == type) {
                this.getContext().getOperate().setOperateType(OperateType.drag);
            }
            this.x = e.getX();
            this.y = e.getY();
            EditPart currentPart = this.partManager.getPart(this.x, this.y);
            if (currentPart != null && (currentPart.getComponent() instanceof KDTable || currentPart.getComponent() instanceof UictDetailPanel)) {
                Component comp = currentPart.getComponent();
                KDTable table = comp instanceof KDTable ? (KDTable)comp : ((UictDetailPanel)comp).getEntryTable();
                if (EditUIEditorHelper.dispatchEvent2KDTScrollBar((Component)this.maskPanel, e, table)) {
                    table.reLayoutAndPaint();
                    return;
                }
                if (!this.context.isBase()) {
                    BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)currentPart.getModel();
                    int selectColIndex = adapter.getItem().getFromColumnIndex();
                    Object activeCol = null;
                    if (this.partManager.getMultiSelected().size() == 1) {
                        activeCol = EditUIEditorHelper.dispatchEvent2KDTView((Component)this.maskPanel, e, table);
                    }
                    if (activeCol != null && activeCol instanceof Boolean) {
                        EditUIEditorHelper.setColumnItem((BizConfigureTreeNode)this.getNode(), adapter, table);
                        return;
                    }
                    if (adapter != null && adapter.getItem() != null && selectColIndex > -1 && this.partManager.getMultiSelected().size() == 1) {
                        adapter.getItem().setFromColumnIndex(-1);
                        this.setAllViewerEditPartUnSelected();
                        this.partManager.clearMultiSelected();
                        if (OperateType.format == this.getContext().getOperate().getOperateType()) {
                            this.format(currentPart);
                            this.getContext().setOperate(new Operate(OperateType.select));
                            this.resetCursor();
                        }
                        this.partManager.select(currentPart);
                        this.partManager.source(currentPart);
                        currentPart.performRequest(this.selectedRequest);
                    }
                }
            }
            if (this.partManager.getSelection() == null) {
                EditUIEditorHelper.dispatchEvent2ParentViewer(this, e);
                return;
            }
            if (!this.isResizing) {
                List multiSelected = this.partManager.getMultiSelected();
                for (int i = 0; i < multiSelected.size(); ++i) {
                    EditPart part = (EditPart)multiSelected.get(i);
                    if (part instanceof RootEditPart) continue;
                    this.imageList.put(part, FigureHelper.drawAlphaImage(part.getComponent().getSize(), 0.3f, Color.gray, true));
                }
            }
            this.partManager.getSelection().performRequest(new MouseDraggRequest());
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (OperateType.select != this.getContext().getOperate().getOperateType()) {
            return;
        }
        this.x = e.getX();
        this.y = e.getY();
        Object cursorHead = null;
        EditPart currentPart = this.partManager.getPart(this.x, this.y);
        if (!this.context.isBase() && currentPart != null && (currentPart.getComponent() instanceof KDTable || currentPart.getComponent() instanceof UictDetailPanel)) {
            Component comp = currentPart.getComponent();
            KDTable table = comp instanceof KDTable ? (KDTable)comp : ((UictDetailPanel)comp).getEntryTable();
            cursorHead = EditUIEditorHelper.dispatchEvent2KDTView((Component)this.maskPanel, e, table);
        }
        if (cursorHead != null && cursorHead instanceof Cursor) {
            this.setCursor((Cursor)cursorHead);
            this.border = this.getCursor().getType();
        } else {
            EditPart selection = this.partManager.getSelection();
            ComponentResizeManager manager = new ComponentResizeManager();
            Point point = new Point(this.x, this.y);
            if (selection != null) {
                Component comp = selection.getComponent();
                this.isResizing = manager.isResizing(comp, point);
            } else {
                this.isResizing = false;
            }
            if (this.isResizing) {
                Cursor cursor = manager.getCursor();
                if (this.getCursor().getType() != cursor.getType()) {
                    this.setCursor(cursor);
                }
                this.border = this.getCursor().getType();
            } else {
                this.resetCursor();
            }
        }
        if (this.isStopNSeconds) {
            this.repaint();
        }
        if (this.mouseStopTimer.isRunning()) {
            this.mouseStopTimer.restart();
        } else {
            this.mouseStopTimer.start();
        }
        this.isStopNSeconds = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        EditPart part = this.partManager.getPart(e.getX(), e.getY());
        if (SwingUtilities.isLeftMouseButton(e) && !this.isMutiSelectModel(e)) {
            if (OperateType.create == this.getContext().getOperate().getOperateType()) {
                this.createField(e.getX(), e.getY());
            }
            if (part != null && (part.getComponent() instanceof KDTable || part.getComponent() instanceof UictDetailPanel)) {
                BizConfigureItemInfoAdapter adapter;
                int columnIndex;
                Component comp = part.getComponent();
                KDTable table = comp instanceof KDTable ? (KDTable)comp : ((UictDetailPanel)comp).getEntryTable();
                if (EditUIEditorHelper.dispatchEvent2KDTScrollBar((Component)this.maskPanel, e, table)) {
                    this.setAllViewerEditPartUnSelected();
                    return;
                }
                if (!this.context.isBase() && (columnIndex = EditUIEditorHelper.dispatchEvent2KDTHeadView((Component)this.maskPanel, e, table, (int)comp.getBounds().getX())) != -1 && (adapter = (BizConfigureItemInfoAdapter)part.getModel()) != null && adapter.getItem() != null) {
                    adapter.getItem().setFromColumnIndex(columnIndex);
                }
            }
            this.setAllViewerEditPartUnSelected();
            if (part != null) {
                if (OperateType.format == this.getContext().getOperate().getOperateType()) {
                    this.format(part);
                    this.getContext().setOperate(new Operate(OperateType.select));
                    this.resetCursor();
                }
            } else {
                EditUIEditorHelper.dispatchEvent2ParentViewer(this, e);
                return;
            }
            this.partManager.select(part);
            this.partManager.source(part);
            part.performRequest(this.selectedRequest);
            this.repaint();
        } else if (SwingUtilities.isLeftMouseButton(e) && this.isMutiSelectModel(e)) {
            if (this.partManager.getSelection() != null) {
                BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)this.partManager.getSelection().getModel();
                adapter.getItem().setFromColumnIndex(-1);
                this.partManager.addMultiSelected(this.partManager.getSelection());
                this.partManager.getSelection().performRequest(this.multiSelectedRequest);
                this.partManager.select(null);
            }
            if (part != null) {
                if (OperateType.format == this.getContext().getOperate().getOperateType()) {
                    this.format(part);
                }
                if (this.partManager.containsMultiSelected(part)) {
                    this.partManager.removeMultiSelected(part);
                    part.performRequest(this.unSelectedRequest);
                } else {
                    this.partManager.addMultiSelected(part);
                    part.performRequest(this.multiSelectedRequest);
                }
            } else {
                EditUIEditorHelper.dispatchEvent2ParentViewer(this, e);
                return;
            }
            this.repaint();
        } else if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
            if (OperateType.select != this.getContext().getOperate().getOperateType()) {
                IUIEditor editor = ((Context)this.context).getEditorUI();
                editor.reset();
                return;
            }
            if (this.partManager.getMultiSelected().size() == 0) {
                this.setAllEditPartUnSelected();
                if (part != null) {
                    part.performRequest(this.selectedRequest);
                }
                this.partManager.select(part);
                this.partManager.clearMultiSelected();
                this.repaint();
            }
            this.updateAction();
            if (2 == this.getContext().getStatus() || 0 == this.getContext().getStatus()) {
                this.popMenu.show((Component)this, e.getX(), e.getY());
            }
        }
        this.getContext().getRootViewer().getMaskPanel().requestFocus();
    }

    private boolean isMutiSelectModel(MouseEvent e) {
        return e.isControlDown() || 3 == this.getContext().getStatus();
    }

    protected abstract void createField(int var1, int var2);

    protected void format(EditPart part) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.launchMouseEvent) {
            EditPart source;
            Operate operate = this.getContext().getOperate();
            OperateType type = operate.getOperateType();
            if (OperateType.select != type && OperateType.drag != type) {
                return;
            }
            EditPart currentPart = this.partManager.getPart(e.getX(), e.getY());
            if (currentPart != null && (currentPart.getComponent() instanceof KDTable || currentPart.getComponent() instanceof UictDetailPanel)) {
                Component comp = currentPart.getComponent();
                KDTable table = comp instanceof KDTable ? (KDTable)comp : ((UictDetailPanel)comp).getEntryTable();
                if (EditUIEditorHelper.dispatchEvent2KDTScrollBar((Component)this.maskPanel, e, table)) {
                    return;
                }
                if (!this.context.isBase()) {
                    EditUIEditorHelper.dispatchEvent2KDTHeadView((Component)this.maskPanel, e, table, (int)comp.getBounds().getX());
                    BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)currentPart.getModel();
                    if (adapter != null && adapter.getItem() != null) {
                        adapter.getItem().setFromColumnIndex(-1);
                    }
                }
            }
            if ((source = this.partManager.getSource()) != null) {
                if (OperateType.drag == type) {
                    if (!this.isResizing) {
                        this.doMove();
                    } else {
                        this.doResize(source);
                    }
                }
            } else {
                EditUIEditorHelper.dispatchEvent2ParentViewer(this, e);
            }
            operate.setOperateType(OperateType.select);
            this.releasSelectedParam();
            this.setResizing(false);
            this.setAllViewerEditPartMoveOut();
            this.repaint();
        }
        this.launchMouseEvent = false;
    }

    private void doMove() {
        if (this.imageList.isEmpty()) {
            return;
        }
        EditPart source = this.partManager.getSource();
        int deltaX = this.x - this.tx - source.getComponent().getX();
        int deltaY = this.y - this.ty - source.getComponent().getY();
        if (deltaX != 0 || deltaY != 0) {
            List parts = this.partManager.getMultiSelected();
            for (int i = 0; i < parts.size(); ++i) {
                EditPart part = (EditPart)parts.get(i);
                int newX = deltaX + part.getComponent().getX();
                int newY = deltaY + part.getComponent().getY();
                this.doMove(part, newX, newY);
            }
        }
    }

    private void doMove(EditPart part, int x, int y) {
        if (this == this.getContext().getMouseInViewer()) {
            part.sendRequest(this.getDirectEditRequest(part, x, y));
        } else {
            boolean isParent = UictEditorHelper.isParent(this.context.getMouseInViewer(), part.getComponent());
            if (isParent) {
                this.imageList.clear();
                return;
            }
            Point p2 = SwingUtilities.convertPoint(this, x, y, this.context.getMouseInViewer());
            ChangeContainerRequest request = new ChangeContainerRequest(part, this, this.context.getMouseInViewer(), p2);
            part.sendRequest(request);
        }
        part.performRequest(new AfterMouseDraggRequest());
    }

    private void doResize(EditPart source) {
        List requests = this.getResizeRequests(source);
        for (int i = 0; i < requests.size(); ++i) {
            ResizeRequest request = (ResizeRequest)requests.get(i);
            source.sendRequest(request);
        }
        source.performRequest(new AfterMouseDraggRequest());
        this.isResizing = false;
    }

    private List getResizeRequests(EditPart source) {
        ArrayList<ResizeRequest> requests = new ArrayList<ResizeRequest>();
        switch (this.border) {
            case 8: 
            case 9: {
                requests.add(new ResizeRequest(source, this, this.border, this.y));
                break;
            }
            case 10: 
            case 11: {
                requests.add(new ResizeRequest(source, this, this.border, this.x));
                break;
            }
            case 4: {
                requests.add(new ResizeRequest(source, this, 10, this.x));
                requests.add(new ResizeRequest(source, this, 9, this.y));
                break;
            }
            case 6: {
                requests.add(new ResizeRequest(source, this, 8, this.y));
                requests.add(new ResizeRequest(source, this, 10, this.x));
                break;
            }
            case 5: {
                requests.add(new ResizeRequest(source, this, 9, this.y));
                requests.add(new ResizeRequest(source, this, 11, this.x));
                break;
            }
            case 7: {
                requests.add(new ResizeRequest(source, this, 8, this.y));
                requests.add(new ResizeRequest(source, this, 11, this.x));
                break;
            }
        }
        return requests;
    }

    protected abstract Request getDirectEditRequest(EditPart var1, int var2, int var3);

    public Map getImageList() {
        return this.imageList;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isExited = false;
        this.getContext().setMouseInViewer(this);
        this.maskPanel.requestFocus();
        this.drawBorder = true;
        this.repaint();
        this.resetCursor();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isExited = true;
        this.resetCursor();
        this.drawBorder = false;
        this.mouseInInfo.clear();
        this.moveTimer.stop();
        this.repaint();
    }

    protected abstract List getCurrentMouseInInfo();

    class MouseStopActionListener
    implements ActionListener {
        MouseStopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractEditPartViewer.this.isStopNSeconds = true;
            AbstractEditPartViewer.this.mouseStopTimer.stop();
            AbstractEditPartViewer.this.getCurrentMouseInInfo();
            AbstractEditPartViewer.this.getMaskPanel().repaint();
        }
    }

    class MoveActionListener
    implements ActionListener {
        MoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractEditPartViewer.this.moveTimer.stop();
            AbstractEditPartViewer.this.moveAction.setStep(AbstractEditPartViewer.this.moveStep);
            AbstractEditPartViewer.this.moveAction.setDirection(AbstractEditPartViewer.this.direction);
            AbstractEditPartViewer.this.moveAction.actionPerformed(null);
            AbstractEditPartViewer.this.moveStep = 0;
            AbstractEditPartViewer.this.direction = 0;
        }
    }
}

