/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.AlignPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.ChangeContainerPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.ChangeZOrderProlicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.DirectEditPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.FormatPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.ResizePolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.SameSizePolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.policy.ShowDynBorderPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ShowDynBorderRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.EPBorderLayout;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.UictDetailPanel;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class CommonEditPart
extends AbstractEditPart {
    private static final Logger logger = CoreUIObject.getLogger(CommonEditPart.class);
    protected BufferedImage figure;
    protected Component component;
    protected Component baseComponent;
    protected boolean isMoveIn = false;
    protected boolean isSelected = false;
    protected boolean isMultiSelected = false;
    protected boolean isShowDynBorder = false;
    protected BasicStroke _3fbs = new BasicStroke(3.0f);
    protected BizConfigureItemInfo item;
    public ComponentInfo cInfo;
    public Border oldBorder;

    public BizConfigureItemInfo getItemInfo() {
        return this.item;
    }

    public CommonEditPart() {
    }

    public CommonEditPart(BizConfigureItemInfo item) {
        if (item == null) {
            return;
        }
        this.item = item;
        this.cInfo = item.getComponent();
        KDRectangle rect = item.getBounds();
        FigureHelper.ComponentParam cp = FigureHelper.getComponentParam(item);
        this.component = this.createComponent(this.cInfo, cp);
        if (this.component != null) {
            if (rect != null && rect.getRectangle() != null) {
                this.component.setBounds(rect.getRectangle());
            }
            if (this.component instanceof JComponent) {
                this.oldBorder = ((JComponent)this.component).getBorder();
            }
        }
    }

    @Override
    public void activate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).addPropertyChangeListener(this);
    }

    @Override
    public void deactivate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).removePropertyChangeListener(this);
    }

    @Override
    public void performRequest(Request request) {
        Object type = request.getType();
        if ("selected".equals(type)) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.isMultiSelected = false;
                this.refreshVisuals();
            }
        } else if ("multiselected".equals(type)) {
            if (!this.isMultiSelected) {
                this.isSelected = false;
                this.isMultiSelected = true;
                this.refreshVisuals();
            }
        } else if ("unselected".equals(type)) {
            if (this.isSelected || this.isMultiSelected) {
                this.isSelected = false;
                this.isMultiSelected = false;
                this.refreshVisuals();
            }
        } else if ("resetborder".equals(type)) {
            ShowDynBorderRequest req = (ShowDynBorderRequest)request;
            this.isShowDynBorder = req.isShowDynBorder();
            this.refreshVisuals();
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", new DirectEditPolicy());
        this.installEditPolicy("ChangeContainerPolicy", new ChangeContainerPolicy());
        this.installEditPolicy("ResizePolicy", new ResizePolicy());
        this.installEditPolicy("AlignPolicy", new AlignPolicy());
        this.installEditPolicy("SameSizePolicy", new SameSizePolicy());
        this.installEditPolicy("ShowDynBorderPolicy", new ShowDynBorderPolicy());
        this.installEditPolicy("FormatPolicy", new FormatPolicy(this));
        this.installEditPolicy("ChangeZOrderProlicy", new ChangeZOrderProlicy());
    }

    @Override
    public BufferedImage getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    protected BufferedImage createFigure() {
        KDRectangle bounds = this.getBounds();
        if (bounds != null) {
            Dimension size = bounds.getRectangle().getSize();
            size.width += 4;
            size.height += 4;
            return FigureHelper.drawAlphaImage(size, 0.0f, Color.white, false);
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        KDRectangle bounds;
        String name;
        BizConfigureItemInfoAdapter adpter = (BizConfigureItemInfoAdapter)this.getModel();
        if (evt != null && ("rectangle".equals(name = evt.getPropertyName()) || "format".equals(name)) && (bounds = adpter.getBounds()) != null) {
            if (this.component != null && !bounds.getRectangle().equals(this.component.getBounds())) {
                this.component.setBounds(bounds.getRectangle());
            }
            if (this.figure == null || this.figure.getWidth() != bounds.getWidth() || this.figure.getHeight() != bounds.getHeight()) {
                this.refreshVisuals();
            }
        }
        this.refreshComponent(FigureHelper.getComponentParam((BizConfigureItemInfo)adpter.getItem()));
        if (this.viewer instanceof UictEditPartViewer) {
            ((UictEditPartViewer)this.viewer).repaint();
        }
    }

    @Override
    public void setViewer(EditPartViewer viewer) {
        super.setViewer(viewer);
        if (this.component != null && viewer instanceof UictEditPartViewer) {
            UictEditPartViewer parent = (UictEditPartViewer)viewer;
            if (this.isBorderLayout(parent)) {
                String constraint = this.repareBorderLayoutConstraint((String)this.cInfo.getConstraint());
                if (!StringUtils.isEmpty((String)constraint)) {
                    this.resetComponentStatus(this.component);
                    this.resetPreferredSize(this.component, this.cInfo);
                    parent.add(this.component, constraint);
                    CommonEditPartViewer listener = new CommonEditPartViewer(this, (Context)viewer.getContext());
                    BizConfigureTreeNode node = (BizConfigureTreeNode)parent.getNode();
                    listener.setNode(node);
                    this.regestListener(this.component, listener);
                }
            } else {
                parent.add(this.component);
            }
        }
    }

    protected void regestListener(Component component, CommonEditPartViewer listener) {
        if (component instanceof KDTable) {
            KDTable table = (KDTable)component;
            this.regestListener(table, listener);
        } else if (component instanceof KDTreeView) {
            this.regestListener((KDTreeView)component, listener);
        } else {
            component.addMouseListener(listener);
            component.addMouseWheelListener(listener);
        }
    }

    private void regestListener(KDTable table, CommonEditPartViewer listener) {
        table.addKDTMouseListener((KDTMouseListener)listener);
        table.addMouseWheelListener((MouseWheelListener)listener);
        KDTViewManager manager = table.getViewManager();
        if (manager != null) {
            int n = manager.getViewCount();
            for (int i = 0; i < n; ++i) {
                BasicView view = manager.getView(i);
                view.addMouseListener((MouseListener)listener);
                view.addMouseWheelListener((MouseWheelListener)listener);
            }
        }
    }

    private void regestListener(KDTreeView view, CommonEditPartViewer listener) {
        Component[] components = view.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JScrollPane)) continue;
            components[i].addMouseWheelListener(listener);
        }
    }

    protected void resetComponentStatus(Component comp) {
        if (comp instanceof KDTreeView) {
            ((KDTreeView)comp).setShowButton(false);
        }
        comp.setEnabled(false);
    }

    protected void resetPreferredSize(Component comp, ComponentInfo cInfo) {
        PropertyInfo property;
        if (comp instanceof JComponent && (property = cInfo.getPropertyByName("preferredSize")) != null && !StringUtils.isEmpty((String)property.getValue())) {
            String value = property.getValue();
            try {
                String[] split = StringUtils.split((String)value, (int)44);
                int width = Integer.parseInt(split[0]);
                int height = Integer.parseInt(split[1]);
                Dimension size = new Dimension(width, height);
                ((JComponent)comp).setPreferredSize(size);
            }
            catch (Exception e) {
                logger.error((Object)("illegal preferredSize for component : " + cInfo.getName()), (Throwable)e);
            }
        }
    }

    private String repareBorderLayoutConstraint(String constraint) {
        if ("Center".equalsIgnoreCase(constraint)) {
            constraint = "Center";
        } else if ("North".equalsIgnoreCase(constraint)) {
            constraint = "North";
        } else if ("East".equalsIgnoreCase(constraint)) {
            constraint = "East";
        } else if ("West".equalsIgnoreCase(constraint)) {
            constraint = "West";
        } else if ("South".equalsIgnoreCase(constraint)) {
            constraint = "South";
        } else {
            logger.error((Object)("Illega constraint : " + constraint));
            return null;
        }
        return constraint;
    }

    public boolean isBorderLayout(JComponent viewer) {
        if (viewer == null) {
            return false;
        }
        LayoutManager layout = viewer.getLayout();
        if (layout == null) {
            return false;
        }
        return layout instanceof EPBorderLayout;
    }

    @Override
    public void refreshVisuals() {
        Graphics g;
        this.figure = this.createFigure();
        if (this.figure == null) {
            return;
        }
        if (this.isMoveIn) {
            g = this.figure.getGraphics();
            g.setColor(Color.red);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.isSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
            FigureHelper.drawPoint(g, new Rectangle(0, 0, this.figure.getWidth(), this.figure.getHeight()), 15, Color.black);
        }
        if (this.isMultiSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.isShowDynBorder && this.cInfo != null && this.cInfo.isConfigured()) {
            g = this.figure.getGraphics();
            g.setColor(Color.BLUE);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.viewer != null) {
            ((JComponent)((Object)this.viewer)).repaint();
            ((JComponent)((Object)this.viewer)).revalidate();
        }
    }

    public KDRectangle getBounds() {
        BizConfigureItemInfo item = (BizConfigureItemInfo)((BizConfigureItemInfoAdapter)this.getModel()).getItem();
        return item.getBounds();
    }

    @Override
    public Object getConstraint() {
        return this.getBounds();
    }

    protected Component createComponent(ComponentInfo cInfo, FigureHelper.ComponentParam cp) {
        if (cp == null || cInfo == null) {
            return null;
        }
        Component control = null;
        String classType = cInfo.getClassType();
        try {
            control = (Component)Class.forName(classType).newInstance();
            control.setName(cInfo.getName());
            this.baseComponent = control;
            if (control instanceof JComponent) {
                ((JComponent)control).setOpaque(true);
            }
            control.setEnabled(cp.enabled);
            Method method = null;
            try {
                method = control.getClass().getMethod("setRequired", Boolean.TYPE);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (method != null) {
                method.invoke((Object)control, cp.required);
            }
            method = null;
            try {
                method = control.getClass().getMethod("setHorizontalAlignment", Integer.TYPE);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (method != null) {
                method.invoke((Object)control, new Integer(cp.horizontalAlignment));
            }
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) {
                ((KDTable)control).setFormatXml(cp.formatXml);
                ((KDTable)control).checkParsed(true);
                String buildDetail = cInfo.getExtendedProperty("buildDetail");
                if ("true".equals(buildDetail)) {
                    UictDetailPanel udp = new UictDetailPanel((KDTable)control);
                    control = udp;
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(cInfo.getClassType())) {
                method = null;
                try {
                    method = control.getClass().getMethod("setText", String.class);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)control, cp.text);
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(cInfo.getClassType())) {
                    KDLabel label = (KDLabel)control;
                    label.setBackground(Color.gray);
                }
                if ("com.kingdee.bos.ctrl.swing.KDWorkButton".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(cInfo.getClassType())) {
                    this.setIcon(control, cp);
                }
            } else if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getClassType())) {
                this.initLabelContainer((KDLabelContainer)control, cp);
            }
            if (cInfo.getParent() != null) {
                if ("com.kingdee.bos.ctrl.swing.KDScrollPane".equals(cInfo.getParent().getClassType())) {
                    cInfo = cInfo.getParent();
                    KDScrollPane scrollPaneNoteField = new KDScrollPane();
                    scrollPaneNoteField.getViewport().add(control, null);
                    control = scrollPaneNoteField;
                }
                if ("com.kingdee.bos.ctrl.swing.KDLabelContainer".equals(cInfo.getParent().getClassType())) {
                    KDLabelContainer lblContainer = this.createLabelContainer(cp);
                    lblContainer.setBoundEditor((JComponent)control);
                    control = lblContainer;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"createComponent error", (Throwable)e);
            return null;
        }
        return control;
    }

    private void setIcon(Component comp, FigureHelper.ComponentParam cp) {
        try {
            Method method = comp.getClass().getMethod("setIcon", Icon.class);
            method.invoke((Object)comp, cp.icon);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private KDLabelContainer createLabelContainer(FigureHelper.ComponentParam cp) {
        KDLabelContainer lblContainer = new KDLabelContainer();
        this.initLabelContainer(lblContainer, cp);
        return lblContainer;
    }

    private void initLabelContainer(KDLabelContainer lblContainer, FigureHelper.ComponentParam cp) {
        lblContainer.setBoundLabelText(cp.boundLabelText);
        lblContainer.setBoundLabelLength(cp.boundLabelLength);
        lblContainer.setBoundLabelUnderline(cp.boundLabelUnderline);
        lblContainer.setBoundLabelAlignment(cp.boundLabelAlignment);
        lblContainer.getBoundLabel().setOpaque(true);
    }

    protected void refreshComponent(FigureHelper.ComponentParam cp) {
        if (cp == null || this.baseComponent == null) {
            return;
        }
        try {
            this.baseComponent.setEnabled(cp.enabled);
            Method method = null;
            try {
                method = this.baseComponent.getClass().getMethod("setRequired", Boolean.TYPE);
            }
            catch (Exception e) {
                logger.debug((Object)e);
            }
            if (method != null) {
                method.invoke((Object)this.baseComponent, cp.required);
            }
            if (this.baseComponent instanceof KDTable) {
                int rowCount = ((KDTable)this.baseComponent).getRowCount();
                ((KDTable)this.baseComponent).setFormatXml(cp.formatXml);
                ((KDTable)this.baseComponent).checkParsed(true);
                ((KDTable)this.baseComponent).addRows(rowCount);
            } else if (this.baseComponent instanceof KDLabel || this.baseComponent instanceof KDButton || this.baseComponent instanceof KDRadioButton || this.baseComponent instanceof KDCheckBox || this.baseComponent instanceof KDWorkButton) {
                method = null;
                try {
                    method = this.baseComponent.getClass().getMethod("setText", String.class);
                }
                catch (Exception e) {
                    logger.debug((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)this.baseComponent, cp.text);
                }
                if (this.baseComponent instanceof KDButton || this.baseComponent instanceof KDWorkButton) {
                    this.setIcon(this.baseComponent, cp);
                }
            } else if (this.baseComponent instanceof KDContainer) {
                method = null;
                try {
                    method = this.baseComponent.getClass().getMethod("setTitle", String.class);
                }
                catch (Exception e) {
                    logger.debug((Object)e);
                }
                if (method != null) {
                    method.invoke((Object)this.baseComponent, cp.text);
                }
            } else if (this.baseComponent instanceof KDLabelContainer) {
                this.initLabelContainer((KDLabelContainer)this.baseComponent, cp);
            }
            if (this.baseComponent.getParent() != null) {
                Component tmp = this.baseComponent;
                if (tmp.getParent() instanceof JViewport) {
                    tmp = tmp.getParent();
                }
                if (tmp.getParent() instanceof KDScrollPane) {
                    tmp = tmp.getParent();
                }
                if (tmp.getParent() instanceof KDLabelContainer) {
                    KDLabelContainer lblContainer = (KDLabelContainer)tmp.getParent();
                    lblContainer.setBoundLabelText(cp.boundLabelText);
                    lblContainer.setBoundLabelLength(cp.boundLabelLength);
                    lblContainer.setBoundLabelUnderline(cp.boundLabelUnderline);
                    lblContainer.setBoundLabelAlignment(cp.boundLabelAlignment);
                    lblContainer.getBoundLabel().setOpaque(true);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
    }

    public Border getOldBorder() {
        return this.oldBorder;
    }
}

