/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.ISelectionChangedListener;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EditPartManager {
    private List partList = new ArrayList(10);
    private List multiSelected = new ArrayList(5);
    private EditPart selected;
    private EditPart target;
    private EditPart source;
    private List selectionListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EditPart part) {
        List list = this.partList;
        synchronized (list) {
            this.partList.remove(part);
            this.partList.add(part);
        }
    }

    public boolean contains(EditPart part) {
        return this.partList.contains(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EditPart part) {
        List list = this.partList;
        synchronized (list) {
            this.partList.remove(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.partList;
        synchronized (list) {
            this.partList.clear();
        }
    }

    public void select(EditPart editpart) {
        if (this.selected != editpart) {
            this.selected = this.contains(editpart) ? editpart : null;
            this.addMultiSelected(editpart);
        }
    }

    public void target(EditPart editpart) {
        if (this.target != editpart) {
            this.target = this.contains(editpart) ? editpart : null;
        }
    }

    public void source(EditPart editpart) {
        if (this.source != editpart) {
            this.source = this.contains(editpart) ? editpart : null;
        }
    }

    public List getPartList() {
        return this.partList;
    }

    public List getMultiSelected() {
        return this.multiSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultiSelected(EditPart editpart) {
        if (editpart != null) {
            List list = this.multiSelected;
            synchronized (list) {
                if (!this.multiSelected.contains(editpart)) {
                    this.multiSelected.add(editpart);
                    this.fireSelectionChanged(editpart);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultiSelected(EditPart editpart) {
        if (editpart == null) {
            return false;
        }
        List list = this.multiSelected;
        synchronized (list) {
            return this.multiSelected.contains(editpart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMultiSelected(EditPart editpart) {
        List list = this.multiSelected;
        synchronized (list) {
            this.multiSelected.remove(editpart);
            this.fireSelectionChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMultiSelected() {
        List list = this.multiSelected;
        synchronized (list) {
            this.multiSelected.clear();
            this.fireSelectionChanged(null);
        }
    }

    public EditPart getSelection() {
        return this.selected;
    }

    public EditPart getTarget() {
        return this.target;
    }

    public EditPart getSource() {
        return this.source;
    }

    public Iterator iterator() {
        return this.partList.iterator();
    }

    public int size() {
        return this.partList.size();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.selectionListeners.remove(l);
    }

    protected void fireSelectionChanged(EditPart editpart) {
        Object[] listeners = this.selectionListeners.toArray();
        SelectionChangedEvent event = new SelectionChangedEvent(this, editpart);
        for (int i = 0; i < listeners.length; ++i) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            if (listener == null) continue;
            listener.selectionChanged(event);
        }
    }

    public EditPart getPart(int x, int y) {
        Iterator e = this.iterator();
        EditPart retVal = null;
        while (e.hasNext()) {
            EditPart part = (EditPart)e.next();
            Component component = part.getComponent();
            if (component == null) continue;
            Rectangle bounds = component.getBounds();
            if (x < bounds.x || x > bounds.x + bounds.width || y < bounds.y || y > bounds.y + bounds.height) continue;
            retVal = part;
            break;
        }
        return retVal;
    }

    public EditPart getPart2(int x, int y) {
        Iterator e = this.iterator();
        while (e.hasNext()) {
            EditPart part = (EditPart)e.next();
            Component component = part.getComponent();
            if (component == null) continue;
            Rectangle bounds = component.getBounds();
            if (x != bounds.x || y != bounds.y) continue;
            return part;
        }
        return null;
    }

    public Rectangle getRectangle() {
        int maxX = -1;
        int maxY = -1;
        for (int i = 0; i < this.partList.size(); ++i) {
            EditPart part = (EditPart)this.partList.get(i);
            Component component = part.getComponent();
            if (component.getX() + component.getWidth() > maxX) {
                maxX = component.getX() + component.getWidth();
            }
            if (component.getY() + component.getHeight() <= maxY) continue;
            maxY = component.getY() + component.getHeight();
        }
        return new Rectangle(0, 0, maxX, maxY);
    }

    public boolean isSelectedPart(EditPart part) {
        return this.multiSelected.contains(part);
    }

    public void drawImageComponents(Graphics g, int x, int y, Map images) {
        if (this.selected != null) {
            int deltaX = x - this.selected.getComponent().getX();
            int deltaY = y - this.selected.getComponent().getY();
            for (int i = 0; i < this.multiSelected.size(); ++i) {
                EditPart part = (EditPart)this.multiSelected.get(i);
                g.drawImage((BufferedImage)images.get(part), part.getComponent().getX() + deltaX, part.getComponent().getY() + deltaY, part.getComponent().getWidth(), part.getComponent().getHeight(), null);
            }
        }
    }
}

