/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.ContainerEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.TabbedPaneEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComponent;

public class KDSplitPaneEditPart
extends ContainerEditPart {
    protected BizConfigureTreeNode splitPaneNode;
    protected UictEditPartViewer innerViewer;
    protected KDRectangle rect;
    private final String ORIENTATION = "orientation";
    private final String DIVIDERLOCATION = "dividerLocation";
    private final String RESIZEWEIGHT = "resizeWeight";

    public KDSplitPaneEditPart(BizConfigureTreeNode splitPaneNode, BizConfigureItemInfo item) {
        if (item == null) {
            return;
        }
        this.item = item;
        this.cInfo = item.getComponent();
        this.splitPaneNode = splitPaneNode;
        this.initComponent();
    }

    private void initComponent() {
        this.component = new KDSplitPane();
        this.initOrientation(this.component, this.cInfo);
        this.initDividerLocation(this.component, this.cInfo);
        this.initResizeWeight(this.component, this.cInfo);
        if (this.item.getBounds() != null) {
            this.rect = this.item.getBounds();
            this.component.setBounds(this.rect.getX() - 2, this.rect.getY() - 2, this.rect.getWidth() - 4, this.rect.getHeight() - 4);
            if (this.component instanceof JComponent) {
                this.oldBorder = ((JComponent)this.component).getBorder();
            }
        }
    }

    private void initOrientation(Component comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("orientation");
        if (property != null && property.getValue() != null) {
            int value;
            try {
                value = Integer.parseInt(property.getValue());
            }
            catch (Exception e) {
                value = 0;
            }
            ((KDSplitPane)comp).setOrientation(value);
        }
    }

    private void initDividerLocation(Component comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("dividerLocation");
        if (property != null && property.getValue() != null) {
            int value;
            try {
                value = Integer.parseInt(property.getValue());
            }
            catch (Exception e) {
                value = -1;
            }
            ((KDSplitPane)comp).setDividerLocation(value);
        }
    }

    private void initResizeWeight(Component comp, ComponentInfo cInfo) {
        PropertyInfo property = cInfo.getPropertyByName("resizeWeight");
        if (property != null && property.getValue() != null) {
            try {
                double weight = Double.parseDouble(property.getValue());
                if (weight >= 0.0 && weight <= 1.0) {
                    ((KDSplitPane)comp).setDividerLocation(weight);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deepPanel(BizConfigureTreeNode node, KDSplitPane splitPane) {
        int i;
        BizConfigureItemCollection items = (BizConfigureItemCollection)node.getConfigureItems();
        HashMap<String, BizConfigureTreeNode> nodes = new HashMap<String, BizConfigureTreeNode>();
        int n = node.getChildCount();
        for (i = 0; i < n; ++i) {
            BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)node.getChildAt(i));
            nodes.put(child.getName(), child);
        }
        n = items.size();
        for (i = 0; i < n; ++i) {
            BizConfigureTreeNode childNode;
            BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)items.get(i);
            if (itemInfo.getComponent() == null) continue;
            ComponentInfo cInfo = itemInfo.getComponent();
            Object constraint = cInfo.getConstraint();
            if (this.isIllegConstrantName(constraint)) break;
            Object object = nodes.get(cInfo.getName());
            if (object == null) {
                this.createCommonEditPart(splitPane, node, itemInfo);
                continue;
            }
            if ("com.kingdee.bos.ctrl.swing.KDPanel".equals(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(cInfo.getClassType())) {
                childNode = (BizConfigureTreeNode)((Object)object);
                this.innerViewer = new UictEditPartViewer(childNode, (Context)this.viewer.getContext());
                splitPane.add((Component)this.innerViewer, constraint);
                this.viewer.addChildViewer(this.innerViewer);
                this.innerViewer.setParentViewer(this.viewer);
                continue;
            }
            if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(cInfo.getClassType())) {
                childNode = (BizConfigureTreeNode)((Object)object);
                KDSplitPane childSplit = new KDSplitPane();
                this.initOrientation((Component)childSplit, cInfo);
                this.initDividerLocation((Component)childSplit, cInfo);
                this.initResizeWeight((Component)childSplit, cInfo);
                this.deepPanel(childNode, childSplit);
                splitPane.add((Component)childSplit, constraint);
                continue;
            }
            if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(cInfo.getClassType())) {
                childNode = (BizConfigureTreeNode)((Object)object);
                TabbedPaneEditPart tabbedPart = new TabbedPaneEditPart(childNode, itemInfo, (Context)this.viewer.getContext());
                tabbedPart.reload();
                splitPane.add(tabbedPart.getComponent(), constraint);
                continue;
            }
            this.createCommonEditPart(splitPane, node, itemInfo);
        }
    }

    private void createCommonEditPart(KDSplitPane splitPane, BizConfigureTreeNode node, BizConfigureItemInfo itemInfo) {
        BizConfigureItemInfoAdapter adapter = new BizConfigureItemInfoAdapter(itemInfo);
        CommonEditPart part = new CommonEditPart(itemInfo);
        part.setModel(adapter);
        part.activate();
        Component comp = part.getComponent();
        CommonEditPartViewer commonviewer = new CommonEditPartViewer(part, (Context)this.viewer.getContext());
        commonviewer.setNode(node);
        this.resetComponentStatus(comp);
        this.regestListener(comp, commonviewer);
        splitPane.add(comp, itemInfo.getComponent().getConstraint());
    }

    private boolean isIllegConstrantName(Object obj) {
        if (obj == null) {
            return true;
        }
        if (!(obj instanceof String)) {
            return true;
        }
        String s = obj.toString();
        return !"left".equalsIgnoreCase(s) && !"right".equalsIgnoreCase(s) && !"top".equalsIgnoreCase(s) && !"bottom".equalsIgnoreCase(s);
    }

    @Override
    public void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
        KDSplitPane splitPane = (KDSplitPane)this.component;
        this.deepPanel(this.splitPaneNode, splitPane);
        if (viewer instanceof UictEditPartViewer) {
            if (this.isBorderLayout((UictEditPartViewer)viewer) && this.cInfo.getConstraint() != null && this.cInfo.getConstraint() instanceof String) {
                ((UictEditPartViewer)viewer).add((Component)splitPane, this.cInfo.getConstraint().toString());
                splitPane.setEnabled(false);
            } else {
                ((UictEditPartViewer)viewer).getMaskPanel().add((Component)splitPane);
            }
        }
        ((JComponent)((Object)viewer)).revalidate();
        this.baseComponent = splitPane;
    }
}

