/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.action.DeleteAction;
import java.awt.event.KeyEvent;

public class KeyEventHandler {
    AbstractEditPartViewer viewer;

    public KeyEventHandler(AbstractEditPartViewer viewer) {
        this.viewer = viewer;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 89: {
                this.keyPressed_Y(e);
                break;
            }
            case 90: {
                this.keyPressed_Z(e);
                break;
            }
            case 127: {
                this.keyPressed_DELETE();
                break;
            }
            case 27: {
                this.keyPressed_ESC();
                break;
            }
            case 37: {
                this.keyPressed_LEFT();
                e.consume();
                break;
            }
            case 38: {
                this.keyPressed_UP();
                e.consume();
                break;
            }
            case 39: {
                this.keyPressed_RIGHT();
                e.consume();
                break;
            }
            case 40: {
                this.keyPressed_DOWN();
                e.consume();
                break;
            }
        }
    }

    private void keyPressed_DOWN() {
        if (this.viewer.moveTimer.isRunning()) {
            this.viewer.moveTimer.restart();
        } else {
            this.viewer.moveTimer.start();
        }
        if (this.viewer.direction != 4) {
            this.viewer.direction = 4;
            this.viewer.moveStep = 0;
        }
        ++this.viewer.moveStep;
    }

    private void keyPressed_RIGHT() {
        if (this.viewer.moveTimer.isRunning()) {
            this.viewer.moveTimer.restart();
        } else {
            this.viewer.moveTimer.start();
        }
        if (this.viewer.direction != 2) {
            this.viewer.direction = 2;
            this.viewer.moveStep = 0;
        }
        ++this.viewer.moveStep;
    }

    private void keyPressed_UP() {
        if (this.viewer.moveTimer.isRunning()) {
            this.viewer.moveTimer.restart();
        } else {
            this.viewer.moveTimer.start();
        }
        if (this.viewer.direction != 3) {
            this.viewer.direction = 3;
            this.viewer.moveStep = 0;
        }
        ++this.viewer.moveStep;
    }

    private void keyPressed_LEFT() {
        if (this.viewer.moveTimer.isRunning()) {
            this.viewer.moveTimer.restart();
        } else {
            this.viewer.moveTimer.start();
        }
        if (this.viewer.direction != 1) {
            this.viewer.direction = 1;
            this.viewer.moveStep = 0;
        }
        ++this.viewer.moveStep;
    }

    private void keyPressed_ESC() {
        this.viewer.setAllViewerEscape();
        if (this.viewer.getContext() instanceof Context) {
            Context context = (Context)this.viewer.getContext();
            IUIEditor editor = context.getEditorUI();
            editor.reset();
        }
    }

    private void keyPressed_DELETE() {
        if (this.viewer.getContext().isBase()) {
            DeleteAction delete = new DeleteAction(this.viewer.getContext().getRootViewer());
            delete.actionPerformed(null);
        }
    }

    private void keyPressed_Z(KeyEvent e) {
        if (e.isControlDown() && this.viewer.getCommandStack().canUndo()) {
            this.viewer.getCommandStack().undo();
        }
    }

    private void keyPressed_Y(KeyEvent e) {
        if (e.isControlDown() && this.viewer.getCommandStack().canRedo()) {
            this.viewer.getCommandStack().redo();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent arg0) {
    }
}

