/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.dtp.ControlDefaultSizeManager;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.CommonDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.util.EPUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NewCtrlDialog
extends CommonDialog {
    private static final Logger logger = CoreUIObject.getLogger(NewCtrlDialog.class);
    protected KDLabelContainer lblName;
    protected KDTextField txtName;
    protected KDButton btnConfirm;
    protected KDButton btnCancel;
    protected KDLabelContainer lblLabelText;
    protected KDTextField txtLabelText;
    protected KDCheckBox chkMultiLan;
    protected UIObjectInfo uiModel;
    protected ComponentInfo newCtrl;
    protected BizConfigureTreeNode node;
    protected ComponentInfo cInfoEdit;
    private String classType;
    private Layout layout;
    private Point place = new Point();
    protected String EXIT_STATUS = null;
    protected String OPER_STATUS = null;
    public static final String CONFIRM_EXIT = "confirm";
    public static final String CANCEL_EXIT = "cancel";
    public static final String NEW = "new";
    public static final String EDIT = "edit";
    protected Boolean validate = Boolean.TRUE;

    public NewCtrlDialog() throws Exception {
        this.jbInit();
        this.initUIP();
    }

    protected void jbInit() throws Exception {
        this.setUITitle("\u65b0\u589e\u5b57\u6bb5\u63a7\u4ef6");
        this.lblName = new KDLabelContainer();
        this.txtName = new KDTextField();
        this.btnConfirm = new KDButton();
        this.btnCancel = new KDButton();
        this.lblLabelText = new KDLabelContainer();
        this.txtLabelText = new KDTextField();
        this.chkMultiLan = new KDCheckBox();
        this.lblName.setName("lblName");
        this.txtName.setName("txtName");
        this.btnConfirm.setName("btnConfirm");
        this.btnCancel.setName("btnCancel");
        this.lblLabelText.setName("lblLabelText");
        this.txtLabelText.setName("txtLabelText");
        this.chkMultiLan.setName("chkMultiLan");
        this.lblName.setBoundLabelText("\u540d\u79f0");
        this.lblName.setBoundLabelLength(80);
        this.btnConfirm.setText("\u786e\u5b9a");
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewCtrlDialog.this.beforeActionPerformed(e);
                try {
                    NewCtrlDialog.this.btnConfirm_actionPerformed(e);
                }
                catch (Exception exc) {
                    NewCtrlDialog.this.handUIException(exc);
                }
                finally {
                    NewCtrlDialog.this.afterActionPerformed(e);
                }
            }
        });
        this.btnCancel.setText("\u53d6\u6d88");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewCtrlDialog.this.beforeActionPerformed(e);
                try {
                    NewCtrlDialog.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    NewCtrlDialog.this.handUIException(exc);
                }
                finally {
                    NewCtrlDialog.this.afterActionPerformed(e);
                }
            }
        });
        this.lblLabelText.setBoundLabelText("\u6807\u7b7e\u6587\u5b57");
        this.lblLabelText.setBoundLabelLength(80);
        this.chkMultiLan.setText("\u662f\u5426\u591a\u8bed\u8a00");
        this.chkMultiLan.setSelected(false);
        this.chkMultiLan.setVisible(false);
        this.txtName.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField textField;
                if (Character.getNumericValue(e.getKeyChar()) == -1 && e.getKeyChar() != '\b') {
                    e.consume();
                }
                if ((textField = (JTextField)e.getSource()).getCaretPosition() == 0) {
                    e.setKeyChar(Character.toLowerCase(e.getKeyChar()));
                }
            }
        });
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 400, 200));
        this.setLayout(null);
        this.lblName.setBounds(new Rectangle(10, 11, 383, 19));
        this.add((Component)this.lblName, null);
        this.btnConfirm.setBounds(new Rectangle(240, 170, 73, 21));
        this.add((Component)this.btnConfirm, null);
        this.btnCancel.setBounds(new Rectangle(319, 170, 73, 21));
        this.add((Component)this.btnCancel, null);
        this.lblLabelText.setBounds(new Rectangle(10, 35, 383, 19));
        this.add((Component)this.lblLabelText, null);
        this.chkMultiLan.setBounds(new Rectangle(10, 59, 140, 19));
        this.add((Component)this.chkMultiLan, null);
        this.lblName.setBoundEditor((JComponent)this.txtName);
        this.lblLabelText.setBoundEditor((JComponent)this.txtLabelText);
    }

    public void setUIObjectInfo(UIObjectInfo uiModel) {
        this.uiModel = uiModel;
    }

    public void setNode(BizConfigureTreeNode node) {
        this.node = node;
    }

    public void setPlace(Point place) {
        this.place = place;
    }

    public void setClassType(String classType) {
        this.classType = classType;
        Type[] types = new Type[]{new Type("TextField", "\u6587\u672c"), new Type("TextArea", "\u5907\u6ce8"), new Type("Number", "\u6570\u5b57"), new Type("Date", "\u65e5\u671f"), new Type("Time", "\u65f6\u95f4"), new Type("Bool", "\u5e03\u5c14"), new Type("Enum", "\u679a\u4e3e"), new Type("F7", "F7")};
        String headText = "";
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].name.equals(classType)) continue;
            headText = types[i].alias;
            break;
        }
        this.setUITitle("\u65b0\u589e" + headText + "\u63a7\u4ef6\u5b57\u6bb5");
    }

    public void setSupportMultiLanguage(boolean isSupportML) {
        this.chkMultiLan.setSelected(false);
        this.chkMultiLan.setVisible(isSupportML);
    }

    public void setLayoutInfo(Layout layout) {
        this.layout = layout;
    }

    public ComponentInfo getNewCtrl() {
        return this.newCtrl;
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.OPER_STATUS.equals(EDIT)) {
            this.peformEdit();
        } else {
            BizConfigureTreeNode childNode;
            if (!this.dataValidate()) {
                this.validate = Boolean.FALSE;
                return;
            }
            ComponentInfo cInfo = null;
            if ("TextField".equals(this.classType)) {
                cInfo = ComponentHelper.createTextField(this.uiModel, this.txtName.getText(), this.txtLabelText.getText(), this.chkMultiLan.isSelected());
            } else if ("TextArea".equals(this.classType)) {
                cInfo = ComponentHelper.createTextArea(this.uiModel, this.txtName.getText(), this.txtLabelText.getText(), this.chkMultiLan.isSelected());
            } else if ("Number".equals(this.classType)) {
                cInfo = ComponentHelper.createFormattedTextField(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("Date".equals(this.classType)) {
                cInfo = ComponentHelper.createDatePicker(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("Time".equals(this.classType)) {
                cInfo = ComponentHelper.createTimePicker(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("Bool".equals(this.classType)) {
                cInfo = ComponentHelper.createCheckBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("Enum".equals(this.classType)) {
                cInfo = ComponentHelper.createComboBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("F7".equals(this.classType)) {
                cInfo = ComponentHelper.createBizPromptBox(this.uiModel, this.txtName.getText(), this.txtLabelText.getText());
            } else if ("addEntry".equals(this.classType)) {
                cInfo = ComponentHelper.createEntry(this.uiModel, this.txtName.getText(), this.txtLabelText.getText(), this.layout);
            } else if (!StringUtils.isEmpty((String)this.classType)) {
                cInfo = ComponentHelper.createComponent(this.uiModel, this.classType, this.txtName.getText(), this.txtLabelText.getText(), this.layout);
            } else {
                this.EXIT_STATUS = CANCEL_EXIT;
                this.disposeUIWindow();
                return;
            }
            ComponentInfo parent = (ComponentInfo)this.node.getUserObject();
            Dimension dim = ControlDefaultSizeManager.getDefaultSize((String)cInfo.getClassType());
            Object constraint = ComponentHelper.createContraint(parent, new Rectangle(10, 10, dim.width, dim.height));
            if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parent.getClassType())) {
                constraint = this.txtLabelText.getText();
            }
            cInfo.setConstraint(constraint);
            parent.addChild((AbstractUIObjectInfo)this.uiModel, cInfo);
            BizConfigureItemInfo item = new BizConfigureItemInfo();
            KDRectangle rect = new KDRectangle(new Rectangle(this.place.x, this.place.y, dim.width, dim.height));
            ComponentInfo childField = EditUIEditorHelper.getNeedComponent(cInfo);
            childField.setConfigured(true);
            item.setName(childField.getName());
            item.setLabel(this.txtLabelText.getText());
            item.setLabelLength(100);
            item.setLabelUnderLine(true);
            item.setEnabled(true);
            item.setVisible(true);
            item.setRequired(false);
            item.setBounds(rect);
            item.setComponent(childField);
            BizConfigureItemCollection items = (BizConfigureItemCollection)this.node.getConfigureItems();
            items.add(item);
            if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(parent.getClassType())) {
                item.setBounds(null);
            }
            if ((EditUIEditorHelper.isXYOrKDLayout(cInfo) || "com.kingdee.bos.ctrl.kdf.table.KDTable".equals(cInfo.getClassType())) && (childNode = EditUIEditorHelper.createConfigureTreeNode(cInfo, this.uiModel, null)) != null) {
                childNode.setItem(item);
                this.node.add((MutableTreeNode)((Object)childNode));
            }
            this.newCtrl = cInfo;
        }
        this.EXIT_STATUS = CONFIRM_EXIT;
        this.disposeUIWindow();
    }

    protected void peformEdit() {
        if (this.cInfoEdit == null) {
            return;
        }
        this.cInfoEdit.setConstraint((Object)this.txtLabelText.getText());
        BizConfigureItemCollection items = (BizConfigureItemCollection)this.node.getConfigureItems();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            BizConfigureItemInfo itemInfo = (BizConfigureItemInfo)items.get(i);
            if (!this.cInfoEdit.equals((Object)itemInfo.getComponent())) continue;
            itemInfo.setLabel(this.txtLabelText.getText());
            break;
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EXIT_STATUS = CANCEL_EXIT;
        this.disposeUIWindow();
    }

    private boolean dataValidate() {
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            ExceptionHandler.handleWarn((JComponent)((Object)this), "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (EPUtils.checkStringIsChinese(this.txtName.getText())) {
            ExceptionHandler.handleWarn((JComponent)((Object)this), "\u540d\u79f0\u7b2c\u4e00\u4e2a\u5b57\u7b26\u662f\u82f1\u6587\u5b57\u6bcd\uff0c\u4e14\u540d\u79f0\u53ea\u80fd\u662f\u82f1\u6587\u5b57\u6bcd\u548c\u5176\u4ed6\u4efb\u610f\u5b57\u7b26\u7684\u7ec4\u5408\uff01");
            return false;
        }
        if (this.uiModel.getNameManager().isUsed(this.transLate(this.txtName.getText()))) {
            ExceptionHandler.handleWarn((JComponent)((Object)this), "\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u6539\u7528\u5176\u5b83\u540d\u79f0\uff01");
            return false;
        }
        return true;
    }

    private String transLate(String text) {
        String transText = null;
        transText = "TextField".equals(this.classType) || "TextArea".equals(this.classType) || "Number".equals(this.classType) ? "txt" + text : ("Date".equals(this.classType) || "Time".equals(this.classType) ? "pk" + text : ("Bool".equals(this.classType) ? "chk" + text : ("Enum".equals(this.classType) ? "combo" + text : ("F7".equals(this.classType) ? "prmt" + text : text))));
        return transText;
    }

    @Override
    public String getExitStatus() {
        return this.EXIT_STATUS;
    }

    public void init(ComponentInfo cInfo, String oper_status) {
        this.init(cInfo, oper_status, "");
    }

    public void init(ComponentInfo cInfo, String oper_status, String label) {
        this.OPER_STATUS = oper_status;
        if (NEW.equals(this.OPER_STATUS)) {
            this.txtName.setEnabled(true);
        } else {
            this.txtName.setEnabled(false);
        }
        if (cInfo != null) {
            this.txtName.setText(cInfo.getName());
            this.txtLabelText.setText(label);
            this.cInfoEdit = cInfo;
        }
    }

    class Type {
        private String name;
        private String alias;

        public Type(String name, String alias) {
            this.alias = alias;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            return this.alias;
        }
    }
}

