/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyEditorFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.DataBindProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.FilterItemProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.Property;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.ActionCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.AnchorCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.IconCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.BizRuleCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.BooleanAsCheckBoxPropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.ComboBoxPropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.DefaultValuePropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.EnumPropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.EventCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.FilterItemsEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.IntegerPropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.PropertyBindEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.TextPropertyEditor;
import com.kingdee.util.enums.Enum;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();
    private static PropertyEditorRegistry instance = new PropertyEditorRegistry();
    private static final Logger logger = CoreUIObject.getLogger(PropertyEditorRegistry.class);

    private PropertyEditorRegistry() {
        this.registerDefaults();
    }

    public static PropertyEditorRegistry getInstance() {
        return instance;
    }

    @Override
    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class type = property.getType();
        Class editorClass = (Class)this.typeToEditor.get(type);
        Class[] paramType = property.getEditorClassParamType();
        Object[] params = property.getEditorClassParams();
        PropertyEditor editor = this.loadPropertyEditorWithParam(editorClass, paramType, params);
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditorWithParam(Class clz, Class[] paramTypes, Object[] params) {
        PropertyEditor editor = null;
        if (ArrayUtils.isEmpty((Object[])paramTypes) || ArrayUtils.isEmpty((Object[])params)) {
            editor = this.loadPropertyEditor(clz);
        } else {
            try {
                Constructor constructor = clz.getConstructor(paramTypes);
                editor = (PropertyEditor)constructor.newInstance(params);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"error ", (Throwable)e);
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(Integer.TYPE, IntegerPropertyEditor.class);
        this.registerEditor(Boolean.TYPE, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(String.class, TextPropertyEditor.class);
        this.registerEditor(Enum.class, EnumPropertyEditor.class);
        this.registerEditor(AnchorCellEditor.class, AnchorCellEditor.class);
        this.registerEditor(ActionCellEditor.class, ActionCellEditor.class);
        this.registerEditor(ComboBoxPropertyEditor.class, ComboBoxPropertyEditor.class);
        this.registerEditor(DefaultValuePropertyEditor.class, DefaultValuePropertyEditor.class);
        this.registerEditor(IconCellEditor.class, IconCellEditor.class);
        this.registerEditor(DataBindProperty.class, PropertyBindEditor.class);
        this.registerEditor(EventCellEditor.class, EventCellEditor.class);
        this.registerEditor(BizRuleCellEditor.class, BizRuleCellEditor.class);
        this.registerEditor(FilterItemProperty.class, FilterItemsEditor.class);
    }
}

