/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.model.layout.KDLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.LabelContainerAlignmentEnum;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.editor.bind.DataBindUtils;
import com.kingdee.eas.ep.client.editor.bizrule.RuleManager;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditorType;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyDescriptorUI;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyEditorRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.AbstractItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ConstraintProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.DataBindProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.EnumProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.FilterItemProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.LabelContainerTextProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.LengthProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ListVisibleProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.NameProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ObjectProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ScaleProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.UITitleProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.AnchorCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.IconCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.LabelContainerAlignmentCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.BizRuleCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.ComboBoxPropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.DefaultValueHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.DefaultValuePropertyEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.EventCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.util.PropertyUtil;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.CommonQueryFilter;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.client.util.ListVisibleTool;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PropertyFactory {
    private final String basCategory = "\u57fa\u672c\u5c5e\u6027";
    private final String appearanceCategory = "\u5916\u89c2";
    private final String constraintCategory = "\u4f4d\u7f6e";
    private final String otherCategory = "\u5176\u4ed6";
    private IContext context;
    private static final Logger logger = CoreUIObject.getLogger(PropertyFactory.class);

    public PropertyFactory(IContext context) {
        this.context = context;
    }

    public ObjectProperty[] getProperty(AbstractItemInfoAdapter model) {
        ObjectProperty[] properties = this.createProperty(model);
        if (this.context.getStatus() == 1) {
            this.setEditAble(properties, false);
        }
        return properties;
    }

    private ObjectProperty[] createProperty(AbstractItemInfoAdapter model) {
        ArrayList list = new ArrayList();
        if (model != null) {
            try {
                AbstractBizConfigureItemInfo item = model.getItem();
                if (item != null && item.getComponent() != null) {
                    ComponentInfo component = model.getItem().getComponent();
                    if (component.getParent() == null && "com.kingdee.bos.ctrl.swing.KDPanel".equals(component.getClassType())) {
                        list.addAll(this.createProperties4Root(model));
                    } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType()) && item.getFromColumnIndex() != -1 && !this.context.isBase()) {
                        list.addAll(this.createProperties4KDTableColumn(model));
                    } else {
                        list.addAll(this.createBaseProperties(model));
                        list.addAll(this.createLengthProperties(model));
                        list.addAll(this.createAppearanceProperties(model));
                        list.addAll(this.createConstraintProperties(model));
                        list.addAll(this.createOtherProperties(model));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        ObjectProperty[] properties = new ObjectProperty[list.size()];
        list.toArray(properties);
        return properties;
    }

    private List createProperties4Root(AbstractItemInfoAdapter model) {
        ArrayList<UITitleProperty> properties = new ArrayList<UITitleProperty>();
        ObjectProperty property = this.createUITitleProperty("uititle_inf", "\u6807\u9898", "\u57fa\u672c\u5c5e\u6027", String.class, model, this.context.getUiModel().getTitle());
        properties.add((UITitleProperty)property);
        KDRectangle rectangle = ((BizConfigureItemInfoAdapter)model).getBounds();
        BizConfigureItemInfoAdapter owener = (BizConfigureItemInfoAdapter)model;
        property = this.createConstraintProperty("width_pro", "\u5bbd\u5ea6", owener, new Integer(rectangle.getWidth()));
        properties.add((UITitleProperty)property);
        property = this.createConstraintProperty("height_pro", "\u9ad8\u5ea6", owener, new Integer(rectangle.getHeight()));
        properties.add((UITitleProperty)property);
        property = this.createLayoutProperty(model);
        properties.add((UITitleProperty)property);
        return properties;
    }

    private List createProperties4KDTableColumn(AbstractItemInfoAdapter model) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        String title = "";
        HeaderInfo headInfo = null;
        int index = model.getItem().getFromColumnIndex();
        String formatXml = ((BizConfigureItemInfoAdapter)model).getFormatXml();
        TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom((String)formatXml);
        ArrayList list = (ArrayList)tableInfo.getColumns();
        ColumnInfo columnInfo = (ColumnInfo)list.get(index);
        BizConfigureItemInfo colItem = this.getColumnItem(model, columnInfo);
        List headers = tableInfo.getHeaders();
        if (headers.size() > 0) {
            headInfo = (HeaderInfo)headers.get(headers.size() - 1);
        }
        if (headInfo != null && index < headInfo.getCellCount() && headInfo.getCells().get(index) != null) {
            title = ((CellInfo)headInfo.getCells().get(index)).getName();
        }
        ObjectProperty property = this.createColumnProperty("colName", "\u5217\u540d", "\u57fa\u672c\u5c5e\u6027", String.class, model, colItem.getName());
        properties.add(property);
        property = this.createColumnProperty("colTitle", "\u6807\u9898", "\u57fa\u672c\u5c5e\u6027", String.class, model, title);
        properties.add(property);
        property = this.createColumnProperty("colVisible", "\u53ef\u89c1", "\u57fa\u672c\u5c5e\u6027", Boolean.TYPE, model, colItem.isVisible());
        properties.add(property);
        property = this.createColumnProperty("colFrozen", "\u5217\u51bb\u7ed3", "\u57fa\u672c\u5c5e\u6027", Boolean.TYPE, model, colItem.isFrozen());
        properties.add(property);
        if (DefaultValueHelper.supportDefaultValue(colItem)) {
            property = this.createColumnDefaultValueProperty(model, colItem);
            properties.add(property);
        }
        return properties;
    }

    private BizConfigureItemInfo getColumnItem(AbstractItemInfoAdapter model, ColumnInfo columnInfo) {
        BizConfigureItemCollection configureItemCol = null;
        if (this.context.getRootViewer() != null && this.context.getRootViewer().getNode() != null) {
            UictEditPartViewer viewer = (UictEditPartViewer)this.context.getRootViewer();
            int count = viewer.getNode().getChildCount();
            configureItemCol = EditUIEditorHelper.getConfigureItem(count, (BizConfigureTreeNode)viewer.getNode(), model.getName());
        }
        if (configureItemCol != null) {
            for (int i = 0; i < configureItemCol.size(); ++i) {
                BizConfigureItemInfo info = (BizConfigureItemInfo)configureItemCol.get(i);
                if (!info.getName().equals(columnInfo.getName())) continue;
                return info;
            }
        }
        return null;
    }

    private UITitleProperty createUITitleProperty(String name, String alias, String category, Class type, AbstractItemInfoAdapter owener, Object value) {
        UITitleProperty property = new UITitleProperty();
        property.setContext(this.context);
        property.setName(name);
        property.setDisplayName(alias);
        property.setCategory(category);
        property.setType(type);
        property.setOwner(owener);
        property.setValue(value, false);
        return property;
    }

    private List createBaseProperties(AbstractItemInfoAdapter model) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        ComponentInfo component = model.getItem().getComponent();
        ObjectProperty property = this.createNameProperty(model);
        if (property != null) {
            properties.add(property);
        }
        property = this.createProperty("Visible", "\u53ef\u89c1", "\u57fa\u672c\u5c5e\u6027", Boolean.TYPE, model);
        properties.add(property);
        if (EditorType.userLayout == this.context.getEditorType()) {
            property.setEditable(EditUIEditorHelper.isVisible(component));
        }
        if (!component.isContainer() && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType())) {
            property = this.createProperty("Enabled", "\u53ef\u7528 ", "\u57fa\u672c\u5c5e\u6027", Boolean.TYPE, model);
            properties.add(property);
            if (EditorType.userLayout == this.context.getEditorType()) {
                property.setEditable(EditUIEditorHelper.isEnabled(component));
            }
        }
        if (this.isNeedRequired(model.getItem())) {
            property = this.createProperty("Required", "\u5fc5\u5f55", "\u57fa\u672c\u5c5e\u6027", Boolean.TYPE, model);
            properties.add(property);
            if (EditorType.userLayout == this.context.getEditorType()) {
                property.setEditable(!EditUIEditorHelper.isRequired(component));
            }
        }
        if (this.context.isBase() && UIType.EDITUI.equals((Object)((Context)this.context).getUitype()) && (property = this.createListUIVisibleProperty((Context)this.context, model)) != null) {
            properties.add(property);
            if (this.context.isBase() && UIType.EDITUI.equals((Object)((Context)this.context).getUitype()) && (property = this.createCommonQueryFilterProperty((Context)this.context, model)) != null) {
                properties.add(property);
            }
        }
        return properties;
    }

    private ObjectProperty createNameProperty(AbstractItemInfoAdapter model) {
        NameProperty nameProperty = new NameProperty();
        nameProperty.setCategory("\u57fa\u672c\u5c5e\u6027");
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo component = item.getComponent();
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equals(component.getClassType()) && item.getProperty() != null) {
            nameProperty.setEditable(false);
        } else {
            nameProperty.setEditable(component.isConfigured() && this.context.isBase());
        }
        nameProperty.setOwner(model);
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        if (property != null) {
            nameProperty.setValue(property.getName(), false);
        } else {
            nameProperty.setValue(model.get("Name"), false);
        }
        nameProperty.setContext(this.context);
        return nameProperty;
    }

    private List createAppearanceProperties(AbstractItemInfoAdapter model) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo roundInfo = EditUIEditorHelper.getRoundedComponent(item.getComponent());
        if (this.isLabelContainer(roundInfo)) {
            properties.add(this.createTextProperty(model));
            properties.add(this.createProperty("label_underline", "\u663e\u793a\u6587\u5b57\u4e0b\u5212\u7ebf", "\u5916\u89c2", Boolean.TYPE, model));
            properties.add(this.createProperty("label_length", "\u663e\u793a\u6587\u5b57\u957f\u5ea6", "\u5916\u89c2", Integer.TYPE, model));
            properties.add(this.createAlingmenetProperty(model));
            PropertyEditorRegistry.getInstance().registerEditor(LabelContainerAlignmentCellEditor.class, LabelContainerAlignmentCellEditor.class);
        } else if (this.supportTargetText(roundInfo)) {
            properties.add(this.createProperty("Label", "\u663e\u793a\u6587\u5b57", "\u5916\u89c2", String.class, model));
        }
        if (this.isHorizontalAlignment(item.getComponent())) {
            properties.add(this.createHorizontalAlignmentProperty(model));
        }
        return properties;
    }

    private List createLengthProperties(AbstractItemInfoAdapter model) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo comp = item.getComponent();
        if (this.isCanSetFieldLengthComp(comp)) {
            properties.add(this.createLengthProperty(model));
        }
        if (comp != null && "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(comp.getClassType()) && BizDataTypeEnum.DECIMAL.getValue().equals(comp.getExtendedProperty("dataType"))) {
            properties.add(this.createScaleProperty(model));
        }
        if (this.isTextContainer(comp)) {
            properties.add(this.createMaxLengthProperty("maxLength", "\u53ef\u8f93\u5165\u7684\u6700\u5927\u957f\u5ea6", "\u57fa\u672c\u5c5e\u6027", Integer.TYPE, model));
        }
        return properties;
    }

    private List createConstraintProperties(AbstractItemInfoAdapter model) {
        ArrayList<ConstraintProperty> properties = new ArrayList<ConstraintProperty>();
        ComponentInfo component = model.getItem().getComponent();
        if (component != null && model instanceof BizConfigureItemInfoAdapter) {
            ComponentInfo roundInfo = EditUIEditorHelper.getRoundedComponent(component);
            if ((roundInfo = roundInfo.getParent()) != null) {
                LayoutInfo layoutInfo = roundInfo.getLayoutInfo();
                if (layoutInfo != null && ("XYLayout".equalsIgnoreCase(layoutInfo.getType()) || "KDLayout".equalsIgnoreCase(layoutInfo.getType()))) {
                    KDRectangle rectangle = ((BizConfigureItemInfoAdapter)model).getBounds();
                    if (rectangle == null) {
                        rectangle = new KDRectangle();
                    }
                    BizConfigureItemInfoAdapter owener = (BizConfigureItemInfoAdapter)model;
                    properties.add(this.createConstraintProperty("x_pro", "x\u5750\u6807", owener, new Integer(rectangle.getX())));
                    properties.add(this.createConstraintProperty("y_pro", "y\u5750\u6807", owener, new Integer(rectangle.getY())));
                    properties.add(this.createConstraintProperty("width_pro", "\u5bbd\u5ea6", owener, new Integer(rectangle.getWidth())));
                    properties.add(this.createConstraintProperty("height_pro", "\u9ad8\u5ea6", owener, new Integer(rectangle.getHeight())));
                    if ("KDLayout".equalsIgnoreCase(layoutInfo.getType())) {
                        ConstraintProperty property = new ConstraintProperty();
                        property.setContext(this.context);
                        property.setName("anchor_pro");
                        property.setDisplayName("\u951a\u5b9a");
                        property.setCategory("\u4f4d\u7f6e");
                        property.setType(AnchorCellEditor.class);
                        property.setOwner(model);
                        property.setValue(new Integer(rectangle.getAnchor()), false);
                        property.setEditorClassParamType(new Class[]{BizConfigureItemInfoAdapter.class});
                        property.setEditorClassParams(new Object[]{owener});
                        properties.add(property);
                    }
                }
                if (this.needLayoutProperty(model.getItem())) {
                    properties.add(this.createLayoutProperty(model));
                }
            }
        }
        return properties;
    }

    private List createOtherProperties(AbstractItemInfoAdapter model) {
        ArrayList<ObjectProperty> properties = new ArrayList<ObjectProperty>();
        if (model instanceof BizConfigureItemInfoAdapter) {
            ObjectProperty property;
            AbstractBizConfigureItemInfo item = model.getItem();
            ComponentInfo component = item.getComponent();
            if (component != null && component.isConfigured() && "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(component.getClassType()) && this.context.getEditorType() == EditorType.baseLayout) {
                property = new ObjectProperty();
                property.setContext(this.context);
                property.setName("formatString");
                property.setDisplayName("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32");
                property.setCategory("\u5176\u4ed6");
                property.setType(String.class);
                property.setOwner(model);
                property.setValue(component.getExtendedProperty("formatString"), false);
                properties.add(property);
            }
            if (this.isButton(item) && this.context.isBase()) {
                properties.add(this.createIconBindProperty(model));
            }
            if (!this.context.isBase() && DefaultValueHelper.supportDefaultValue((BizConfigureItemInfo)item)) {
                properties.add(this.createDefaultValueProperty(model));
            }
            if ((property = this.createEventProperty(model)) != null) {
                properties.add(property);
            }
            if (this.canBind(component) && (property = this.createDataBindProperty(model)) != null) {
                properties.add(property);
            }
            if (this.context.isBase() && "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(component.getClassType())) {
                String extendedProperty;
                property = this.createDisPlayFormatProperty((BizConfigureItemInfoAdapter)model);
                if (property != null) {
                    properties.add(property);
                }
                String dfF7UIName = (extendedProperty = component.getExtendedProperty("defaultf7uiname")) == null ? "" : extendedProperty.toString();
                property = this.createProperty("defaultf7uiname", "\u81ea\u5b9a\u4e49F7\u7c7b\u540d", "\u5176\u4ed6", String.class, model);
                property.setValue(dfF7UIName, false);
                properties.add(property);
                property = this.createFilterItemProperty(model);
                properties.add(property);
            }
        }
        return properties;
    }

    private boolean isButton(AbstractBizConfigureItemInfo item) {
        ComponentInfo roundInfo = EditUIEditorHelper.getRoundedComponent(item.getComponent());
        return "com.kingdee.bos.ctrl.swing.KDButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDWorkButton".equals(roundInfo.getClassType());
    }

    private boolean isNeedRequired(AbstractBizConfigureItemInfo item) {
        return !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDCheckBox".equals(item.getComponent().getClassType()) && !this.isButton(item) && !"com.kingdee.bos.ctrl.swing.KDRadioButton".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDLabel".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDPanel".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(item.getComponent().getClassType()) && !"com.kingdee.bos.ctrl.swing.KDContainer".equals(item.getComponent().getClassType()) && item.getProperty() != null;
    }

    private ListVisibleProperty createListUIVisibleProperty(Context context, AbstractItemInfoAdapter model) {
        PropertyBindingCollection bindings;
        BizUnitInfo bizUnit = context.getEditorUI().getModel();
        AbstractBizConfigureItemInfo item = model.getItem();
        ListVisibleTool tool = new ListVisibleTool(context, bizUnit, (BizConfigureItemInfo)item);
        ComponentInfo component = item.getComponent();
        if (this.canBind(component) && !(bindings = component.getPropertyBindings()).isEmpty() && tool.supportListVisible()) {
            ListVisibleProperty property = new ListVisibleProperty();
            property.setContext(context);
            property.setOwner(model);
            property.setCategory(this.basCategory);
            boolean listVisible = ((BizConfigureItemInfo)item).isListVisible();
            property.setValue(listVisible, false);
            return property;
        }
        return null;
    }

    private ObjectProperty createCommonQueryFilterProperty(Context context, AbstractItemInfoAdapter model) {
        BizUnitInfo bizUnit = context.getEditorUI().getModel();
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo component = item.getComponent();
        CommonQueryFilter queryFilter = new CommonQueryFilter(context, bizUnit, (BizConfigureItemInfo)item);
        if (this.canBind(component) && queryFilter.supportQueryFilter()) {
            ObjectProperty property = new ObjectProperty();
            property.setContext(context);
            property.setName("isCommonQueryFilter");
            property.setDisplayName("\u901a\u7528\u8fc7\u6ee4");
            property.setCategory("\u57fa\u672c\u5c5e\u6027");
            property.setType(Boolean.TYPE);
            property.setOwner(model);
            boolean filter = ((BizConfigureItemInfo)item).isCommonQueryFilter();
            property.setValue(filter, false);
            return property;
        }
        return null;
    }

    private ObjectProperty createEventProperty(AbstractItemInfoAdapter model) {
        AbstractBizConfigureItemInfo item = model.getItem();
        EditorType type = this.context.getEditorType();
        if (type != EditorType.userLayout && UIType.EDITUI.equals((Object)((Context)this.context).getUitype()) && item instanceof BizConfigureItemInfo && ((BizConfigureItemInfo)item).getProperty() != null && item.getComponent() != null && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(item.getComponent().getClassType())) {
            ObjectProperty property = new ObjectProperty();
            property.setName("event_pro");
            property.setContext(this.context);
            property.setCategory("\u5176\u4ed6");
            property.setOwner(model);
            if (type == EditorType.baseLayout) {
                property.setDisplayName("\u503c\u66f4\u65b0\u4e8b\u4ef6");
                property.setType(BizRuleCellEditor.class);
                property.setEditorClassParamType(new Class[]{BizConfigureItemInfoAdapter.class, Context.class});
                property.setEditorClassParams(new Object[]{model, this.context});
                property.setValue((Object)RuleManager.getRuleCollection(this.context, (BizConfigureItemInfo)item));
            } else {
                property.setDisplayName("\u4e8b\u4ef6");
                property.setType(EventCellEditor.class);
                property.setEditorClassParamType(new Class[]{BizConfigureItemInfoAdapter.class, Context.class});
                property.setEditorClassParams(new Object[]{model, this.context});
                property.setValue((Object)item.getConfigureEventCollection(), false);
            }
            return property;
        }
        return null;
    }

    private boolean canBind(ComponentInfo comp) {
        UIType uiType;
        return EditUIEditorHelper.canBind(comp) && !"com.kingdee.bos.ctrl.kdf.table.KDTable".equals(comp.getClassType()) && !"com.kingdee.eas.ep.client.KDPictureBox".equals(comp.getClassType()) && UIType.EDITUI.equals((Object)(uiType = ((Context)this.context).getEditorUI().getUiType()));
    }

    private ObjectProperty createDataBindProperty(AbstractItemInfoAdapter model) {
        ComponentInfo component = model.getItem().getComponent();
        DataBindProperty property = new DataBindProperty();
        property.setContext(this.context);
        this.context.put("component", component);
        property.setCategory("\u5176\u4ed6");
        property.setType(DataBindProperty.class);
        property.setOwner(model);
        property.setEditable(this.context.isBase() && component.isConfigured());
        property.setEditorClassParamType(new Class[]{IContext.class});
        property.setEditorClassParams(new Object[]{this.context});
        property.setValue(DataBindUtils.getPropertyBindInfo(component), false);
        return property;
    }

    private ObjectProperty createFilterItemProperty(AbstractItemInfoAdapter model) {
        ComponentInfo component = model.getItem().getComponent();
        FilterItemProperty property = new FilterItemProperty();
        property.setContext(this.context);
        property.setCategory("\u5176\u4ed6");
        property.setType(FilterItemProperty.class);
        property.setOwner(model);
        property.setEditable(this.context.isBase());
        property.setEditorClassParamType(new Class[]{IContext.class});
        property.setEditorClassParams(new Object[]{this.context});
        String value = component.getExtendedProperty("f7FilterItem");
        property.setValue(value, false);
        return property;
    }

    private ObjectProperty createIconBindProperty(AbstractItemInfoAdapter model) {
        PropertyInfo perInfo = model.getItem().getComponent().getPropertyByName("icon");
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName("btn_icon");
        property.setDisplayName("\u56fe\u6807\u8bbe\u7f6e");
        property.setCategory("\u5176\u4ed6");
        property.setType(IconCellEditor.class);
        property.setOwner(model);
        property.setEditorClassParamType(new Class[]{BizConfigureItemInfoAdapter.class});
        property.setEditorClassParams(new Object[]{(BizConfigureItemInfoAdapter)model});
        if (perInfo != null) {
            property.setValue(perInfo.getValue(), false);
        } else {
            property.setValue(null, false);
        }
        return property;
    }

    private ObjectProperty createDefaultValueProperty(AbstractItemInfoAdapter model) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName("DefaultValue");
        property.setDisplayName("\u9ed8\u8ba4\u503c");
        property.setCategory("\u5176\u4ed6");
        property.setType(DefaultValuePropertyEditor.class);
        property.setOwner(model);
        property.setEditorClassParamType(new Class[]{IContext.class, BizConfigureItemInfo.class});
        property.setEditorClassParams(new Object[]{this.context, (BizConfigureItemInfo)model.getItem()});
        property.setValue(model.getItem().getDefaultValue(), false);
        return property;
    }

    private ConstraintProperty createConstraintProperty(String name, String alias, BizConfigureItemInfoAdapter model, Object value) {
        ConstraintProperty property = new ConstraintProperty();
        property.setContext(this.context);
        property.setName(name);
        property.setDisplayName(alias);
        property.setCategory("\u4f4d\u7f6e");
        property.setType(Integer.TYPE);
        property.setOwner(model);
        property.setValue(value, false);
        return property;
    }

    private ObjectProperty createDisPlayFormatProperty(BizConfigureItemInfoAdapter model) {
        BizConfigureItemInfo item = (BizConfigureItemInfo)model.getItem();
        EntityObjectInfo entity = item.getDataSource();
        ObjectProperty property = null;
        if (entity != null) {
            property = new ObjectProperty();
            property.setContext(this.context);
            property.setName("displayformat");
            property.setDisplayName("\u663e\u793a\u540d\u79f0 ");
            property.setCategory(this.otherCategory);
            property.setType(ComboBoxPropertyEditor.class);
            property.setOwner(model);
            property.setEditorClassParamType(new Class[]{Object[].class});
            List items = PropertyDescriptorUI.createDisPlayFormatItems(entity);
            property.setEditorClassParams(new Object[]{items.toArray()});
            ComboBoxItem combItem = this.getItemByName(items, PropertyDescriptorUI.getFormatName(item.getComponent()));
            property.setValue(combItem, false);
        }
        return property;
    }

    private ComboBoxItem getItemByName(List items, String name) {
        if (name == null) {
            name = "number";
        }
        for (int i = 0; i < items.size(); ++i) {
            ComboBoxItem item = (ComboBoxItem)items.get(i);
            if (item.getValue() == null || !item.getValue().toString().equals(name)) continue;
            return item;
        }
        return null;
    }

    private ComboBoxItem getItemByValue(List items, int value) {
        for (int i = 0; i < items.size(); ++i) {
            Integer intValue;
            ComboBoxItem item = (ComboBoxItem)items.get(i);
            if (item.getValue() == null || (intValue = (Integer)item.getValue()) != value) continue;
            return item;
        }
        return null;
    }

    private boolean needLayoutProperty(AbstractBizConfigureItemInfo item) {
        ComponentInfo component = item.getComponent();
        return component != null && ("com.kingdee.bos.ctrl.swing.KDPanel".equals(component.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(component.getClassType()));
    }

    private ConstraintProperty createLayoutProperty(AbstractItemInfoAdapter model) {
        AbstractBizConfigureItemInfo item = model.getItem();
        Layout layout = LayoutConverter.convertToLayoutObj((LayoutInfo)item.getComponent().getLayoutInfo());
        String layoutValue = "XYLayout";
        if (layout instanceof KDLayout) {
            layoutValue = "KDLayout";
        }
        String[] items = new String[]{"XYLayout", "KDLayout"};
        ConstraintProperty property = new ConstraintProperty();
        property.setContext(this.context);
        property.setName("layout_inf");
        property.setDisplayName("\u5e03\u5c40");
        property.setOwner(model);
        property.setCategory(this.constraintCategory);
        property.setType(ComboBoxPropertyEditor.class);
        property.setEditorClassParamType(new Class[]{String[].class});
        property.setEditorClassParams(new Object[]{items});
        property.setEditable(item.getComponent().isConfigured());
        property.setValue(layoutValue, false);
        return property;
    }

    private boolean isLabelContainer(ComponentInfo component) {
        return component != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(component.getClassType());
    }

    private boolean supportTargetText(ComponentInfo component) {
        String classType;
        return component != null && ("com.kingdee.bos.ctrl.swing.KDLabel".equals(classType = component.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(classType) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(classType) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(classType) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(classType));
    }

    private boolean isHorizontalAlignment(ComponentInfo component) {
        Method method = null;
        try {
            String classType = component.getClassType();
            if (classType != null && !classType.equals("")) {
                Component control = (Component)Class.forName(classType).newInstance();
                method = control.getClass().getMethod("setHorizontalAlignment", Integer.TYPE);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return method != null;
    }

    private ObjectProperty createProperty(String name, String alias, String category, Class type, AbstractItemInfoAdapter owener) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName(name);
        property.setDisplayName(alias);
        property.setCategory(category);
        property.setType(type);
        property.setOwner(owener);
        property.setValue(owener.get(name), false);
        return property;
    }

    private ObjectProperty createColumnProperty(String name, String alias, String category, Class type, AbstractItemInfoAdapter owener, Object value) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName(name);
        property.setDisplayName(alias);
        property.setCategory(category);
        property.setType(type);
        property.setOwner(owener);
        if ("colName".equals(name) || "colTitle".equals(name)) {
            property.setEditable(false);
        }
        property.setValue(value, false);
        return property;
    }

    private ObjectProperty createColumnDefaultValueProperty(AbstractItemInfoAdapter model, BizConfigureItemInfo item) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName("colDefault");
        property.setDisplayName("\u9ed8\u8ba4\u503c");
        property.setCategory("\u5176\u4ed6");
        property.setType(DefaultValuePropertyEditor.class);
        property.setOwner(model);
        property.setEditorClassParamType(new Class[]{IContext.class, BizConfigureItemInfo.class});
        property.setEditorClassParams(new Object[]{this.context, item});
        property.setValue(item.getDefaultValue(), false);
        return property;
    }

    private LabelContainerTextProperty createTextProperty(AbstractItemInfoAdapter model) {
        LabelContainerTextProperty property = new LabelContainerTextProperty();
        property.setContext(this.context);
        property.setCategory("\u5916\u89c2");
        property.setType(String.class);
        property.setOwner(model);
        property.setValue(model.get(property.getName()), false);
        return property;
    }

    private ObjectProperty createAlingmenetProperty(AbstractItemInfoAdapter model) {
        EnumProperty property = new EnumProperty();
        property.setContext(this.context);
        property.setName("label_alignment");
        property.setDisplayName("\u663e\u793a\u6587\u5b57\u65b9\u5411");
        property.setCategory("\u5916\u89c2");
        property.setType(Enum.class);
        property.setOwner(model);
        property.setEditorClassParamType(new Class[]{Class.class});
        property.setEditorClassParams(new Object[]{LabelContainerAlignmentEnum.class});
        Integer align = (Integer)model.get("label_alignment");
        IntEnum intEnum = EnumUtils.getEnum(LabelContainerAlignmentEnum.class, (int)(align == null ? 7 : align));
        property.setValue(intEnum, false);
        return property;
    }

    private ObjectProperty createHorizontalAlignmentProperty(AbstractItemInfoAdapter model) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName("horizontalAlignment");
        property.setDisplayName("\u6c34\u5e73\u5bf9\u9f50\u65b9\u5f0f");
        property.setCategory("\u5916\u89c2");
        property.setType(ComboBoxPropertyEditor.class);
        property.setOwner(model);
        ArrayList<ComboBoxItem> items = new ArrayList<ComboBoxItem>();
        items.add(new ComboBoxItem(new Integer(2), "\u5de6\u5bf9\u9f50"));
        items.add(new ComboBoxItem(new Integer(0), "\u5c45\u4e2d"));
        items.add(new ComboBoxItem(new Integer(4), "\u53f3\u5bf9\u9f50"));
        property.setEditorClassParamType(new Class[]{Object[].class});
        property.setEditorClassParams(new Object[]{items.toArray()});
        Integer align = (Integer)model.get("horizontalAlignment");
        ComboBoxItem combItem = this.getItemByValue(items, align == null ? 2 : align);
        property.setValue(combItem, false);
        return property;
    }

    private void setEditAble(ObjectProperty[] properties, boolean editable) {
        for (int i = 0; i < properties.length; ++i) {
            ObjectProperty property = properties[i];
            property.setEditable(editable);
        }
    }

    private boolean isTextContainer(ComponentInfo component) {
        return component != null && ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()));
    }

    private boolean isCanSetFieldLengthComp(ComponentInfo component) {
        return component != null && ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(component.getClassType()) || "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(component.getClassType()) && BizDataTypeEnum.DECIMAL.getValue().equals(component.getExtendedProperty("dataType")));
    }

    private ObjectProperty createMaxLengthProperty(String name, String alias, String category, Class type, AbstractItemInfoAdapter owener) {
        ObjectProperty property = new ObjectProperty();
        property.setContext(this.context);
        property.setName(name);
        property.setDisplayName(alias);
        property.setCategory(category);
        property.setType(type);
        property.setOwner(owener);
        AbstractBizConfigureItemInfo item = owener.getItem();
        ComponentInfo component = item.getComponent();
        com.kingdee.bos.metadata.entity.PropertyInfo prop = item.getProperty();
        int maxLength = EditUIEditorHelper.getMaxLength(component);
        if (maxLength == -1) {
            property.setValue(owener.get(name), false);
        } else {
            property.setValue(maxLength, false);
        }
        if (prop != null) {
            property.setEditorClassParamType(new Class[]{OwnPropertyInfo.class, Boolean.class, String.class});
            property.setEditorClassParams(new Object[]{(OwnPropertyInfo)prop, false, "maxLength"});
        }
        return property;
    }

    private ObjectProperty createLengthProperty(AbstractItemInfoAdapter model) {
        LengthProperty lengthProperty = new LengthProperty();
        lengthProperty.setCategory("\u57fa\u672c\u5c5e\u6027");
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo component = item.getComponent();
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        lengthProperty.setEditable(component.isConfigured() && this.context.isBase() && this.existsInTable(property));
        lengthProperty.setOwner(model);
        if (property != null) {
            lengthProperty.setValue(((OwnPropertyInfo)property).getLength(), false);
        } else {
            lengthProperty.setValue(model.get("Length"), false);
        }
        if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(component.getClassType())) {
            lengthProperty.setEditorClassParamType(new Class[]{Integer.class, Boolean.class});
            lengthProperty.setEditorClassParams(new Object[]{28, false});
        } else {
            lengthProperty.setEditorClassParamType(new Class[]{Boolean.class});
            lengthProperty.setEditorClassParams(new Object[]{false});
        }
        lengthProperty.setContext(this.context);
        return lengthProperty;
    }

    private ObjectProperty createScaleProperty(AbstractItemInfoAdapter model) {
        ScaleProperty scaleProperty = new ScaleProperty();
        scaleProperty.setCategory("\u57fa\u672c\u5c5e\u6027");
        AbstractBizConfigureItemInfo item = model.getItem();
        ComponentInfo component = item.getComponent();
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        scaleProperty.setEditable(component.isConfigured() && this.context.isBase() && this.existsInTable(property));
        scaleProperty.setOwner(model);
        if (property != null) {
            scaleProperty.setValue(((OwnPropertyInfo)property).getDecimalDigits(), false);
            scaleProperty.setEditorClassParamType(new Class[]{OwnPropertyInfo.class, Boolean.class, String.class});
            scaleProperty.setEditorClassParams(new Object[]{(OwnPropertyInfo)property, false, "Scale"});
        } else {
            scaleProperty.setValue(model.get("Scale"), false);
            scaleProperty.setEditorClassParamType(new Class[]{Integer.class, Boolean.class});
            scaleProperty.setEditorClassParams(new Object[]{10, false});
        }
        scaleProperty.setContext(this.context);
        return scaleProperty;
    }

    private boolean existsInTable(com.kingdee.bos.metadata.entity.PropertyInfo property) {
        try {
            IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
            com.kingdee.bos.metadata.data.ColumnInfo mappingField = property.getMappingField();
            DataTableInfo tableInfo = PropertyUtil.getTableInfo((Context)this.context);
            if (tableInfo != null && mappingField != null && !instance.exists(tableInfo.getName(), mappingField.getName())) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }
}

