/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.ext.pe.beans.renderer.PrimitiveBooleanCellRenderer;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyRendererFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.DataBindProperty;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.ExtendedPropertyDescriptor;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.Property;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.PropertyDescriptorAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.BizRuleCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.editor.EventCellEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render.DataBindRender;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render.DateRenderer;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render.DefaultCellRenderer;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render.EventCellRender;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.render.StringCellRenderer;
import com.kingdee.util.enums.Enum;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class PropertyRendererRegistry
implements PropertyRendererFactory {
    private Map typeToRenderer = new HashMap();
    private Map propertyToRenderer = new HashMap();
    private static final Logger logger = Logger.getLogger(PropertyRendererRegistry.class);

    public PropertyRendererRegistry() {
        this.registerDefaults();
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property property) {
        return this.getRenderer(property);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Class type) {
        return this.getRenderer(type);
    }

    public synchronized TableCellRenderer getRenderer(Property property) {
        Object value;
        PropertyDescriptor descriptor;
        TableCellRenderer renderer = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) instanceof ExtendedPropertyDescriptor && ((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass() != null) {
            try {
                return (TableCellRenderer)((ExtendedPropertyDescriptor)descriptor).getPropertyTableRendererClass().newInstance();
            }
            catch (Exception ex) {
                logger.error((Object)"PropertyRendererRegistry.getRenderer(Property property)", (Throwable)ex);
            }
        }
        if ((value = this.propertyToRenderer.get(property)) instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"PropertyRendererRegistry.getRenderer(Property property)", (Throwable)e);
            }
        } else {
            renderer = this.getRenderer(property.getType());
        }
        return renderer;
    }

    public synchronized TableCellRenderer getRenderer(Class type) {
        TableCellRenderer renderer = null;
        Object value = this.typeToRenderer.get(type);
        if (value instanceof TableCellRenderer) {
            renderer = (TableCellRenderer)value;
        } else if (value instanceof Class) {
            try {
                renderer = (TableCellRenderer)((Class)value).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"PropertyRendererRegistry.getRenderer(Class type)", (Throwable)e);
            }
        }
        if (renderer == null) {
            renderer = new DefaultCellRenderer();
        }
        return renderer;
    }

    public synchronized void registerRenderer(Class type, Class rendererClass) {
        this.typeToRenderer.put(type, rendererClass);
    }

    public synchronized void registerRenderer(Class type, TableCellRenderer renderer) {
        this.typeToRenderer.put(type, renderer);
    }

    public synchronized void unregisterRenderer(Class type) {
        this.typeToRenderer.remove(type);
    }

    public synchronized void registerRenderer(Property property, Class rendererClass) {
        this.propertyToRenderer.put(property, rendererClass);
    }

    public synchronized void registerRenderer(Property property, TableCellRenderer renderer) {
        this.propertyToRenderer.put(property, renderer);
    }

    public synchronized void unregisterRenderer(Property property) {
        this.propertyToRenderer.remove(property);
    }

    public void registerDefaults() {
        this.typeToRenderer.clear();
        this.propertyToRenderer.clear();
        DefaultCellRenderer renderer = new DefaultCellRenderer();
        renderer.setShowOddAndEvenRows(false);
        DateRenderer dateRenderer = new DateRenderer();
        dateRenderer.setShowOddAndEvenRows(false);
        this.registerRenderer(Integer.TYPE, (TableCellRenderer)renderer);
        this.registerRenderer(Boolean.TYPE, (TableCellRenderer)new PrimitiveBooleanCellRenderer());
        this.registerRenderer(String.class, (TableCellRenderer)new StringCellRenderer());
        this.registerRenderer(Enum.class, (TableCellRenderer)new DefaultCellRenderer());
        this.registerRenderer(DataBindProperty.class, (TableCellRenderer)new DataBindRender());
        this.registerRenderer(EventCellEditor.class, (TableCellRenderer)new EventCellRender());
        this.registerRenderer(BizRuleCellEditor.class, (TableCellRenderer)new EventCellRender());
    }
}

