/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPolicy;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.UIConstraintCommand;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;
import com.kingdee.eas.ep.client.figure.FigureHelper;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;

public class RootEditPart
extends AbstractEditPart {
    private BufferedImage figure;
    private KDPanel component;
    private boolean isSelected = false;
    private boolean isMultiSelected = false;
    private BasicStroke _3fbs = new BasicStroke(3.0f);

    public RootEditPart(BizConfigureItemInfoAdapter model) {
        this.setModel(model);
        this.component = this.createComponent();
    }

    private KDPanel createComponent() {
        KDPanel component = new KDPanel();
        KDRectangle rect = this.getBounds();
        if (rect != null && rect.getRectangle() != null) {
            component.setBounds(0, 0, rect.getWidth(), rect.getHeight());
        }
        return component;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public BufferedImage getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    private BufferedImage createFigure() {
        KDRectangle bounds = this.getBounds();
        if (bounds != null) {
            Dimension size = bounds.getRectangle().getSize();
            size.width += 4;
            size.height += 4;
            return FigureHelper.drawAlphaImage(size, 0.0f, Color.white, false);
        }
        return null;
    }

    public KDRectangle getBounds() {
        BizConfigureItemInfo item = (BizConfigureItemInfo)((BizConfigureItemInfoAdapter)this.getModel()).getItem();
        return item.getBounds();
    }

    @Override
    public void performRequest(Request request) {
        Object type = request.getType();
        if ("selected".equals(type)) {
            if (!this.isSelected) {
                this.isSelected = true;
                this.isMultiSelected = false;
                this.refreshVisuals();
            }
        } else if ("multiselected".equals(type)) {
            if (!this.isMultiSelected) {
                this.isSelected = false;
                this.isMultiSelected = true;
                this.refreshVisuals();
            }
        } else if ("unselected".equals(type) && (this.isSelected || this.isMultiSelected)) {
            this.isSelected = false;
            this.isMultiSelected = false;
            this.refreshVisuals();
        }
    }

    @Override
    public void activate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).addPropertyChangeListener(this);
    }

    @Override
    public void deactivate() {
        ((BizConfigureItemInfoAdapter)this.getModel()).removePropertyChangeListener(this);
    }

    @Override
    protected void refreshVisuals() {
        Graphics g;
        this.figure = this.createFigure();
        if (this.figure == null) {
            return;
        }
        if (this.isSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(2, 2, this.figure.getWidth() - 3, this.figure.getHeight() - 3);
            FigureHelper.drawPoint(g, new Rectangle(0, 0, this.figure.getWidth(), this.figure.getHeight()), 15, Color.black);
        }
        if (this.isMultiSelected) {
            g = this.figure.getGraphics();
            g.setColor(Color.orange);
            ((Graphics2D)g).setStroke(this._3fbs);
            g.drawRect(0, 0, this.figure.getWidth() - 1, this.figure.getHeight() - 1);
        }
        if (this.viewer != null) {
            ((UictEditPartViewer)this.viewer).repaint();
            ((UictEditPartViewer)this.viewer).revalidate();
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ResizePolicy", new RootResizePolicy());
    }

    @Override
    public void setViewer(EditPartViewer viewer) {
        super.setViewer(viewer);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        BizConfigureItemInfoAdapter adpter;
        KDRectangle bounds;
        String name;
        if (evt != null && "rectangle".equals(name = evt.getPropertyName()) && (bounds = (adpter = (BizConfigureItemInfoAdapter)this.getModel()).getBounds()) != null) {
            if (this.component != null && !bounds.getRectangle().equals(this.component.getBounds())) {
                this.component.setBounds(0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (this.figure == null || this.figure.getWidth() != bounds.getWidth() || this.figure.getHeight() != bounds.getHeight()) {
                this.refreshVisuals();
            }
        }
        if (this.viewer != null) {
            ((UictEditPartViewer)this.viewer).repaint();
            Context context = (Context)this.viewer.getContext();
            IUIEditor editor = context.getEditorUI();
            if (editor instanceof EditUIEditor) {
                ((EditUIEditor)editor).editPartSelectionChanged(new SelectionChangedEvent(this, this));
            }
        }
    }

    class RootResizePolicy
    implements EditPolicy {
        private EditPart editpart;

        RootResizePolicy() {
        }

        @Override
        public boolean understandsRequest(Request request) {
            return request != null && "resize".equals(request.getType());
        }

        @Override
        public Command getCommand(Request request) {
            if (request != null && "resize".equals(request.getType())) {
                ResizeRequest resizeRequest = (ResizeRequest)request;
                EditPart source = resizeRequest.getSourceEditPart();
                BizConfigureItemInfoAdapter model = (BizConfigureItemInfoAdapter)source.getModel();
                Rectangle oldSize = RootEditPart.this.component.getBounds();
                int coordinate = resizeRequest.getCoordinate();
                UIConstraintCommand command = null;
                switch (resizeRequest.getBorder()) {
                    case 9: {
                        int height = coordinate - oldSize.y;
                        command = new UIConstraintCommand("height_pro", (UictEditPartViewer)RootEditPart.this.viewer, new Integer(height));
                        command.setTarget(model);
                        break;
                    }
                    case 11: {
                        int width = coordinate - oldSize.x;
                        command = new UIConstraintCommand("width_pro", (UictEditPartViewer)RootEditPart.this.viewer, new Integer(width));
                        command.setTarget(model);
                    }
                }
                return command;
            }
            return null;
        }

        @Override
        public EditPart getHost() {
            return this.editpart;
        }

        @Override
        public EditPart getTargetEditPart(Request request) {
            return null;
        }

        @Override
        public void setHost(EditPart editpart) {
            this.editpart = editpart;
        }
    }
}

