/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.RootEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.RootEditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class RootEditPartViewer
extends UictEditPartViewer {
    private RootEditPart rootEditPart;

    public RootEditPartViewer(BizConfigureTreeNode node, Context context) {
        super(node, context);
    }

    @Override
    public void createEditPart() {
        super.createEditPart();
        this.rootEditPart = this.createRootEditPart();
        ((RootEditPartManager)this.partManager).setRootEditPart(this.rootEditPart);
    }

    private RootEditPart createRootEditPart() {
        BizConfigureItemInfo rootItem = this.node.getItem();
        BizConfigureItemInfoAdapter rootAdapter = new BizConfigureItemInfoAdapter(rootItem);
        RootEditPart part = new RootEditPart(rootAdapter);
        part.addNotify();
        part.activate();
        part.setViewer(this);
        return part;
    }

    @Override
    protected void paintMaskPanelTopLevel(Graphics g) {
        super.paintMaskPanelTopLevel(g);
        if (this.rootEditPart != this.partManager.getSelection()) {
            BizConfigureItemInfo item = this.node.getItem();
            KDRectangle bounds = item.getBounds();
            g.setColor(Color.gray);
            g.drawRect(1, 1, bounds.getWidth() - 1, bounds.getHeight() - 1);
        }
    }

    @Override
    protected void paintSelectedComponent(Graphics g) {
        super.paintSelectedComponent(g);
        BufferedImage figure = this.rootEditPart.getFigure();
        Component comp = this.rootEditPart.getComponent();
        if (figure != null && comp != null) {
            g.drawImage(figure, comp.getX() - 2, comp.getY() - 2, figure.getWidth(), figure.getHeight(), this);
        }
    }

    @Override
    public EditPartManager createPartManager() {
        return new RootEditPartManager();
    }

    @Override
    public void setAllEditPartUnSelected() {
        super.setAllEditPartUnSelected();
        this.rootEditPart.performRequest(this.unSelectedRequest);
    }

    @Override
    public void setAllEditPartMoveOut() {
        super.setAllEditPartMoveOut();
        this.rootEditPart.performRequest(this.moveOutRequest);
    }
}

