/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.client.EntriesManagerUI;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.CreateComponetConfigUI;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.FormatOperate;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.KeyEventHandler;
import com.kingdee.eas.ep.client.editor.editui.designer.Operate;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyDescriptorUI;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.Target;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ActionRegistry;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.EditKDTableAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.EditKDTableAction2;
import com.kingdee.eas.ep.client.editor.editui.designer.action.EditTabPaneAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.FormatPainterAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.MoveAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.NewDataBindAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ZOrderBottomAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.ZOrderTopAction;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CreateCommand;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.ISelectionChangedListener;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.DirectEditRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ShowDynBorderRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.EPBorderLayout;
import com.kingdee.eas.ep.client.editor.editui.designer.util.UictEditorHelper;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UictEditPartViewer
extends AbstractEditPartViewer {
    public JMenuItem showDynBorder;
    private ComponentNameManager nameManager = null;

    public UictEditPartViewer(BizConfigureTreeNode node, Context context) {
        super(context);
        this.node = node;
        this.setName(node.getName());
        ComponentInfo comp = (ComponentInfo)node.getUserObject();
        LayoutInfo layoutInfo = comp.getLayoutInfo();
        if (layoutInfo != null && "BorderLayout".equalsIgnoreCase(layoutInfo.getType())) {
            this.setLayout(new EPBorderLayout());
        } else {
            this.setLayout(null);
            this.add((Component)this.maskPanel);
        }
        this.maskPanel.setLayout(null);
        this.commandStack = context.getCommandStack();
        this.factory = new UictEditPartFactory(node, context);
        this.partManager = this.createPartManager();
        this.regestListeners();
        this.createEditPart();
        this.initPopupmenu();
        this.createActions();
    }

    public UictEditPartViewer() {
    }

    protected void initPopupmenu() {
        this.popMenu = new KDPopupMenu();
        this.showContainerPop = new JCheckBoxMenuItem("\u663e\u793a\u5bb9\u5668\u63d0\u793a");
        this.showContainerPop.setSelected(this.context.isShowContainer());
        this.showContainerPop.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ((Context)UictEditPartViewer.this.getContext()).setShowContainer(UictEditPartViewer.this.showContainerPop.isSelected());
            }
        });
        this.popMenu.add((JMenuItem)this.showContainerPop);
        this.showDynBorder = new JCheckBoxMenuItem("\u9ad8\u4eae\u663e\u793a\u52a8\u6001\u63a7\u4ef6");
        this.showDynBorder.setSelected(this.context.isShowDynBorder());
        this.showDynBorder.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                boolean isShowDynBorder = UictEditPartViewer.this.showDynBorder.isSelected();
                ((Context)UictEditPartViewer.this.getContext()).setShowDynBorder(isShowDynBorder);
            }
        });
        this.popMenu.add(this.showDynBorder);
        this.popMenu.addSeparator();
    }

    private void drawDynBorder(boolean isShowDynBorder) {
        Iterator iter = this.partManager.iterator();
        while (iter.hasNext()) {
            EditPart part = (EditPart)iter.next();
            part.performRequest(new ShowDynBorderRequest(part, isShowDynBorder));
        }
    }

    public Map getItemAdapterMap() {
        return this.itemAdapterMap;
    }

    @Override
    public ComponentTreeNode getNode() {
        return (BizConfigureTreeNode)this.node;
    }

    @Override
    public IContext getContext() {
        return (Context)this.context;
    }

    public JPanel getComponentPanel() {
        return this;
    }

    public EditPartManager createPartManager() {
        return new EditPartManager();
    }

    protected void showCreateConfigUI(int x, int y) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("X", new Integer(x));
        uiContext.put("Y", new Integer(y));
        uiContext.put("Editor", ((Context)this.context).getEditorUI());
        uiContext.put("nameManager", this.nameManager);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CreateComponetConfigUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            logger.error((Object)e1);
        }
    }

    private void regestListeners() {
        this.context.addPropertyChangeListener(this);
        this.keyEventHandler = new KeyEventHandler(this);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                UictEditPartViewer.this.context.getEditorUI().editPartSelectionChanged(event);
            }
        };
        this.addSelectionChangedListener(listener);
    }

    @Override
    public void createEditPart() {
        if (this.factory == null) {
            logger.info((Object)"factory is null...");
            throw new NullPointerException("factory is null...");
        }
        Iterator iter = this.node.getConfigureItems().iterator();
        while (iter.hasNext()) {
            EditPart part;
            BizConfigureItemInfoAdapter item = new BizConfigureItemInfoAdapter((BizConfigureItemInfo)iter.next());
            if (UictEditorHelper.contains(this.partManager, (BizConfigureItemInfo)item.getItem()) || (part = this.factory.createEditPart(item)) == null) continue;
            part.setViewer(this);
            this.partManager.add(part);
            this.addRows2KDTable(part);
            this.itemAdapterMap.put(item.getItem(), item);
        }
        UictEditorHelper.retainAll(this.partManager, this.itemAdapterMap, (BizConfigureItemCollection)this.node.getConfigureItems(), this);
        this.drawDynBorder(this.context.isShowDynBorder());
        this.revalidate();
        this.repaint();
    }

    private void addRows2KDTable(EditPart tablePart) {
        Component component2 = tablePart.getComponent();
        if (component2 instanceof KDTable) {
            ((KDTable)component2).addRows(5);
        }
    }

    @Override
    protected void resetPreferredSize() {
        Dimension partSize = this.getPartSize();
        Dimension designSize = this.getDesignSize();
        int width = Math.max(partSize.width, designSize.width);
        int height = Math.max(partSize.height, designSize.height);
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
    }

    private Dimension getPartSize() {
        int maxHeight = 0;
        int maxWidth = 0;
        Iterator iter = this.partManager.iterator();
        while (iter.hasNext()) {
            EditPart part = (EditPart)iter.next();
            Component comp = part.getComponent();
            if (comp == null) continue;
            int conY = comp.getY() + comp.getHeight() + 50;
            int conX = comp.getX() + comp.getWidth() + 50;
            maxHeight = maxHeight < conY ? conY : maxHeight;
            maxWidth = maxWidth < conX ? conX : maxWidth;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private Dimension getDesignSize() {
        UictEditPartViewer view = (UictEditPartViewer)this.context.getRootViewer();
        BizConfigureTreeNode node = (BizConfigureTreeNode)view.getNode();
        KDRectangle rec = (KDRectangle)node.getItem().get("bounds");
        return new Dimension(rec.getWidth() + 50, rec.getHeight() + 50);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        BaseAction action = new EditKDTableAction(this);
        registry.registerAction(action);
        this.editKDTablePop = this.popMenu.add((Action)action);
        this.editKDTablePop.setText("\u7f16\u8f91\u8868\u4fe1\u606f");
        action.addRelateComponent(this.editKDTablePop);
        action = new EditTabPaneAction(this);
        registry.registerAction(action);
        this.editTabPanePop = this.popMenu.add((Action)action);
        this.editTabPanePop.setText("\u7f16\u8f91\u9875\u7b7e");
        action.addRelateComponent(this.editTabPanePop);
        action = new NewDataBindAction(this);
        registry.registerAction(action);
        this.newDataBindPop = this.popMenu.add((Action)action);
        this.newDataBindPop.setText("\u6570\u636e\u7ed1\u5b9a");
        action.addRelateComponent(this.newDataBindPop);
        action = new EditKDTableAction2(this);
        registry.registerAction(action);
        this.tablePop = this.popMenu.add((Action)action);
        this.tablePop.setText("\u8868\u683c\u7f16\u8f91");
        action.addRelateComponent(this.tablePop);
        if (this.getNode() != null && this.getNode().getItem() != null && EditUIEditorHelper.isXYOrKDLayout(this.getNode().getItem().getComponent())) {
            action = new ZOrderTopAction(this);
            registry.registerAction(action);
            action.addRelateComponent(this.popMenu.add((Action)action));
            action = new ZOrderBottomAction(this);
            registry.registerAction(action);
            action.addRelateComponent(this.popMenu.add((Action)action));
        }
        this.moveAction = new MoveAction(this);
    }

    @Override
    public EditPartViewer getParentViewer() {
        return this.parentViewer;
    }

    @Override
    protected void perform_editComponent(EditPart part) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("viewer", this);
        uiContext.put("edituieditorcontext", this.context);
        if (part != null) {
            uiContext.put("edit type", "edit ctrl");
            uiContext.put("item adapter", part.getModel());
        } else {
            uiContext.put("edit type", "edit viewer");
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PropertyDescriptorUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handleError(this, (Exception)((Object)e1), "\u6253\u5f00\u5c5e\u6027\u9875\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showcontainer")) {
            this.showContainerPop.setSelected((Boolean)evt.getNewValue());
        } else if ("showdynborder".equals(evt.getPropertyName())) {
            this.showDynBorder.setSelected((Boolean)evt.getNewValue());
            this.drawDynBorder((Boolean)evt.getNewValue());
        }
    }

    public Layout getViewerLayout() {
        Object obj = this.node.getUserObject();
        if (obj instanceof ComponentInfo) {
            ComponentInfo container = (ComponentInfo)obj;
            return LayoutConverter.convertToLayoutObj((LayoutInfo)container.getLayoutInfo());
        }
        return new XYLayout();
    }

    @Override
    public List getCurrentMouseInInfo() {
        this.mouseInInfo.clear();
        EditPart currentPart = this.partManager.getPart(this.x, this.y);
        if (currentPart != null && currentPart.getModel() instanceof BizConfigureItemInfoAdapter) {
            BizConfigureItemInfo item = (BizConfigureItemInfo)((BizConfigureItemInfoAdapter)currentPart.getModel()).getItem();
            ComponentInfo roundInfo = EditUIEditorHelper.getRoundedComponent(item.getComponent());
            if (roundInfo != null && "com.kingdee.bos.ctrl.swing.KDLabelContainer".equalsIgnoreCase(roundInfo.getClassType())) {
                this.mouseInInfo.add("\u6807\u7b7e\u540d\u79f0\uff1a" + roundInfo.getName());
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\uff1a" + item.getLabel());
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\u957f\u5ea6\uff1a" + item.getLabelLength());
            } else if ("com.kingdee.bos.ctrl.swing.KDLabel".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equals(roundInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDContainer".equals(roundInfo.getClassType())) {
                this.mouseInInfo.add("\u6807\u7b7e\u6587\u5b57\uff1a" + item.getLabel());
            }
            KDRectangle rectangle = ((BizConfigureItemInfoAdapter)currentPart.getModel()).getBounds();
            this.mouseInInfo.add("\u63a7\u4ef6\u540d\u79f0\uff1a" + ((BizConfigureItemInfoAdapter)currentPart.getModel()).getName());
            this.mouseInInfo.add("\u5c5e\u4e8e\u9759\u6001\u5143\u6570\u636e\uff1a" + (item.getComponent().isConfigured() ? "\u5426" : "\u662f"));
            this.mouseInInfo.add("\u7ea6\u675f\uff1a" + rectangle.toString());
            return this.mouseInInfo;
        }
        return this.mouseInInfo;
    }

    @Override
    protected Request getDirectEditRequest(EditPart source, int x, int y) {
        return new DirectEditRequest(source, this, x, y);
    }

    protected void entriesManager(EditPart part) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        uiContext.put("viewer", this);
        uiContext.put("edituieditorcontext", this.context);
        if (part != null) {
            uiContext.put("edit type", "edit ctrl");
            uiContext.put("item adapter", part.getModel());
        } else {
            uiContext.put("edit type", "edit viewer");
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EntriesManagerUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handleError(this, (Exception)((Object)e1), "\u6253\u5f00\u5c5e\u6027\u9875\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01");
        }
    }

    @Override
    protected void createField(int x, int y) {
        Operate operate = this.getContext().getOperate();
        Target target = operate.getTarget();
        String name = target.getName();
        Object classType = target.getClassType();
        if ((BizDataTypeEnum.OBJECT.equals(classType) || BizDataTypeEnum.ENUM.equals(classType)) && StringUtils.isEmpty((String)name)) {
            this.showCreateConfigUI(x, y);
        } else {
            CreateCommand command = new CreateCommand(this, new Point(x, y));
            this.getCommandStack().execute(command);
            this.createEditPart();
        }
        ((Context)this.getContext()).getEditorUI().reset();
    }

    @Override
    protected void format(EditPart part) {
        Operate operate = this.getContext().getOperate();
        if (operate instanceof FormatOperate) {
            FormatPainterAction action = ((FormatOperate)operate).getFormatAction();
            action.format(part);
        }
    }
}

