/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer;

import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.framework.GetterFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.metadata.webui.transfer.UIType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.ep.IEditUIConfigure;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractUserConfigureEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditorType;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.Operate;
import com.kingdee.eas.ep.client.editor.editui.designer.OperateType;
import com.kingdee.eas.ep.client.editor.editui.designer.PropertyFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.RootEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.action.AlignAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.FormatPainterAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.RedoAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.SameSizeAction;
import com.kingdee.eas.ep.client.editor.editui.designer.action.UndoAction;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.CommandStack;
import com.kingdee.eas.ep.client.editor.editui.designer.listener.SelectionChangedEvent;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizUnitProxy;
import com.kingdee.eas.ep.client.editor.editui.designer.model.property.Property;
import com.kingdee.eas.ep.client.editor.editui.designer.ui.property.PropertySheetPanel;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.policy.tree.UnitNodeCreatorForUserConfigure;
import com.kingdee.eas.ep.client.runtime.UIConfigureExecutor;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.ep.client.util.UserBehaviorCollector;
import com.kingdee.eas.ep.client.util.UserConfigureLicenseService;
import com.kingdee.eas.ep.client.util.UserConfigureUtils;
import com.kingdee.eas.ep.depend.MetadataUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;

public class UserConfigureEditor
extends AbstractUserConfigureEditor
implements IUIEditor {
    private EditUIConfigureInfo configure;
    private Context context;
    private BizConfigureTreeNode node;
    private RootEditPartViewer rootViewer;
    private BizUnitProxy model;
    private PropertySheetPanel propertyPanel;
    private PropertyFactory propertyFactory;
    private FormatPainterAction formatAction;
    private ToolBarManager toolBarManager;

    public void onLoad() throws Exception {
        super.onLoad();
        this._checkLicense();
        MetaDataPK uipk = (MetaDataPK)this.getUIContext().get("MetaDataPK");
        this.initBizUnitInfo(uipk);
        this.initContext();
        this.loadBizConfigureInfo();
        this.propertyFactory = new PropertyFactory(this.context);
        this.node = this.getTreeRoot();
        this.initEditPartViewer();
        this.initPropertyPane();
        this.initToolBar();
    }

    private void _checkLicense() throws Exception {
        if (!UserConfigureLicenseService.check()) {
            LicenseController control = FrameWorkClientUtils.getLicenseController();
            String message = LicenseService.constructLicenseMessage((LicenseController)control, (String)"com.kingdee.eas.ep.client.StandardCustomizedUnitUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)message, (int)0);
            this.abort();
        }
    }

    private void initContext() {
        this.context = new Context();
        this.context.setStatus(0);
        this.context.setCommandStack(new CommandStack());
        this.context.setShowContainer(false);
        this.context.setEditorType(EditorType.userLayout);
        this.context.setUiModel(this.getModel().getEditUI());
        this.context.setUitype(UIType.EDITUI);
        this.context.setDepend(UserConfigureUtils.userConfigureProject);
        this.context.setEditorUI(this);
    }

    private void initBizUnitInfo(MetaDataPK uipk) {
        UIObjectInfo uiObjectInfo = EditUIEditorHelper.loadUIObject(uipk, null);
        if (UictUtils.isEmptyMD((AbstractMDValue)uiObjectInfo)) {
            throw new RuntimeException("UI\u5143\u6570\u636e\u4e0d\u5b58\u5728 \uff0c \u4e0d\u652f\u6301\u7528\u6237\u914d\u7f6e \uff0c \u8bf7\u8054\u7cfb\u5355\u636e\u7684\u5f00\u53d1\u4eba\u5458");
        }
        String bizUnitPK = uiObjectInfo.getBizUnitPK();
        BizUnitInfo bizUnit = MetadataUtils.loadBizUnit((IMetaDataPK)MetaDataPK.create((String)bizUnitPK));
        this.model = new BizUnitProxy();
        this.model.setDepend(UserConfigureUtils.userConfigureProject);
        this.model.setEditUI(uiObjectInfo);
        this.model.setBizUnitInfo(bizUnit);
        EntityObjectInfo entity = this.getBindEntity(uiObjectInfo);
        this.model.setEntity(entity);
    }

    private EntityObjectInfo getBindEntity(UIObjectInfo ui) {
        DataObjectCollection col = ui.getDataObjects();
        DataObjectInfo doInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            EntityObjectInfo entity;
            doInfo = col.get(i);
            if (!MetaDataTypeList.ENTITY.toString().equals(doInfo.getObjectType()) || UictUtils.isEmptyMD((AbstractMDValue)(entity = MetadataUtils.loadEntity((IMetaDataPK)MetaDataPK.create((String)doInfo.getType()))))) continue;
            try {
                return CloneUtils.clone((EntityObjectInfo)entity);
            }
            catch (CloneNotSupportedException e) {
                MsgBox.showError(null, (String)"\u514b\u9686\u51fa\u9519", (String)ExceptionHandler.buildDetail((Throwable)e));
                SysUtil.abort();
            }
        }
        return null;
    }

    private void loadBizConfigureInfo() {
        CoreUI target = (CoreUI)this.getUIContext().get("target");
        UIConfigureExecutor excutor = new UIConfigureExecutor(target);
        EditUIConfigureInfo configureInfo = (EditUIConfigureInfo)excutor.getBizConfigure(target.getMetaDataPK(), null);
        if (configureInfo == null) {
            configureInfo = this.createNewUIConfigureInfo();
            this.setOprtState(OprtState.ADDNEW);
        } else {
            String userSchemeID = UserConfigureUtils.userConfigureProject.getId();
            if (!userSchemeID.equals(configureInfo.getCustomizedSchemeID())) {
                configureInfo = this.createCopy(configureInfo);
                this.setOprtState(OprtState.ADDNEW);
            } else {
                this.setOprtState(OprtState.EDIT);
            }
        }
        this.configure = configureInfo;
        this.setDataObject((IObjectValue)this.configure);
    }

    private EditUIConfigureInfo createNewUIConfigureInfo() {
        EditUIConfigureInfo configureInfo = new EditUIConfigureInfo();
        configureInfo.setEnable(true);
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        configureInfo.setOrgUnit(orgUnit.castToFullOrgUnitInfo());
        configureInfo.setUIObjectPK(this.model.getEditUI().getFullName());
        String userSchemeID = UserConfigureUtils.userConfigureProject.getId();
        configureInfo.setCustomizedSchemeID(userSchemeID);
        configureInfo.setPriorityLevel(0);
        configureInfo.setName(SysContext.getSysContext().getUserName() + "UserSolution");
        return configureInfo;
    }

    private EditUIConfigureInfo createCopy(EditUIConfigureInfo configure) {
        EditUIConfigureInfo newConfigure = this.createNewUIConfigureInfo();
        newConfigure.setUIObject(configure.getUIObject());
        newConfigure.setBizRuleSet(configure.getBizRuleSet());
        return newConfigure;
    }

    private BizConfigureTreeNode getTreeRoot() {
        BizConfigureTreeNode tree = EditUIEditorHelper.getBizConfigureTree(this.context, this.model, false);
        EditUIEditorHelper.loadConfigure(this.model.getEditUI(), tree, this.configure);
        return tree;
    }

    private void initEditPartViewer() {
        this.rootViewer = new RootEditPartViewer(this.node, this.context);
        this.context.setRootViewer(this.rootViewer);
        this.rootViewer.setPreferredSize(new Dimension(1013, 389));
        KDScrollPane scroll = new KDScrollPane((Component)this.rootViewer);
        this.kDSplitPane1.add((Component)scroll, (Object)"top");
        scroll.getVerticalScrollBar().setUnitIncrement(10);
    }

    private void initPropertyPane() {
        this.propertyPanel = new PropertySheetPanel();
        this.propertyPanel.setPreferredSize(new Dimension(1013, 240));
        this.kDSplitPane1.add((Component)this.propertyPanel, (Object)"bottom");
        this.resetPropertyPanel(null);
    }

    @Override
    public BizUnitInfo getModel() {
        return this.model;
    }

    @Override
    public BizConfigureTreeNode getRootNode() {
        return this.node;
    }

    @Override
    public UIType getUiType() {
        return UIType.EDITUI;
    }

    @Override
    public void reset() {
        this.context.setOperate(new Operate(OperateType.select));
        UictEditPartViewer mouseInViewer = (UictEditPartViewer)this.context.getMouseInViewer();
        if (mouseInViewer != null) {
            mouseInViewer.resetCursor();
        }
        this.resetPropertyPanel(null);
    }

    @Override
    public void editPartSelectionChanged(SelectionChangedEvent event) {
        if (this.formatAction != null) {
            this.formatAction.updateAction();
        }
        EditPart editPart = event.getEditPart();
        this.resetPropertyPanel(editPart);
    }

    public void resetPropertyPanel(EditPart part) {
        BizConfigureItemInfoAdapter model = null;
        if (part != null) {
            model = (BizConfigureItemInfoAdapter)part.getModel();
        } else {
            UictEditPartViewer viewer = (UictEditPartViewer)this.context.getRootViewer();
            BizConfigureItemInfo item = ((BizConfigureTreeNode)viewer.getNode()).getItem();
            model = new BizConfigureItemInfoAdapter(item);
        }
        Property[] properties = this.propertyFactory.getProperty(model);
        this.propertyPanel.setProperties(properties);
        this.propertyPanel.repaint();
    }

    @Override
    public Project getDepends() {
        return UserConfigureUtils.userConfigureProject;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK pk;
        IEditUIConfigure ioc = EditUIConfigureFactory.getRemoteInstance();
        UserConfigureUtils.storeConfigureModel(this.getModel(), this.configure, this.node);
        if (this.configure.getId() == null) {
            if (!this.isEmpty(this.configure)) {
                this.createUnitNode();
                pk = ioc.addnew(this.configure);
                this.configure.setId(BOSUuid.read((String)pk.toString()));
                UserConfigureUtils.assign(this.configure);
            }
        } else {
            pk = new ObjectUuidPK(this.configure.getId());
            if (this.isEmpty(this.configure)) {
                ioc.delete((IObjectPK)pk);
                UserConfigureUtils.clearAssign(this.configure);
                this.configure.setId(null);
            } else {
                ioc.update((IObjectPK)pk, this.configure);
            }
        }
        GetterFactory.clearGetterInfoOnClient();
        MetaDataPK uipk = (MetaDataPK)this.getUIContext().get("MetaDataPK");
        UserBehaviorCollector.fireUserConfigure((IMetaDataPK)uipk);
        MsgBox.showInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f,\u914d\u7f6e\u4fe1\u606f\u5c06\u4ece\u4e0b\u6b21\u6253\u5f00\u754c\u9762\u65f6\u5f00\u59cb\u751f\u6548\u3002");
    }

    private boolean isEmpty(EditUIConfigureInfo configure) {
        return StringUtils.isEmpty((String)configure.getUIObject()) && StringUtils.isEmpty((String)configure.getBizRuleSet());
    }

    private void createUnitNode() throws Exception {
        MetaDataPK pk = (MetaDataPK)this.getUIContext().get("MetaDataPK");
        if (!UserConfigureUtils.isCustomized(pk.getFullName())) {
            UnitNodeCreatorForUserConfigure creator = new UnitNodeCreatorForUserConfigure();
            CustomizedUnitInfo rootNode = creator.getUserSchemeRootNode();
            CustomizedUnitInfo unit = creator.createUnit(rootNode, this.model.getBizUnitInfo());
            ICustomizedUnit bizInterface = CustomizedUnitFactory.getRemoteInstance();
            try {
                bizInterface.addnew((CoreBaseInfo)unit);
            }
            catch (EPException e) {
                if (!EPException.ITEM_CUSTOMIZED.getCode().equals(e.getSubCode())) {
                    throw e;
                }
            }
            catch (ObjectNotFoundException e) {
                MsgBox.showError((Component)((Object)this), (String)"\u4fdd\u5b58\u5931\u8d25 \uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u662f\u5426\u5df2\u6267\u884cDEP\u7684\u6570\u636e\u5e93\u811a\u672c\u3002", (String)ExceptionHandler.buildDetail((Throwable)e));
                SysUtil.abort();
            }
        }
    }

    private void initToolBar() {
        this.toolBarManager = new ToolBarManager();
        this.toolBarManager.initToolBar();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.configure.setUIObject(null);
        this.configure.setBizRuleSet(null);
        this.node = this.getTreeRoot();
        this.initEditPartViewer();
        this.initPropertyPane();
        this.toolBarManager.resetActions();
    }

    private class ToolBarManager {
        private List<BaseAction> actions = new ArrayList<BaseAction>();

        private ToolBarManager() {
        }

        private void initToolBar() {
            AlignAction alignLeftAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 0, "designer/figures/align/alignleft.gif");
            JButton alignLeft = UserConfigureEditor.this.toolBar.add((Action)alignLeftAction);
            alignLeft.setText(null);
            alignLeft.setToolTipText("\u5de6\u5bf9\u9f50");
            this.actions.add(alignLeftAction);
            AlignAction alignCenterAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 1, "designer/figures/align/aligncenter.gif");
            JButton alignCenter = UserConfigureEditor.this.toolBar.add((Action)alignCenterAction);
            alignCenter.setText(null);
            alignCenter.setToolTipText("\u6c34\u5e73\u4e2d\u5fc3\u5bf9\u9f50");
            this.actions.add(alignCenterAction);
            AlignAction alignRightAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 2, "designer/figures/align/alignright.gif");
            JButton alignRight = UserConfigureEditor.this.toolBar.add((Action)alignRightAction);
            alignRight.setText(null);
            alignRight.setToolTipText("\u53f3\u5bf9\u9f50");
            this.actions.add(alignRightAction);
            UserConfigureEditor.this.toolBar.add((Component)new KDSeparator());
            AlignAction alignTopAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 3, "designer/figures/align/aligntop.gif");
            JButton alignTop = UserConfigureEditor.this.toolBar.add((Action)alignTopAction);
            alignTop.setText(null);
            alignTop.setToolTipText("\u4e0a\u5bf9\u9f50");
            this.actions.add(alignTopAction);
            AlignAction alignMiddleAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 4, "designer/figures/align/alignmid.gif");
            JButton alignMiddle = UserConfigureEditor.this.toolBar.add((Action)alignMiddleAction);
            alignMiddle.setText(null);
            alignMiddle.setToolTipText("\u5782\u76f4\u4e2d\u5fc3\u5bf9\u9f50");
            this.actions.add(alignMiddleAction);
            AlignAction alignBottomAction = new AlignAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 5, "designer/figures/align/alignbottom.gif");
            JButton alignBottom = UserConfigureEditor.this.toolBar.add((Action)alignBottomAction);
            alignBottom.setText(null);
            alignBottom.setToolTipText("\u5e95\u5bf9\u9f50");
            this.actions.add(alignBottomAction);
            UserConfigureEditor.this.toolBar.add((Component)new KDSeparator());
            SameSizeAction sameWidthAction = new SameSizeAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 0, "designer/SameWidth.gif");
            JButton sameWidth = UserConfigureEditor.this.toolBar.add((Action)sameWidthAction);
            sameWidth.setText(null);
            sameWidth.setToolTipText("\u7b49\u5bbd");
            this.actions.add(sameWidthAction);
            SameSizeAction sameHeightAction = new SameSizeAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 1, "designer/SameHeight.gif");
            JButton sameHeight = UserConfigureEditor.this.toolBar.add((Action)sameHeightAction);
            sameHeight.setText(null);
            sameHeight.setToolTipText("\u7b49\u9ad8");
            this.actions.add(sameHeightAction);
            SameSizeAction sameWidthAndHeightAction = new SameSizeAction((EditPartViewer)UserConfigureEditor.this.rootViewer, 2, "designer/SameHeightAndWidth.gif");
            JButton sameWidthAndHeight = UserConfigureEditor.this.toolBar.add((Action)sameWidthAndHeightAction);
            sameWidthAndHeight.setText(null);
            sameWidthAndHeight.setToolTipText("\u7b49\u5bbd\u7b49\u9ad8");
            this.actions.add(sameWidthAndHeightAction);
            UserConfigureEditor.this.toolBar.add((Component)new KDSeparator());
            RedoAction redoAction = new RedoAction(UserConfigureEditor.this.rootViewer);
            JButton redo = UserConfigureEditor.this.toolBar.add((Action)redoAction);
            redo.setText(null);
            redo.setToolTipText("\u91cd\u505a");
            this.actions.add(redoAction);
            UndoAction undoAction = new UndoAction(UserConfigureEditor.this.rootViewer);
            JButton undo = UserConfigureEditor.this.toolBar.add((Action)undoAction);
            undo.setText(null);
            undo.setToolTipText("\u64a4\u9500");
            this.actions.add(undoAction);
            UserConfigureEditor.this.formatAction = new FormatPainterAction(UserConfigureEditor.this.rootViewer);
            JButton formatbutton = UserConfigureEditor.this.toolBar.add((Action)UserConfigureEditor.this.formatAction);
            UserConfigureEditor.this.formatAction.addRelateComponent(formatbutton);
            this.actions.add(UserConfigureEditor.this.formatAction);
        }

        private void resetActions() {
            int n = this.actions.size();
            for (int i = 0; i < n; ++i) {
                this.actions.get(i).setEditPartViewer(UserConfigureEditor.this.rootViewer);
            }
        }
    }
}

