/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.action;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.ComponentSelectionTree;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.FormatOperate;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.action.BaseAction;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComponentFormat;
import com.kingdee.eas.ep.client.editor.editui.designer.model.FormatFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.request.FormatRequest;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FormatPainterAction
extends BaseAction {
    private static final long serialVersionUID = -5763126892105670147L;
    private ComponentFormat format;
    private IContext context;
    private static final String actionName = "\u683c\u5f0f\u5237";

    public FormatPainterAction(EditPartViewer editPartViewer) {
        this.editPartViewer = editPartViewer;
        this.context = editPartViewer.getContext();
        this.putValue("Name", actionName);
        this.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_formatpainter"));
        this.putValue("ShortDescription", actionName);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resetTree();
        this.resetContext();
        this.recordFormat();
    }

    public void format(EditPart part) {
        if (this.accept(part) && this.getFormat() != null) {
            this.apply(this.getFormat(), part);
        }
    }

    private boolean accept(EditPart part) {
        Object model;
        if (part != null && (model = part.getModel()) instanceof BizConfigureItemInfoAdapter) {
            return this.accept((BizConfigureItemInfo)((BizConfigureItemInfoAdapter)model).getItem());
        }
        return false;
    }

    private boolean accept(BizConfigureItemInfo item) {
        if (item != null && item.getComponent() != null) {
            ComponentInfo comp = item.getComponent();
            if (!(comp = EditUIEditorHelper.getRoundedComponent(comp)).isContainer() || EditUIEditorHelper.isLabelContainer(comp)) {
                return true;
            }
        }
        return false;
    }

    private void recordFormat() {
        EditPart part = this.getSelectedPart(this.editPartViewer);
        if (this.accept(part)) {
            Object model = part.getModel();
            this.record((BizConfigureItemInfoAdapter)model);
        }
    }

    private void record(BizConfigureItemInfoAdapter adapter) {
        BizConfigureItemInfo item = (BizConfigureItemInfo)adapter.getItem();
        this.format = FormatFactory.getFormat(item);
    }

    private void apply(ComponentFormat format, EditPart part) {
        FormatRequest request = new FormatRequest(format);
        part.sendRequest(request);
    }

    public ComponentFormat getFormat() {
        return this.format;
    }

    private EditPart getSelectedPart(EditPartViewer root) {
        Set parts = this.getSelectedParts(root);
        if (!parts.isEmpty()) {
            return (EditPart)parts.iterator().next();
        }
        return null;
    }

    private Set getSelectedParts(EditPartViewer root) {
        HashSet set = new HashSet();
        EditPartManager partManager = root.getPartManager();
        set.addAll(partManager.getMultiSelected());
        List childs = root.getChildViewer();
        for (int i = 0; i < childs.size(); ++i) {
            Set parts = this.getSelectedParts((EditPartViewer)childs.get(i));
            set.addAll(parts);
        }
        set.remove(null);
        return set;
    }

    @Override
    public boolean isEnabled() {
        Set parts = this.getSelectedParts(this.editPartViewer);
        if (parts.size() == 1) {
            EditPart part = (EditPart)parts.iterator().next();
            return this.accept(part);
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    private void resetTree() {
        ComponentSelectionTree tree;
        IUIEditor editor = ((Context)this.context).getEditorUI();
        if (editor instanceof EditUIEditor && (tree = ((EditUIEditor)editor).getComponentSelectionTree()) != null) {
            tree.setSelectionRow(0);
        }
    }

    private void resetContext() {
        FormatOperate operate = new FormatOperate();
        operate.setFormatAction(this);
        this.context.setOperate(operate);
    }
}

