/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.action;

import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.action.AbstractMoveAction;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.DirectEditRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.util.UictEditorHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class MoveAction
extends AbstractMoveAction {
    public MoveAction(EditPartViewer editPartViewer) {
        super(editPartViewer);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList viewers = new ArrayList();
        UictEditorHelper.getAllViewer(viewers, (UictEditPartViewer)this.editPartViewer);
        int size = viewers.size();
        for (int i = size - 1; i >= 0; --i) {
            UictEditPartViewer uictEditPartViewer = (UictEditPartViewer)viewers.get(i);
            if (uictEditPartViewer.getPartManager().getMultiSelected().size() > 0) {
                List mul = uictEditPartViewer.getPartManager().getMultiSelected();
                for (EditPart part : mul) {
                    if (!(part instanceof CommonEditPart)) continue;
                    this.doMove(uictEditPartViewer, (CommonEditPart)part);
                }
                continue;
            }
            EditPart part = uictEditPartViewer.getPartManager().getSelection();
            if (!(part instanceof CommonEditPart)) continue;
            this.doMove(uictEditPartViewer, (CommonEditPart)part);
        }
        this.step = 0;
        this.direction = 0;
    }

    private void doMove(UictEditPartViewer uictEditPartViewer, CommonEditPart part) {
        BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)part.getModel();
        if (adapter == null || adapter.getBounds() == null || this.step == 0) {
            return;
        }
        KDRectangle bounds = adapter.getBounds();
        DirectEditRequest request = new DirectEditRequest();
        request.setSourceEditPart(part);
        request.setViwer(uictEditPartViewer);
        switch (this.direction) {
            case 1: {
                request.setX(bounds.getX() - this.step);
                request.setY(bounds.getY());
                part.sendRequest(request);
                break;
            }
            case 2: {
                request.setX(bounds.getX() + this.step);
                request.setY(bounds.getY());
                part.sendRequest(request);
                break;
            }
            case 3: {
                request.setX(bounds.getX());
                request.setY(bounds.getY() - this.step);
                part.sendRequest(request);
                break;
            }
            case 4: {
                request.setX(bounds.getX());
                request.setY(bounds.getY() + this.step);
                part.sendRequest(request);
                break;
            }
        }
    }
}

