/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.CommonEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.ContainerEditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ChangeContainerRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ShowDynBorderRequest;
import com.kingdee.eas.ep.client.model.BizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;

public class ChangeContainerCommand
extends Command {
    private UictEditPartViewer sourceViwer;
    private UictEditPartViewer targetViewer;
    private BizConfigureTreeNode sourceNode;
    private BizConfigureTreeNode targetNode;
    private BizConfigureTreeNode containerNode;
    private BizConfigureItemCollection sourceList;
    private BizConfigureItemCollection targetList;
    private EditPart source;
    private KDRectangle oldConstraint;
    private KDRectangle newConstraint;
    private int sourceIndex;
    private Point suggestPlace;

    public ChangeContainerCommand(ChangeContainerRequest request) {
        this.sourceViwer = (UictEditPartViewer)request.getSourceViwer();
        this.targetViewer = (UictEditPartViewer)request.getTargetViewer();
        this.sourceNode = (BizConfigureTreeNode)this.sourceViwer.getNode();
        this.targetNode = (BizConfigureTreeNode)this.targetViewer.getNode();
        this.sourceList = (BizConfigureItemCollection)this.sourceNode.getConfigureItems();
        this.targetList = (BizConfigureItemCollection)this.targetNode.getConfigureItems();
        this.suggestPlace = request.getSuggestPlace();
        this.source = request.getSourceEditPart();
        this.oldConstraint = ((BizConfigureItemInfoAdapter)this.source.getModel()).getBounds();
        this.sourceIndex = this.sourceList.indexOf(((BizConfigureItemInfoAdapter)this.source.getModel()).getItem());
        if (this.isContainer(this.source)) {
            String nodeName = ((BizConfigureItemInfoAdapter)this.source.getModel()).getName();
            int count = this.sourceNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                BizConfigureTreeNode child = (BizConfigureTreeNode)((Object)this.sourceNode.getChildAt(i));
                if (nodeName == null || !nodeName.equals(child.getName())) continue;
                this.containerNode = child;
                break;
            }
        }
        this.newConstraint = new KDRectangle(this.oldConstraint);
        this.newConstraint.getRectangle().x = 10;
        this.newConstraint.getRectangle().y = 10;
        if (this.suggestPlace != null) {
            int x = this.suggestPlace.x;
            int y = this.suggestPlace.y;
            Rectangle bounds = this.targetViewer.getBounds();
            if (x < bounds.width && y < bounds.height) {
                this.newConstraint.getRectangle().x = x;
                this.newConstraint.getRectangle().y = y;
            }
        } else {
            this.newConstraint.getRectangle().y = EditUIEditorHelper.getMaxHeight(this.targetNode) + 10;
        }
    }

    private boolean isContainer(EditPart part) {
        BizConfigureItemInfo itemInfo;
        if (part instanceof ContainerEditPart) {
            return true;
        }
        return part instanceof CommonEditPart && EditUIEditorHelper.isKDTable(itemInfo = ((CommonEditPart)part).getItemInfo());
    }

    @Override
    public void execute() {
        BizConfigureItemInfo item = (BizConfigureItemInfo)((BizConfigureItemInfoAdapter)this.source.getModel()).getItem();
        item.setBounds(this.newConstraint);
        if (this.sourceIndex == -1) {
            return;
        }
        this.sourceList.removeObject(this.sourceIndex);
        this.targetList.add(item);
        if (this.containerNode != null) {
            this.sourceNode.remove((MutableTreeNode)((Object)this.containerNode));
            this.targetNode.add((MutableTreeNode)((Object)this.containerNode));
        }
        this.sourceViwer.createEditPart();
        this.targetViewer.createEditPart();
        Iterator iterator = this.targetViewer.getPartManager().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof EditPart)) continue;
            EditPart part = (EditPart)next;
            part.performRequest(new ShowDynBorderRequest(part, this.targetViewer.getContext().isShowDynBorder()));
        }
    }

    @Override
    public void undo() {
        BizConfigureItemInfo item = (BizConfigureItemInfo)((BizConfigureItemInfoAdapter)this.source.getModel()).getItem();
        item.setBounds(this.oldConstraint);
        this.targetList.remove(item);
        this.sourceList.addObject(this.sourceIndex, (IObjectValue)item);
        if (this.containerNode != null) {
            this.targetNode.remove((MutableTreeNode)((Object)this.containerNode));
            this.sourceNode.add((MutableTreeNode)((Object)this.containerNode));
        }
        this.sourceViwer.createEditPart();
        this.targetViewer.createEditPart();
    }
}

