/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartManager;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.request.SelectedRequest;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.util.Iterator;
import javax.swing.JPanel;

public class ChangeZOrderCommand
extends Command {
    public static final String TOP = "_top";
    public static final String BOTTOM = "_bottom";
    private EditPart part;
    private String zOrder;
    private int originalComponentInfoIndex;
    private int originalItemIndex;

    public ChangeZOrderCommand(EditPart part, String zOrder) {
        this.part = part;
        this.zOrder = zOrder;
    }

    @Override
    public boolean canExecute() {
        EditPartViewer viewer;
        if ((TOP.equals(this.zOrder) || BOTTOM.equals(this.zOrder)) && (viewer = this.part.getViewer()) instanceof AbstractEditPartViewer) {
            return this.validateComponent(this.part) && this.validateItem(this.part);
        }
        return false;
    }

    private boolean validateComponent(EditPart part) {
        ComponentInfo component = this.getComponentInfo(part);
        ComponentInfo parent = component.getParent();
        return parent != null && parent.getComponents().contains(component);
    }

    private boolean validateItem(EditPart part) {
        AbstractBizConfigureItemInfo item;
        AbstractEditPartViewer viewer = (AbstractEditPartViewer)part.getViewer();
        ComponentTreeNode node = viewer.getNode();
        AbstractBizConfigureItemCollection items = node.getConfigureItems();
        return items.contains(item = ((BizConfigureItemInfoAdapter)part.getModel()).getItem());
    }

    private ComponentInfo getComponentInfo(EditPart part) {
        BizConfigureItemInfoAdapter adapter = (BizConfigureItemInfoAdapter)part.getModel();
        AbstractBizConfigureItemInfo item = adapter.getItem();
        ComponentInfo component = item.getComponent();
        return EditUIEditorHelper.getRoundedComponent(component);
    }

    @Override
    public void execute() {
        this.reOrderComponentInfo();
        this.reOrderItemInfo();
        this.reCreateEditPart();
        this.fireZOrderChanged();
    }

    private void reOrderComponentInfo() {
        ComponentInfo component = this.getComponentInfo(this.part);
        ComponentInfo parent = component.getParent();
        ComponentCollection components = parent.getComponents();
        this.originalComponentInfoIndex = components.indexOf((IObjectValue)component);
        components.remove(component);
        if (TOP.equals(this.zOrder)) {
            components.addObject(0, (IObjectValue)component);
        } else if (BOTTOM.equals(this.zOrder)) {
            components.addObject(components.size(), (IObjectValue)component);
        }
    }

    private void reOrderItemInfo() {
        AbstractEditPartViewer viewer = (AbstractEditPartViewer)this.part.getViewer();
        ComponentTreeNode node = viewer.getNode();
        AbstractBizConfigureItemCollection items = node.getConfigureItems();
        AbstractBizConfigureItemInfo item = ((BizConfigureItemInfoAdapter)this.part.getModel()).getItem();
        this.originalItemIndex = items.indexOf(item);
        items.removeObject((IObjectValue)item);
        if (TOP.equals(this.zOrder)) {
            items.addObject(0, (IObjectValue)item);
        } else if (BOTTOM.equals(this.zOrder)) {
            items.addObject(items.size(), (IObjectValue)item);
        }
    }

    private void reCreateEditPart() {
        AbstractEditPartViewer viewer = (AbstractEditPartViewer)this.part.getViewer();
        EditPartManager partManager = viewer.getPartManager();
        this.clearPartManager(partManager);
        this.clearViewer(viewer);
        viewer.createEditPart();
        this.part = this.reGetEditPart(partManager, this.part);
        partManager.select(this.part);
        this.part.performRequest(new SelectedRequest());
    }

    private void clearViewer(AbstractEditPartViewer viewer) {
        JPanel maskPanel = viewer.getMaskPanel();
        maskPanel.removeAll();
        viewer.removeAll();
        viewer.add(maskPanel);
    }

    private void clearPartManager(EditPartManager partManager) {
        partManager.clear();
        partManager.clearMultiSelected();
        partManager.select(null);
        partManager.target(null);
        partManager.source(null);
    }

    private EditPart reGetEditPart(EditPartManager partManager, EditPart part) {
        AbstractBizConfigureItemInfo item = ((BizConfigureItemInfoAdapter)part.getModel()).getItem();
        Iterator iterator = partManager.iterator();
        while (iterator.hasNext()) {
            EditPart newPart = (EditPart)iterator.next();
            AbstractBizConfigureItemInfo newItem = ((BizConfigureItemInfoAdapter)newPart.getModel()).getItem();
            if (!item.equals(newItem)) continue;
            return newPart;
        }
        return null;
    }

    @Override
    public void undo() {
        this.undoReOrderComponent();
        this.undoReOrderItemInfo();
        this.reCreateEditPart();
        this.fireZOrderChanged();
    }

    private void undoReOrderComponent() {
        ComponentInfo component = this.getComponentInfo(this.part);
        ComponentInfo parent = component.getParent();
        ComponentCollection components = parent.getComponents();
        if (this.originalComponentInfoIndex < components.size()) {
            components.remove(component);
            components.addObject(this.originalComponentInfoIndex, (IObjectValue)component);
        }
    }

    private void undoReOrderItemInfo() {
        AbstractEditPartViewer viewer = (AbstractEditPartViewer)this.part.getViewer();
        ComponentTreeNode node = viewer.getNode();
        AbstractBizConfigureItemCollection items = node.getConfigureItems();
        AbstractBizConfigureItemInfo item = ((BizConfigureItemInfoAdapter)this.part.getModel()).getItem();
        if (this.originalItemIndex < items.size()) {
            items.removeObject((IObjectValue)item);
            items.addObject(this.originalItemIndex, (IObjectValue)item);
        }
    }

    private void fireZOrderChanged() {
        AbstractEditPartViewer viewer = (AbstractEditPartViewer)this.part.getViewer();
        Context context = (Context)viewer.getContext();
        IUIEditor editor = context.getEditorUI();
        if (editor instanceof EditUIEditor) {
            ((EditUIEditor)editor).refreshUIComponentsOutlinePanel();
        }
    }
}

