/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import java.util.ArrayList;
import java.util.Stack;

public class CommandStack {
    private Stack redoable = new Stack();
    private Stack undoable = new Stack();
    private static final int MAX_UNDO = 10;

    public boolean canRedo() {
        return !this.redoable.isEmpty();
    }

    public boolean canUndo() {
        if (this.undoable.size() == 0) {
            return false;
        }
        return ((Command)this.undoable.lastElement()).canUndo();
    }

    public void dispose() {
        this.flushUndo();
        this.flushRedo();
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.flushRedo();
        command.execute();
        this.undoable.push(command);
        int size = this.undoable.size();
        if (size > 10) {
            this.undoable.remove(0);
        }
    }

    public void flush() {
        this.flushRedo();
        this.flushUndo();
    }

    private void flushRedo() {
        while (!this.redoable.isEmpty()) {
            ((Command)this.redoable.pop()).dispose();
        }
    }

    private void flushUndo() {
        while (!this.undoable.isEmpty()) {
            ((Command)this.undoable.pop()).dispose();
        }
    }

    public Object[] getCommands() {
        ArrayList commands = new ArrayList(this.undoable);
        for (int i = this.redoable.size() - 1; i >= 0; --i) {
            commands.add(this.redoable.get(i));
        }
        return commands.toArray();
    }

    public Command getRedoCommand() {
        return this.redoable.isEmpty() ? null : (Command)this.redoable.peek();
    }

    public Command getUndoCommand() {
        return this.undoable.isEmpty() ? null : (Command)this.undoable.peek();
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = (Command)this.redoable.pop();
        command.redo();
        this.undoable.push(command);
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        Command command = (Command)this.undoable.pop();
        command.undo();
        this.redoable.push(command);
    }
}

