/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.IContext;
import com.kingdee.eas.ep.client.editor.editui.designer.Operate;
import com.kingdee.eas.ep.client.editor.editui.designer.Target;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.util.FieldNameManager;
import com.kingdee.eas.ep.client.handle.ExceptionHandler;
import com.kingdee.eas.ep.client.util.PaletteUtils;
import com.kingdee.eas.ep.client.util.UserBehaviorCollector;
import com.kingdee.eas.util.AbortException;
import com.kingdee.util.StringUtils;
import java.awt.Point;

public class CreateCommand
extends Command {
    private Point point;
    private EditPartViewer viewer;

    public CreateCommand(EditPartViewer viewer, Point point) {
        this.viewer = viewer;
        this.point = point;
    }

    @Override
    public void execute() {
        IContext context = this.viewer.getContext();
        Operate operate = context.getOperate();
        Target target = operate.getTarget();
        UserBehaviorCollector.fireCreateComponent(target);
        String name = target.getName();
        Object classType = target.getClassType();
        PaletteUtils util = new PaletteUtils(this.viewer, classType, name);
        String fieldName = (String)context.get("fieldName");
        String fieldAlias = (String)context.get("fieldAlias");
        Boolean isListVisible = (Boolean)context.get("isListVisible");
        if (fieldName != null) {
            fieldName = this.getFieldNameByName(fieldName);
        } else {
            String type = "";
            type = BizDataTypeEnum.OBJECT.equals(classType) || BizDataTypeEnum.ENUM.equals(classType) ? name : util.getComponentType(classType);
            if (StringUtils.isEmpty((String)type)) {
                type = classType.toString();
            }
            fieldAlias = fieldName = this.createName(type);
        }
        util.setName(fieldName);
        util.setAlias(fieldAlias);
        if (classType instanceof BizDataTypeEnum) {
            util.initProcessing(name);
            util.getProcessing().setListDisplay(false);
            util.setLocation(this.point.x, this.point.y);
            util.addEntityFiled();
            if (isListVisible != null && isListVisible.equals(Boolean.TRUE)) {
                util.getProcessing().setListDisplay(true);
            }
            util.addEditUICommpent();
        } else if ("\u5206\u5f55".equals(name)) {
            util.setXY(this.point.x, this.point.y);
            util.initEntityProcessing();
        } else {
            util.setXY(this.point.x, this.point.y);
            util.addOnlyComponent();
        }
        if (!"\u5206\u5f55".equals(name)) {
            context.setDirty(true);
        }
    }

    private String createName(String classType) {
        Context context = (Context)this.viewer.getContext();
        BizUnitInfo model = context.getEditorUI().getModel();
        try {
            FieldNameManager manager = new FieldNameManager(model);
            return manager.getFieldName(classType);
        }
        catch (Exception e) {
            ExceptionHandler.handleError(null, e, "\u521d\u59cb\u5316FieldNameManager\u51fa\u9519");
            throw new AbortException();
        }
    }

    public String getFieldNameByName(String fieldName) {
        PropertyInfo propertyInfo;
        Context context = (Context)this.viewer.getContext();
        BizUnitInfo bizUnit = context.getEditorUI().getModel();
        EntityObjectInfo entity = bizUnit.getEntity();
        for (int i = 1; i < Integer.MAX_VALUE && (propertyInfo = entity.getPropertyByName(fieldName)) != null; ++i) {
            fieldName = fieldName + i;
        }
        return fieldName;
    }

    @Override
    public void undo() {
        super.undo();
    }

    @Override
    public boolean canUndo() {
        return false;
    }
}

