/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComponentFormat;
import com.kingdee.eas.ep.client.editor.editui.designer.model.FormatFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.model.LabelContainerFormat;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import java.awt.Dimension;

public class FormatCommand
extends Command {
    private ComponentFormat backup;
    private BizConfigureItemInfoAdapter adapter;
    private ComponentFormat format;

    public FormatCommand(BizConfigureItemInfoAdapter adapter, ComponentFormat format) {
        this.adapter = adapter;
        this.format = format;
    }

    @Override
    public void execute() {
        this.backup(this.adapter);
        this.apply(this.adapter, this.format);
    }

    @Override
    public void undo() {
        this.apply(this.adapter, this.backup);
    }

    private void backup(BizConfigureItemInfoAdapter adapter) {
        BizConfigureItemInfo item = (BizConfigureItemInfo)adapter.getItem();
        this.backup = FormatFactory.getFormat(item);
    }

    private void apply(BizConfigureItemInfoAdapter adapter, ComponentFormat format) {
        BizConfigureItemInfo item = (BizConfigureItemInfo)adapter.getItem();
        ComponentInfo component = item.getComponent();
        component = EditUIEditorHelper.getRoundedComponent(component);
        item.setVisible(format.isVisible());
        item.setEnabled(format.isEnable());
        KDRectangle bounds = item.getBounds();
        Dimension size = format.getSize();
        if (bounds != null && size != null) {
            bounds.setWidth((int)size.getWidth());
            bounds.setHeight((int)size.getHeight());
        }
        if (format instanceof LabelContainerFormat && EditUIEditorHelper.isLabelContainer(component)) {
            LabelContainerFormat cFormat = (LabelContainerFormat)format;
            item.setLabelAlignment(cFormat.getLabelAlignment());
            item.setLabelLength(cFormat.getLabelLength());
            item.setLabelUnderLine(cFormat.isLabelUnderline());
        }
        adapter.fireProperty("format", null, format);
    }
}

