/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.XYLayout;
import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;

public class LayoutValueChangeCommand
extends Command {
    private AbstractEditPartViewer viewer;
    private ComponentInfo container;
    private Layout newLayout;
    private Layout oldLayout;

    public LayoutValueChangeCommand(AbstractEditPartViewer viewer, ComponentInfo container, Layout layout) {
        this.viewer = viewer;
        this.container = container;
        this.newLayout = layout;
    }

    @Override
    public boolean canExecute() {
        if (this.container != null && this.newLayout != null) {
            this.oldLayout = this.getLayout(this.container);
            this.newLayout.setName(this.oldLayout.getName());
            return true;
        }
        return false;
    }

    @Override
    public void execute() {
        this.setLayout(this.newLayout);
        this.viewer.repaint();
    }

    @Override
    public void undo() {
        this.setLayout(this.oldLayout);
        this.viewer.repaint();
    }

    private void setLayout(Layout layout) {
        if (layout == null) {
            return;
        }
        ComponentCollection collection = this.container.getComponents();
        int j = collection.size();
        for (int i = 0; i < j; ++i) {
            collection.get(i).getConstraint();
        }
        this.container.setLayoutInfo(LayoutConverter.convertToInfo((Layout)layout));
        if (this.container.isHerited()) {
            this.container.getLayoutInfo().setOverride(true);
        }
    }

    private Layout getLayout(ComponentInfo cInfo) {
        if (cInfo != null) {
            return LayoutConverter.convertToLayoutObj((LayoutInfo)cInfo.getLayoutInfo());
        }
        return new XYLayout();
    }
}

