/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.dtp.kdtable.TableInfoHelper;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.BizDataTypeEnum;
import com.kingdee.eas.ep.DataSourceEnum;
import com.kingdee.eas.ep.LabelContainerAlignmentEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.editor.editui.designer.model.ComboBoxItem;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class PropertyValueChangeCommand
extends Command {
    private String property;
    private BizConfigureItemInfoAdapter adapter;
    private Object newValue;
    private Object oldValue;
    private String cellDisplayText;
    private BizConfigureItemInfo colItem;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ep.client.editor.editui.designer.commands.PropertyValueChangeCommand");
    private Context context;

    public PropertyValueChangeCommand() {
    }

    public PropertyValueChangeCommand(String property, BizConfigureItemInfoAdapter adapter, Object newValue, String cellDisplayText) {
        if (newValue == null) {
            newValue = "";
        }
        this.property = property;
        this.adapter = adapter;
        this.newValue = newValue;
        this.cellDisplayText = cellDisplayText;
        if ("action_pro".equals(property)) {
            this.oldValue = ComponentHelper.getPropertyValue(this.adapter.getItem().getComponent(), "action");
            if (newValue == null || "<none>".equals(newValue) || StringUtils.isEmpty((String)newValue.toString())) {
                this.newValue = "";
            }
        }
    }

    public PropertyValueChangeCommand(String property, BizConfigureItemInfo item, Object newValue, String cellDisplayText) {
        this(property, new BizConfigureItemInfoAdapter(item), newValue, cellDisplayText);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public boolean canExecute() {
        if ("Label".equals(this.property) || "label_underline".equals(this.property) || "Visible".equals(this.property) || "Enabled".equals(this.property) || "Required".equals(this.property) || "Sum".equals(this.property) || "DefaultValue".equals(this.property) || "displayformat".equals(this.property) || "editformat".equals(this.property) || "defaultf7uiname".equals(this.property) || "f7FilterItem".equals(this.property) || "formatString".equals(this.property) || "Name".equals(this.property) || "horizontalAlignment".equals(this.property) || "isCommonQueryFilter".equals(this.property) || "colVisible".equals(this.property) || "colFrozen".equals(this.property) || "colDefault".equals(this.property) || "maxLength".equals(this.property)) {
            return true;
        }
        if ("label_length".equals(this.property) || "x_pro".equals(this.property) || "y_pro".equals(this.property) || "width_pro".equals(this.property) || "height_pro".equals(this.property) || "anchor_pro".equals(this.property)) {
            return this.isInteger(this.newValue);
        }
        if ("label_alignment".equals(this.property) && this.newValue instanceof LabelContainerAlignmentEnum) {
            this.newValue = new Integer(((LabelContainerAlignmentEnum)((Object)this.newValue)).getValue());
            return true;
        }
        return false;
    }

    private boolean isInteger(Object newValue) {
        try {
            new Integer(newValue.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        if (this.adapter == null || this.adapter.getItem() == null) {
            return;
        }
        BizConfigureItemInfo item = (BizConfigureItemInfo)this.adapter.getItem();
        if ("Name".equals(this.property)) {
            AbstractUIObjectInfo uiModel;
            this.oldValue = this.adapter.getItem().getName();
            if (this.newValue instanceof String && !StringUtils.isEmpty((String)((String)this.newValue)) && !(uiModel = this.context.getUiModel()).getNameManager().isUsed((String)this.newValue)) {
                this.adapter.getItem().setName((String)this.newValue);
            }
        } else if ("Label".equals(this.property)) {
            this.oldValue = this.adapter.getItem().getLabel();
            if (this.newValue == null) {
                this.adapter.setLabel("");
            } else {
                this.adapter.setLabel(this.newValue.toString());
            }
        } else if ("label_length".equals(this.property)) {
            this.oldValue = new Integer(this.adapter.getItem().getLabelLength());
            this.adapter.setLabelLength(new Integer(this.newValue.toString()));
        } else if ("horizontalAlignment".equals(this.property)) {
            ComboBoxItem combItem = (ComboBoxItem)this.newValue;
            String value = combItem.getValue().toString();
            this.oldValue = new Integer(item.getHorizontalAlignment());
            this.adapter.setHorizontalAlignment(new Integer(value.toString()));
        } else if ("label_alignment".equals(this.property)) {
            this.oldValue = new Integer(item.getLabelAlignment());
            this.adapter.setLabelAligment(new Integer(this.newValue.toString()));
        } else if ("label_underline".equals(this.property)) {
            this.oldValue = new Boolean(item.isLabelUnderLine());
            this.adapter.setLabelUnderLine(Boolean.valueOf(this.newValue.toString()));
        } else if ("x_pro".equals(this.property)) {
            KDRectangle tmp = new KDRectangle(item.getBounds());
            this.oldValue = new KDRectangle(tmp);
            tmp.setX(new Integer(this.newValue.toString()).intValue());
            this.adapter.setBounds(tmp);
        } else if ("y_pro".equals(this.property)) {
            KDRectangle tmp = new KDRectangle(item.getBounds());
            this.oldValue = new KDRectangle(tmp);
            tmp.setY(new Integer(this.newValue.toString()).intValue());
            this.adapter.setBounds(tmp);
        } else if ("width_pro".equals(this.property)) {
            KDRectangle tmp = new KDRectangle(item.getBounds());
            this.oldValue = new KDRectangle(tmp);
            tmp.setWidth(new Integer(this.newValue.toString()).intValue());
            this.adapter.setBounds(tmp);
        } else if ("height_pro".equals(this.property)) {
            KDRectangle tmp = new KDRectangle(item.getBounds());
            this.oldValue = new KDRectangle(tmp);
            tmp.setHeight(new Integer(this.newValue.toString()).intValue());
            this.adapter.setBounds(tmp);
        } else if ("anchor_pro".equals(this.property)) {
            KDRectangle tmp = new KDRectangle(item.getBounds());
            this.oldValue = new KDRectangle(tmp);
            tmp.setAnchor(new Integer(this.newValue.toString()).intValue());
            this.adapter.setBounds(tmp);
        } else if ("action_pro".equals(this.property)) {
            ComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "action", this.newValue);
        } else if ("Visible".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isVisible());
            this.adapter.getItem().setVisible(Boolean.valueOf(this.newValue.toString()));
            this.adapter.fireProperty("Visible", this.oldValue, this.newValue);
        } else if ("isCommonQueryFilter".equals(this.property)) {
            this.oldValue = new Boolean(item.isCommonQueryFilter());
            item.setCommonQueryFilter(Boolean.valueOf(this.newValue.toString()));
            this.adapter.fireProperty("isCommonQueryFilter", this.oldValue, this.newValue);
        } else if ("Required".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isRequired());
            this.adapter.getItem().setRequired(Boolean.valueOf(this.newValue.toString()));
            this.adapter.fireProperty("Required", this.oldValue, this.newValue);
        } else if ("Enabled".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isEnabled());
            this.adapter.getItem().setEnabled(Boolean.valueOf(this.newValue.toString()));
            this.adapter.fireProperty("Enabled", this.oldValue, this.newValue);
        } else if ("Sum".equals(this.property)) {
            this.oldValue = new Boolean(this.adapter.getItem().isSum());
            this.adapter.getItem().setSum(Boolean.valueOf(this.newValue.toString()));
            this.adapter.fireProperty("Sum", this.oldValue, this.newValue);
        } else if ("DefaultValue".equals(this.property)) {
            this.oldValue = this.adapter.getItem().getDefaultValue();
            this.adapter.getItem().setDefaultValue(this.getDefaultValue());
            this.adapter.fireProperty("DefaultValue", this.oldValue, this.newValue);
        } else if ("colVisible".equals(this.property)) {
            this.colItem = EditUIEditorHelper.getColumnItem(this.adapter, (UictEditPartViewer)this.context.getRootViewer(), false);
            this.oldValue = this.colItem.isVisible();
            this.colItem.setVisible(Boolean.valueOf(this.newValue.toString()));
            EditUIEditorHelper.setColumnInfo(this.adapter, this.colItem);
        } else if ("colFrozen".equals(this.property)) {
            this.colItem = EditUIEditorHelper.getColumnItem(this.adapter, (UictEditPartViewer)this.context.getRootViewer(), Boolean.valueOf(this.newValue.toString()));
            this.oldValue = this.colItem.isFrozen();
            this.colItem.setFrozen(Boolean.valueOf(this.newValue.toString()));
        } else if ("colDefault".equals(this.property)) {
            this.colItem = EditUIEditorHelper.getColumnItem(this.adapter, (UictEditPartViewer)this.context.getRootViewer(), false);
            this.oldValue = this.colItem.getDefaultValue();
            if (this.newValue == null) {
                this.colItem.setDefaultValue("");
            } else {
                this.colItem.setDefaultValue(this.newValue.toString());
            }
        } else if ("displayformat".equals(this.property)) {
            if (item.getColumn() != null && this.newValue instanceof ComboBoxItem) {
                AbstractUIObjectInfo uiModel;
                ComponentInfo table = item.getEntry();
                ColumnInfo column = item.getColumn();
                TableInfo parent = column.getParent();
                if (table == null || parent == null) {
                    logger.info((Object)(this.getClass().getName() + " : get table is null"));
                    return;
                }
                String formatXmlExt = table.getExtendedProperty("extend_formatxml");
                TableInfoHelper.parseFormatXmlExt((TableInfo)parent, (String)formatXmlExt);
                ComboBoxItem combItem = (ComboBoxItem)this.newValue;
                String value = combItem.getValue().toString();
                value = this.parseStrToDisplayField(value);
                column.setExtendedProperty("dataField", value);
                if (this.context != null && (uiModel = this.context.getUiModel()) != null && uiModel instanceof UIObjectInfo) {
                    this.extractTableSumInfo((UIObjectInfo)uiModel, table, parent);
                }
                String formatXMLExt = TableInfoHelper.toFormatXmlExt((TableInfo)parent);
                table.setExtendedProperty("extend_formatxml", formatXMLExt);
                table.setConfigured(true);
            } else {
                ComponentInfo componentInfo = this.adapter.getItem().getComponent();
                if (componentInfo != null && this.newValue instanceof ComboBoxItem && "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(componentInfo.getClassType())) {
                    ComboBoxItem combItem = (ComboBoxItem)this.newValue;
                    String value = combItem.getValue().toString();
                    value = this.parseStrToDisplayField(value);
                    componentInfo.setExtendedProperty("displayFormat", value);
                }
            }
        } else if ("defaultf7uiname".equals(this.property)) {
            if (item.getColumn() != null && item.getEntry() != null) {
                ComponentInfo componentInfo = item.getEntry();
                ColumnInfo columnInfo = item.getColumn();
                this.oldValue = componentInfo.getExtendedProperty("defaultf7uiname");
                if (columnInfo.getName() != null) {
                    String key = "defaultf7uiname." + componentInfo.getName() + "." + columnInfo.getName();
                    if (this.newValue == null || StringUtils.isEmpty((String)this.newValue.toString().trim())) {
                        componentInfo.removeExtendedProperty(key);
                    } else {
                        String f7uiname = this.newValue.toString().trim();
                        componentInfo.setExtendedProperty(key, f7uiname);
                    }
                }
            } else {
                ComponentInfo componentInfo = this.adapter.getItem().getComponent();
                if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(componentInfo.getClassType())) {
                    this.oldValue = componentInfo.getExtendedProperty("defaultf7uiname");
                    String key = "defaultf7uiname";
                    if (this.newValue == null || StringUtils.isEmpty((String)this.newValue.toString().trim())) {
                        componentInfo.removeExtendedProperty(key);
                    } else {
                        String f7uiname = this.newValue.toString().trim();
                        componentInfo.setExtendedProperty(key, f7uiname);
                    }
                }
            }
        } else if ("formatString".equals(this.property)) {
            ComponentInfo componentInfo = this.adapter.getItem().getComponent();
            if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equals(componentInfo.getClassType())) {
                this.oldValue = componentInfo.getExtendedProperty("formatString");
                String key = "formatString";
                if (this.newValue == null || StringUtils.isEmpty((String)this.newValue.toString().trim())) {
                    componentInfo.removeExtendedProperty(key);
                } else {
                    componentInfo.setExtendedProperty(key, this.newValue.toString().trim());
                }
            }
        } else if ("f7FilterItem".equals(this.property)) {
            ComponentInfo componentInfo = this.adapter.getItem().getComponent();
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equals(componentInfo.getClassType())) {
                String key = "f7FilterItem";
                this.oldValue = componentInfo.getExtendedProperty(key);
                if (this.newValue == null || StringUtils.isEmpty((String)this.newValue.toString().trim())) {
                    componentInfo.removeExtendedProperty(key);
                } else {
                    componentInfo.setExtendedProperty(key, this.newValue.toString().trim());
                }
            }
        } else if ("maxLength".equals(this.property)) {
            this.oldValue = new Integer(item.getMaxLength());
            item.setMaxLength(Integer.parseInt(this.newValue.toString()));
            ComponentInfo component = item.getComponent();
            PropertyInfo prop = component.getPropertyByName("maxLength");
            if (prop != null) {
                prop.setValue(this.newValue.toString());
            }
        }
    }

    private void extractTableSumInfo(UIObjectInfo uiObject, ComponentInfo tableControl, TableInfo tableInfo) {
        List columns = tableInfo.getColumns();
        int m = columns.size();
        for (int j = 0; j < m; ++j) {
            ColumnInfo column = (ColumnInfo)columns.get(j);
            com.kingdee.bos.metadata.entity.PropertyInfo property = EditUIProxyHelper.getColumnBindProperty((UIObjectInfo)uiObject, (ComponentInfo)tableControl, (String)column.getName(), (boolean)true);
            if (!ConvertUtils.getExtendedPropertyBooelanValue((IObjectValue)property, (String)"needSum")) continue;
            column.setExtendedProperty("needSum", Boolean.TRUE.toString());
        }
    }

    @Override
    public void undo() {
        if ("Name".equals(this.property)) {
            if (this.oldValue instanceof String && !StringUtils.isEmpty((String)((String)this.oldValue))) {
                this.adapter.getItem().setName((String)this.oldValue);
            }
        } else if ("Label".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.setLabel("");
            } else {
                this.adapter.setLabel(this.oldValue.toString());
            }
        } else if ("label_length".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.setLabelLength(-1);
            } else {
                this.adapter.setLabelLength(Integer.valueOf(this.oldValue.toString()));
            }
        } else if ("label_alignment".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.setLabelAligment(7);
            } else {
                this.adapter.setLabelAligment(new Integer(this.oldValue.toString()));
            }
        } else if ("x_pro".equals(this.property) || "y_pro".equals(this.property) || "width_pro".equals(this.property) || "height_pro".equals(this.property) || "anchor_pro".equals(this.property)) {
            this.adapter.setBounds((KDRectangle)this.oldValue);
        } else if ("label_underline".equals(this.property)) {
            this.adapter.setLabelUnderLine((Boolean)this.oldValue);
            this.adapter.fireProperty("label_underline", this.oldValue, this.newValue);
        } else if ("action_pro".equals(this.property)) {
            ComponentHelper.setPropertyValue(this.adapter.getItem().getComponent(), "action", this.oldValue);
        } else if ("Visible".equals(this.property)) {
            this.adapter.getItem().setVisible((Boolean)this.oldValue);
            this.adapter.fireProperty("Visible", this.oldValue, this.newValue);
        } else if ("Required".equals(this.property)) {
            this.adapter.getItem().setRequired((Boolean)this.oldValue);
            this.adapter.fireProperty("Required", this.oldValue, this.newValue);
        } else if ("Enabled".equals(this.property)) {
            this.adapter.getItem().setEnabled((Boolean)this.oldValue);
            this.adapter.fireProperty("Enabled", this.oldValue, this.newValue);
        } else if ("Sum".equals(this.property)) {
            this.adapter.getItem().setSum((Boolean)this.oldValue);
            this.adapter.fireProperty("Sum", this.oldValue, this.newValue);
        } else if ("DefaultValue".equals(this.property)) {
            if (this.oldValue == null) {
                this.adapter.getItem().setDefaultValue(null);
            } else {
                this.adapter.getItem().setDefaultValue(this.oldValue.toString());
            }
            this.adapter.fireProperty("DefaultValue", this.oldValue, this.newValue);
        } else if ("colVisible".equals(this.property)) {
            this.colItem.setVisible(Boolean.valueOf(this.oldValue.toString()));
            EditUIEditorHelper.setColumnInfo(this.adapter, this.colItem);
        } else if ("colFrozen".equals(this.property)) {
            this.colItem.setFrozen(Boolean.valueOf(this.oldValue.toString()));
        } else if ("colDefault".equals(this.property)) {
            if (this.oldValue == null) {
                this.colItem.setDefaultValue("");
            } else {
                this.colItem.setDefaultValue(this.oldValue.toString());
            }
        } else if ("maxLength".equals(this.property)) {
            BizConfigureItemInfo item = (BizConfigureItemInfo)this.adapter.getItem();
            item.setMaxLength(Integer.parseInt(this.oldValue.toString()));
            ComponentInfo component = item.getComponent();
            PropertyInfo prop = component.getPropertyByName("maxLength");
            if (prop != null) {
                prop.setValue(this.oldValue.toString());
            }
        }
    }

    private String getDefaultValue() {
        DataSourceEnum dstype = this.adapter.getItem().getDataSourceType();
        BizDataTypeEnum dtype = this.adapter.getItem().getDataType();
        if (DataSourceEnum.SELF.equals((Object)dstype) || DataSourceEnum.BASEDATAEXT.equals((Object)dstype) ? BizDataTypeEnum.DATE.equals((Object)dtype) : DataSourceEnum.BASEDATA.equals((Object)dstype)) {
            return this.cellDisplayText;
        }
        return this.newValue.toString();
    }

    public String parseStrToDisplayField(String sDisField) {
        if (StringUtils.isEmpty((String)sDisField)) {
            return "$number$";
        }
        String strFirst = "";
        String strLeft = "";
        String strSecond = "";
        String strRight = "";
        String strTemp = "";
        String sDisplayFormat = "";
        int iPos = sDisField.indexOf("+");
        if (iPos > 0) {
            strFirst = sDisField.substring(0, iPos).trim();
            strTemp = sDisField.substring(iPos + 2);
            sDisplayFormat = "$" + strFirst + "$";
            if (sDisField.trim().length() > iPos && strTemp.trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                strLeft = strTemp.substring(0, iPos);
                strLeft = strLeft.replaceAll("\"", "");
                sDisplayFormat = sDisplayFormat + strLeft;
                if (strTemp.trim().length() > iPos + 1 && (strTemp = strTemp.substring(iPos + 2)).trim().length() > 0 && (iPos = strTemp.indexOf("+")) > 0) {
                    strSecond = strTemp.substring(0, iPos);
                    sDisplayFormat = sDisplayFormat + "$" + strSecond.trim() + "$";
                    if (strTemp.length() > iPos + 1) {
                        strRight = strTemp.substring(iPos + 2);
                        strRight = strRight.replaceAll("\"", "");
                        sDisplayFormat = sDisplayFormat + strRight;
                    }
                }
            }
        } else {
            strFirst = sDisField.trim();
            sDisplayFormat = "$" + strFirst + "$";
        }
        return sDisplayFormat;
    }
}

