/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ElementProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.util.PropertyUtil;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import org.apache.log4j.Logger;

public class RelengthCommand
extends Command {
    private static final Logger logger = CoreUIObject.getLogger(RelengthCommand.class);
    private AbstractBizConfigureItemInfo item;
    private Context context;
    private int newValue;
    private int oldValue;
    private String oldScaleValue;
    private String oldMaxlengthValue;

    public RelengthCommand(AbstractBizConfigureItemInfo item, Context context, int newValue) {
        this.item = item;
        this.context = context;
        this.newValue = newValue;
    }

    @Override
    public void execute() {
        this.backupOldName(this.item);
        try {
            this.doRelength(this.item, this.context, this.newValue);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.undo();
        }
    }

    private void doRelength(AbstractBizConfigureItemInfo item, Context context, int newValue) throws BOSException {
        item.setLength(newValue);
        item.setPrecision(newValue);
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        if (property != null) {
            this.relengthProperty(context, property, newValue);
            this.relengthColumnInfo(context, property, newValue);
            this.remaxlengthProperty(newValue);
        }
    }

    private void relengthProperty(Context context, com.kingdee.bos.metadata.entity.PropertyInfo property, int len) {
        if (property != null && property.isConfigured()) {
            IUIEditor eidtor = context.getEditorUI();
            EntityObjectInfo entity = eidtor.getModel().getEntity();
            this.setLength((AbstractMDValue)property, len);
            if (this.item.getComponent() != null && "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(this.item.getComponent().getClassType())) {
                if (((OwnPropertyInfo)property).getDecimalDigits() >= len) {
                    this.oldScaleValue = String.valueOf(((OwnPropertyInfo)property).getDecimalDigits());
                    this.item.setScale(len - 1);
                    PropertyUtil.setScale((AbstractMDValue)property, "decimalDigits", len - 1);
                    PropertyUtil.reprecisionValueProperty(this.item, len - 1);
                } else if (this.oldScaleValue != null) {
                    this.item.setScale(Integer.parseInt(this.oldScaleValue));
                    PropertyUtil.setScale((AbstractMDValue)property, "decimalDigits", Integer.parseInt(this.oldScaleValue));
                    PropertyUtil.reprecisionValueProperty(this.item, Integer.parseInt(this.oldScaleValue));
                }
                PropertyUtil.renumValueProperty(this.item);
            }
            entity.getProperties().updateIndex();
            this.firePropertyChanged("entity");
        }
    }

    private void firePropertyChanged(String type) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.context.get("AddFiledPorcessingInit");
        AddFiledProcessing processing = init.initialize();
        processing.getProcessor(type);
    }

    private void setLength(AbstractMDValue md, int len) {
        if (md != null) {
            IStateManager stateManager = md.getStateManager();
            if (stateManager instanceof ElementProxyStateManager) {
                IStateManager delegate = ((ElementProxyStateManager)stateManager).getDelegate();
                md.setStateManager(delegate);
            }
            md.setInt("length", len);
            md.setInt("precision", len);
        }
    }

    private void relengthColumnInfo(Context context, com.kingdee.bos.metadata.entity.PropertyInfo property, int newValue) throws BOSException {
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        ColumnInfo mappingField = property.getMappingField();
        DataTableInfo tableInfo = PropertyUtil.getTableInfo(context);
        if (tableInfo != null && mappingField != null && !instance.exists(tableInfo.getName(), mappingField.getName())) {
            this.relengthColumnInfo(tableInfo, property, mappingField, newValue);
        }
    }

    private void relengthColumnInfo(DataTableInfo table, com.kingdee.bos.metadata.entity.PropertyInfo property, ColumnInfo mappingField, int newValue) {
        if (property != null && mappingField != null) {
            ColumnInfo columnInfo = table.getColumnByName(mappingField.getName());
            this.setLength((AbstractMDValue)mappingField, newValue);
            this.setLength((AbstractMDValue)columnInfo, newValue);
            if (this.item.getComponent() != null && "com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(this.item.getComponent().getClassType())) {
                if (columnInfo.getScale() >= newValue) {
                    PropertyUtil.setScale((AbstractMDValue)mappingField, "scale", newValue - 1);
                    PropertyUtil.setScale((AbstractMDValue)columnInfo, "scale", newValue - 1);
                } else if (this.oldScaleValue != null) {
                    PropertyUtil.setScale((AbstractMDValue)mappingField, "scale", Integer.parseInt(this.oldScaleValue));
                    PropertyUtil.setScale((AbstractMDValue)columnInfo, "scale", Integer.parseInt(this.oldScaleValue));
                }
            }
            table.getColumns().updateIndex();
        }
    }

    private void remaxlengthProperty(int newValue) {
        BizConfigureItemInfo item = (BizConfigureItemInfo)this.item;
        ComponentInfo component = item.getComponent();
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        PropertyInfo prop = component.getPropertyByName("maxLength");
        if (prop != null && Integer.parseInt(prop.getValue()) > ((OwnPropertyInfo)property).getLength()) {
            this.oldMaxlengthValue = prop.getValue();
            prop.setValue(String.valueOf(newValue));
            item.setMaxLength(newValue);
        } else if (prop != null && this.oldMaxlengthValue != null) {
            prop.setValue(this.oldMaxlengthValue);
            item.setMaxLength(Integer.parseInt(this.oldMaxlengthValue));
        }
    }

    private void backupOldName(AbstractBizConfigureItemInfo item) {
        this.oldValue = this.getPropertyValue(item);
    }

    private int getPropertyValue(AbstractBizConfigureItemInfo item) {
        int oldValue = 0;
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        oldValue = property != null ? ((OwnPropertyInfo)property).getLength() : item.getLength();
        return oldValue;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        try {
            this.doRelength(this.item, this.context, this.oldValue);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

