/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ElementProxyStateManager;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.ui.dtp.model.ComponentNameManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.util.ComponentHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.util.PropertyUtil;
import com.kingdee.eas.ep.client.editor.entity.TableSynchronizer;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.ep.client.util.ListVisibleTool;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class RenameCommand
extends Command {
    private static final Logger logger = CoreUIObject.getLogger(RenameCommand.class);
    private AbstractBizConfigureItemInfo item;
    private Context context;
    private String newName;
    private String oldName;

    public RenameCommand(AbstractBizConfigureItemInfo item, Context context, String newName) {
        this.item = item;
        this.context = context;
        this.newName = newName;
    }

    @Override
    public void execute() {
        this.backupOldName(this.item);
        try {
            this.doRename(this.item, this.context, this.newName);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.undo();
        }
    }

    private void doRename(AbstractBizConfigureItemInfo item, Context context, String newName) throws BOSException {
        this.resetListUI(item, context);
        this.resetEditUI(item, context, newName);
    }

    private void resetEditUI(AbstractBizConfigureItemInfo item, Context context, String newName) throws BOSException {
        String oldName = this.getPropertyName(item);
        this.renameComponent(item, context, newName);
        PropertyInfo property = item.getProperty();
        if (property != null) {
            this.renameProperty(context, property, newName);
            this.renameColumnInfo(context, property, newName);
            this.renameDataBind(item.getComponent(), oldName, property);
        }
    }

    private void renameColumnInfo(Context context, PropertyInfo property, String newName) throws BOSException {
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        ColumnInfo mappingField = property.getMappingField();
        DataTableInfo tableInfo = PropertyUtil.getTableInfo(context);
        if (tableInfo != null && mappingField != null && !instance.exists(tableInfo.getName(), mappingField.getName())) {
            this.renameColumnInfo(tableInfo, property, mappingField, newName);
        }
    }

    private void resetListUI(AbstractBizConfigureItemInfo item, Context context) {
        BizUnitInfo bizUnit = context.getEditorUI().getModel();
        ListVisibleTool tool = new ListVisibleTool(context, bizUnit, (BizConfigureItemInfo)item);
        if (tool.isListVisible()) {
            tool.setListVisible(false);
        }
    }

    private void renameComponent(AbstractBizConfigureItemInfo item, Context context, String newName) {
        ComponentInfo component = item.getComponent();
        if (component != null && component.isConfigured()) {
            this.renameComponent(context, component, newName, item);
            ComponentInfo roundedComponent = EditUIEditorHelper.getRoundedComponent(component);
            if (EditUIEditorHelper.isLabelContainer(roundedComponent)) {
                this.renameComponent(context, roundedComponent, newName, item);
            }
            item.setControlName(component.getName());
            item.setName(component.getName());
        }
    }

    private void backupOldName(AbstractBizConfigureItemInfo item) {
        this.oldName = this.getPropertyName(item);
    }

    private String getPropertyName(AbstractBizConfigureItemInfo item) {
        String oldName = "";
        PropertyInfo property = item.getProperty();
        oldName = property != null ? property.getName() : item.getName();
        return oldName;
    }

    private void renameComponent(Context context, ComponentInfo component, String name, AbstractBizConfigureItemInfo item) {
        String old = component.getName();
        String classType = component.getClassType();
        if (item.getProperty() != null) {
            String prefix = ComponentHelper.getPrefix(classType);
            name = prefix + name;
        }
        ComponentNameManager nameManager = this.getNameManager(context);
        String nameByTypeAndName = nameManager.getNameByTypeAndName(name, classType);
        this.setName((AbstractMDValue)component, nameByTypeAndName);
        nameManager.remove(old);
    }

    private void renameProperty(Context context, PropertyInfo property, String name) {
        if (property != null && property.isConfigured()) {
            IUIEditor eidtor = context.getEditorUI();
            EntityObjectInfo entity = eidtor.getModel().getEntity();
            String propertyName = this.getName(entity, name);
            this.setName((AbstractMDValue)property, propertyName);
            entity.getProperties().updateIndex();
            MutiLanUtil.setAlias(property, name);
            if (property instanceof LinkPropertyInfo) {
                RelationshipInfo relationship = ((LinkPropertyInfo)property).getRelationship();
                this.renameRelationship(relationship, propertyName);
            }
            this.firePropertyChanged("entity");
        }
    }

    private String getName(EntityObjectInfo entity, String suggestName) {
        String name = suggestName;
        for (int i = 0; i < Integer.MAX_VALUE && entity.getPropertyByName(name) != null; ++i) {
            name = suggestName + i;
        }
        return name;
    }

    private String getName(DataTableInfo table, String suggestName) {
        String name = suggestName;
        for (int i = 0; i < Integer.MAX_VALUE && table.getColumnByName(suggestName) != null; ++i) {
            name = suggestName + i;
        }
        return name;
    }

    private void renameRelationship(RelationshipInfo relationship, String name) {
        EntityObjectInfo clientObject = relationship.getClientObject();
        EntityObjectInfo supplierObject = relationship.getSupplierObject();
        String relationName = "R_" + clientObject.getName() + "_" + supplierObject.getName() + "_" + name;
        this.setName((AbstractMDValue)relationship, relationName);
    }

    private void renameColumnInfo(DataTableInfo table, PropertyInfo property, ColumnInfo mappingField, String name) throws BOSException {
        if (property != null && mappingField != null) {
            if (property instanceof LinkPropertyInfo) {
                name = StringUtils.headCharUpperCase((String)name) + "ID";
            }
            ColumnInfo columnInfo = table.getColumnByName(mappingField.getName());
            String columnName = TableSynchronizer.generateColumnName(name, table);
            this.setName((AbstractMDValue)mappingField, columnName);
            this.setName((AbstractMDValue)columnInfo, columnName);
            table.getColumns().updateIndex();
        }
    }

    private void setName(AbstractMDValue md, String name) {
        if (md != null) {
            IStateManager stateManager = md.getStateManager();
            if (stateManager instanceof ElementProxyStateManager) {
                IStateManager delegate = ((ElementProxyStateManager)stateManager).getDelegate();
                md.setStateManager(delegate);
            }
            md.setString("name", name);
        }
    }

    private void renameDataBind(ComponentInfo component, String oldName, PropertyInfo property) {
        PropertyBindingCollection propertyBindings = component.getPropertyBindings();
        PropertyBindingInfo bindingInfo = null;
        for (int i = 0; i < propertyBindings.size(); ++i) {
            PropertyBindingInfo info = propertyBindings.get(i);
            if (!oldName.equals(info.getBingdingField())) continue;
            bindingInfo = info;
        }
        if (bindingInfo != null) {
            bindingInfo.setBingdingField(property.getName());
            propertyBindings.updateIndex();
        }
    }

    private boolean canRename(EntityObjectInfo entity, PropertyInfo property) {
        String name;
        PropertyInfo propertyByName;
        return entity != null && property != null && property.isConfigured() && (propertyByName = entity.getPropertyByName(name = property.getName())) == null;
    }

    private boolean canRename(DataTableInfo table, ColumnInfo mappingField) {
        String name;
        ColumnInfo columnByName;
        return table != null && mappingField != null && (columnByName = table.getColumnByName(name = mappingField.getName())) == null;
    }

    private void firePropertyChanged(String type) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.context.get("AddFiledPorcessingInit");
        AddFiledProcessing processing = init.initialize();
        processing.getProcessor(type);
    }

    private ComponentNameManager getNameManager(Context context) {
        AbstractUIObjectInfo uiModel = context.getUiModel();
        return uiModel.getNameManager();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        try {
            this.doRename(this.item, this.context, this.oldName);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

