/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.client.editor.addfiled.AddFiledProcessing;
import com.kingdee.eas.ep.client.editor.editui.designer.Context;
import com.kingdee.eas.ep.client.editor.editui.designer.IUIEditor;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.util.PropertyUtil;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import org.apache.log4j.Logger;

public class RescaleCommand
extends Command {
    private static final Logger logger = CoreUIObject.getLogger(RescaleCommand.class);
    private AbstractBizConfigureItemInfo item;
    private Context context;
    private int newValue;
    private int oldValue;

    public RescaleCommand(AbstractBizConfigureItemInfo item, Context context, int newValue) {
        this.item = item;
        this.context = context;
        this.newValue = newValue;
    }

    @Override
    public void execute() {
        this.backupOldValue(this.item);
        try {
            this.doRescale(this.item, this.context, this.newValue);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            this.undo();
        }
    }

    private void doRescale(AbstractBizConfigureItemInfo item, Context context, int newValue) throws BOSException {
        item.setScale(newValue);
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        if (property != null) {
            this.rescaleProperty(context, property, newValue);
            this.rescaleColumnInfo(context, property, newValue);
        }
    }

    private void rescaleProperty(Context context, com.kingdee.bos.metadata.entity.PropertyInfo property, int scale) {
        if (property != null && property.isConfigured()) {
            IUIEditor eidtor = context.getEditorUI();
            EntityObjectInfo entity = eidtor.getModel().getEntity();
            PropertyUtil.setScale((AbstractMDValue)property, "decimalDigits", scale);
            PropertyUtil.reprecisionValueProperty(this.item, scale);
            PropertyUtil.renumValueProperty(this.item);
            entity.getProperties().updateIndex();
            this.firePropertyChanged("entity");
        }
    }

    private void firePropertyChanged(String type) {
        AddFiledProcessing.ProcessingInit init = (AddFiledProcessing.ProcessingInit)this.context.get("AddFiledPorcessingInit");
        AddFiledProcessing processing = init.initialize();
        processing.getProcessor(type);
    }

    private void rescaleColumnInfo(Context context, com.kingdee.bos.metadata.entity.PropertyInfo property, int newValue) throws BOSException {
        IUpdateSql instance = UpdateSqlFactory.getRemoteInstance();
        ColumnInfo mappingField = property.getMappingField();
        DataTableInfo tableInfo = PropertyUtil.getTableInfo(context);
        if (tableInfo != null && mappingField != null && !instance.exists(tableInfo.getName(), mappingField.getName())) {
            this.rescaleColumnInfo(tableInfo, property, mappingField, newValue);
        }
    }

    private void rescaleColumnInfo(DataTableInfo table, com.kingdee.bos.metadata.entity.PropertyInfo property, ColumnInfo mappingField, int newValue) throws BOSException {
        if (property != null && mappingField != null) {
            ColumnInfo columnInfo = table.getColumnByName(mappingField.getName());
            PropertyUtil.setScale((AbstractMDValue)mappingField, "scale", newValue);
            PropertyUtil.setScale((AbstractMDValue)columnInfo, "scale", newValue);
            table.getColumns().updateIndex();
        }
    }

    private void reprecisionValueProperty(int newValue) {
        ComponentInfo component = this.item.getComponent();
        PropertyInfo prop = component.getPropertyByName("precision");
        if (prop != null) {
            prop.setValue(String.valueOf(newValue));
        }
    }

    private void backupOldValue(AbstractBizConfigureItemInfo item) {
        this.oldValue = this.getPropertyValue(item);
    }

    private int getPropertyValue(AbstractBizConfigureItemInfo item) {
        int oldValue = 0;
        com.kingdee.bos.metadata.entity.PropertyInfo property = item.getProperty();
        oldValue = property != null ? ((OwnPropertyInfo)property).getDecimalDigits() : item.getScale();
        return oldValue;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        try {
            this.doRescale(this.item, this.context, this.oldValue);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

