/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.commands;

import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.layout.KDRectangle;
import com.kingdee.eas.ep.client.editor.editui.designer.UictEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.commands.Command;
import com.kingdee.eas.ep.client.editor.editui.designer.model.BizConfigureItemInfoAdapter;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;

public class UIConstraintCommand
extends Command {
    private UictEditPartViewer viewer;
    private String property;
    private ComponentInfo mainPanel;
    private Object newConstraint;
    private Object oldConstraint;
    private Object size;
    private BizConfigureItemInfoAdapter adapter;

    public UIConstraintCommand(String property, UictEditPartViewer viewer, Object size) {
        this.property = property;
        this.viewer = viewer;
        this.size = size;
    }

    @Override
    public boolean canExecute() {
        try {
            new Integer(this.size.toString());
        }
        catch (Exception e) {
            return false;
        }
        if (!"width_pro".equals(this.property) && !"height_pro".equals(this.property)) {
            return false;
        }
        if (this.mainPanel == null) {
            this.mainPanel = (ComponentInfo)this.viewer.getNode().getUserObject();
        }
        if (EditUIEditorHelper.isXYOrKDLayout(this.mainPanel)) {
            this.oldConstraint = this.mainPanel.getConstraint();
            if (this.oldConstraint == null || this.oldConstraint instanceof String && StringUtils.isEmpty((String)this.oldConstraint.toString())) {
                this.oldConstraint = new Rectangle(0, 0, 800, 600);
            }
            if (this.oldConstraint instanceof Rectangle) {
                Rectangle rect = (Rectangle)this.oldConstraint;
                this.newConstraint = new Rectangle(rect);
                if ("width_pro".equals(this.property)) {
                    ((Rectangle)this.newConstraint).width = new Integer(this.size.toString());
                } else if ("height_pro".equals(this.property)) {
                    ((Rectangle)this.newConstraint).height = new Integer(this.size.toString());
                }
            } else if (this.oldConstraint instanceof KDLayoutConstraint) {
                KDLayoutConstraint kd = (KDLayoutConstraint)this.oldConstraint;
                this.newConstraint = new KDLayoutConstraint(kd);
                if ("width_pro".equals(this.property)) {
                    ((KDLayoutConstraint)this.newConstraint).width = new Integer(this.size.toString());
                } else if ("height_pro".equals(this.property)) {
                    ((KDLayoutConstraint)this.newConstraint).height = new Integer(this.size.toString());
                }
            }
            return true;
        }
        return false;
    }

    public void setTarget(BizConfigureItemInfoAdapter adapter) {
        this.adapter = adapter;
        this.mainPanel = adapter.getItem().getComponent();
    }

    @Override
    public void execute() {
        this.resetComponent(this.newConstraint);
        this.resetItem(this.newConstraint);
        this.viewer.repaint();
    }

    private void resetItem(Object constraint) {
        Object rect = constraint;
        if (rect instanceof KDLayoutConstraint) {
            rect = ((KDLayoutConstraint)this.newConstraint).toRectangle();
        }
        if (rect instanceof Rectangle) {
            KDRectangle tmp = new KDRectangle((Rectangle)rect);
            this.adapter.setBounds(tmp);
        }
    }

    private void resetComponent(Object constraint) {
        this.mainPanel.setConstraint(constraint);
        if (this.mainPanel.isHerited()) {
            this.mainPanel.setOverrideConstraint(true);
        }
    }

    @Override
    public void undo() {
        this.resetComponent(this.oldConstraint);
        this.resetItem(this.oldConstraint);
        this.viewer.repaint();
    }
}

