/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.bizrule.common.EventType;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.RuleTypeEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractBizConfigEventDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleCalculateTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleLinkPropTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RulePrecisionTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleSetPropTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.RuleValidateTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizUictFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventHandler;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventRuleManager;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.ITreeContentProvider;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.UictEvent;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureEventCollection;
import com.kingdee.eas.ep.client.model.BizConfigureEventInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BizConfigEventDialog
extends AbstractBizConfigEventDialog {
    private static final Logger logger = CoreUIObject.getLogger(BizConfigEventDialog.class);
    private AbstractBizConfigureItemInfo bizConfigureItemInfo = null;
    private BizUnitInfo bizUnitInfo = null;
    private BizFieldInfo bizField = null;
    private IObjectValue bizFieldOwner = null;
    private IEventRuleManager bizEventRuleManager = null;
    private Map ruleType2ClassNameMap = null;
    private boolean isModify = false;
    private BizConfigureEventInfo oldEventInfo = null;
    private int ruleCount = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.pnlCondition.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 85, 800, 230));
        this.pnlHandler.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 316, 800, 250));
        this.bizUnitInfo = (BizUnitInfo)this.getUIContext().get("BizUnitInfo");
        this.bizField = (BizFieldInfo)this.getUIContext().get("BizFieldInfo");
        this.bizFieldOwner = (IObjectValue)this.getUIContext().get("BizFieldOwner");
        this.bizConfigureItemInfo = (AbstractBizConfigureItemInfo)this.getUIContext().get("BizConfigureItemInfo");
        this.isModify = (Boolean)this.getUIContext().get("isModify");
        BizUictFactory.createOperationPanel(this.pnlCalculator, this.getEventRuleManager(), true);
        new RuleConditionTreeHelper(this.getEventRuleManager()).initFieldsTree(this.treeFields, this.bizUnitInfo, 3);
        this.getEventRuleManager().registerStyledRuleEditor((Component)this.txtPaneCondition);
        this.init();
        this.radioBtnSaveEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BizConfigEventDialog.this.radioBtnEvent_actionPerformed(e);
                }
                catch (Exception exc) {
                    BizConfigEventDialog.this.handUIException(exc);
                }
            }
        });
        this.radioBtnUpdateEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BizConfigEventDialog.this.radioBtnEvent_actionPerformed(e);
                }
                catch (Exception exc) {
                    BizConfigEventDialog.this.handUIException(exc);
                }
            }
        });
        this.radioBtnInitialEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BizConfigEventDialog.this.radioBtnEvent_actionPerformed(e);
                }
                catch (Exception exc) {
                    BizConfigEventDialog.this.handUIException(exc);
                }
            }
        });
    }

    protected void radioBtnEvent_actionPerformed(ActionEvent e) throws Exception {
        if (this.isModify()) {
            return;
        }
        RuleTypeEnum rte = (RuleTypeEnum)((Object)this.cmbRuleType.getItemAt(0));
        if (e.getSource() == this.radioBtnSaveEvent) {
            if (rte.getValue().equalsIgnoreCase("1")) {
                this.cmbRuleType.removeItemAt(0);
            }
        } else if (e.getSource() == this.radioBtnUpdateEvent) {
            if (!rte.getValue().equalsIgnoreCase("1")) {
                this.cmbRuleType.insertItemAt((Object)RuleTypeEnum.CALCULATE, 0);
            }
        } else if (e.getSource() == this.radioBtnInitialEvent && !rte.getValue().equalsIgnoreCase("1")) {
            this.cmbRuleType.insertItemAt((Object)RuleTypeEnum.CALCULATE, 0);
        }
    }

    public IEventRuleManager getEventRuleManager() {
        if (this.bizEventRuleManager == null) {
            this.bizEventRuleManager = (IEventRuleManager)BizUictFactory.createInstanceFromClass(BizUictFactory.BIZ_RULE_MANAGER);
        }
        return this.bizEventRuleManager;
    }

    private void init() {
        if (this.isModify()) {
            this.oldEventInfo = (BizConfigureEventInfo)((Object)this.getUIContext().get("BIZ_CONFIG_EVENT_INFO"));
            this.setEventType(this.oldEventInfo.getEventType());
            this.txtRuleName.setText(this.oldEventInfo.getRuleName());
            this.txtRuleName.setEnabled(false);
            this.setUseCondition(this.oldEventInfo.isUseCondition());
            String ruleType = this.oldEventInfo.getRuleType();
            this.cmbRuleType.setSelectedItem(RuleTypeEnum.getEnumMap().get(ruleType));
            this.cmbRuleType.setEnabled(false);
            IEventHandler eventhandler = null;
            if (this.oldEventInfo.isUseCondition()) {
                this.getEventRuleManager().parseExpression(this.bizUnitInfo, this.oldEventInfo.getCondition());
                this.getEventRuleManager().setRules(this.oldEventInfo.getCondition());
                eventhandler = (IEventHandler)((Object)this.getFirstHandleTab());
                eventhandler.setActions(this.oldEventInfo.getActions());
                eventhandler = (IEventHandler)((Object)this.getSecondHandleTab());
                eventhandler.setActions(this.oldEventInfo.getExceptionActions());
            } else {
                eventhandler = (IEventHandler)((Object)this.getFirstHandleTab());
                eventhandler.setActions(this.oldEventInfo.getActions());
            }
            String oprtState = (String)this.getUIContext().get("OPRT_STATE");
            if ("VIEW".equals(oprtState)) {
                this.disableComponent();
            }
        } else {
            this.ruleCount = (Integer)this.getUIContext().get("EVENT_RULE_COUNT");
            this.setUseCondition(true);
            this.cmbRuleType.setSelectedItem((Object)RuleTypeEnum.CALCULATE);
        }
    }

    private void disableComponent() {
        this.disableAllComponet((Container)this.pnlEventTypeButton);
        this.disableAllComponet((Container)this.pnlUseCondition);
        if (this.useCondition()) {
            this.disableAllComponet((Container)this.pnlCondition);
            this.disableAllComponet((Container)this.getFirstHandleTab());
            this.disableAllComponet((Container)this.getSecondHandleTab());
        } else {
            this.disableAllComponet((Container)this.getFirstHandleTab());
        }
    }

    private void disableAllComponet(Container parent) {
        if (parent == null) {
            return;
        }
        Component[] components = parent.getComponents();
        int m = components.length;
        for (int i = 0; i < m; ++i) {
            components[i].setEnabled(false);
            if (!(components[i] instanceof Container)) continue;
            this.disableAllComponet((Container)components[i]);
        }
    }

    private void setUseCondition(boolean useCondition) {
        this.radioBtnUseCondition.setSelected(useCondition);
        this.radioBtnUnUseCondition.setSelected(!useCondition);
    }

    private final boolean isModify() {
        return this.isModify;
    }

    @Override
    protected void cmbRuleType_actionPerformed(ActionEvent e) throws Exception {
        this.refactUI(false);
    }

    private void refactUI(boolean copyAction) throws Exception {
        String selectedRuleType = this.getSelectedRuleType();
        String tabClassName = this.getTabClassNameMapByRuleType(selectedRuleType);
        List actions = null;
        if (this.getFirstHandleTab() != null) {
            actions = ((IEventHandler)((Object)this.getFirstHandleTab())).getActions();
        }
        this.tabPaneHandler.removeAll();
        if (this.useCondition()) {
            this.createTabByClassName(BizConfigRes.getString("BizConfigureEventDialog.SET_WHEN_CONDITION_IS_TRUE"), tabClassName);
            this.createTabByClassName(BizConfigRes.getString("BizConfigureEventDialog.SET_WHEN_CONDITION_IS_FALSE"), tabClassName);
        } else {
            this.createTabByClassName(BizConfigRes.getString("BizConfigureEventDialog.SETTING"), tabClassName);
        }
        if (copyAction && actions != null) {
            ((IEventHandler)((Object)this.getFirstHandleTab())).setActions(actions);
        }
        this.refreshUIWhenUseConditionChanged();
        this.initRuleName(selectedRuleType);
    }

    private void createTabByClassName(String tabTitle, String tabClassName) throws Exception {
        Class<?> tabClass = Class.forName(tabClassName);
        CoreUIObject coreUIObject = (CoreUIObject)tabClass.newInstance();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("BizUnitInfo", this.bizUnitInfo);
        values.put("BizUnitInfo", this.bizUnitInfo);
        values.put("OPRT_STATE", this.getUIContext().get("OPRT_STATE"));
        values.put("BizFieldOwner", this.bizFieldOwner);
        values.put("BizFieldInfo", this.bizField);
        coreUIObject.setUserObject(values);
        coreUIObject.initLayout();
        coreUIObject.onLoad();
        this.tabPaneHandler.addTab(tabTitle, (Component)coreUIObject);
    }

    private String getTabClassNameMapByRuleType(String ruleType) {
        if (this.ruleType2ClassNameMap == null) {
            this.ruleType2ClassNameMap = new HashMap();
            this.ruleType2ClassNameMap.put(RuleTypeEnum.CALCULATE.getName(), RuleCalculateTab.class.getName());
            this.ruleType2ClassNameMap.put(RuleTypeEnum.LINK_PROPERTY.getName(), RuleLinkPropTab.class.getName());
            this.ruleType2ClassNameMap.put(RuleTypeEnum.SET_PRECISION.getName(), RulePrecisionTab.class.getName());
            this.ruleType2ClassNameMap.put(RuleTypeEnum.SET_FIELD_PROPERTY.getName(), RuleSetPropTab.class.getName());
            this.ruleType2ClassNameMap.put(RuleTypeEnum.VALIDATE.getName(), RuleValidateTab.class.getName());
        }
        return (String)this.ruleType2ClassNameMap.get(ruleType);
    }

    private String getSelectedRuleType() {
        Object obj = this.cmbRuleType.getSelectedItem();
        if (obj != null && obj instanceof StringEnum) {
            String funcType = ((StringEnum)obj).getName();
            return funcType;
        }
        return null;
    }

    private void initRuleName(String selectedValue) {
        if (!this.isModify()) {
            String ruleAlias = this.createRuleInfoName(this.bizConfigureItemInfo);
            if (RuleTypeEnum.CALCULATE.getName().equals(selectedValue)) {
                this.txtRuleName.setText("Calculate" + ruleAlias);
            } else if (RuleTypeEnum.LINK_PROPERTY.getName().equals(selectedValue)) {
                this.txtRuleName.setText("LinkProp" + ruleAlias);
            } else if (RuleTypeEnum.SET_FIELD_PROPERTY.getName().equals(selectedValue)) {
                this.txtRuleName.setText("SetProp" + ruleAlias);
            } else if (RuleTypeEnum.VALIDATE.getName().equals(selectedValue)) {
                this.txtRuleName.setText("Validate" + ruleAlias);
            } else if (RuleTypeEnum.SET_PRECISION.getName().equals(selectedValue)) {
                this.txtRuleName.setText("SetPrecision" + ruleAlias);
            }
        }
    }

    @Override
    protected void radioBtnUseCondition_actionPerformed(ActionEvent e) throws Exception {
        this.refactUI(true);
    }

    @Override
    protected void radioBtnUnUseCondition_actionPerformed(ActionEvent e) throws Exception {
        this.refactUI(true);
    }

    private void refreshUIWhenUseConditionChanged() {
        if (this.useCondition()) {
            int height = (int)((Rectangle)this.pnlCondition.getClientProperty((Object)"OriginalBounds")).getHeight();
            this.splitPaneMain.setDividerLocation(height);
        } else {
            this.splitPaneMain.setDividerLocation(0);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        BizConfigureEventInfo eventInfo = new BizConfigureEventInfo();
        if (this.btnGrpRuleEventType.getSelection() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("BizConfigEventDialog.PLEASE_SELECT_EVENT_TYPE"));
            return;
        }
        eventInfo.setEventType(this.getEventType());
        eventInfo.setUseCondtion(this.useCondition());
        IEventHandler eventhandler = null;
        if (this.useCondition()) {
            String condition = this.getEventRuleManager().getRules();
            if (!this.validateCondition(condition)) {
                return;
            }
            eventInfo.setCondition(condition);
            eventhandler = (IEventHandler)((Object)this.getFirstHandleTab());
            List actions = eventhandler.getActions();
            if (!this.validateActions(actions, BizConfigRes.getString("BizConfigEventDialog.CONDITION_TRUE_TAB_INVALID"))) {
                return;
            }
            eventInfo.setActions(actions);
            eventhandler = (IEventHandler)((Object)this.getSecondHandleTab());
            List exceptionActions = eventhandler.getActions();
            if (!this.validateActions(exceptionActions, BizConfigRes.getString("BizConfigEventDialog.CONDITION_FALSE_TAB_INVALID"))) {
                return;
            }
            eventInfo.setExceptionActions(exceptionActions);
        } else {
            eventhandler = (IEventHandler)((Object)this.getFirstHandleTab());
            List actions = eventhandler.getActions();
            if (!this.validateActions(actions, BizConfigRes.getString("BizConfigEventDialog.HANDLER_TAB_INVALID"))) {
                return;
            }
            eventInfo.setActions(actions);
        }
        eventInfo.setRuleName(this.txtRuleName.getText());
        eventInfo.setRuleType(((StringEnum)this.cmbRuleType.getSelectedItem()).getName());
        if (this.bizConfigureItemInfo.getConfigureEventCollection() == null) {
            this.bizConfigureItemInfo.setConfigureEventCollection(new BizConfigureEventCollection());
        }
        this.bizConfigureItemInfo.getConfigureEventCollection().add(eventInfo);
        if (this.isModify()) {
            this.bizConfigureItemInfo.getConfigureEventCollection().remove(this.oldEventInfo);
        }
        this.destroyWindow();
    }

    private boolean validateCondition(String condition) {
        if (StringUtils.isEmpty((String)condition)) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("BizConfigEventDialog.CONDITION_CAN_NOT_BE_NULL"));
            return false;
        }
        return this.validateRule(condition, BizConfigRes.getString("BizConfigEventDialog.CONDITION_INVALID"));
    }

    private boolean validateActions(List actions, String errMsg) {
        if (actions != null && actions.size() > 0) {
            String ruleScript = null;
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                ruleScript = (String)actions.get(i);
                if (this.validateRule(ruleScript, errMsg)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private boolean useCondition() {
        return this.radioBtnUseCondition.isSelected();
    }

    private EventType getEventType() {
        if (this.radioBtnInitialEvent.isSelected()) {
            return EventType.INITIAL;
        }
        if (this.radioBtnUpdateEvent.isSelected()) {
            return EventType.CHANGE;
        }
        if (this.radioBtnSaveEvent.isSelected()) {
            return EventType.SUBMIT;
        }
        return null;
    }

    private void setEventType(EventType eventType) {
        if (EventType.INITIAL.equals((Object)eventType)) {
            this.radioBtnInitialEvent.setSelected(true);
        } else if (EventType.CHANGE.equals((Object)eventType)) {
            this.radioBtnUpdateEvent.setSelected(true);
        } else if (EventType.SUBMIT.equals((Object)eventType)) {
            this.radioBtnSaveEvent.setSelected(true);
        }
    }

    private boolean validateRule(String rule, String errMsg) {
        String msg = rule;
        if (rule.indexOf("UIRuleUtil.throwException(") > -1) {
            msg = msg.substring("UIRuleUtil.throwException(".length(), msg.length() - 1);
        }
        try {
            BizEventDefHelper.parseScript(this.bizUnitInfo, rule);
            return true;
        }
        catch (BIMException e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)("\u3010" + msg + "\u3011 \u516c\u5f0f\u5b9a\u4e49\u4e0d\u5408\u6cd5\u3002"));
            return false;
        }
        catch (ParserException e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)("\u3010" + msg + "\u3011 \u516c\u5f0f\u5b9a\u4e49\u4e0d\u5408\u6cd5\u3002"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)("\u3010" + msg + "\u3011 \u516c\u5f0f\u5b9a\u4e49\u4e0d\u5408\u6cd5\u3002\n" + errMsg));
            return false;
        }
    }

    private String createRuleInfoName(AbstractBizConfigureItemInfo itemInfo) {
        String ruleName = StringUtils.fixNumber((int)(this.ruleCount + 1), (int)4);
        return ruleName;
    }

    private Component getFirstHandleTab() {
        if (this.tabPaneHandler.getTabCount() >= 1) {
            return this.tabPaneHandler.getComponentAt(0);
        }
        return null;
    }

    private Component getSecondHandleTab() {
        if (this.tabPaneHandler.getTabCount() >= 2) {
            return this.tabPaneHandler.getComponentAt(1);
        }
        return null;
    }

    class RuleConditionTreeHelper
    implements TreeSelectionListener,
    ITreeContentProvider {
        private static final String SPLIT_FLAG = ".";
        private IEventRuleManager eventRuleManager = null;

        public RuleConditionTreeHelper(IEventRuleManager eventRuleManager) {
            this.eventRuleManager = eventRuleManager;
        }

        public void initFieldsTree(KDTree fieldsTree, BizUnitInfo bizUnitInfo, final int treeItemDoubleClickEventCode) {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(null);
            if (bizUnitInfo != null) {
                EntityObjectInfo entityObjectInfo = bizUnitInfo.getEntity();
                Object[] elements = this.getElements(entityObjectInfo);
                this.layoutChildren(root, elements);
            }
            ((KingdeeTreeModel)fieldsTree.getModel()).setRoot((TreeNode)root);
            fieldsTree.setRootVisible(false);
            fieldsTree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    try {
                        Object source;
                        if (e.getButton() == 1 && e.getClickCount() == 2 && (source = e.getSource()) instanceof KDTree) {
                            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)((KDTree)source).getSelectionPath().getLastPathComponent();
                            PropertyInfo info = (PropertyInfo)selectedNode.getUserObject();
                            String name = info.getAlias() == null ? info.getName() : info.getAlias();
                            String tempName = "";
                            while (selectedNode.getParent() != null) {
                                info = (PropertyInfo)(selectedNode = (DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
                                if (info == null) continue;
                                tempName = info.getAlias() == null ? info.getName() : info.getAlias();
                                name = tempName + RuleConditionTreeHelper.SPLIT_FLAG + name;
                            }
                            UictEvent uictEvent = new UictEvent(e.getSource(), e.getID(), null);
                            uictEvent.setEventCode(treeItemDoubleClickEventCode);
                            uictEvent.setAttachment(name);
                            RuleConditionTreeHelper.this.getEventRuleManager().actionPerformed(uictEvent);
                        }
                    }
                    catch (Exception err) {
                        logger.error((Object)err.getMessage());
                    }
                }
            });
            fieldsTree.addTreeSelectionListener((TreeSelectionListener)this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultKingdeeTreeNode treeNode;
            if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null && this.hasChildren(treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent())) {
                Object[] children = this.getChildren(treeNode);
                this.layoutChildren(treeNode, children);
            }
        }

        private IEventRuleManager getEventRuleManager() {
            return this.eventRuleManager;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EntityObjectInfo) {
                PropertyCollection propertyCol = ((EntityObjectInfo)inputElement).getInheritedNoDuplicatedProperties();
                return this.getPropertyArray(propertyCol, null);
            }
            return null;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement != null && ((DefaultKingdeeTreeNode)parentElement).getUserObject() instanceof LinkPropertyInfo) {
                Object obj = ((DefaultKingdeeTreeNode)parentElement).getUserObject();
                RelationshipInfo relation = ((LinkPropertyInfo)obj).getRelationship();
                EntityObjectInfo entity = relation.getSupplierObject();
                PropertyCollection propertyCol = entity.getInheritedNoDuplicatedProperties();
                return this.getPropertyArray(propertyCol, (DefaultKingdeeTreeNode)parentElement);
            }
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            return ((DefaultKingdeeTreeNode)element).getUserObject() instanceof LinkPropertyInfo;
        }

        @Override
        public Object getParent(Object element) {
            return ((DefaultKingdeeTreeNode)element).getParent();
        }

        private Object[] getPropertyArray(PropertyCollection propertyCol, DefaultKingdeeTreeNode object) {
            LinkedList<DefaultKingdeeTreeNode> list = new LinkedList<DefaultKingdeeTreeNode>();
            for (int i = 0; i < propertyCol.size(); ++i) {
                PropertyInfo prop = propertyCol.get(i);
                if (prop == null || StringUtils.isEmpty((String)prop.getName()) || "parent".equalsIgnoreCase(prop.getName())) continue;
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)prop);
                node.setText(this.getPropertyAlais(prop));
                list.add(node);
                if (object == null) {
                    this.getEventRuleManager().appendItemAndLabel(prop.getName(), this.getPropertyAlais(prop));
                    continue;
                }
                PropertyInfo propertyInfo = (PropertyInfo)object.getUserObject();
                String name = propertyInfo.getName() + SPLIT_FLAG + prop.getName();
                String alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + this.getPropertyAlais(prop);
                DefaultKingdeeTreeNode tempnode = object;
                while (tempnode.getParent() != null && tempnode.getParent().getParent() != null) {
                    DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tempnode.getParent();
                    propertyInfo = (PropertyInfo)treeNode.getUserObject();
                    name = propertyInfo.getName() + SPLIT_FLAG + name;
                    alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + alias;
                    tempnode = treeNode;
                }
                this.getEventRuleManager().appendItemAndLabel(name, alias);
            }
            BizEventDefHelper.sortListByText(list);
            return list.toArray();
        }

        private String getPropertyAlais(PropertyInfo prop) {
            return StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        }

        @Override
        public void layoutChildren(Object parent, Object[] elements) {
            if (parent == null || elements == null || elements.length == 0) {
                return;
            }
            DefaultKingdeeTreeNode node = null;
            int m = elements.length;
            for (int i = 0; i < m; ++i) {
                node = (DefaultKingdeeTreeNode)elements[i];
                ((DefaultKingdeeTreeNode)parent).add((MutableTreeNode)node);
                if (!this.hasChildren(node)) continue;
                node.setCustomIcon(node.getRenderIcon(false, false));
            }
        }
    }
}

