/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.BizConfigRes;
import com.kingdee.eas.ep.RuleTypeEnum;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractEventDefineUI;
import com.kingdee.eas.ep.client.editor.editui.designer.event.BizConfigEventDialog;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemCollection;
import com.kingdee.eas.ep.client.model.AbstractBizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.BizConfigureEventCollection;
import com.kingdee.eas.ep.client.model.BizConfigureEventInfo;
import com.kingdee.eas.ep.client.model.BizConfigureItemInfo;
import com.kingdee.eas.ep.client.model.ComponentTreeNode;
import com.kingdee.eas.ep.client.util.EditUIEditorHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EventDefineUI
extends AbstractEventDefineUI {
    private static final Logger logger = CoreUIObject.getLogger(EventDefineUI.class);
    public static final String BIZUNITINFO = "bizUnitInfo";
    public static final String BIZTREENODE = "bizTreeNode";
    private BizUnitInfo bizUnit;
    private ComponentTreeNode bizTreeNode;
    private DefaultKingdeeTreeNode treeRoot = new DefaultKingdeeTreeNode();

    public void onLoad() throws Exception {
        super.onLoad();
        this.butAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.butAdd.setToolTipText("\u65b0\u589e\u4e8b\u4ef6");
        this.butEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.butEdit.setToolTipText("\u4fee\u6539\u4e8b\u4ef6");
        this.butDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.butDelete.setToolTipText("\u5220\u9664\u4e8b\u4ef6");
        this.tree.getSelectionModel().setSelectionMode(1);
        Object object = this.getUIContext().get(BIZUNITINFO);
        if (!(object instanceof BizUnitInfo)) {
            throw new IllegalArgumentException("can not get the BizUnitInfo from uicontext!");
        }
        this.bizUnit = (BizUnitInfo)object;
        object = this.getUIContext().get(BIZTREENODE);
        if (!(object instanceof ComponentTreeNode)) {
            throw new IllegalArgumentException("can not get the BizConfigureTreeNode from uicontext!");
        }
        this.bizTreeNode = (ComponentTreeNode)((Object)object);
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.treeRoot));
        this.buildTree();
        this.tree.expandOnLevel(2);
        this.setAllEnable(false);
    }

    private void buildTree() {
        this.treeRoot.removeAllChildren();
        this.treeRoot.setText("\u7ec4\u4ef6\u6811");
        this.treeRoot.setUserObject((Object)this.bizTreeNode);
        this.buildDetail(this.treeRoot, this.bizTreeNode);
    }

    private void buildDetail(DefaultKingdeeTreeNode parent, ComponentTreeNode bizNode) {
        if (parent != null && bizNode != null) {
            int i;
            AbstractBizConfigureItemCollection itemCol = bizNode.getConfigureItems();
            HashSet<String> nodes = new HashSet<String>();
            int size = bizNode.getChildCount();
            for (i = 0; i < size; ++i) {
                ComponentTreeNode childNode = (ComponentTreeNode)((Object)bizNode.getChildAt(i));
                nodes.add(childNode.getName());
                DefaultKingdeeTreeNode tNode = new DefaultKingdeeTreeNode();
                ComponentInfo kdtable = (ComponentInfo)childNode.getUserObject();
                tNode.setUserObject((Object)kdtable);
                tNode.setText(StringUtils.isEmpty((String)kdtable.getAlias()) ? kdtable.getName() : kdtable.getAlias());
                parent.add((MutableTreeNode)tNode);
                this.buildDetail(tNode, childNode);
            }
            size = itemCol.size();
            for (i = 0; i < size; ++i) {
                AbstractBizConfigureItemInfo item = itemCol.get(i);
                if (nodes.contains(item.getName())) continue;
                DefaultKingdeeTreeNode fNode = new DefaultKingdeeTreeNode();
                fNode.setUserObject((Object)item);
                fNode.setText(StringUtils.isEmpty((String)item.getAlias()) ? item.getName() : item.getAlias());
                parent.add((MutableTreeNode)fNode);
            }
        }
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (treeNode.getUserObject() instanceof AbstractBizConfigureItemInfo) {
                AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)treeNode.getUserObject();
                this.setAllEnable(true);
                this.refreshTableEventDef(item);
            } else {
                this.clearAll();
                this.setAllEnable(false);
            }
        }
    }

    private void refreshTableEventDef(AbstractBizConfigureItemInfo item) {
        this.tableList.removeRows();
        if (item != null) {
            this.tableList.setUserObject((Object)item);
            BizConfigureEventCollection eventCollection = item.getConfigureEventCollection();
            if (eventCollection != null) {
                this.putDataToTable(eventCollection);
            }
        }
    }

    private void refreshTableEventDef() {
        BizConfigureEventCollection eventCollection;
        AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)this.tableList.getUserObject();
        this.tableList.removeRows();
        if (item != null && (eventCollection = item.getConfigureEventCollection()) != null) {
            this.putDataToTable(eventCollection);
        }
    }

    private void putDataToTable(BizConfigureEventCollection eventCollection) {
        BizConfigureEventInfo eventInfo = null;
        int m = eventCollection.size();
        for (int i = 0; i < m; ++i) {
            eventInfo = eventCollection.get(i);
            this.tableList.addRow().setUserObject((Object)eventInfo);
            BindingUtility.setTableCellValue((KDTable)this.tableList, (int)i, (String)"ruleName", (Object)eventInfo.getRuleName());
            BindingUtility.setTableCellValue((KDTable)this.tableList, (int)i, (String)"ruleType", (Object)((RuleTypeEnum)((Object)RuleTypeEnum.getEnumMap().get(eventInfo.getRuleType()))).getAlias());
            BindingUtility.setTableCellValue((KDTable)this.tableList, (int)i, (String)"eventType", (Object)BizEventDefHelper.getLabelValueByEventType(eventInfo.getEventType().getName()));
        }
    }

    @Override
    protected void butAdd_actionPerformed(ActionEvent e) throws Exception {
        AbstractBizConfigureItemInfo bizConfigureItemInfo = (AbstractBizConfigureItemInfo)this.tableList.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("BizConfigureItemInfo", bizConfigureItemInfo);
        uiContext.put("EVENT_RULE_COUNT", new Integer(EditUIEditorHelper.getEventRuleTotalCount(this.bizTreeNode)));
        uiContext.put("BizFieldOwner", this.getBizFieldOwner(this.bizUnit, this.getSelectedTreeNode()));
        uiContext.put("BizFieldInfo", this.getBizField(this.bizUnit, this.getSelectedTreeNode(), bizConfigureItemInfo));
        this.showEventDefineDialog((Map)uiContext, Boolean.FALSE);
        this.refreshTableEventDef();
    }

    @Override
    protected void butEdit_actionPerformed(ActionEvent e) throws Exception {
        this.showExistedEventDefinition();
    }

    private void showExistedEventDefinition() {
        try {
            BizConfigureEventInfo eventInfo = this.getSelectedEventInfo();
            if (eventInfo != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put("BIZ_CONFIG_EVENT_INFO", eventInfo);
                uiContext.put("BizConfigureItemInfo", this.tableList.getUserObject());
                uiContext.put("BizFieldOwner", this.getBizFieldOwner(this.bizUnit, this.getSelectedTreeNode()));
                uiContext.put("BizFieldInfo", this.getBizField(this.bizUnit, this.getSelectedTreeNode(), (AbstractBizConfigureItemInfo)this.tableList.getUserObject()));
                this.showEventDefineDialog((Map)uiContext, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void showEventDefineDialog(Map uiContext, Boolean isModify) throws UIException {
        uiContext.put("BizUnitInfo", this.bizUnit);
        uiContext.put("isModify", isModify);
        uiContext.put("OPRT_STATE", this.oprtState);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizConfigEventDialog.class.getName(), uiContext);
        uiWindow.show();
        this.refreshTableEventDef();
    }

    @Override
    protected void butDelete_actionPerformed(ActionEvent e) throws Exception {
        BizConfigureEventInfo eventInfo = this.getSelectedEventInfo();
        if (eventInfo != null && MsgBox.showConfirm2New((Component)((Object)this), (String)BizConfigRes.getString("BizConfigureEditUI.WHETHER_DELETE_OR_NOT")) == 0) {
            AbstractBizConfigureItemInfo item = (AbstractBizConfigureItemInfo)this.tableList.getUserObject();
            BizConfigureEventCollection eventCol = item.getConfigureEventCollection();
            eventCol.remove(eventInfo);
            this.refreshTableEventDef();
        }
    }

    private BizConfigureEventInfo getSelectedEventInfo() {
        KDTSelectBlock selectBlock = this.tableList.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BizConfigRes.getString("BizConfigureEditUI.PLEASE_SELECT_EVENT_DEF"));
            return null;
        }
        int row = selectBlock.getEndRow();
        BizConfigureEventInfo eventInfo = (BizConfigureEventInfo)((Object)this.tableList.getRow(row).getUserObject());
        return eventInfo;
    }

    private IObjectValue getBizFieldOwner(BizUnitInfo bizUnit, DefaultKingdeeTreeNode treeNode) {
        Object nodeData;
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)treeNode.getParent();
        if (parentNode != null && (nodeData = parentNode.getUserObject()) instanceof ComponentInfo) {
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(((ComponentInfo)nodeData).getClassType())) {
                return BizUnitCtrl.getFieldByControlName((BizFieldCollection)bizUnit.getFields(), (String)((ComponentInfo)nodeData).getName());
            }
            if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(((ComponentInfo)nodeData).getClassType()) || "com.kingdee.bos.ctrl.web.DataGrid".equals(((ComponentInfo)nodeData).getClassType())) {
                return this.getWebFieldByControlName(bizUnit, ((ComponentInfo)nodeData).getName());
            }
        }
        return bizUnit;
    }

    private BizFieldInfo getWebFieldByControlName(BizUnitInfo bizUnit, String name) {
        if (bizUnit == null || StringUtils.isEmpty((String)name)) {
            return null;
        }
        BizFieldCollection fields = bizUnit.getFields();
        if (fields == null) {
            return null;
        }
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (name.equalsIgnoreCase(bizField.getWebControlName())) {
                return bizField;
            }
            if (!(bizField instanceof BizGroupFieldInfo)) continue;
            BizFieldCollection subFields = ((BizGroupFieldInfo)bizField).getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                bizField = subFields.get(j);
                if (!name.equalsIgnoreCase(bizField.getWebControlName())) continue;
                return bizField;
            }
        }
        return null;
    }

    private BizFieldInfo getBizField(BizUnitInfo bizUnit, DefaultKingdeeTreeNode treeNode, AbstractBizConfigureItemInfo item) {
        IObjectValue fieldOwner = this.getBizFieldOwner(bizUnit, treeNode);
        if (item != null) {
            if (fieldOwner != null && fieldOwner instanceof BizGroupFieldInfo) {
                if (item instanceof BizConfigureItemInfo && ((BizConfigureItemInfo)item).getColumn() != null) {
                    return BizUnitCtrl.getFieldByControlName((BizFieldCollection)((BizGroupFieldInfo)fieldOwner).getFields(), (String)((BizConfigureItemInfo)item).getColumn().getName());
                }
            } else {
                return BizUnitCtrl.getFieldByControlName((BizFieldCollection)bizUnit.getFields(), (String)item.getName());
            }
        }
        return null;
    }

    private DefaultKingdeeTreeNode getSelectedTreeNode() {
        if (this.tree.getLastSelectedPathComponent() != null && this.tree.getLastSelectedPathComponent() instanceof DefaultKingdeeTreeNode) {
            return (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        }
        return null;
    }

    private void clearAll() {
        this.tableList.removeRows();
    }

    private void setAllEnable(boolean enable) {
        this.butAdd.setEnabled(enable);
        this.butEdit.setEnabled(enable);
        this.butDelete.setEnabled(enable);
    }

    @Override
    protected void tableList_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.showExistedEventDefinition();
        }
    }

    @Override
    protected void tableList_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tableList_editStopped(KDTEditEvent e) throws Exception {
    }
}

