/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.client.editor.editui.designer.event;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.bizunit.AbstractBizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ep.client.editor.editui.designer.event.AbstractRuleCalculateTab;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizEventDefHelper;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.BizUictFactory;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventHandler;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.IEventRuleManager;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.ITreeContentProvider;
import com.kingdee.eas.ep.client.editor.editui.designer.event.util.UictEvent;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RuleCalculateTab
extends AbstractRuleCalculateTab
implements IEventHandler {
    private static final Logger logger = CoreUIObject.getLogger(RuleCalculateTab.class);
    private IEventRuleManager bizEventRuleManager = null;
    private BizUnitInfo bizUnitInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map values = (Map)this.getUserObject();
        this.bizUnitInfo = (BizUnitInfo)values.get("BizUnitInfo");
        BizUictFactory.createOperationPanel(this.pnlOperation, this.getEventRuleManager(), true);
        new RuleCalculateTreeHelper(this.getEventRuleManager()).initFieldsTree(this.treeItemView, this.bizUnitInfo, 3);
        this.getEventRuleManager().registerStyledRuleEditor((Component)this.txtPaneRuleEditor);
        this.treeItemView.setToggleClickCount(1);
    }

    public IEventRuleManager getEventRuleManager() {
        if (this.bizEventRuleManager == null) {
            this.bizEventRuleManager = (IEventRuleManager)BizUictFactory.createInstanceFromClass(BizUictFactory.BIZ_RULE_MANAGER);
        }
        return this.bizEventRuleManager;
    }

    @Override
    public List getActions() {
        String rule = this.getEventRuleManager().getRules();
        if (rule != null && !"".equals(rule)) {
            LinkedList<String> actions = new LinkedList<String>();
            actions.add(rule);
            return actions;
        }
        return null;
    }

    @Override
    public void setActions(List actions) {
        if (actions != null) {
            String rules = "";
            int m = actions.size();
            for (int i = 0; i < m; ++i) {
                rules = rules + (String)actions.get(i);
            }
            this.getEventRuleManager().parseExpression(this.bizUnitInfo, rules);
            this.getEventRuleManager().setRules(rules);
        }
    }

    class RuleCalculateTreeHelper
    implements TreeSelectionListener,
    ITreeContentProvider {
        private static final String SPLIT_FLAG = ".";
        private IEventRuleManager eventRuleManager = null;
        private Object inputElement = null;

        public RuleCalculateTreeHelper(IEventRuleManager eventRuleManager) {
            this.eventRuleManager = eventRuleManager;
        }

        public void initFieldsTree(KDTree fieldsTree, BizUnitInfo bizUnitInfo, final int treeItemDoubleClickEventCode) {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(null);
            if (bizUnitInfo != null) {
                EntityObjectInfo entityObjectInfo = bizUnitInfo.getEntity();
                Object[] elements = this.getElements(entityObjectInfo);
                this.layoutChildren(root, elements);
            }
            ((KingdeeTreeModel)fieldsTree.getModel()).setRoot((TreeNode)root);
            fieldsTree.setRootVisible(false);
            fieldsTree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    try {
                        Object source;
                        if (e.getButton() == 1 && e.getClickCount() == 2 && (source = e.getSource()) instanceof KDTree) {
                            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)((KDTree)source).getSelectionPath().getLastPathComponent();
                            PropertyInfo info = (PropertyInfo)selectedNode.getUserObject();
                            String name = info.getAlias() == null ? info.getName() : info.getAlias();
                            String tempName = "";
                            while (selectedNode.getParent() != null) {
                                info = (PropertyInfo)(selectedNode = (DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
                                if (info == null) continue;
                                tempName = info.getAlias() == null ? info.getName() : info.getAlias();
                                name = tempName + RuleCalculateTreeHelper.SPLIT_FLAG + name;
                            }
                            UictEvent uictEvent = new UictEvent(e.getSource(), e.getID(), null);
                            uictEvent.setEventCode(treeItemDoubleClickEventCode);
                            uictEvent.setAttachment(name);
                            RuleCalculateTreeHelper.this.getEventRuleManager().actionPerformed(uictEvent);
                        }
                    }
                    catch (Exception err) {
                        logger.error((Object)err.getMessage());
                    }
                }
            });
            fieldsTree.addTreeSelectionListener((TreeSelectionListener)this);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultKingdeeTreeNode treeNode;
            if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null && this.hasChildren(treeNode = (DefaultKingdeeTreeNode)e.getNewLeadSelectionPath().getLastPathComponent())) {
                Object[] children = this.getChildren(treeNode);
                this.layoutChildren(treeNode, children);
            }
        }

        private IEventRuleManager getEventRuleManager() {
            return this.eventRuleManager;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            this.inputElement = inputElement;
            if (inputElement instanceof EntityObjectInfo) {
                PropertyCollection propertyCol = ((EntityObjectInfo)inputElement).getInheritedNoDuplicatedProperties();
                return this.getPropertyArray(propertyCol, null);
            }
            return null;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement != null && ((DefaultKingdeeTreeNode)parentElement).getUserObject() instanceof LinkPropertyInfo) {
                Object obj = ((DefaultKingdeeTreeNode)parentElement).getUserObject();
                RelationshipInfo relation = ((LinkPropertyInfo)obj).getRelationship();
                EntityObjectInfo entity = relation.getSupplierObject();
                PropertyCollection propertyCol = entity.getInheritedNoDuplicatedProperties();
                return this.getPropertyArray(propertyCol, (DefaultKingdeeTreeNode)parentElement);
            }
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            return ((DefaultKingdeeTreeNode)element).getUserObject() instanceof LinkPropertyInfo;
        }

        @Override
        public Object getParent(Object element) {
            return ((DefaultKingdeeTreeNode)element).getParent();
        }

        private boolean isValidateDataType(BizDataType type) {
            return BizDataType.AMOUNT.equals((Object)type) || BizDataType.DECIMAL.equals((Object)type) || BizDataType.INTEGER.equals((Object)type) || BizDataType.PRICE.equals((Object)type) || BizDataType.QUANTITY.equals((Object)type) || BizDataType.DATE.equals((Object)type) || BizDataType.STRING.equals((Object)type) || BizDataType.ENUM.equals((Object)type) || BizDataType.OBJECT.equals((Object)type) || BizDataType.BOOLEAN.equals((Object)type);
        }

        private Object[] getPropertyArray(PropertyCollection propertyCol, DefaultKingdeeTreeNode object) {
            LinkedList<DefaultKingdeeTreeNode> list = new LinkedList<DefaultKingdeeTreeNode>();
            for (int i = 0; i < propertyCol.size(); ++i) {
                PropertyInfo prop = propertyCol.get(i);
                if (prop == null || StringUtils.isEmpty((String)prop.getName()) || "parent".equalsIgnoreCase(prop.getName())) continue;
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)prop;
                    BizDataType type = null;
                    try {
                        type = AbstractBizUnitCtrl.getBizDataType((DataType)ownPropertyInfo.getDataType());
                    }
                    catch (BIMException e) {
                        logger.error((Object)e);
                    }
                    if (!this.isValidateDataType(type)) continue;
                    DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)prop);
                    node.setText(this.getPropertyAlais(prop));
                    list.add(node);
                    if (object == null) {
                        this.getEventRuleManager().appendItemAndLabel(prop.getName(), this.getPropertyAlais(prop));
                        continue;
                    }
                    PropertyInfo propertyInfo = (PropertyInfo)object.getUserObject();
                    String name = propertyInfo.getName() + SPLIT_FLAG + prop.getName();
                    String alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + this.getPropertyAlais(prop);
                    DefaultKingdeeTreeNode tempnode = object;
                    while (tempnode.getParent() != null && tempnode.getParent().getParent() != null) {
                        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tempnode.getParent();
                        propertyInfo = (PropertyInfo)treeNode.getUserObject();
                        name = propertyInfo.getName() + SPLIT_FLAG + name;
                        alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + alias;
                        tempnode = treeNode;
                    }
                    this.getEventRuleManager().appendItemAndLabel(name, alias);
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)prop;
                EntityObjectInfo subEntity = null;
                RelationshipInfo relation = linkPropertyInfo.getRelationship();
                if (relation == null || relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = relation.getSupplierObject()) == null || subEntity.equals(this.inputElement)) continue;
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)prop);
                node.setText(this.getPropertyAlais(prop));
                list.add(node);
                if (object == null) {
                    this.getEventRuleManager().appendItemAndLabel(prop.getName(), this.getPropertyAlais(prop));
                    continue;
                }
                PropertyInfo propertyInfo = (PropertyInfo)object.getUserObject();
                String name = propertyInfo.getName() + SPLIT_FLAG + prop.getName();
                String alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + this.getPropertyAlais(prop);
                DefaultKingdeeTreeNode tempnode = object;
                while (tempnode.getParent() != null && tempnode.getParent().getParent() != null) {
                    DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tempnode.getParent();
                    propertyInfo = (PropertyInfo)treeNode.getUserObject();
                    name = propertyInfo.getName() + SPLIT_FLAG + name;
                    alias = this.getPropertyAlais(propertyInfo) + SPLIT_FLAG + alias;
                    tempnode = treeNode;
                }
                this.getEventRuleManager().appendItemAndLabel(name, alias);
            }
            BizEventDefHelper.sortListByText(list);
            return list.toArray();
        }

        private String getPropertyAlais(PropertyInfo prop) {
            return StringUtils.isEmpty((String)prop.getAlias()) ? prop.getName() : prop.getAlias();
        }

        @Override
        public void layoutChildren(Object parent, Object[] elements) {
            if (parent == null || elements == null || elements.length == 0) {
                return;
            }
            DefaultKingdeeTreeNode node = null;
            int m = elements.length;
            for (int i = 0; i < m; ++i) {
                node = (DefaultKingdeeTreeNode)elements[i];
                ((DefaultKingdeeTreeNode)parent).add((MutableTreeNode)node);
                if (!this.hasChildren(node)) continue;
                node.setCustomIcon(node.getRenderIcon(false, false));
            }
        }
    }
}

